/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.core.model.ds.Table;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceAttributesPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.util.Version;

public class DataSourceAttributesDialog
extends DataConsumerAttributesDialog<DataSourceNode> {
    private static final Logger theLogger = Logger.getLogger(DataSourceAttributesDialog.class.getName());
    private DataSourceAttributesPanel content;
    private boolean checkForUnderlyingTable = true;
    private boolean showChangeDs;
    private boolean _isDatabaseVersion12andUp;
    private List<String> isJSONConstraintColumns = new ArrayList<String>();

    public DataSourceAttributesDialog(Context context, DataSourceNode dataSourceNode) {
        super(context, dataSourceNode, dataSourceNode);
    }

    public boolean isDatabaseVersion12andUp() {
        return this._isDatabaseVersion12andUp;
    }

    @Override
    protected List<AttributeType> getAvailableAttributes(final AbstractDataNode abstractDataNode) {
        final ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        class GetAttrs
        extends ProgressRunnable {
            GetAttrs() {
            }

            protected Object doWork() throws Exception {
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(DataSourceAttributesDialog.this.context);
                DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)abstractDataNode.getData();
                TableType tableType = dataSourceNodeType.getSourceTable();
                Table table = new Table(tableType);
                List<Map<String, Object>> list = DatabaseMetadataUtils.getColumnDetails(connectionFolder, table, DataSourceAttributesDialog.this.isJSONConstraintColumns);
                return list;
            }

            protected void finish(Object object) {
                List list = (List)object;
                if (list != null && !list.isEmpty()) {
                    for (Map map : list) {
                        AttributeType attributeType = new AttributeType();
                        attributeType.setName((String)map.get("COLUMN_NAME"));
                        attributeType.setDataType((String)map.get("DATA_TYPE"));
                        attributeType.setDataTypeQualifier((String)map.get("DATA_QUALIFIER"));
                        attributeType.setStatus(AttributeStatus.VALID);
                        arrayList.add(attributeType);
                    }
                }
            }
        }
        GetAttrs getAttrs = new GetAttrs();
        getAttrs.setTitle(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS"));
        getAttrs.setMessage(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS_DESCR"));
        getAttrs.setCancelable(false);
        try {
            getAttrs.start(true);
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        return arrayList;
    }

    public void setCheckForUnderlyingTable(boolean bl) {
        this.checkForUnderlyingTable = bl;
    }

    public void setShowChangeDs(boolean bl) {
        this.showChangeDs = bl;
    }

    @Override
    protected String getDialogTitle() {
        return DataDialogsLrb.get("DATA_SOURCE_DIALOG_TITLE");
    }

    @Override
    protected String getHelpId() {
        return "dm_datasource_edit_columns";
    }

    @Override
    protected JPanel getDialogContent() {
        Version version = ConnectionFolder.getConnectionFolder(this.context).getDbVersion();
        this._isDatabaseVersion12andUp = DbVersionHelper.isDB12102Up((Version)version);
        List<AttributeType> list = this.getAvailableAttributes(this.data);
        if (this.checkForUnderlyingTable && list.isEmpty()) {
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this.data.getData();
            TableType tableType = dataSourceNodeType.getSourceTable();
            String string = tableType.getSchema();
            String string2 = tableType.getName();
            this.errorMessage = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_MISSING"), string + "." + string2);
            return null;
        }
        this.content = new DataSourceAttributesPanel(this.context, this.thisNode, list, this.isJSONConstraintColumns, this._isDatabaseVersion12andUp, false);
        this.content.setShowChangeDs(this.showChangeDs);
        return this.content;
    }

    @Override
    protected void customizeDialog(JEWTDialog jEWTDialog) {
        JButton jButton = new JButton(JSON_SETTINGS_TEXT);
        this.content.setJsonButton(jButton);
        jButton.addActionListener(this.content);
        jEWTDialog.addCustomButton((Component)jButton);
    }
}

