/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.CreateTableNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DBColumnType;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;

public abstract class DataConsumerAttributesDialog<T extends AbstractDataNode>
implements DialogDisplayable {
    private static final Logger theLogger = Logger.getLogger(DataConsumerAttributesDialog.class.getName());
    public static String JSON_SETTINGS_TEXT = DataDialogsLrb.get("DATA_SOURCE_WZD_JSON_SETTINGS_BUTTON");
    protected Context context;
    protected String errorMessage;
    protected T thisNode;
    protected AbstractDataNode data;

    public DataConsumerAttributesDialog(Context context, T t, AbstractDataNode abstractDataNode) {
        this.context = context;
        this.thisNode = t;
        this.data = abstractDataNode;
    }

    protected List<AttributeType> getAvailableAttributes(final AbstractDataNode abstractDataNode) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        class GetAttrs
        extends ProgressRunnable {
            private List<AttributeType> cols;

            GetAttrs() {
            }

            public List<AttributeType> getColumns() {
                return this.cols;
            }

            protected Object doWork() throws Exception {
                if (abstractDataNode instanceof DataProvider) {
                    if (abstractDataNode instanceof CreateTableNode) {
                        CreateTableNodeType createTableNodeType = (CreateTableNodeType)abstractDataNode.getData();
                        if (null != createTableNodeType.getDBAttributes() && null != createTableNodeType.getDBAttributes().getDBAttribute()) {
                            this.cols = DataConsumerAttributesDialog.getCreateColumnDetails(createTableNodeType.getDBAttributes().getDBAttribute());
                        }
                    } else {
                        this.cols = DataConsumerAttributesDialog.getColumnDetails(abstractDataNode.getAttributes().getAttribute());
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        GetAttrs getAttrs = new GetAttrs();
        getAttrs.setTitle(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS"));
        getAttrs.setMessage(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS_DESCR"));
        getAttrs.setCancelable(false);
        try {
            getAttrs.start(true);
            if (null != getAttrs.getColumns()) {
                arrayList.addAll(getAttrs.getColumns());
            }
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        return arrayList;
    }

    public static List<AttributeType> getColumnDetails(List<AttributeType> list) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(list.size());
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = new AttributeType();
            attributeType2.setName(attributeType.getName());
            attributeType2.setDataType(attributeType.getDataType());
            attributeType2.setDataTypeQualifier(attributeType.getDataTypeQualifier());
            attributeType2.setAlias(attributeType.getAlias());
            attributeType2.setAnnotation(attributeType.getAnnotation());
            attributeType2.setStatus(attributeType.getStatus());
            arrayList.add(attributeType2);
        }
        return arrayList;
    }

    public static List<AttributeType> getCreateColumnDetails(List<DBColumnType> list) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(list.size());
        for (DBColumnType dBColumnType : list) {
            DBColumnType dBColumnType2 = new DBColumnType();
            dBColumnType2.setName(dBColumnType.getAlias() != null && !dBColumnType.getAlias().trim().isEmpty() ? dBColumnType.getAlias() : dBColumnType.getName());
            dBColumnType2.setDataType(dBColumnType.getDataType());
            dBColumnType2.setDataTypeQualifier(dBColumnType.getDataTypeQualifier());
            dBColumnType2.setStatus(dBColumnType.getStatus());
            dBColumnType2.setAnnotation(dBColumnType.getAnnotation());
            dBColumnType2.setIndex(dBColumnType.getIndex());
            dBColumnType2.setKey(dBColumnType.getKey());
            arrayList.add((AttributeType)dBColumnType2);
        }
        return arrayList;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected String getDialogTitle() {
        return DataDialogsLrb.get("DIALOG_TITLE");
    }

    protected void customizeDialog(JEWTDialog jEWTDialog) {
    }

    protected void onDialogClose() {
    }

    protected abstract String getHelpId();

    protected abstract JComponent getDialogContent();

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){
            protected JComponent content;

            @Override
            public void onOK() throws DialogExecutionException {
                ((DataConsumerPanel)((Object)this.content)).doWork();
            }

            @Override
            public String getTitle() {
                return DataConsumerAttributesDialog.this.getDialogTitle();
            }

            @Override
            public String getHelpTopic() {
                return DataConsumerAttributesDialog.this.getHelpId();
            }

            @Override
            public JComponent getContent() {
                this.content = DataConsumerAttributesDialog.this.getDialogContent();
                return this.content;
            }

            @Override
            public void customizeDialogProperties(JEWTDialog jEWTDialog) {
                super.customizeDialogProperties(jEWTDialog);
                DataConsumerAttributesDialog.this.customizeDialog(jEWTDialog);
            }

            @Override
            public void onWindowClose() {
                DataConsumerAttributesDialog.this.onDialogClose();
            }
        };
    }
}

