/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableAdapter;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableOptionsType;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.javatools.dialogs.MessageDialog;

public class CreateTableStorageSettingsPanel
extends JPanel
implements DataminerGUIPanel,
DialogDisplayable {
    private String title;
    private JMultiLineLabel jCompressionDescription = new JMultiLineLabel();
    private CreateTableOptionsType tableOptions;
    private static int defaultCompressionValue = 20;
    private Integer previousState;
    protected static final String UNSUPPORTED_STORAGE_WARNING = "Exadata Hybrid Columnar Compression";
    private static Hashtable<Integer, JLabel> compressionLabels = new Hashtable();
    private static Hashtable<String, Integer> compressionLabelsToValues = new Hashtable();
    private JCheckBox jChkBoxLogging;
    private JScrollPane jScrollPanelCompressionExplanation;
    private JSlider jSliderCompression;

    public CreateTableStorageSettingsPanel(String string, CreateTableOptionsType createTableOptionsType) {
        this.title = string;
        this.tableOptions = createTableOptionsType;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jChkBoxLogging = new JCheckBox();
        this.jSliderCompression = new JSlider();
        this.jScrollPanelCompressionExplanation = new JScrollPane();
        this.jChkBoxLogging.setText("Logging ON");
        this.jSliderCompression.setMajorTickSpacing(20);
        this.jSliderCompression.setPaintLabels(true);
        this.jSliderCompression.setSnapToTicks(true);
        this.jSliderCompression.setBorder(BorderFactory.createTitledBorder("Compression Method"));
        this.jScrollPanelCompressionExplanation.setBorder(null);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderCompression, -1, 400, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jChkBoxLogging, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent(this.jScrollPanelCompressionExplanation));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jChkBoxLogging, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderCompression, -1, 115, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPanelCompressionExplanation, -2, 64, -2)));
    }

    @Override
    public void initRes() {
        this.jSliderCompression.setBorder(BorderFactory.createTitledBorder(DataDialogsLrb.get("TABLECOMPRESSION_METHOD")));
    }

    @Override
    public void initUI() {
        this.jSliderCompression.setMaximum(80);
        this.jSliderCompression.setLabelTable(compressionLabels);
        if (this.tableOptions == null) {
            this.setDefaultOptions();
        } else {
            String string = this.tableOptions.getTableCompression();
            if (string == null || string.isEmpty()) {
                this.setDefaultOptions();
            } else {
                String string2 = MetaDataHelper.tableCompressionCovertToHuman(string);
                int n = compressionLabelsToValues.get(string2);
                this.jSliderCompression.setValue(n);
                this.jChkBoxLogging.setSelected(this.tableOptions.getLogging().equals("LOGGING"));
            }
        }
        this.setCompressionDescrition(false);
        this.jSliderCompression.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Object object = changeEvent.getSource();
                if (object instanceof JSlider) {
                    JSlider jSlider = (JSlider)object;
                    int n = jSlider.getValue();
                    if (CreateTableStorageSettingsPanel.this.previousState == null) {
                        CreateTableStorageSettingsPanel.this.previousState = n;
                        if (CreateTableStorageSettingsPanel.this.previousState > 40) {
                            CreateTableStorageSettingsPanel.this.previousState = defaultCompressionValue;
                        }
                    }
                    if (!jSlider.getValueIsAdjusting()) {
                        if (n > 40 && !MessageDialog.optionalConfirm((String)CreateTableStorageSettingsPanel.UNSUPPORTED_STORAGE_WARNING, (Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("UNSUPPORTED_STORAGE_MESSAGE"), (String)DataDialogsLrb.get("UNSUPPORTED_STORAGE_MESSAGE_TITLE"), null)) {
                            jSlider.setValue(CreateTableStorageSettingsPanel.this.previousState);
                        }
                        CreateTableStorageSettingsPanel.this.previousState = null;
                    }
                    CreateTableStorageSettingsPanel.this.setCompressionDescrition(true);
                }
            }
        });
        this.jChkBoxLogging.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTableStorageSettingsPanel.this.tableOptions.setLogging(CreateTableStorageSettingsPanel.this.jChkBoxLogging.isSelected() ? "LOGGING" : "NOLOGGING");
            }
        });
    }

    private void setDefaultOptions() {
        this.jSliderCompression.setValue(defaultCompressionValue);
        this.jChkBoxLogging.setSelected(false);
        if (this.tableOptions == null) {
            this.tableOptions = new CreateTableOptionsType();
        }
        this.tableOptions.setTableCompression(MetaDataHelper.defaultTableCompressionMachine());
        this.tableOptions.setLogging("NOLOGGING");
    }

    private void setCompressionDescrition(boolean bl) {
        Integer n = this.jSliderCompression.getValue();
        JLabel jLabel = compressionLabels.get(n);
        if (jLabel != null) {
            String string = jLabel.getText();
            String string2 = MessageFormat.format(DataDialogsLrb.get("TABLECOMPRESSION_SELECTION_EXPLANATION"), string);
            this.loadDescription(this.jCompressionDescription, this.jScrollPanelCompressionExplanation, string2);
            if (bl) {
                this.tableOptions.setTableCompression(MetaDataHelper.tableCompressionCovertToMachine(string));
            }
        }
    }

    public String getCompressionMethod() {
        Integer n = this.jSliderCompression.getValue();
        JLabel jLabel = compressionLabels.get(n);
        String string = jLabel.getText();
        return string;
    }

    protected void loadDescription(JMultiLineLabel jMultiLineLabel, JScrollPane jScrollPane, String string) {
        jMultiLineLabel.setText(string);
        jScrollPane.getViewport().add((Component)jMultiLineLabel);
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableAdapter(){

            @Override
            public String getTitle() {
                return CreateTableStorageSettingsPanel.this.title;
            }

            @Override
            public String getHelpTopic() {
                return "create_table_storage_settings";
            }

            @Override
            public JComponent getContent() {
                return CreateTableStorageSettingsPanel.this;
            }
        };
    }

    public CreateTableOptionsType getTableOptions() {
        return this.tableOptions;
    }

    static {
        compressionLabels.put(0, new JLabel(MetaDataHelper.tableCompressionCovertToHuman("NONE")));
        compressionLabels.put(20, new JLabel(MetaDataHelper.tableCompressionCovertToHuman("ROW STORE COMPRESS")));
        compressionLabels.put(40, new JLabel(MetaDataHelper.tableCompressionCovertToHuman("ROW STORE COMPRESS ADVANCED")));
        compressionLabels.put(60, new JLabel(MetaDataHelper.tableCompressionCovertToHuman("COLUMN STORE COMPRESS FOR QUERY HIGH")));
        compressionLabels.put(80, new JLabel(MetaDataHelper.tableCompressionCovertToHuman("COLUMN STORE COMPRESS FOR ARCHIVE LOW")));
        compressionLabelsToValues.put(MetaDataHelper.tableCompressionCovertToHuman("NONE"), 0);
        compressionLabelsToValues.put(MetaDataHelper.tableCompressionCovertToHuman("ROW STORE COMPRESS"), 20);
        compressionLabelsToValues.put(MetaDataHelper.tableCompressionCovertToHuman("ROW STORE COMPRESS ADVANCED"), 40);
        compressionLabelsToValues.put(MetaDataHelper.tableCompressionCovertToHuman("COLUMN STORE COMPRESS FOR QUERY HIGH"), 60);
        compressionLabelsToValues.put(MetaDataHelper.tableCompressionCovertToHuman("COLUMN STORE COMPRESS FOR ARCHIVE LOW"), 80);
    }
}

