/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.models.AttributeItem;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.wizard.AbstractWizardPage;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingThemePanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingTokenPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.TransformWizardModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class TextTransColumnSettingPage
extends AbstractWizardPage
implements DataminerGUIPanel {
    private TransformWizardModel _wizModel;
    private String _transformType;
    private TextTransColumnSettingTokenPanel _tokenPanel;
    private TextTransColumnSettingThemePanel _themePanel;
    private boolean _isEdit;
    private boolean _isAdjusting;
    private static String TRANSFORM_TOKEN = DialogsLrb.get("BUILDTEXT_TRANSFORM_TYPE_TOKEN");
    private static String TRANSFORM_THEME = DialogsLrb.get("BUILDTEXT_TRANSFORM_TYPE_THEME");
    private static String USE_EXISTING_COLUMN = DialogsLrb.get("TRANSFORM_WIZ_USE_EXISTING_COLUMN");
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private JPanel jBottomPanel;
    private JScrollPane jDescScrollPane;
    private JPanel jDetailPanel;
    private JSeparator jSeparator;
    private JPanel jSettingPanel;
    private JPanel jTopPanel;
    private JComboBox jTransformComboBox;
    private JLabel jTransformLabel;
    private JComboBox jTransformTypeComboBox;
    private JLabel jTransformTypeLabel;
    private JComboBox jTransformedColumnComboBox;
    private JLabel jTransformedColumnLabel;

    public TextTransColumnSettingPage() {
        this.initComponents();
        this.initRes();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTransformLabel, (Component)this.jTransformComboBox, (String)DialogsLrb.get("TRANSFORM_WIZ_TRANSFORM"));
        ResourceUtils.resLabel((JLabel)this.jTransformedColumnLabel, (Component)this.jTransformedColumnComboBox, (String)DialogsLrb.get("TRANSFORM_WIZ_TRANSFORM_COLUMN"));
        ResourceUtils.resLabel((JLabel)this.jTransformTypeLabel, (Component)this.jTransformTypeComboBox, (String)DialogsLrb.get("TRANSFORM_WIZ_TRANSFORM_TYPE"));
    }

    @Override
    public void initUI() {
        this._wizModel = (TransformWizardModel)this.getTraversableContext().get("wizardModel");
        List list = this._wizModel.getTransformedAttributes().getMapTextTransformedSource();
        this._isAdjusting = true;
        this.jDescScrollPane.setVisible(false);
        this.jTransformComboBox.removeAllItems();
        this.jTransformComboBox.addItem(TRANSFORM_TOKEN);
        this.jTransformComboBox.addItem(TRANSFORM_THEME);
        if (list.size() > 0) {
            this.jTransformComboBox.addItem(USE_EXISTING_COLUMN);
        }
        this.jTransformComboBox.setSelectedItem(TRANSFORM_TOKEN);
        this._transformType = TRANSFORM_TOKEN;
        boolean bl = true;
        this._isEdit = this._wizModel.isEdit();
        if (list.size() > 0) {
            ArrayList<TextTransformationOutputAttributeType> arrayList = new ArrayList<TextTransformationOutputAttributeType>();
            for (MapTextTransformedSourceType mapTextTransformedSourceType : list) {
                arrayList.add(mapTextTransformedSourceType.getKey());
            }
            Collections.sort(arrayList, AttributeTypeComparator.getComparator());
            this.jTransformedColumnComboBox.removeAllItems();
            for (AttributeType attributeType : arrayList) {
                this.jTransformedColumnComboBox.addItem(new AttributeItem(attributeType));
            }
            this.jTransformedColumnComboBox.setSelectedIndex(0);
            this.jTransformTypeComboBox.removeAllItems();
            this.jTransformTypeComboBox.addItem(TRANSFORM_TOKEN);
            this.jTransformTypeComboBox.addItem(TRANSFORM_THEME);
            AttributeItem attributeItem = (AttributeItem)this.jTransformedColumnComboBox.getSelectedItem();
            boolean bl2 = bl = ((TextTransformationOutputAttributeType)attributeItem.getAttribute()).getTransformationElement().getTheme() == null;
            if (bl) {
                this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_TOKEN);
            } else {
                this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_THEME);
            }
        }
        this.jTopPanel.setVisible(false);
        this._tokenPanel = new TextTransColumnSettingTokenPanel((PropertyModel)this._wizModel.getPropertyModel(), this._wizModel.getContext(), (JPanel)((Object)this), this._wizModel.getNode(), null, null);
        this._themePanel = new TextTransColumnSettingThemePanel((PropertyModel)this._wizModel.getPropertyModel(), this._wizModel.getContext(), (JPanel)((Object)this), this._wizModel.getNode(), null, null);
        this.jDetailPanel.removeAll();
        this.jDetailPanel.add(this._tokenPanel);
        this.jDetailPanel.updateUI();
        this._isAdjusting = false;
        this.enableControls();
    }

    private void enableControls() {
    }

    @Override
    public String getPageDirtyKey() {
        return "TransformDirty";
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        this.setDirty(true, "NewColumnDirty");
        return this.validateAndWriteToState(this._wizModel);
    }

    public boolean validateAndWriteToState(TransformWizardModel transformWizardModel) {
        boolean bl = true;
        ValidateWriteThread validateWriteThread = new ValidateWriteThread(transformWizardModel);
        validateWriteThread.setMessage(MessageFormat.format(GroupLrb.get("VALIDATING_GROUP_TABLES_DETAILS"), new Object[]{null}));
        validateWriteThread.setCancelable(false);
        try {
            validateWriteThread.start(true);
            bl = validateWriteThread.getValidation();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)GroupLrb.get("CREATE_GROUP_FAILURE_TITLE"), (String)GroupLrb.get("CREATE_GROUP_FAILURE_MESG"), null);
        }
        return bl;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.jDescScrollPane = new JScrollPane();
        this.jTransformLabel = new JLabel();
        this.jTransformComboBox = new JComboBox();
        this.jSeparator = new JSeparator();
        this.jSettingPanel = new JPanel();
        this.jTopPanel = new JPanel();
        this.jTransformedColumnLabel = new JLabel();
        this.jTransformedColumnComboBox = new JComboBox();
        this.jTransformTypeLabel = new JLabel();
        this.jTransformTypeComboBox = new JComboBox();
        this.jBottomPanel = new JPanel();
        this.jDetailPanel = new JPanel();
        this.jDescScrollPane.setBorder(null);
        this.jTransformLabel.setText("Transform:");
        this.jTransformComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Token", "Theme", "<Use Existing Column>"}));
        this.jTransformComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingPage.this.jTransformComboBoxActionPerformed(actionEvent);
            }
        });
        this.jSeparator.setMaximumSize(new Dimension(400, Short.MAX_VALUE));
        this.jSettingPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.jTransformedColumnLabel.setText("Transformed Column:");
        this.jTransformedColumnComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"012345678901234567890123456789"}));
        this.jTransformedColumnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingPage.this.jTransformedColumnComboBoxActionPerformed(actionEvent);
            }
        });
        this.jTransformTypeLabel.setText("Transform Type:");
        this.jTransformTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Token", "Theme"}));
        GroupLayout groupLayout = new GroupLayout(this.jTopPanel);
        this.jTopPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTransformedColumnLabel).addComponent(this.jTransformTypeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTransformTypeComboBox, -2, -1, -2).addComponent(this.jTransformedColumnComboBox, -2, -1, -2)).addContainerGap(34, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTransformedColumnLabel).addComponent(this.jTransformedColumnComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTransformTypeLabel).addComponent(this.jTransformTypeComboBox, -2, -1, -2))));
        this.jDetailPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout2 = new GroupLayout(this.jBottomPanel);
        this.jBottomPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jDetailPanel, -1, 362, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jDetailPanel, GroupLayout.Alignment.TRAILING, -1, 294, Short.MAX_VALUE));
        GroupLayout groupLayout3 = new GroupLayout(this.jSettingPanel);
        this.jSettingPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTopPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jBottomPanel, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jTopPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBottomPanel, -1, -1, Short.MAX_VALUE)));
        GroupLayout groupLayout4 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jDescScrollPane, GroupLayout.Alignment.LEADING, -1, 374, Short.MAX_VALUE).addComponent(this.jSettingPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator, -1, 374, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout4.createSequentialGroup().addComponent(this.jTransformLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTransformComboBox, -2, -1, -2))).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.jDescScrollPane, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTransformLabel).addComponent(this.jTransformComboBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jSeparator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSettingPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void jTransformedColumnComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._isAdjusting) {
            return;
        }
        this._isAdjusting = true;
        AttributeItem attributeItem = (AttributeItem)this.jTransformedColumnComboBox.getSelectedItem();
        TextTransformationType textTransformationType = ((TextTransformationOutputAttributeType)attributeItem.getAttribute()).getTransformationElement();
        boolean bl = ((TextTransformationOutputAttributeType)attributeItem.getAttribute()).getTransformationElement().getTheme() == null;
        this.jDetailPanel.removeAll();
        if (bl) {
            this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_TOKEN);
            this.jDetailPanel.add(this._tokenPanel);
            this._tokenPanel.setReadOnly(USE_EXISTING_COLUMN.equals(this._transformType));
            this._tokenPanel.refreshUI(textTransformationType);
        } else {
            this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_THEME);
            this.jDetailPanel.add(this._themePanel);
            this._themePanel.setReadOnly(USE_EXISTING_COLUMN.equals(this._transformType));
            this._themePanel.refreshUI(textTransformationType);
        }
        this.jDetailPanel.updateUI();
        this._isAdjusting = false;
    }

    private void jTransformComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._isAdjusting) {
            return;
        }
        this._isAdjusting = true;
        this._transformType = (String)this.jTransformComboBox.getSelectedItem();
        this.jTopPanel.setVisible(USE_EXISTING_COLUMN.equals(this._transformType));
        this.jTransformTypeComboBox.setEnabled(false);
        this.jDetailPanel.removeAll();
        if (USE_EXISTING_COLUMN.equals(this._transformType)) {
            boolean bl;
            AttributeItem attributeItem = (AttributeItem)this.jTransformedColumnComboBox.getSelectedItem();
            TextTransformationType textTransformationType = ((TextTransformationOutputAttributeType)attributeItem.getAttribute()).getTransformationElement();
            boolean bl2 = bl = ((TextTransformationOutputAttributeType)attributeItem.getAttribute()).getTransformationElement().getTheme() == null;
            if (bl) {
                this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_TOKEN);
                this.jDetailPanel.add(this._tokenPanel);
                this._tokenPanel.setReadOnly(true);
                this._tokenPanel.refreshUI(textTransformationType);
            } else {
                this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_THEME);
                this.jDetailPanel.add(this._themePanel);
                this._themePanel.setReadOnly(true);
                this._themePanel.refreshUI(textTransformationType);
            }
        } else if (TRANSFORM_TOKEN.equals(this._transformType)) {
            this.jDetailPanel.add(this._tokenPanel);
            this._tokenPanel.setReadOnly(false);
            this._tokenPanel.refreshUI(null);
        } else {
            this.jDetailPanel.add(this._themePanel);
            this._themePanel.setReadOnly(false);
            this._themePanel.refreshUI(null);
        }
        this.jDetailPanel.updateUI();
        this._isAdjusting = false;
    }

    public TextNodeType.Stoplists getStoplists() {
        return this._wizModel.getStoplists();
    }

    class ValidateWriteThread
    extends ProgressRunnable {
        private TransformWizardModel _model;
        boolean _validated = true;
        private boolean _canceled = false;
        private boolean _forceUpdate = false;

        public ValidateWriteThread(TransformWizardModel transformWizardModel) {
            this._model = transformWizardModel;
        }

        public boolean getForceUpdate() {
            return this._forceUpdate;
        }

        public void setForceUpdate(boolean bl) {
            this._forceUpdate = bl;
        }

        public boolean getValidation() {
            return this._validated;
        }

        protected Object doWork() throws Exception {
            this._validated = true;
            try {
                TextTransformationType textTransformationType = null;
                JPanel jPanel = (JPanel)TextTransColumnSettingPage.this.jDetailPanel.getComponent(0);
                boolean bl = jPanel instanceof TextTransColumnSettingTokenPanel;
                if (TextTransColumnSettingPage.this._isEdit) {
                    List<TransformationSourceAttribute> list = TextTransColumnSettingPage.this._wizModel.getEditAttributes();
                    for (TransformationSourceAttribute transformationSourceAttribute : list) {
                        TextTransformationOutputAttributeType textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)transformationSourceAttribute;
                        textTransformationType = textTransformationOutputAttributeType.getTransformationElement();
                        TextNodeType.Stoplists stoplists = TextTransColumnSettingPage.this._wizModel.getStoplists();
                        if (bl) {
                            TextTransColumnSettingPage.this._tokenPanel.copySettings(textTransformationType, stoplists);
                            continue;
                        }
                        TextTransColumnSettingPage.this._themePanel.copySettings(textTransformationType, stoplists);
                    }
                } else {
                    List<MapTextTransformedSourceType> list = TextTransColumnSettingPage.this._wizModel.getNewAttributes();
                    list.clear();
                    List<TransformationSourceAttribute> list2 = TextTransColumnSettingPage.this._wizModel.getSelectedAttributes();
                    TextNodeType.Stoplists stoplists = TextTransColumnSettingPage.this._wizModel.getStoplists();
                    for (TransformationSourceAttribute transformationSourceAttribute : list2) {
                        textTransformationType = new TextTransformationType();
                        if (bl) {
                            TextTransColumnSettingPage.this._tokenPanel.copySettings(textTransformationType, stoplists);
                        } else {
                            TextTransColumnSettingPage.this._themePanel.copySettings(textTransformationType, stoplists);
                        }
                        MapTextTransformedSourceType mapTextTransformedSourceType = new MapTextTransformedSourceType();
                        TextTransformationOutputAttributeType textTransformationOutputAttributeType = new TextTransformationOutputAttributeType();
                        textTransformationOutputAttributeType.setSource(transformationSourceAttribute.getName());
                        textTransformationOutputAttributeType.setDataType("DM_NESTED_NUMERICALS");
                        textTransformationOutputAttributeType.setIsOutput(true);
                        textTransformationOutputAttributeType.setModified(true);
                        textTransformationOutputAttributeType.setStatus(AttributeStatus.VALID);
                        textTransformationOutputAttributeType.setTransformationElement(textTransformationType);
                        mapTextTransformedSourceType.setKey(textTransformationOutputAttributeType);
                        list.add(mapTextTransformedSourceType);
                    }
                }
                TextTransColumnSettingPage.this._transformType = (String)TextTransColumnSettingPage.this.jTransformComboBox.getSelectedItem();
                if (TextTransColumnSettingPage.this._transformType.equals(USE_EXISTING_COLUMN)) {
                    TextTransColumnSettingPage.this._transformType = (String)TextTransColumnSettingPage.this.jTransformTypeComboBox.getSelectedItem();
                }
                TextTransColumnSettingPage.this._wizModel.generateOutputNames(TextTransColumnSettingPage.this._transformType);
            }
            catch (ValidationException validationException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)validationException.getLocalizedMessage(), (String)DialogsLrb.get("ERROR_TITLE"), null);
                this._validated = false;
            }
            return null;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

