/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistDetailsPanel;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.ide.Context;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class AddStopwordsPanel
extends DialogDisplayer<BuildTextNode> {
    private JPanel parent;
    private StoplistType stoplist;
    private boolean dirty;
    private boolean isAdjusting;
    private boolean isTokenType;
    private boolean isThemeType;
    private JScrollPane jDescScrollPane;
    private JComboBox<String> jLanguageComboBox;
    private JLabel jLanguageLabel;
    private JScrollPane jStopwordScrollPane;
    private JTextArea jStopwordTextArea;
    private JComboBox<String> jTypeComboBox;
    private JLabel jTypeLabel;

    public AddStopwordsPanel(Context context, BuildTextNode buildTextNode, JPanel jPanel, StoplistType stoplistType) {
        super(context, buildTextNode);
        assert (context != null) : "Context must not be null.";
        this.init(jPanel, stoplistType);
    }

    private void init(JPanel jPanel, StoplistType stoplistType) {
        this.parent = jPanel;
        this.dirty = false;
        this.stoplist = (StoplistType)MetaDataHelper.copyMetadataObject(stoplistType);
        this.isTokenType = false;
        this.isThemeType = false;
        if (this.parent instanceof StoplistDetailsPanel) {
            this.isTokenType = ((StoplistDetailsPanel)this.parent).isTokenTransformType();
            this.isThemeType = ((StoplistDetailsPanel)this.parent).isThemeTransformType();
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTypeLabel, this.jTypeComboBox, (String)DialogsLrb.get("ADD_STOPWORD_TYPE"));
        ResourceUtils.resLabel((JLabel)this.jLanguageLabel, this.jLanguageComboBox, (String)DialogsLrb.get("ADD_STOPWORD_LANGUAGE"));
    }

    @Override
    public void initUI() {
        this.isAdjusting = true;
        JMultiLineLabel jMultiLineLabel = new JMultiLineLabel();
        jMultiLineLabel.setText(DialogsLrb.get("ADD_STOPWORD_DESC"));
        this.jDescScrollPane.getViewport().add((Component)jMultiLineLabel);
        this.jTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.StopTokenType.toHuman((String)"Word"), ServerConstants.StopTokenType.toHuman((String)"Theme")}));
        if (this.isTokenType) {
            this.jTypeComboBox.setSelectedItem(ServerConstants.StopTokenType.toHuman((String)"Word"));
        }
        if (this.isThemeType) {
            this.jTypeComboBox.setSelectedItem(ServerConstants.StopTokenType.toHuman((String)"Theme"));
        }
        this.refreshUI();
        this.isAdjusting = false;
    }

    private void refreshUI() {
        String string = (String)this.jTypeComboBox.getSelectedItem();
        if (string.equals(ServerConstants.StopTokenType.toHuman((String)"Theme"))) {
            this.jLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.StoplistLanguage.toHuman((String)"ENGLISH"), ServerConstants.StoplistLanguage.toHuman((String)"FRENCH")}));
        } else {
            this.jLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.StoplistLanguage.toHuman((String)"All"), ServerConstants.StoplistLanguage.toHuman((String)"SIMPLIFIED CHINESE"), ServerConstants.StoplistLanguage.toHuman((String)"TRADITIONAL CHINESE"), ServerConstants.StoplistLanguage.toHuman((String)"DANISH"), ServerConstants.StoplistLanguage.toHuman((String)"DUTCH"), ServerConstants.StoplistLanguage.toHuman((String)"ENGLISH"), ServerConstants.StoplistLanguage.toHuman((String)"FINNISH"), ServerConstants.StoplistLanguage.toHuman((String)"FRENCH"), ServerConstants.StoplistLanguage.toHuman((String)"GERMAN"), ServerConstants.StoplistLanguage.toHuman((String)"ITALIAN"), ServerConstants.StoplistLanguage.toHuman((String)"PORTUGUESE"), ServerConstants.StoplistLanguage.toHuman((String)"SPANISH"), ServerConstants.StoplistLanguage.toHuman((String)"SWEDISH")}));
        }
        if (this.stoplist.getType().equals("Basic")) {
            String string2 = this.stoplist.getLanguage();
            this.jLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman((String)string2));
        } else {
            String string3 = "All";
            this.jLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman((String)string3));
        }
        this.enableControls();
    }

    private void enableControls() {
        this.jTypeComboBox.setEnabled(!this.isTokenType && !this.isThemeType);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    @Override
    public boolean doWork() {
        String string;
        String string2;
        Object object;
        String string3;
        Object object22;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        TreeMap<String, TokenInfo> treeMap = new TreeMap<String, TokenInfo>();
        for (Object object22 : this.stoplist.getStopTokens().getToken()) {
            string3 = object22.getLanguage();
            object = object22.getType();
            string2 = object22.getItem();
            string = string3 + ":" + (String)object + ":" + string2;
            treeMap.put(string, new TokenInfo(string3, (String)object, string2));
        }
        Object object3 = (String)this.jTypeComboBox.getSelectedItem();
        object3 = ServerConstants.StopTokenType.toSchema((String)object3);
        object22 = (String)this.jLanguageComboBox.getSelectedItem();
        object22 = ServerConstants.StoplistLanguage.toSchema((String)object22);
        string3 = this.jStopwordTextArea.getText();
        if (StringUtils.checkDataLossWithMsg(this.getContext(), string3, oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb.get("ERROR_TITLE"))) {
            return false;
        }
        object = new WStringTokenizer(string3, ",");
        while (((WStringTokenizer)object).hasMoreTokens()) {
            string2 = ((WStringTokenizer)object).nextToken();
            if ((string2 = string2.trim()).length() == 0) {
                bl3 = true;
                continue;
            }
            string = (String)object22 + ":" + (String)object3 + ":" + string2;
            if (treeMap.containsKey(string)) {
                bl2 = true;
                continue;
            }
            treeMap.put(string, new TokenInfo((String)object22, (String)object3, string2));
            this.dirty = true;
        }
        this.stoplist.getStopTokens().getToken().clear();
        string2 = null;
        string = "Basic";
        for (TokenInfo tokenInfo : treeMap.values()) {
            object22 = tokenInfo.getLanguage();
            object3 = tokenInfo.getType();
            String string4 = tokenInfo.getToken();
            StoplistType.StopTokens.Token token = new StoplistType.StopTokens.Token();
            token.setLanguage((String)object22);
            token.setType((String)object3);
            token.setItem(string4);
            if (string2 == null) {
                string2 = object22;
            } else if (!string2.equals(object22)) {
                string = "Multi";
            }
            this.stoplist.getStopTokens().getToken().add(token);
        }
        this.stoplist.setType(string);
        this.stoplist.setLanguage("Multi".equals(string) ? string : string2);
        if (bl2) {
            MessageDialog.error((Component)UITools.getParentWindow(this), (Object)DialogsLrb.get("ADD_STOPWORD_DUPLICATED_REMOVED"), (String)DialogsLrb.get("WARNING_TITLE"), null);
        }
        if (bl3) {
            MessageDialog.error((Component)UITools.getParentWindow(this), (Object)DialogsLrb.get("ADD_STOPWORD_EMPTY_REMOVED"), (String)DialogsLrb.get("WARNING_TITLE"), null);
        }
        return bl;
    }

    private void initComponents() {
        this.jDescScrollPane = new JScrollPane();
        this.jTypeLabel = new JLabel();
        this.jTypeComboBox = new JComboBox();
        this.jLanguageLabel = new JLabel();
        this.jLanguageComboBox = new JComboBox();
        this.jStopwordScrollPane = new JScrollPane();
        this.jStopwordTextArea = new JTextArea();
        this.setPreferredSize(new Dimension(500, 341));
        this.jDescScrollPane.setBorder(null);
        this.jDescScrollPane.setOpaque(false);
        this.jTypeLabel.setLabelFor(this.jTypeComboBox);
        this.jTypeLabel.setText("Type:");
        this.jTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddStopwordsPanel.this.jTypeComboBoxActionPerformed(actionEvent);
            }
        });
        this.jLanguageLabel.setLabelFor(this.jLanguageComboBox);
        this.jLanguageLabel.setText("Language:");
        this.jStopwordTextArea.setColumns(20);
        this.jStopwordTextArea.setRows(5);
        this.jStopwordScrollPane.setViewportView(this.jStopwordTextArea);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jDescScrollPane, GroupLayout.Alignment.TRAILING, -1, 480, Short.MAX_VALUE).addComponent(this.jStopwordScrollPane, -1, 480, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTypeComboBox, -2, 124, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLanguageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLanguageComboBox, -2, 124, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(0, this.jLanguageLabel, this.jTypeLabel);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jDescScrollPane, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTypeLabel).addComponent(this.jTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLanguageLabel).addComponent(this.jLanguageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jStopwordScrollPane, -1, 211, Short.MAX_VALUE).addContainerGap()));
        this.jTypeComboBox.getAccessibleContext().setAccessibleName("Type:");
    }

    private void jTypeComboBoxActionPerformed(ActionEvent actionEvent) {
        this.refreshUI();
    }

    public StoplistType getStoplist() {
        return this.stoplist;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("ADD_STOPWORD_DIALOG");
    }

    @Override
    protected String getHelpTopic() {
        return "stopword";
    }

    private static class WStringTokenizer
    extends StringTokenizer {
        private String tbt;
        private String d;
        private int startpos = 0;

        WStringTokenizer(String string, String string2) {
            super(string, string2);
            this.tbt = string;
            this.d = string2;
        }

        @Override
        public int countTokens() {
            int n = 0;
            int n2 = this.startpos;
            try {
                while (true) {
                    this.nextToken();
                    ++n;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.startpos = n2;
                return n;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasMoreTokens();
        }

        @Override
        public boolean hasMoreTokens() {
            return this.countTokens() > 0;
        }

        @Override
        public Object nextElement() {
            return this.d;
        }

        @Override
        public String nextToken() throws NoSuchElementException {
            if (this.startpos > this.tbt.length()) {
                throw new NoSuchElementException();
            }
            int n = this.tbt.indexOf(this.d, this.startpos);
            if (n < 0) {
                n = this.tbt.length();
            }
            String string = this.tbt.substring(this.startpos, n);
            this.startpos = n + this.d.length();
            return string;
        }

        @Override
        public String nextToken(String string) throws NoSuchElementException {
            this.d = string;
            return this.nextToken();
        }
    }

    private static class TokenInfo {
        private final String language;
        private final String type;
        private final String token;

        TokenInfo(String string, String string2, String string3) {
            this.language = string;
            this.type = string2;
            this.token = string3;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getType() {
            return this.type;
        }

        public String getToken() {
            return this.token;
        }
    }
}

