/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.math.BigDecimal;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Version;

public class ModelESABuildSettingsPanel
extends AbstractPropertiesPanel {
    private JMultiLineLabel jDescription = new JMultiLineLabel();
    private boolean isModelPartitioned = false;
    private Version _dbVersion = null;
    private JLabel jLblMinItems;
    private JLabel jLblThresholdValue;
    private JLabel jLblTopNFeature;
    private JScrollPane jSrcPane;
    private JTextField jTxtMinItems;
    private JTextField jTxtThresholdValue;
    private JTextField jTxtTopNFeature;

    public ModelESABuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this._dbVersion = ConnectionFolder.getConnectionFolder(advancedSettingsPanel.getContext()).getDbVersion();
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        PartitionExpressions partitionExpressions = commonSettingDataObject.getParentPanel().getMetadataCopy().getPartitionExpressions();
        if (partitionExpressions != null && partitionExpressions.getPartitionExpression() != null && partitionExpressions.getPartitionExpression().size() > 0) {
            this.isModelPartitioned = true;
        }
        this.initComponents();
        this.intRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSrcPane = new JScrollPane();
        this.jLblTopNFeature = new JLabel();
        this.jTxtTopNFeature = new NumberTextField();
        this.jLblMinItems = new JLabel();
        this.jTxtMinItems = new NumberTextField();
        this.jLblThresholdValue = new JLabel();
        this.jTxtThresholdValue = new NumberTextField();
        this.jSrcPane.setBorder(null);
        this.jLblTopNFeature.setText("Top N Feature:");
        this.jLblMinItems.setText("Minimum Items:");
        this.jLblThresholdValue.setText("Threshold Value:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jSrcPane, -1, 394, Short.MAX_VALUE).addContainerGap(26, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLblMinItems, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTxtMinItems, -2, 110, -2)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLblTopNFeature, -2, 182, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTxtTopNFeature, -2, 110, -2)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLblThresholdValue, -2, 107, -2).addGap(10, 10, 10).addComponent(this.jTxtThresholdValue, -2, 110, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this.jLblMinItems, this.jLblThresholdValue, this.jLblTopNFeature);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jSrcPane, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblTopNFeature).addComponent(this.jTxtTopNFeature, -2, -1, -2)).addGap(8, 8, 8).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblMinItems).addComponent(this.jTxtMinItems, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblThresholdValue).addComponent(this.jTxtThresholdValue, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLblTopNFeature.getAccessibleContext().setAccessibleName("");
        this.jLblMinItems.getAccessibleContext().setAccessibleName("");
        this.jLblThresholdValue.getAccessibleContext().setAccessibleName("");
    }

    private void intRes() {
        ResourceUtils.resLabel((JLabel)this.jLblTopNFeature, (Component)this.jTxtTopNFeature, (String)AlgSettingsLrb.get("ESAS_TOPN_FEATURES"));
        ResourceUtils.resLabel((JLabel)this.jLblMinItems, (Component)this.jTxtMinItems, (String)AlgSettingsLrb.get("ESAS_MIN_ITEMS"));
        ResourceUtils.resLabel((JLabel)this.jLblThresholdValue, (Component)this.jTxtThresholdValue, (String)AlgSettingsLrb.get("ESAS_VALUE_THRESHOLD"));
    }

    private void initUI() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.loadDescription(this.jDescription, this.jSrcPane);
        this.setDataType(this.jTxtTopNFeature, Integer.class);
        this.setDataType(this.jTxtMinItems, Integer.class);
        this.setDataType(this.jTxtThresholdValue, Double.class);
        ((NumberTextField)this.jTxtThresholdValue).setDecimal(true, 8);
        this.setSigned(this.jTxtTopNFeature, false);
        this.setSigned(this.jTxtMinItems, false);
        this.setSigned(this.jTxtThresholdValue, false);
        this.setLocale(this.jTxtTopNFeature, commonSettingDataObject.getLocale());
        this.setLocale(this.jTxtMinItems, commonSettingDataObject.getLocale());
        this.setLocale(this.jTxtThresholdValue, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("ESAS_TOPN_FEATURES");
        if (bigDecimal == null) {
            commonSettingDataObject.setBackupNullValue("ESAS_TOPN_FEATURES");
        } else {
            commonSettingDataObject.setBackupValue("ESAS_TOPN_FEATURES", bigDecimal);
            this.setNumber(this.jTxtTopNFeature, bigDecimal);
            this.jTxtTopNFeature.setToolTipText(AlgSettingsLrb.get("ESAS_TOPN_FEATURES_TOOLTIP"));
        }
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("ESAS_MIN_ITEMS");
        if (bigDecimal == null) {
            commonSettingDataObject.setBackupNullValue("ESAS_MIN_ITEMS");
        } else {
            commonSettingDataObject.setBackupValue("ESAS_MIN_ITEMS", bigDecimal);
            this.setNumber(this.jTxtMinItems, bigDecimal);
            this.jTxtMinItems.setToolTipText(AlgSettingsLrb.get("ESAS_MIN_ITEMS_TOOLTIP"));
        }
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("ESAS_VALUE_THRESHOLD");
        if (bigDecimal == null) {
            commonSettingDataObject.setBackupNullValue("ESAS_VALUE_THRESHOLD");
        } else {
            commonSettingDataObject.setBackupValue("ESAS_VALUE_THRESHOLD", bigDecimal.doubleValue());
            this.setNumber(this.jTxtThresholdValue, bigDecimal);
            this.jTxtThresholdValue.setToolTipText(AlgSettingsLrb.get("ESAS_VALUE_THRESHOLD_TOOLTIP"));
        }
    }

    @Override
    public void processInput() {
        Number number = this.getNumber(this.jTxtTopNFeature);
        if (null == number || number.intValue() < 0) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ESAS_TOPN_FEATURES_INVALID"));
            return;
        }
        this.setObjectValue("ESAS_TOPN_FEATURES", number);
        number = this.getNumber(this.jTxtMinItems);
        if (null == number || number.intValue() < 0) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ESAS_MIN_ITEMS_INVALID"));
            return;
        }
        this.setObjectValue("ESAS_MIN_ITEMS", number);
        number = this.getNumber(this.jTxtThresholdValue);
        if (null == number || number.intValue() < 0) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ESAS_VALUE_THRESHOLD_INVALID"));
            return;
        }
        this.setObjectValue("ESAS_VALUE_THRESHOLD", number);
    }
}

