/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.controls.models.SingleColumnTableModel;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.res.ARLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelARAddFilterPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelARPreprocessInputData;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.association.AssociationPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.association.WorkflowAssociationPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriModelType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RuleItemsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderGroup;
import oracle.javatools.ui.HyperlinkButton;

public class ModelARFilterPanel
extends JPanel
implements DataminerGUIPanel,
DialogDisplayable {
    private PropertyModel propertyModel;
    private static final Logger theLogger = Logger.getLogger(ModelARFilterPanel.class.getName());
    private JButton remIncAntecedentBtn;
    private JButton addIncAntecedentBtn;
    private JButton remIncConsequentBtn;
    private JButton addIncConsequentBtn;
    private JButton remExcAntecedentBtn;
    private JButton addExcAntecedentBtn;
    private JButton remExcConsequentBtn;
    private JButton addExcConsequentBtn;
    private AbstractBuildNode node;
    private Context context;
    private boolean filtersActive;
    private boolean filtersActiveOld;
    private RuleItemsType assoAntInRulesOld;
    private RuleItemsType assoConsInRulesOld;
    private RuleItemsType assoAntExRulesOld;
    private RuleItemsType assoConsExRulesOld;
    private boolean assoGeneratePreprocessedTableOld;
    private String assoPreprocessedTableNameOld;
    private boolean generatePreprocessedTable;
    private Map<String, CommonSettingDataObject> stateMap;
    private BuildNodeType nodeDataCopy;
    private boolean dirty;
    private String preprocessedTableName;
    private Mode mode;
    private ModelDescriptor model;
    private SingleColumnTableModel<String> includeAntTableModel;
    private SingleColumnTableModel<String> includeConTableModel;
    private SingleColumnTableModel<String> excludeAntTableModel;
    private SingleColumnTableModel<String> excludeConTableModel;
    private HyperlinkButton advSettingsBtn;
    private JCheckBox enableFiltersCheckBox;
    private DataMinerTablePanel excludeAntecedentTablePanel;
    private DataMinerTablePanel excludeConsequentTablePanel;
    private Header excludeHeader;
    private DataMinerTablePanel includeAntecedentTablePanel;
    private DataMinerTablePanel includeConsequentTablePanel;
    private Header includeHeader;
    private JPanel jExcludeRulesPanel;
    private JPanel jIncludeRulesPanel;

    public ModelARFilterPanel(PropertyModel propertyModel, Map<String, CommonSettingDataObject> map) {
        super(null);
        this.mode = Mode.PI_PANEL;
        this.stateMap = map;
        this.context = this.getContext(propertyModel);
        this.node = this.getTargetNode(propertyModel);
        this.nodeDataCopy = (BuildNodeType)this.node.getData();
        this.propertyModel = propertyModel;
        this.addAncestorListener(new PIAncestorListener(this));
        this.init();
        this.load();
    }

    public ModelARFilterPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType) {
        this.mode = Mode.BUILD_DIALOG;
        this.context = context;
        this.node = abstractBuildNode;
        this.nodeDataCopy = buildNodeType;
        this.init();
        this.load();
    }

    public ModelARFilterPanel(Context context, ModelDescriptor modelDescriptor) {
        this.mode = Mode.MODEL_VIEWER;
        this.context = context;
        this.model = modelDescriptor;
        this.init();
    }

    private void init() {
        this.initComponents();
        this.initUIComponents();
        this.initRes();
        this.initUI();
    }

    private void initUIComponents() {
        this.remIncAntecedentBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.addIncAntecedentBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.includeAntecedentTablePanel.addControlBarComponents(this.addIncAntecedentBtn, this.remIncAntecedentBtn);
        this.remIncConsequentBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.addIncConsequentBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.includeConsequentTablePanel.addControlBarComponents(this.addIncConsequentBtn, this.remIncConsequentBtn);
        this.remExcAntecedentBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.addExcAntecedentBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.excludeAntecedentTablePanel.addControlBarComponents(this.addExcAntecedentBtn, this.remExcAntecedentBtn);
        this.remExcConsequentBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.addExcConsequentBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.excludeConsequentTablePanel.addControlBarComponents(this.addExcConsequentBtn, this.remExcConsequentBtn);
    }

    @Override
    public void initRes() {
        this.includeHeader.setText(AlgSettingsLrb.get("ASSO_FILTER_INCLUDE"));
        this.excludeHeader.setText(AlgSettingsLrb.get("ASSO_FILTER_EXCLUDE"));
        this.remIncAntecedentBtn.setToolTipText(AlgSettingsLrb.get("ASSO_FILTER_ITEM_DELETE_TOOLTIP"));
        this.addIncAntecedentBtn.setToolTipText(AlgSettingsLrb.get("ASSO_FILTER_ITEM_ADD_TOOLTIP"));
        this.remIncConsequentBtn.setToolTipText(AlgSettingsLrb.get("ASSO_FILTER_ITEM_DELETE_TOOLTIP"));
        this.addIncConsequentBtn.setToolTipText(AlgSettingsLrb.get("ASSO_FILTER_ITEM_ADD_TOOLTIP"));
        this.remExcAntecedentBtn.setToolTipText(AlgSettingsLrb.get("ASSO_FILTER_ITEM_DELETE_TOOLTIP"));
        this.addExcAntecedentBtn.setToolTipText(AlgSettingsLrb.get("ASSO_FILTER_ITEM_ADD_TOOLTIP"));
        this.remExcConsequentBtn.setToolTipText(AlgSettingsLrb.get("ASSO_FILTER_ITEM_DELETE_TOOLTIP"));
        this.addExcConsequentBtn.setToolTipText(AlgSettingsLrb.get("ASSO_FILTER_ITEM_ADD_TOOLTIP"));
    }

    @Override
    public void initUI() {
        this.enableControls(false);
        this.initHeaders();
        this.initTables();
        this.initOthers();
    }

    private void initHeaders() {
        HeaderGroup headerGroup = new HeaderGroup(this.includeHeader);
        headerGroup.add((Component)this.jIncludeRulesPanel);
        HeaderGroup headerGroup2 = new HeaderGroup(this.excludeHeader);
        headerGroup2.add((Component)this.jExcludeRulesPanel);
        this.excludeHeader.setLevel(Header.Level.PAGE);
        this.excludeHeader.setExpandable(true);
        this.excludeHeader.setExpanded(true);
        this.includeHeader.setLevel(Header.Level.PAGE);
        this.includeHeader.setExpandable(true);
        this.includeHeader.setExpanded(true);
    }

    private void initTables() {
        this.includeAntTableModel = new SingleColumnTableModel(CoreCommonLrb.get((String)"ITEM"));
        this.includeConTableModel = new SingleColumnTableModel(CoreCommonLrb.get((String)"ITEM"));
        this.excludeAntTableModel = new SingleColumnTableModel(CoreCommonLrb.get((String)"ITEM"));
        this.excludeConTableModel = new SingleColumnTableModel(CoreCommonLrb.get((String)"ITEM"));
        this.includeAntecedentTablePanel.setup((TableModel)((Object)this.includeAntTableModel), ARLrb.get((String)"ANTECEDENT"), 0);
        this.includeConsequentTablePanel.setup((TableModel)((Object)this.includeConTableModel), ARLrb.get((String)"CONSEQUENT"), 0);
        this.excludeAntecedentTablePanel.setup((TableModel)((Object)this.excludeAntTableModel), ARLrb.get((String)"ANTECEDENT"), 0);
        this.excludeConsequentTablePanel.setup((TableModel)((Object)this.excludeConTableModel), ARLrb.get((String)"CONSEQUENT"), 0);
        RemoveItemActionListener removeItemActionListener = new RemoveItemActionListener();
        this.remIncAntecedentBtn.addActionListener(removeItemActionListener);
        this.remIncConsequentBtn.addActionListener(removeItemActionListener);
        this.remExcAntecedentBtn.addActionListener(removeItemActionListener);
        this.remExcConsequentBtn.addActionListener(removeItemActionListener);
        AddItemActionListener addItemActionListener = new AddItemActionListener();
        this.addIncAntecedentBtn.addActionListener(addItemActionListener);
        this.addIncConsequentBtn.addActionListener(addItemActionListener);
        this.addExcAntecedentBtn.addActionListener(addItemActionListener);
        this.addExcConsequentBtn.addActionListener(addItemActionListener);
    }

    private void initOthers() {
        this.advSettingsBtn.addActionListener((ActionListener)new AdvSettingsActionListener());
        if (Mode.MODEL_VIEWER.equals((Object)this.mode)) {
            this.enableFiltersCheckBox.setVisible(false);
            this.advSettingsBtn.setVisible(false);
        }
    }

    private boolean isPIMode() {
        return this.mode == Mode.PI_PANEL;
    }

    public void setStateMap(Map<String, CommonSettingDataObject> map) {
        this.stateMap = map;
    }

    public void reload(PropertyModel propertyModel) {
        this.propertyModel = propertyModel;
        this.context = this.getContext(propertyModel);
        this.node = this.getTargetNode(propertyModel);
        this.nodeDataCopy = (BuildNodeType)this.node.getData();
        this.load();
    }

    private void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return null;
        }
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
        Context context = workflowNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof BuildNodeType) {
            return (AbstractBuildNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return null;
        }
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
        Context context = workflowNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    public void processItemChanged() {
        List list = this.includeAntTableModel.getSrcData();
        List list2 = this.includeConTableModel.getSrcData();
        List list3 = this.excludeAntTableModel.getSrcData();
        List list4 = this.excludeConTableModel.getSrcData();
        List<ModelType> list5 = MetaDataHelper.getModelsCollection(this.nodeDataCopy);
        for (ModelType object : list5) {
            if (this.stateMap.containsKey(object.getId())) continue;
            this.createStateMapForModel(object);
        }
        for (Map.Entry entry : this.stateMap.entrySet()) {
            Object object3;
            ArrayList<Property> arrayList2;
            RuleItemsType.RuleItems ruleItems;
            Object object22;
            RuleItemsType.RuleItems ruleItems2;
            CommonSettingDataObject commonSettingDataObject = (CommonSettingDataObject)entry.getValue();
            RuleItemsType ruleItemsType = new RuleItemsType();
            if (list.size() > 0) {
                ruleItems2 = new RuleItemsType.RuleItems();
                for (Object object22 : list) {
                    object22 = "'" + StringUtils.escapeSingleQuotesForSQL((String)object22) + "'";
                    ruleItems2.getItem().add(object22);
                }
                ruleItemsType.setRuleItems(ruleItems2);
                commonSettingDataObject.setValue("ASSO_ANT_IN_RULES", ruleItemsType);
            } else {
                commonSettingDataObject.setValue("ASSO_ANT_IN_RULES", null);
            }
            ruleItems2 = new RuleItemsType();
            if (list2.size() > 0) {
                ruleItems = new RuleItemsType.RuleItems();
                for (ArrayList<Property> arrayList2 : list2) {
                    arrayList2 = "'" + StringUtils.escapeSingleQuotesForSQL((String)((Object)arrayList2)) + "'";
                    ruleItems.getItem().add(arrayList2);
                }
                ruleItems2.setRuleItems(ruleItems);
                commonSettingDataObject.setValue("ASSO_CONS_IN_RULES", ruleItems2);
            } else {
                commonSettingDataObject.setValue("ASSO_CONS_IN_RULES", null);
            }
            ruleItems = new RuleItemsType();
            if (list3.size() > 0) {
                object22 = new RuleItemsType.RuleItems();
                for (Object object3 : list3) {
                    object3 = "'" + StringUtils.escapeSingleQuotesForSQL((String)object3) + "'";
                    object22.getItem().add(object3);
                }
                ruleItems.setRuleItems((RuleItemsType.RuleItems)object22);
                commonSettingDataObject.setValue("ASSO_ANT_EX_RULES", ruleItems);
            } else {
                commonSettingDataObject.setValue("ASSO_ANT_EX_RULES", null);
            }
            object22 = new RuleItemsType();
            if (list4.size() > 0) {
                arrayList2 = new RuleItemsType.RuleItems();
                for (String string : list4) {
                    string = "'" + StringUtils.escapeSingleQuotesForSQL(string) + "'";
                    arrayList2.getItem().add(string);
                }
                object22.setRuleItems((RuleItemsType.RuleItems)arrayList2);
                commonSettingDataObject.setValue("ASSO_CONS_EX_RULES", object22);
            } else {
                commonSettingDataObject.setValue("ASSO_CONS_EX_RULES", null);
            }
            commonSettingDataObject.setValue("ASSO_FILTERS_ACTIVE", this.filtersActive);
            commonSettingDataObject.setValue("ASSO_GENERATE_PREPROCESSED_TABLE", this.generatePreprocessedTable);
            commonSettingDataObject.setApplyFilter(true);
            commonSettingDataObject.finish();
            commonSettingDataObject.apply();
            if (!(this.propertyModel instanceof WorkflowAssociationPartitionedBuildNodePropertyProxyModel)) continue;
            arrayList2 = new ArrayList<Property>();
            AssociationPartitionedBuildNodePropertyModel.updateEnableFilters(arrayList2, this.node, this.filtersActive, this.filtersActiveOld);
            ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_ASSOC_BUILD_GROUP_BUILD_ITEMS_ENABLE_FILTERS"), this.node, arrayList2);
            AssociationPartitionedBuildNodePropertyModel.updateAssoAntInRules(arrayList2, this.node, ruleItemsType, this.assoAntInRulesOld);
            ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_ASSOC_BUILD_GROUP_BUILD_ITEMS_INCLUDE_ANTECEDENT"), this.node, arrayList2);
            AssociationPartitionedBuildNodePropertyModel.updateAssoConsInRules(arrayList2, this.node, (RuleItemsType)ruleItems2, this.assoConsInRulesOld);
            ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_ASSOC_BUILD_GROUP_BUILD_ITEMS_INCLUDE_CONSEQUENT"), this.node, arrayList2);
            AssociationPartitionedBuildNodePropertyModel.updateAssoAntExRules(arrayList2, this.node, (RuleItemsType)ruleItems, this.assoAntExRulesOld);
            ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_ASSOC_BUILD_GROUP_BUILD_ITEMS_EXCLUDE_ANTECEDENT"), this.node, arrayList2);
            AssociationPartitionedBuildNodePropertyModel.updateAssoConsExRules(arrayList2, this.node, (RuleItemsType)object22, this.assoConsExRulesOld);
            ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_ASSOC_BUILD_GROUP_BUILD_ITEMS_EXCLUDE_CONSEQUENT"), this.node, arrayList2);
            AssociationPartitionedBuildNodePropertyModel.updateGeneratePreprocessedTable(arrayList2, this.node, this.generatePreprocessedTable, this.assoGeneratePreprocessedTableOld);
            ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_ASSOC_BUILD_GROUP_BUILD_ITEMS_GENERATE_TABLE"), this.node, arrayList2);
            object3 = commonSettingDataObject.getModelSettingStringValue("ASSO_PREPROCESSED_TABLE_NAME");
            AssociationPartitionedBuildNodePropertyModel.updatePreprocessedTableName(arrayList2, this.node, (String)object3, this.assoPreprocessedTableNameOld);
            ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_ASSOC_BUILD_GROUP_BUILD_PREPROCESSED_TABLE_NAME"), this.node, arrayList2);
        }
    }

    private void createStateMapForModel(ModelType modelType) {
        if (this.stateMap.containsKey(modelType.getId()) || this.node.getModel() == null) {
            return;
        }
        AbstractDataNode abstractDataNode = this.node.findBuildDataNode(this.node.getModel());
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.nodeDataCopy;
        CommonSettingDataObject commonSettingDataObject = new CommonSettingDataObject(this.context, null, modelType, (BuildNodeType)associationBuildNodeType, abstractDataNode, this.getLocale());
        try {
            if (this.isPIMode()) {
                commonSettingDataObject.loadSettingsForPI();
            } else {
                commonSettingDataObject.load();
            }
            commonSettingDataObject.setLoaded(true);
            this.stateMap.put(modelType.getId(), commonSettingDataObject);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)"Error", (String)exception.getMessage(), null);
        }
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setGeneratePreprocessedTable(boolean bl) {
        this.generatePreprocessedTable = bl;
        this.setDirty(true);
    }

    public boolean getGeneratePreprocessedTable() {
        return this.generatePreprocessedTable;
    }

    public void enableControls(boolean bl) {
        if (!Mode.MODEL_VIEWER.equals((Object)this.mode)) {
            this.addIncAntecedentBtn.setEnabled(bl);
            this.remIncAntecedentBtn.setEnabled(bl);
            this.addIncConsequentBtn.setEnabled(bl);
            this.remIncConsequentBtn.setEnabled(bl);
            this.addExcAntecedentBtn.setEnabled(bl);
            this.remExcAntecedentBtn.setEnabled(bl);
            this.addExcConsequentBtn.setEnabled(bl);
            this.remExcConsequentBtn.setEnabled(bl);
            this.advSettingsBtn.setEnabled(bl);
        }
    }

    public List<String> getIncludeAntecedents() {
        return this.includeAntTableModel.getSrcData();
    }

    public List<String> getIncludeConsequents() {
        return this.includeConTableModel.getSrcData();
    }

    public List<String> getExcludeAntecedents() {
        return this.excludeAntTableModel.getSrcData();
    }

    public List<String> getExcludeConsequents() {
        return this.excludeConTableModel.getSrcData();
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public void onOK() throws DialogExecutionException {
            }

            @Override
            public String getTitle() {
                return CoreCommonLrb.get((String)"ITEMS");
            }

            @Override
            public int getButtonMask() {
                return 3;
            }

            @Override
            public String getHelpTopic() {
                return null;
            }

            @Override
            public JComponent getContent() {
                return ModelARFilterPanel.this;
            }
        };
    }

    private void initComponents() {
        this.enableFiltersCheckBox = new JCheckBox();
        this.jIncludeRulesPanel = new JPanel();
        this.includeAntecedentTablePanel = new DataMinerTablePanel();
        this.includeConsequentTablePanel = new DataMinerTablePanel();
        this.jExcludeRulesPanel = new JPanel();
        this.excludeAntecedentTablePanel = new DataMinerTablePanel();
        this.excludeConsequentTablePanel = new DataMinerTablePanel();
        this.excludeHeader = new Header();
        this.includeHeader = new Header();
        this.advSettingsBtn = new HyperlinkButton();
        this.enableFiltersCheckBox.setText("Enable filters");
        this.enableFiltersCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelARFilterPanel.this.enableFiltersCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jIncludeRulesPanel.setLayout(new GridLayout(1, 0, 25, 0));
        this.jIncludeRulesPanel.add(this.includeAntecedentTablePanel);
        this.jIncludeRulesPanel.add(this.includeConsequentTablePanel);
        this.jExcludeRulesPanel.setLayout(new GridLayout(1, 0, 25, 0));
        this.jExcludeRulesPanel.add(this.excludeAntecedentTablePanel);
        this.jExcludeRulesPanel.add(this.excludeConsequentTablePanel);
        this.excludeHeader.setName("excludeHeader");
        this.excludeHeader.setText("Exclude");
        this.includeHeader.setName("excludeHeader");
        this.includeHeader.setText("Include");
        this.advSettingsBtn.setText("Advanced Settings");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.excludeHeader, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.enableFiltersCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.advSettingsBtn, -2, -1, -2).addGap(2, 2, 2)).addComponent((Component)this.includeHeader, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jIncludeRulesPanel, GroupLayout.Alignment.TRAILING, -1, 684, Short.MAX_VALUE).addComponent(this.jExcludeRulesPanel, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enableFiltersCheckBox).addComponent((Component)this.advSettingsBtn, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.includeHeader, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jIncludeRulesPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.excludeHeader, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jExcludeRulesPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void enableFiltersCheckBoxActionPerformed(ActionEvent actionEvent) {
        AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
        this.filtersActive = abstractButton.getModel().isSelected();
        this.setDirty(true);
        this.enableControls(this.filtersActive);
    }

    public static enum Mode {
        PI_PANEL,
        BUILD_DIALOG,
        MODEL_VIEWER;

    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        private LoadUI() {
            super(ModelARFilterPanel.this, null);
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.createStateMap();
            return null;
        }

        private void createStateMap() throws ODMrDAOException {
            AbstractDataNode abstractDataNode = ModelARFilterPanel.this.node.findBuildDataNode(ModelARFilterPanel.this.node.getModel());
            List list = ((AssociationBuildNodeType)ModelARFilterPanel.this.nodeDataCopy).getModels().getAprioriModel();
            AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)ModelARFilterPanel.this.nodeDataCopy;
            for (AprioriModelType aprioriModelType : list) {
                CommonSettingDataObject commonSettingDataObject = new CommonSettingDataObject(ModelARFilterPanel.this.context, null, (ModelType)aprioriModelType, (BuildNodeType)associationBuildNodeType, abstractDataNode, ModelARFilterPanel.this.getLocale());
                if (ModelARFilterPanel.this.isPIMode()) {
                    commonSettingDataObject.loadSettingsForPI();
                } else {
                    commonSettingDataObject.load();
                }
                commonSettingDataObject.setLoaded(true);
                ModelARFilterPanel.this.stateMap.put(aprioriModelType.getId(), commonSettingDataObject);
            }
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            this.onStateLoaded();
        }

        private void onStateLoaded() {
            CommonSettingDataObject commonSettingDataObject = null;
            Iterator iterator = ModelARFilterPanel.this.stateMap.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                commonSettingDataObject = (CommonSettingDataObject)entry.getValue();
            }
            this.fillTableModelFromState(commonSettingDataObject, ModelARFilterPanel.this.includeAntTableModel, "ASSO_ANT_IN_RULES");
            this.fillTableModelFromState(commonSettingDataObject, ModelARFilterPanel.this.includeConTableModel, "ASSO_CONS_IN_RULES");
            this.fillTableModelFromState(commonSettingDataObject, ModelARFilterPanel.this.excludeAntTableModel, "ASSO_ANT_EX_RULES");
            this.fillTableModelFromState(commonSettingDataObject, ModelARFilterPanel.this.excludeConTableModel, "ASSO_CONS_EX_RULES");
            if (commonSettingDataObject != null) {
                ModelARFilterPanel.this.filtersActive = (Boolean)commonSettingDataObject.getModelSettingObjectValue("ASSO_FILTERS_ACTIVE");
                ModelARFilterPanel.this.generatePreprocessedTable = (Boolean)commonSettingDataObject.getModelSettingObjectValue("ASSO_GENERATE_PREPROCESSED_TABLE");
            } else {
                ModelARFilterPanel.this.filtersActive = false;
                ModelARFilterPanel.this.generatePreprocessedTable = false;
            }
            ModelARFilterPanel.this.preprocessedTableName = ModelARFilterPanel.this.generatePreprocessedTable ? commonSettingDataObject.getModelSettingStringValue("ASSO_PREPROCESSED_TABLE_NAME") : "";
            ModelARFilterPanel.this.enableFiltersCheckBox.setSelected(ModelARFilterPanel.this.filtersActive);
            ModelARFilterPanel.this.enableControls(ModelARFilterPanel.this.filtersActive);
            ModelARFilterPanel.this.filtersActiveOld = ModelARFilterPanel.this.filtersActive;
            ModelARFilterPanel.this.assoAntInRulesOld = (RuleItemsType)commonSettingDataObject.getModelSettingObjectValue("ASSO_ANT_IN_RULES");
            ModelARFilterPanel.this.assoAntExRulesOld = (RuleItemsType)commonSettingDataObject.getModelSettingObjectValue("ASSO_ANT_EX_RULES");
            ModelARFilterPanel.this.assoConsInRulesOld = (RuleItemsType)commonSettingDataObject.getModelSettingObjectValue("ASSO_CONS_IN_RULES");
            ModelARFilterPanel.this.assoConsExRulesOld = (RuleItemsType)commonSettingDataObject.getModelSettingObjectValue("ASSO_CONS_EX_RULES");
            ModelARFilterPanel.this.assoGeneratePreprocessedTableOld = ModelARFilterPanel.this.generatePreprocessedTable;
            ModelARFilterPanel.this.assoPreprocessedTableNameOld = ModelARFilterPanel.this.preprocessedTableName;
        }

        private void fillTableModelFromState(CommonSettingDataObject commonSettingDataObject, SingleColumnTableModel<String> singleColumnTableModel, String string) {
            RuleItemsType.RuleItems ruleItems;
            if (commonSettingDataObject == null) {
                return;
            }
            RuleItemsType ruleItemsType = (RuleItemsType)commonSettingDataObject.getModelSettingObjectValue(string);
            if (ruleItemsType != null && (ruleItems = ruleItemsType.getRuleItems()) != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                List list = ruleItems.getItem();
                for (String string2 : list) {
                    string2 = StringUtils.trimSingleQuotes(string2);
                    arrayList.add(string2);
                }
                singleColumnTableModel.addRows(arrayList);
            }
        }

        @Override
        protected void onFailureOnSuccess(Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private class AdvSettingsActionListener
    implements ActionListener {
        private AdvSettingsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.displayPreprocessInputDialog();
        }

        private void displayPreprocessInputDialog() {
            ModelARPreprocessInputData modelARPreprocessInputData = new ModelARPreprocessInputData(ModelARFilterPanel.this);
            DialogHelper dialogHelper = new DialogHelper(modelARPreprocessInputData);
            if (dialogHelper.showAsDialog(ModelARFilterPanel.this) && ModelARFilterPanel.this.isPIMode()) {
                ModelARFilterPanel.this.processItemChanged();
            }
        }
    }

    private class RemoveItemActionListener
    implements ActionListener {
        private RemoveItemActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataMinerTable dataMinerTable = this.getSourceTable(actionEvent.getSource());
            this.removeSelectedRowsFromTable(dataMinerTable);
            if (ModelARFilterPanel.this.isPIMode()) {
                ModelARFilterPanel.this.processItemChanged();
            }
        }

        private DataMinerTable getSourceTable(Object object) {
            DataMinerTable dataMinerTable = null;
            if (object == ModelARFilterPanel.this.remIncAntecedentBtn) {
                dataMinerTable = ModelARFilterPanel.this.includeAntecedentTablePanel.getTable();
            } else if (object == ModelARFilterPanel.this.remIncConsequentBtn) {
                dataMinerTable = ModelARFilterPanel.this.includeConsequentTablePanel.getTable();
            } else if (object == ModelARFilterPanel.this.remExcAntecedentBtn) {
                dataMinerTable = ModelARFilterPanel.this.excludeAntecedentTablePanel.getTable();
            } else if (object == ModelARFilterPanel.this.remExcConsequentBtn) {
                dataMinerTable = ModelARFilterPanel.this.excludeConsequentTablePanel.getTable();
            } else assert (false) : "Source table not found";
            return dataMinerTable;
        }

        private void removeSelectedRowsFromTable(DataMinerTable dataMinerTable) {
            if (dataMinerTable.getSelectedRowCount() > 0) {
                SingleColumnTableModel singleColumnTableModel = (SingleColumnTableModel)((Object)dataMinerTable.getModel());
                int[] nArray = dataMinerTable.getSelectedRowsInModel();
                singleColumnTableModel.removeRows(nArray);
                ModelARFilterPanel.this.setDirty(true);
            }
        }
    }

    private class AddItemActionListener
    implements ActionListener {
        private AddItemActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataMinerTable dataMinerTable = this.getSourceTable(actionEvent.getSource());
            ModelARAddFilterPanel modelARAddFilterPanel = this.getFilterPanel(dataMinerTable);
            DialogHelper dialogHelper = new DialogHelper(modelARAddFilterPanel);
            if (dialogHelper.showAsDialog(ModelARFilterPanel.this)) {
                ModelARFilterPanel.this.setDirty(true);
                if (ModelARFilterPanel.this.isPIMode()) {
                    ModelARFilterPanel.this.processItemChanged();
                }
            }
        }

        private ModelARAddFilterPanel getFilterPanel(DataMinerTable dataMinerTable) {
            ModelARAddFilterPanel modelARAddFilterPanel = null;
            modelARAddFilterPanel = Mode.MODEL_VIEWER.equals((Object)ModelARFilterPanel.this.mode) ? new ModelARAddFilterPanel(ModelARFilterPanel.this.context, dataMinerTable, ModelARFilterPanel.this.model.getSchema(), ModelARFilterPanel.this.model.getName(), ModelARFilterPanel.this.model.getPartitionId()) : new ModelARAddFilterPanel(ModelARFilterPanel.this.context, dataMinerTable, ModelARFilterPanel.this.node, ModelARFilterPanel.this.preprocessedTableName, ModelARFilterPanel.this.nodeDataCopy);
            return modelARAddFilterPanel;
        }

        private DataMinerTable getSourceTable(Object object) {
            DataMinerTable dataMinerTable = null;
            if (object == ModelARFilterPanel.this.addIncAntecedentBtn) {
                dataMinerTable = ModelARFilterPanel.this.includeAntecedentTablePanel.getTable();
            } else if (object == ModelARFilterPanel.this.addIncConsequentBtn) {
                dataMinerTable = ModelARFilterPanel.this.includeConsequentTablePanel.getTable();
            } else if (object == ModelARFilterPanel.this.addExcAntecedentBtn) {
                dataMinerTable = ModelARFilterPanel.this.excludeAntecedentTablePanel.getTable();
            } else if (object == ModelARFilterPanel.this.addExcConsequentBtn) {
                dataMinerTable = ModelARFilterPanel.this.excludeConsequentTablePanel.getTable();
            } else assert (false) : "Source table not found";
            return dataMinerTable;
        }
    }
}

