/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.controls.JMultiLineLabel;

public abstract class AbstractPropertiesPanel
extends JPanel {
    protected static final String _LOADING = AlgSettingsLrb.get("LOADING_SETTINGS_STATUS");
    protected static final String _UNDER_CONSTRUCTION = "Not implemented yet";
    protected static final String _MULTIPLE_SELECTION = BuildEditorLrb.get("MULTIPLE_SELECTION");
    protected static final String _EMPTY_SELECTION = BuildEditorLrb.get("EMPTY_SELECTION");
    protected AdvancedSettingsPanel parentPanel;
    private ModelType modelType;

    public abstract void processInput();

    protected void clearState() {
        this.getPanelState().clearContentSettings(this.getClass().getName());
        this.getPanelState().clearValidationError();
    }

    protected void setObjectValue(String string, Object object) {
        this.getPanelState().setValue(string, object);
        this.getPanelState().addSetting(this.getClass().getName(), string);
    }

    protected void setNullObjectValue(String string) {
        this.getPanelState().setNullValue(string);
        this.getPanelState().addSetting(this.getClass().getName(), string);
    }

    protected void setValidationErrorObjectValue(String string) {
        this.getPanelState().setValidationError(string);
        this.getPanelState().addValidationErrorSetting(this.getClass().getName());
    }

    public AbstractPropertiesPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        this.modelType = modelType;
        this.parentPanel = advancedSettingsPanel;
    }

    public AbstractPropertiesPanel(AdvancedSettingsPanel advancedSettingsPanel) {
        this.parentPanel = advancedSettingsPanel;
    }

    private Object getAuxMetadata(String string) {
        assert (this.parentPanel != null);
        return this.parentPanel.getAuxMetadata(string);
    }

    private void putAuxMetadata(String string, Object object) {
        assert (this.parentPanel != null);
        this.parentPanel.putAuxMetadata(string, object);
    }

    protected CommonSettingDataObject getPanelState() {
        return (CommonSettingDataObject)this.getAuxMetadata(this.modelType.getId());
    }

    protected void setState(CommonSettingDataObject commonSettingDataObject) {
        this.putAuxMetadata(this.modelType.getId(), commonSettingDataObject);
    }

    protected void setNumber(JTextField jTextField, Number number) {
        ((NumberTextField)jTextField).setNumber(number);
    }

    protected void setDataType(JTextField jTextField, Class clazz) {
        ((NumberTextField)jTextField).setDataType(clazz);
    }

    protected void setSigned(JTextField jTextField, boolean bl) {
        ((NumberTextField)jTextField).setSigned(bl);
    }

    protected void setLocale(JTextField jTextField, Locale locale) {
        ((NumberTextField)jTextField).setLocale(locale);
    }

    protected Number getNumber(JTextField jTextField) {
        return ((NumberTextField)jTextField).getNumber();
    }

    protected void loadDescription(JMultiLineLabel jMultiLineLabel, JScrollPane jScrollPane) {
        jMultiLineLabel.setText(AlgSettingsLrb.get("ALGORITHM_SETTINGS_TITLE"));
        jScrollPane.getViewport().add((Component)jMultiLineLabel);
    }

    protected AbstractPropertiesPanel createModelUnderConstructionPanel() {
        return new ServicePanel(this.parentPanel, _UNDER_CONSTRUCTION);
    }

    protected AbstractPropertiesPanel createMultipleSelection() {
        return new ServicePanel(this.parentPanel, _MULTIPLE_SELECTION);
    }

    protected AbstractPropertiesPanel createEmptySelection() {
        return new ServicePanel(this.parentPanel, _EMPTY_SELECTION);
    }

    protected AbstractPropertiesPanel createLoadingStatusPanel(AdvancedSettingsPanel advancedSettingsPanel) {
        return new ServicePanel(advancedSettingsPanel, _LOADING);
    }

    public AdvancedSettingsPanel getParentPanel() {
        return this.parentPanel;
    }

    public void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    class ServicePanel
    extends AbstractPropertiesPanel {
        JLabel jLblText;

        ServicePanel(AdvancedSettingsPanel advancedSettingsPanel, String string) {
            super(advancedSettingsPanel);
            this.jLblText = new JLabel();
            this.jLblText.setHorizontalAlignment(0);
            this.jLblText.setText(string);
            this.setLayout(new BorderLayout());
            this.add((Component)this.jLblText, "Center");
        }

        @Override
        public void processInput() {
        }

        public boolean isMultipleSelectionPanel() {
            return this.jLblText.getText().equals(_MULTIPLE_SELECTION);
        }

        protected final CommonSettingDataObject getState() {
            return (CommonSettingDataObject)AbstractPropertiesPanel.this.getAuxMetadata(AbstractPropertiesPanel.this.modelType.getId());
        }
    }
}

