/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetAvailableThesaurusQuery;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistDetailsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistWizard;
import oracle.dmt.dataminer.workflow.dialog.build.TextSettingsSynonymPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.combo.CheckComboModel;
import oracle.javatools.ui.combo.JCheckCombo;
import oracle.javatools.util.Version;

public class TextTransColumnSettingSynonymPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(TextSettingsSynonymPanel.class.getName());
    private BuildNodeType _buildNodeType;
    private String _sourceAttributeName;
    private BuildNodeType.Stoplists _stoplists;
    private TextTransformationType.Synonym _synonym;
    private AbstractBuildNode _node;
    private Context _context;
    private boolean _isAdjusting;
    private boolean _isAllSelected;
    private boolean _isNoneSelected;
    private static Icon _editIcon;
    private boolean _dirty;
    private boolean _loadedThesaurus;
    private JLabel JLableMinRows;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private JButton jEditStoplistButton;
    private JLabel jLanguageLabel;
    private JLabel jMaxNumAllDocsLabel;
    private JSpinner jMaxNumAllDocsSpinner;
    private JButton jNewStoplistButton;
    private JComboBox jSelectedStoplistComboBox;
    private JComboBox jSingleBtyeComboBox;
    private JLabel jStoplistLabel;
    private JComboBox jThesaurusComboBox;
    private JLabel jTokenLanguageLabel;
    private JSpinner jTokenMinRowsTokenSpinner;

    public TextTransColumnSettingSynonymPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, String string, TextTransformationType.Synonym synonym, BuildNodeType.Stoplists stoplists) {
        this._context = context;
        this._node = abstractBuildNode;
        this._buildNodeType = buildNodeType;
        this._stoplists = stoplists;
        this._sourceAttributeName = string;
        this._synonym = synonym;
        this._dirty = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTokenLanguageLabel, (Component)this.jSingleBtyeComboBox, (String)DialogsLrb.get("BUILD_TEXT_LANGUAGES"));
        ResourceUtils.resLabel((JLabel)this.jLanguageLabel, (Component)this.jThesaurusComboBox, (String)DialogsLrb.get("BUILD_TEXT_THESAURUS"));
        ResourceUtils.resLabel((JLabel)this.jStoplistLabel, (Component)this.jSelectedStoplistComboBox, (String)DialogsLrb.get("BUILD_TEXT_STOPLIST"));
        ResourceUtils.resSpinner((JLabel)this.jMaxNumAllDocsLabel, (JSpinner)this.jMaxNumAllDocsSpinner, (String)DialogsLrb.get("BUILD_TEXT_MAX_NUM_ALL_DOCS"));
        ResourceUtils.resSpinner((JLabel)this.JLableMinRows, (JSpinner)this.jTokenMinRowsTokenSpinner, (String)DialogsLrb.get("BUILD_TEXT_MIN_ROWS_TOKEN_DOCS"));
        _editIcon = InspectorArb.getIcon((int)24);
    }

    public void initUI() {
        this.jTokenMinRowsTokenSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TextTransColumnSettingSynonymPanel.this._dirty = true;
            }
        });
        this.jEditStoplistButton.setText(null);
        this.jEditStoplistButton.setIcon(_editIcon);
        this.jEditStoplistButton.setToolTipText(DialogsLrb.get("BUILD_TEXT_EDIT_STOPLIST_TOOLTIP"));
        this.jNewStoplistButton.setText(null);
        this.jNewStoplistButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.jNewStoplistButton.setToolTipText(DialogsLrb.get("BUILD_TEXT_ADD_STOPLIST_TOOLTIP"));
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman((String)"All"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman((String)"None"));
        for (ServerConstants.StoplistLanguage.BASIC_LEXER_LANG bASIC_LEXER_LANG : ServerConstants.StoplistLanguage.BASIC_LEXER_LANG.values()) {
            defaultListModel.addElement(bASIC_LEXER_LANG.value());
        }
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.addSelectionInterval(1, 1);
        CheckComboModel checkComboModel = new CheckComboModel(defaultListModel, (ListSelectionModel)defaultListSelectionModel);
        ((JCheckCombo)this.jSingleBtyeComboBox).setModel(checkComboModel);
        ListSelectionModel listSelectionModel = ((JCheckCombo)this.jSingleBtyeComboBox).getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    TextTransColumnSettingSynonymPanel.this.jSingleByteLanguageValueChanged(listSelectionEvent);
                }
            }
        });
        this.loadThesaurus();
        this.refreshUI(this._synonym);
    }

    public boolean isThesaurusLoaded() {
        return this._loadedThesaurus;
    }

    private void loadThesaurus() {
        Version version = ConnectionFolder.getConnectionFolder(this._context).getDbVersion();
        GetAvailableThesaurusQuery getAvailableThesaurusQuery = new GetAvailableThesaurusQuery(version);
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject((ConnectionManager)ConnectionFolder.getConnectionFolder(this._context));
        try {
            List list = sqlDataAccessObject.readItems((Query)getAvailableThesaurusQuery);
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            for (String string : list) {
                defaultComboBoxModel.addElement(string);
            }
            this.jThesaurusComboBox.setModel(defaultComboBoxModel);
            if (defaultComboBoxModel.getSize() > 0) {
                this._loadedThesaurus = true;
            }
        }
        catch (ODMrDAOException oDMrDAOException) {
            logger.log(Level.INFO, DialogsLrb.get("BUILD_TEXT_SYNONYM_THESAURUS_NOT_LOADED"), oDMrDAOException);
        }
    }

    private void initStoplists(String string) {
        List list = null;
        list = this._stoplists.getStoplist();
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StoplistType stoplistType : list) {
            arrayList.add(stoplistType.getName());
            if (string == null || !stoplistType.getId().equals(string)) continue;
            string2 = stoplistType.getName();
        }
        Collections.sort(arrayList);
        arrayList.add(0, ServerConstants.StoplistLanguage.toHuman((String)"None"));
        this.jSelectedStoplistComboBox.removeAllItems();
        this.jSelectedStoplistComboBox.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        if (string2 != null) {
            this.jSelectedStoplistComboBox.setSelectedItem(string2);
        }
    }

    public void refreshUI(TextTransformationType.Synonym synonym) {
        BigInteger bigInteger;
        this.initStoplists(synonym.getToken().getStoplistId());
        List list = null;
        list = synonym.getToken().getLanguages().getLanguage();
        this._isAdjusting = true;
        ListSelectionModel listSelectionModel = ((JCheckCombo)this.jSingleBtyeComboBox).getSelectionModel();
        listSelectionModel.clearSelection();
        CheckComboModel checkComboModel = ((JCheckCombo)this.jSingleBtyeComboBox).getCheckModel();
        boolean bl = false;
        for (TransformationTokenType.Token.Languages.Language language : list) {
            for (int i = 0; i < checkComboModel.getSize(); ++i) {
                String string = (String)checkComboModel.getElementAt(i);
                if (!string.equals(ServerConstants.StoplistLanguage.toHuman((String)language.getName()))) continue;
                listSelectionModel.addSelectionInterval(i, i);
                bl = true;
            }
        }
        if (!bl) {
            listSelectionModel.addSelectionInterval(1, 1);
        }
        this._isAdjusting = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (String string : synonym.getToken().getLexer().getSettings().getAttribute()) {
            if (string.getName().equals("index_stems")) {
                bl2 = true;
            }
            if (!"index_bigram".equals(string.getName())) continue;
            bl3 = true;
        }
        if (synonym != null) {
            String string = synonym.getThesaurus();
            for (int i = 0; i < this.jThesaurusComboBox.getItemCount(); ++i) {
                if (!this.jThesaurusComboBox.getItemAt(i).toString().equals(string)) continue;
                this.jThesaurusComboBox.setSelectedIndex(i);
                break;
            }
        }
        int n = 1;
        if (synonym != null) {
            n = synonym.getToken().getMaxNumberAllDocs().intValue();
        }
        this.jMaxNumAllDocsSpinner.setModel(new SpinnerNumberModel(n, 1, 100000, 1000));
        int n2 = 1;
        if (synonym != null && (bigInteger = synonym.getToken().getMinNumberAllDocs()) != null) {
            n2 = synonym.getToken().getMinNumberAllDocs().intValue();
        }
        this.jTokenMinRowsTokenSpinner.setModel(new SpinnerNumberModel(n2, 1, 100000, 1000));
        this.enableControls();
    }

    public boolean copySettings(BuildNodeType buildNodeType, TransformationTokenType transformationTokenType, BuildNodeType.Stoplists stoplists) throws ValidationException {
        Object object;
        Object[] objectArray;
        StoplistType stoplistType = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        TransformationTokenType.Token.Languages languages = new TransformationTokenType.Token.Languages();
        TransformationTokenType.Token.Languages.Language language = null;
        TextTransformationType.Synonym synonym = (TextTransformationType.Synonym)transformationTokenType;
        synonym.setThesaurus(this.jThesaurusComboBox.getSelectedItem().toString());
        CheckComboModel checkComboModel = ((JCheckCombo)this.jSingleBtyeComboBox).getCheckModel();
        for (Object object2 : objectArray = checkComboModel.getSelectedItem()) {
            object = (String)object2;
            if (ServerConstants.StoplistLanguage.isALL((String)ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isNone((String)ServerConstants.StoplistLanguage.toSchema((String)object))) continue;
            language = new TransformationTokenType.Token.Languages.Language();
            language.setName(ServerConstants.StoplistLanguage.toSchema((String)object));
            if (ServerConstants.StoplistLanguage.isTraditionalChinese((String)ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isSimplifiedChinese((String)ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isJapanese((String)ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isKorean((String)ServerConstants.StoplistLanguage.toSchema((String)object))) {
                language.setType("MultiByte");
            } else {
                language.setType("SingleByte");
            }
            languages.getLanguage().add(language);
            arrayList.add(ServerConstants.StoplistLanguage.toSchema((String)object));
        }
        if (arrayList.size() == 0) {
            throw new ValidationException(DialogsLrb.get("BUILD_TEXT_NO_LANGUAGE_ERROR"));
        }
        transformationTokenType.getToken().setLanguages(languages);
        if (languages.getLanguage().size() <= 1) {
            transformationTokenType.getToken().getLexer().setType("Basic");
        } else {
            transformationTokenType.getToken().getLexer().setType("Auto");
        }
        transformationTokenType.getToken().setStoplistId(null);
        String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
        if (string != null) {
            if (ServerConstants.StoplistLanguage.isDefault((String)ServerConstants.StoplistLanguage.toSchema((String)string))) {
                String n = null;
                n = languages.getLanguage().size() <= 1 ? ((TransformationTokenType.Token.Languages.Language)languages.getLanguage().get(0)).getName() : "Multi";
                stoplistType = AbstractBuildNode.findDefaultStoplist(stoplists, n);
                String n2 = stoplistType.getId();
                transformationTokenType.getToken().setStoplistId(n2);
            } else {
                transformationTokenType.getToken().setStoplistId(AbstractBuildNode.findStoplistId(stoplists, string));
            }
        }
        Integer n = (Integer)this.jMaxNumAllDocsSpinner.getValue();
        transformationTokenType.getToken().setMaxNumberAllDocs(BigInteger.valueOf(n.intValue()));
        Integer n2 = (Integer)this.jTokenMinRowsTokenSpinner.getValue();
        transformationTokenType.getToken().setMinNumberAllDocs(BigInteger.valueOf(n2.intValue()));
        if (stoplistType != null) {
            boolean bl;
            ArrayList<String> arrayList2 = AbstractTextNode.findStoplistLanguages(stoplistType, "Word");
            object = new ArrayList();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (String string2 : arrayList) {
                bl = false;
                for (String string3 : arrayList2) {
                    if (!string2.equals(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                ((ArrayList)object).add(string2);
            }
            for (String string4 : arrayList2) {
                bl = false;
                for (String string3 : arrayList) {
                    if (!string4.equals(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList3.add(string4);
            }
            if (((ArrayList)object).size() > 0) {
                AbstractTextNode.stoplistAddDefaultTokens(this._context, stoplistType, "Word", (ArrayList<String>)object);
            }
            if (arrayList3.size() > 0) {
                List<String> list = new ArrayList();
                list = AbstractBuildNode.stoplistCheckLanguagesUsed(null, buildNodeType, stoplistType, "Word", arrayList3);
                if (list.size() == 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string5 : arrayList3) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(ServerConstants.StoplistLanguage.toHuman((String)string5));
                    }
                    String string6 = MessageFormat.format(DialogsLrb.get("BUILD_TEXT_REMOVE_WORDS_FOR_LANG"), stringBuilder.toString());
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string6, (String)DialogsLrb.get("BUILD_TEXT_DIALOG_TITLE"), null, (boolean)true)) {
                        AbstractTextNode.stoplistRemoveTokens(stoplistType, "Word", arrayList3);
                    }
                }
            }
        }
        return true;
    }

    private void enableControls() {
        if (this.jSelectedStoplistComboBox.getItemCount() > 0) {
            String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
            this.jEditStoplistButton.setEnabled(!ServerConstants.StoplistLanguage.isNone((String)ServerConstants.StoplistLanguage.toSchema((String)string)));
        } else {
            this.jEditStoplistButton.setEnabled(false);
        }
    }

    private void jSingleByteLanguageValueChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray;
        if (this._isAdjusting) {
            return;
        }
        this._isAdjusting = true;
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        CheckComboModel checkComboModel = ((JCheckCombo)this.jSingleBtyeComboBox).getCheckModel();
        for (Object object : objectArray = checkComboModel.getSelectedItem()) {
            String string = (String)object;
            if (!this._isNoneSelected && ServerConstants.StoplistLanguage.isNone((String)ServerConstants.StoplistLanguage.toSchema((String)string))) {
                listSelectionModel.clearSelection();
                listSelectionModel.addSelectionInterval(1, 1);
                this._isNoneSelected = true;
                this._isAllSelected = false;
                break;
            }
            if (!this._isAllSelected && ServerConstants.StoplistLanguage.isALL((String)ServerConstants.StoplistLanguage.toSchema((String)string))) {
                listSelectionModel.removeSelectionInterval(1, 1);
                listSelectionModel.addSelectionInterval(2, checkComboModel.getSize() - 1);
                this._isAllSelected = true;
                this._isNoneSelected = false;
                break;
            }
            listSelectionModel.removeSelectionInterval(0, 0);
            this._isAllSelected = false;
            listSelectionModel.removeSelectionInterval(1, 1);
            this._isNoneSelected = false;
        }
        this._isAdjusting = false;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.jLanguageLabel = new JLabel();
        this.jThesaurusComboBox = new JComboBox();
        this.jStoplistLabel = new JLabel();
        this.jSelectedStoplistComboBox = new JComboBox();
        this.jEditStoplistButton = new JButton();
        this.jNewStoplistButton = new JButton();
        this.jMaxNumAllDocsLabel = new JLabel();
        this.jMaxNumAllDocsSpinner = new JSpinner();
        this.JLableMinRows = new JLabel();
        this.jTokenMinRowsTokenSpinner = new JSpinner();
        this.jTokenLanguageLabel = new JLabel();
        this.jSingleBtyeComboBox = new JCheckCombo();
        this.jLanguageLabel.setText("Thesauruses:");
        this.jThesaurusComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"English", "German", "French"}));
        this.jThesaurusComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingSynonymPanel.this.jThesaurusComboBoxActionPerformed(actionEvent);
            }
        });
        this.jStoplistLabel.setText("Stoplist:");
        this.jSelectedStoplistComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jSelectedStoplistComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingSynonymPanel.this.jSelectedStoplistComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditStoplistButton.setText("---");
        this.jEditStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jEditStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingSynonymPanel.this.jEditStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jNewStoplistButton.setText("+");
        this.jNewStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jNewStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingSynonymPanel.this.jNewStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jMaxNumAllDocsLabel.setLabelFor(this.jMaxNumAllDocsSpinner);
        this.jMaxNumAllDocsLabel.setText("Max number across all documents");
        this.jMaxNumAllDocsSpinner.setModel(new SpinnerNumberModel(3000, 1, 100000, 100));
        this.JLableMinRows.setText("Min number of rows (documents) required for a token");
        this.jTokenLanguageLabel.setText("Languages:");
        this.jSingleBtyeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jSingleBtyeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingSynonymPanel.this.jSingleBtyeComboBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLanguageLabel, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jThesaurusComboBox, -2, 160, -2)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jStoplistLabel, -2, 73, -2).addGap(35, 35, 35).addComponent(this.jSelectedStoplistComboBox, -2, 160, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jEditStoplistButton, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNewStoplistButton, -2, 26, -2).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jMaxNumAllDocsLabel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTokenMinRowsTokenSpinner, -2, 104, -2).addComponent(this.JLableMinRows, -2, 396, -2).addComponent(this.jMaxNumAllDocsSpinner, -2, 104, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTokenLanguageLabel, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSingleBtyeComboBox, -2, 160, -2))).addGap(0, 0, Short.MAX_VALUE)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLanguageLabel).addComponent(this.jThesaurusComboBox, -2, -1, -2)).addGap(7, 7, 7).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTokenLanguageLabel).addComponent(this.jSingleBtyeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSelectedStoplistComboBox, -2, -1, -2).addComponent(this.jNewStoplistButton).addComponent(this.jEditStoplistButton).addComponent(this.jStoplistLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jMaxNumAllDocsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMaxNumAllDocsSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.JLableMinRows).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTokenMinRowsTokenSpinner, -2, -1, -2).addContainerGap(19, Short.MAX_VALUE)));
    }

    private void jSelectedStoplistComboBoxActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jEditStoplistButtonActionPerformed(ActionEvent actionEvent) {
        StoplistType stoplistType;
        String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
        StoplistType stoplistType2 = null;
        Object object = this._stoplists.getStoplist().iterator();
        while (object.hasNext()) {
            stoplistType = (StoplistType)object.next();
            if (!stoplistType.getName().equals(string)) continue;
            stoplistType2 = stoplistType;
            break;
        }
        if (((DialogDisplayer)(object = new StoplistDetailsPanel(this._context, this._node, this._buildNodeType, this, stoplistType2))).showAsDialog(this) && ((StoplistDetailsPanel)object).isDirty()) {
            stoplistType = ((StoplistDetailsPanel)object).getStoplist();
            for (int i = 0; i < this._stoplists.getStoplist().size(); ++i) {
                if (!((StoplistType)this._stoplists.getStoplist().get(i)).getId().equals(stoplistType.getId())) continue;
                this._stoplists.getStoplist().set(i, stoplistType);
                break;
            }
            this._dirty = true;
            this.initStoplists(stoplistType.getId());
        }
    }

    private void jNewStoplistButtonActionPerformed(ActionEvent actionEvent) {
        StoplistWizard stoplistWizard = new StoplistWizard();
        if (stoplistWizard.runWizard(this, null, this._context, this._node, this._sourceAttributeName)) {
            StoplistType stoplistType = stoplistWizard.getModel().getStoplist();
            String string = AbstractBuildNode.getStoplistNextId(this._stoplists) + "";
            stoplistType.setId(string);
            this._stoplists.getStoplist().add(stoplistType);
            this._dirty = true;
            this.initStoplists(string);
        }
    }

    private void jThesaurusComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void jSingleBtyeComboBoxActionPerformed(ActionEvent actionEvent) {
        this._dirty = true;
    }

    public BuildNodeType.Stoplists getStoplists() {
        return this._stoplists;
    }
}

