/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetAvailableThesaurusQuery;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistDetailsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistWizard;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.combo.CheckComboModel;
import oracle.javatools.ui.combo.JCheckCombo;
import oracle.javatools.util.Version;

public class TextSettingsSynonymPanel
extends AbstractPanel<AbstractBuildNode> {
    private static final Logger logger = Logger.getLogger(TextSettingsSynonymPanel.class.getName());
    private BuildNodeType _buildNodeType;
    private TransformationTokenType _synonym;
    private BuildNodeType.Stoplists _stoplists;
    private boolean _isLoading;
    private boolean _isAdjusting;
    private boolean _isAllSelected;
    private boolean _isNoneSelected;
    private boolean _dirty;
    private static Icon _editIcon;
    private boolean _loadedThesaurus;
    private JButton jEditStoplistButton;
    private JButton jNewStoplistButton;
    private JComboBox jThesaurusesComboBox;
    private JLabel jThesaurusesLabel;
    private JComboBox jTokenLanguageComboBox;
    private JLabel jTokenLanguageLabel;
    private JLabel jTokenMaxAllDocsLabel;
    private JSpinner jTokenMaxAllDocsSpinner;
    private JLabel jTokenMinRowsToken;
    private JSpinner jTokenMinRowsTokenSpinner;
    private JComboBox jTokenStoplistComboBox;
    private JLabel jTokenStoplistLabel;

    public TextSettingsSynonymPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, TransformationTokenType transformationTokenType, BuildNodeType.Stoplists stoplists) {
        super(context, abstractBuildNode);
        assert (context != null) : "Context must not be null.";
        assert (abstractBuildNode != null) : "node node must not be null.";
        this.init(buildNodeType, transformationTokenType, stoplists);
    }

    private void init(BuildNodeType buildNodeType, TransformationTokenType transformationTokenType, BuildNodeType.Stoplists stoplists) {
        this._buildNodeType = buildNodeType;
        this._synonym = transformationTokenType;
        this._stoplists = stoplists;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void reload(BuildNodeType buildNodeType, TransformationTokenType transformationTokenType, BuildNodeType.Stoplists stoplists) {
        this._buildNodeType = buildNodeType;
        this._synonym = transformationTokenType;
        this._stoplists = stoplists;
        this.refreshUI(transformationTokenType);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTokenLanguageLabel, (Component)this.jTokenLanguageComboBox, (String)DialogsLrb.get("BUILD_TEXT_LANGUAGES"));
        ResourceUtils.resLabel((JLabel)this.jThesaurusesLabel, (Component)this.jThesaurusesComboBox, (String)DialogsLrb.get("BUILD_TEXT_THESAURUS"));
        ResourceUtils.resLabel((JLabel)this.jTokenStoplistLabel, (Component)this.jTokenStoplistComboBox, (String)DialogsLrb.get("BUILD_TEXT_STOPLIST"));
        ResourceUtils.resSpinner((JLabel)this.jTokenMaxAllDocsLabel, (JSpinner)this.jTokenMaxAllDocsSpinner, (String)DialogsLrb.get("BUILD_TEXT_MAX_NUM_ALL_DOCS"));
        ResourceUtils.resSpinner((JLabel)this.jTokenMinRowsToken, (JSpinner)this.jTokenMinRowsTokenSpinner, (String)DialogsLrb.get("BUILD_TEXT_MIN_ROWS_TOKEN_DOCS"));
        _editIcon = InspectorArb.getIcon((int)24);
    }

    @Override
    public void initUI() {
        this._isLoading = true;
        this.jTokenMaxAllDocsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TextSettingsSynonymPanel.this._dirty = true;
            }
        });
        this.jTokenMinRowsTokenSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TextSettingsSynonymPanel.this._dirty = true;
            }
        });
        this.jEditStoplistButton.setText(null);
        this.jEditStoplistButton.setIcon(_editIcon);
        this.jEditStoplistButton.setToolTipText(DialogsLrb.get("BUILD_TEXT_EDIT_STOPLIST_TOOLTIP"));
        this.jNewStoplistButton.setText(null);
        this.jNewStoplistButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.jNewStoplistButton.setToolTipText(DialogsLrb.get("BUILD_TEXT_ADD_STOPLIST_TOOLTIP"));
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman((String)"All"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman((String)"None"));
        for (ServerConstants.StoplistLanguage.BASIC_LEXER_LANG bASIC_LEXER_LANG : ServerConstants.StoplistLanguage.BASIC_LEXER_LANG.values()) {
            defaultListModel.addElement(bASIC_LEXER_LANG.value());
        }
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.addSelectionInterval(1, 1);
        CheckComboModel checkComboModel = new CheckComboModel(defaultListModel, (ListSelectionModel)defaultListSelectionModel);
        ((JCheckCombo)this.jTokenLanguageComboBox).setModel(checkComboModel);
        ListSelectionModel listSelectionModel = ((JCheckCombo)this.jTokenLanguageComboBox).getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    TextSettingsSynonymPanel.this.jSingleByteLanguageValueChanged(listSelectionEvent);
                }
            }
        });
        this.loadThesaurus();
        this.refreshUI(this._synonym);
        this._isLoading = false;
    }

    public void initLanguages(TransformationTokenType transformationTokenType) {
        List list = null;
        list = transformationTokenType.getToken().getLanguages().getLanguage();
        this._isAdjusting = true;
        ListSelectionModel listSelectionModel = ((JCheckCombo)this.jTokenLanguageComboBox).getSelectionModel();
        listSelectionModel.clearSelection();
        CheckComboModel checkComboModel = ((JCheckCombo)this.jTokenLanguageComboBox).getCheckModel();
        boolean bl = false;
        for (TransformationTokenType.Token.Languages.Language language : list) {
            for (int i = 0; i < checkComboModel.getSize(); ++i) {
                String string = (String)checkComboModel.getElementAt(i);
                if (!string.equals(ServerConstants.StoplistLanguage.toHuman((String)language.getName()))) continue;
                listSelectionModel.addSelectionInterval(i, i);
                bl = true;
            }
        }
        if (!bl) {
            listSelectionModel.addSelectionInterval(1, 1);
        }
        this._isAdjusting = false;
    }

    private void jSingleByteLanguageValueChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray;
        if (this._isAdjusting) {
            return;
        }
        this._isAdjusting = true;
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        CheckComboModel checkComboModel = ((JCheckCombo)this.jTokenLanguageComboBox).getCheckModel();
        for (Object object : objectArray = checkComboModel.getSelectedItem()) {
            String string = (String)object;
            if (!this._isNoneSelected && ServerConstants.StoplistLanguage.isNone((String)ServerConstants.StoplistLanguage.toSchema((String)string))) {
                listSelectionModel.clearSelection();
                listSelectionModel.addSelectionInterval(1, 1);
                this._isNoneSelected = true;
                this._isAllSelected = false;
                break;
            }
            if (!this._isAllSelected && ServerConstants.StoplistLanguage.isALL((String)ServerConstants.StoplistLanguage.toSchema((String)string))) {
                listSelectionModel.removeSelectionInterval(1, 1);
                listSelectionModel.addSelectionInterval(2, checkComboModel.getSize() - 1);
                this._isAllSelected = true;
                this._isNoneSelected = false;
                break;
            }
            listSelectionModel.removeSelectionInterval(0, 0);
            this._isAllSelected = false;
            listSelectionModel.removeSelectionInterval(1, 1);
            this._isNoneSelected = false;
        }
        this._isAdjusting = false;
    }

    public boolean isThesaurusLoaded() {
        return this._loadedThesaurus;
    }

    private void loadThesaurus() {
        Version version = ConnectionFolder.getConnectionFolder(this._context).getDbVersion();
        GetAvailableThesaurusQuery getAvailableThesaurusQuery = new GetAvailableThesaurusQuery(version);
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject((ConnectionManager)ConnectionFolder.getConnectionFolder(this._context));
        try {
            List list = sqlDataAccessObject.readItems((Query)getAvailableThesaurusQuery);
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            for (String string : list) {
                defaultComboBoxModel.addElement(string);
            }
            this.jThesaurusesComboBox.setModel(defaultComboBoxModel);
            if (defaultComboBoxModel.getSize() > 0) {
                this._loadedThesaurus = true;
            }
        }
        catch (ODMrDAOException oDMrDAOException) {
            logger.log(Level.INFO, DialogsLrb.get("BUILD_TEXT_SYNONYM_THESAURUS_NOT_LOADED"), oDMrDAOException);
        }
    }

    private void refreshUI(TransformationTokenType transformationTokenType) {
        BigInteger bigInteger;
        int n;
        if (transformationTokenType != null) {
            this.initStoplists(transformationTokenType.getToken().getStoplistId());
            this.initLanguages(transformationTokenType);
            String string = transformationTokenType instanceof TextTransformationType.Synonym ? ((TextTransformationType.Synonym)transformationTokenType).getThesaurus() : ((BuildNodeType.TextSettings.Synonym)transformationTokenType).getThesaurus();
            for (n = 0; n < this.jThesaurusesComboBox.getItemCount(); ++n) {
                if (!this.jThesaurusesComboBox.getItemAt(n).toString().equals(string)) continue;
                this.jThesaurusesComboBox.setSelectedIndex(n);
                break;
            }
        }
        int n2 = 1;
        if (transformationTokenType != null) {
            n2 = transformationTokenType.getToken().getMaxNumberAllDocs().intValue();
        }
        this.jTokenMaxAllDocsSpinner.setModel(new SpinnerNumberModel(n2, 1, 100000, 1000));
        n = 1;
        if (transformationTokenType != null && (bigInteger = transformationTokenType.getToken().getMinNumberAllDocs()) != null) {
            n = transformationTokenType.getToken().getMinNumberAllDocs().intValue();
        }
        this.jTokenMinRowsTokenSpinner.setModel(new SpinnerNumberModel(n, 1, 100000, 1000));
        this.enableControls();
    }

    public boolean isDirty() {
        return this._dirty;
    }

    private void initStoplists(String string) {
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StoplistType stoplistType : this._stoplists.getStoplist()) {
            arrayList.add(stoplistType.getName());
            if (string == null || !string.equals(stoplistType.getId())) continue;
            string2 = stoplistType.getName();
        }
        Collections.sort(arrayList);
        arrayList.add(0, ServerConstants.StoplistLanguage.toHuman((String)"None"));
        this.jTokenStoplistComboBox.removeAllItems();
        this.jTokenStoplistComboBox.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        if (string2 != null) {
            this.jTokenStoplistComboBox.setSelectedItem(string2);
        }
    }

    private void enableControls() {
        if (this.jTokenStoplistComboBox.getItemCount() > 0) {
            String string = (String)this.jTokenStoplistComboBox.getSelectedItem();
            this.jEditStoplistButton.setEnabled(!ServerConstants.StoplistLanguage.isNone((String)ServerConstants.StoplistLanguage.toSchema((String)string)));
        } else {
            this.jEditStoplistButton.setEnabled(false);
        }
    }

    public void copySettings(BuildNodeType buildNodeType, TransformationTokenType transformationTokenType, BuildNodeType.Stoplists stoplists) throws ValidationException {
        Object object;
        Object[] objectArray;
        TextTransformationType.Synonym synonym;
        StoplistType stoplistType = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        TransformationTokenType.Token.Languages languages = new TransformationTokenType.Token.Languages();
        TransformationTokenType.Token.Languages.Language language = null;
        if (transformationTokenType instanceof BuildNodeType.TextSettings.Synonym) {
            if (this.jThesaurusesComboBox.getSelectedItem() != null) {
                ((BuildNodeType.TextSettings.Synonym)transformationTokenType).setThesaurus(this.jThesaurusesComboBox.getSelectedItem().toString());
            }
        } else {
            synonym = (TextTransformationType.Synonym)transformationTokenType;
            if (this.jThesaurusesComboBox.getSelectedItem() != null) {
                synonym.setThesaurus(this.jThesaurusesComboBox.getSelectedItem().toString());
            }
        }
        synonym = ((JCheckCombo)this.jTokenLanguageComboBox).getCheckModel();
        for (Object object2 : objectArray = synonym.getSelectedItem()) {
            object = (String)object2;
            if (ServerConstants.StoplistLanguage.isALL((String)ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isNone((String)ServerConstants.StoplistLanguage.toSchema((String)object))) continue;
            language = new TransformationTokenType.Token.Languages.Language();
            language.setName(ServerConstants.StoplistLanguage.toSchema((String)object));
            if (ServerConstants.StoplistLanguage.isTraditionalChinese((String)ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isSimplifiedChinese((String)ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isJapanese((String)ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isKorean((String)ServerConstants.StoplistLanguage.toSchema((String)object))) {
                language.setType("MultiByte");
            } else {
                language.setType("SingleByte");
            }
            languages.getLanguage().add(language);
            arrayList.add(ServerConstants.StoplistLanguage.toSchema((String)object));
        }
        if (arrayList.size() == 0) {
            throw new ValidationException(DialogsLrb.get("BUILD_TEXT_NO_LANGUAGE_ERROR"));
        }
        transformationTokenType.getToken().setLanguages(languages);
        if (languages.getLanguage().size() <= 1) {
            transformationTokenType.getToken().getLexer().setType("Basic");
        } else {
            transformationTokenType.getToken().getLexer().setType("Auto");
        }
        transformationTokenType.getToken().setStoplistId(null);
        String string = (String)this.jTokenStoplistComboBox.getSelectedItem();
        if (string != null) {
            if (ServerConstants.StoplistLanguage.isDefault((String)ServerConstants.StoplistLanguage.toSchema((String)string))) {
                String n = null;
                n = languages.getLanguage().size() <= 1 ? ((TransformationTokenType.Token.Languages.Language)languages.getLanguage().get(0)).getName() : "Multi";
                stoplistType = AbstractBuildNode.findDefaultStoplist(stoplists, n);
                String n2 = stoplistType.getId();
                transformationTokenType.getToken().setStoplistId(n2);
            } else {
                transformationTokenType.getToken().setStoplistId(AbstractBuildNode.findStoplistId(stoplists, string));
            }
        }
        Integer n = (Integer)this.jTokenMaxAllDocsSpinner.getValue();
        transformationTokenType.getToken().setMaxNumberAllDocs(BigInteger.valueOf(n.intValue()));
        Integer n2 = (Integer)this.jTokenMinRowsTokenSpinner.getValue();
        transformationTokenType.getToken().setMinNumberAllDocs(BigInteger.valueOf(n2.intValue()));
        if (stoplistType != null) {
            boolean bl;
            ArrayList<String> arrayList2 = AbstractTextNode.findStoplistLanguages(stoplistType, "Word");
            object = new ArrayList();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (String string2 : arrayList) {
                bl = false;
                for (String string3 : arrayList2) {
                    if (!string2.equals(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                ((ArrayList)object).add(string2);
            }
            for (String string4 : arrayList2) {
                bl = false;
                for (String string3 : arrayList) {
                    if (!string4.equals(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList3.add(string4);
            }
            if (((ArrayList)object).size() > 0) {
                AbstractTextNode.stoplistAddDefaultTokens(this._context, stoplistType, "Word", (ArrayList<String>)object);
                this._dirty = true;
            }
            if (arrayList3.size() > 0) {
                List<String> list = new ArrayList();
                list = AbstractBuildNode.stoplistCheckLanguagesUsed(null, buildNodeType, stoplistType, "Word", arrayList3);
                if (list.size() == 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (String string5 : arrayList3) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(ServerConstants.StoplistLanguage.toHuman((String)string5));
                    }
                    String string6 = MessageFormat.format(DialogsLrb.get("BUILD_TEXT_REMOVE_WORDS_FOR_LANG"), stringBuffer.toString());
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string6, (String)DialogsLrb.get("BUILD_TEXT_DIALOG_TITLE"), null, (boolean)true)) {
                        AbstractTextNode.stoplistRemoveTokens(stoplistType, "Word", arrayList3);
                    }
                }
                this._dirty = true;
            }
        }
    }

    private void initComponents() {
        this.jThesaurusesLabel = new JLabel();
        this.jThesaurusesComboBox = new JComboBox();
        this.jTokenStoplistLabel = new JLabel();
        this.jTokenStoplistComboBox = new JComboBox();
        this.jEditStoplistButton = new JButton();
        this.jNewStoplistButton = new JButton();
        this.jTokenMaxAllDocsLabel = new JLabel();
        this.jTokenMaxAllDocsSpinner = new JSpinner();
        this.jTokenMinRowsToken = new JLabel();
        this.jTokenMinRowsTokenSpinner = new JSpinner();
        this.jTokenLanguageLabel = new JLabel();
        this.jTokenLanguageComboBox = new JCheckCombo();
        this.jThesaurusesLabel.setText("Thesauruses:");
        this.jThesaurusesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jThesaurusesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsSynonymPanel.this.jThesaurusesComboBoxActionPerformed(actionEvent);
            }
        });
        this.jTokenStoplistLabel.setText("Stoplists:");
        this.jTokenStoplistComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jTokenStoplistComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsSynonymPanel.this.jTokenStoplistComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditStoplistButton.setText("---");
        this.jEditStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jEditStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsSynonymPanel.this.jEditStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jNewStoplistButton.setText("+");
        this.jNewStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jNewStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsSynonymPanel.this.jNewStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jTokenMaxAllDocsLabel.setText("Max number of tokens across all rows (documents)");
        this.jTokenMaxAllDocsSpinner.setModel(new SpinnerNumberModel(3000, 0, 3000, 1));
        this.jTokenMinRowsToken.setText("Min number of rows (documents) required for a token");
        this.jTokenLanguageLabel.setText("Languages:");
        this.jTokenLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jTokenLanguageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsSynonymPanel.this.jTokenLanguageComboBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(297, 297, 297).addComponent(this.jEditStoplistButton, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNewStoplistButton, -2, 26, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jThesaurusesLabel, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jThesaurusesComboBox, -2, 160, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTokenStoplistLabel, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTokenStoplistComboBox, -2, 160, -2)).addComponent(this.jTokenMaxAllDocsLabel, -2, 283, -2).addComponent(this.jTokenMaxAllDocsSpinner, -2, 70, -2).addComponent(this.jTokenMinRowsToken).addComponent(this.jTokenMinRowsTokenSpinner, -2, 70, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTokenLanguageLabel, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTokenLanguageComboBox, -2, 160, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jThesaurusesLabel).addComponent(this.jThesaurusesComboBox, -2, -1, -2)).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTokenLanguageLabel).addComponent(this.jTokenLanguageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTokenStoplistLabel).addComponent(this.jTokenStoplistComboBox, -2, -1, -2).addComponent(this.jNewStoplistButton).addComponent(this.jEditStoplistButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTokenMaxAllDocsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTokenMaxAllDocsSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTokenMinRowsToken).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTokenMinRowsTokenSpinner, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jTokenStoplistComboBoxActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
        if (!this._isLoading) {
            this._dirty = true;
        }
    }

    private void jEditStoplistButtonActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.jTokenStoplistComboBox.getSelectedItem();
        StoplistType stoplistType = null;
        boolean bl = false;
        for (StoplistType stoplistType2 : this._stoplists.getStoplist()) {
            if (!stoplistType2.getName().equals(string)) continue;
            stoplistType = stoplistType2;
            break;
        }
        bl = true;
        StoplistDetailsPanel stoplistDetailsPanel = new StoplistDetailsPanel(this._context, (AbstractBuildNode)this.getData(), this._buildNodeType, this, stoplistType);
        if (stoplistDetailsPanel.showAsDialog(this) && stoplistDetailsPanel.isDirty()) {
            StoplistType stoplistType2;
            stoplistType2 = stoplistDetailsPanel.getStoplist();
            for (int i = 0; i < this._stoplists.getStoplist().size(); ++i) {
                if (!((StoplistType)this._stoplists.getStoplist().get(i)).getId().equals(stoplistType2.getId())) continue;
                this._stoplists.getStoplist().set(i, stoplistType2);
                break;
            }
            this.initStoplists(stoplistType2.getId());
            this._dirty = true;
        }
    }

    private void jNewStoplistButtonActionPerformed(ActionEvent actionEvent) {
        StoplistWizard stoplistWizard = new StoplistWizard();
        if (stoplistWizard.runWizard(this, null, this._context, (AbstractBuildNode)this.getData(), DialogsLrb.get("BUILD_TEXT_DEFAULT_STOPLIST_NAME"))) {
            StoplistType stoplistType = stoplistWizard.getModel().getStoplist();
            String string = AbstractBuildNode.getStoplistNextId(this._stoplists) + "";
            stoplistType.setId(string);
            this._stoplists.getStoplist().add(stoplistType);
            this.initStoplists(stoplistType.getId());
            this._dirty = true;
        }
    }

    private void jThesaurusesComboBoxActionPerformed(ActionEvent actionEvent) {
        this._dirty = true;
    }

    private void jTokenLanguageComboBoxActionPerformed(ActionEvent actionEvent) {
        this._dirty = true;
    }

    public BuildNodeType.Stoplists getStoplists() {
        return this._stoplists;
    }
}

