/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.Container;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.DataMinerPreferenceSettings;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.ide.config.Preferences;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public class ApplyPreferencesPanel
extends DefaultTraversablePanel {
    private Boolean _automateSettingModel = true;
    private Boolean _automateSettingData = true;
    private Boolean _dataColumnsFirst = true;
    private JComboBox jAutoModelComboBox;
    private JLabel jAutoModelLabel;
    private JComboBox jOutputOrderComboBox;
    private JLabel jOutputOrderLabel;

    public ApplyPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jAutoModelLabel, (Component)this.jAutoModelComboBox, (String)DialogsLrb.get("PREF_AUTOMATE_MODEL_SETTING"));
        this.jAutoModelLabel.getAccessibleContext().setAccessibleName("PREF_AUTOMATE_MODEL_SETTING");
        this.jAutoModelLabel.getAccessibleContext().setAccessibleDescription("PREF_AUTOMATE_MODEL_SETTING_ADA");
        ResourceUtils.resLabel((JLabel)this.jOutputOrderLabel, (Component)this.jOutputOrderComboBox, (String)DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING"));
        this.jOutputOrderLabel.getAccessibleContext().setAccessibleName("PREF_OUTPUT_ORDER_SETTING");
        this.jOutputOrderLabel.getAccessibleContext().setAccessibleDescription("PREF_OUTPUT_ORDER_SETTING_ADA");
        this.setHelpID("preferences_transforms_apply");
    }

    public void initUI() {
        this.jAutoModelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{DialogsLrb.get("PREF_AUTOMATE_MODEL_SETTING_ON"), DialogsLrb.get("PREF_AUTOMATE_MODEL_SETTING_OFF")}));
        this.jOutputOrderComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_DATA"), DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_APPLY")}));
    }

    private void initComponents() {
        this.jAutoModelLabel = new JLabel();
        this.jAutoModelComboBox = new JComboBox();
        this.jOutputOrderLabel = new JLabel();
        this.jOutputOrderComboBox = new JComboBox();
        this.jAutoModelLabel.setLabelFor(this.jAutoModelComboBox);
        this.jAutoModelLabel.setText("Automatic Model Specification Options:");
        this.jAutoModelLabel.setName("jAutoModelLabel");
        this.jAutoModelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jAutoModelComboBox.setName("jAutoModelComboBox");
        this.jOutputOrderLabel.setLabelFor(this.jOutputOrderComboBox);
        this.jOutputOrderLabel.setText("Column Output Order Combo Box:");
        this.jOutputOrderLabel.setName("jOutputOrderLabel");
        this.jOutputOrderComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jOutputOrderComboBox.setName("jOutputOrderComboBox");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jOutputOrderLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jAutoModelLabel, -1, -1, Short.MAX_VALUE)).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jOutputOrderComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jAutoModelComboBox, 0, 135, Short.MAX_VALUE)).addGap(64, 64, 64)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAutoModelLabel).addComponent(this.jAutoModelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jOutputOrderComboBox, -2, -1, -2).addComponent(this.jOutputOrderLabel)).addContainerGap(232, Short.MAX_VALUE)));
    }

    public void onEntry(TraversableContext traversableContext) {
        ApplyPreferenceSettings applyPreferenceSettings = ApplyPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this._automateSettingModel = applyPreferenceSettings.getAutomaticSettingModel();
        this.jAutoModelComboBox.setSelectedItem(this._automateSettingModel != false ? DialogsLrb.get("PREF_AUTOMATE_MODEL_SETTING_ON") : DialogsLrb.get("PREF_AUTOMATE_MODEL_SETTING_OFF"));
        this._dataColumnsFirst = applyPreferenceSettings.getDataColumnsFirst();
        this.jOutputOrderComboBox.setSelectedItem(this._dataColumnsFirst != false ? DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_DATA") : DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_APPLY"));
    }

    public void onExit(TraversableContext traversableContext) {
        ApplyPreferenceSettings applyPreferenceSettings = ApplyPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        applyPreferenceSettings.setAutomaticSettingModel(this.jAutoModelComboBox.getSelectedItem().equals(DialogsLrb.get("PREF_AUTOMATE_MODEL_SETTING_ON")));
        applyPreferenceSettings.setDataColumnsFirst(this.jOutputOrderComboBox.getSelectedItem().equals(DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_DATA")));
    }

    private static ApplyPreferenceSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return ApplyPreferenceSettings.getInstance(traversableContext.getPropertyStorage());
    }

    public static class ApplyPreferenceSettings
    extends DataMinerPreferenceSettings {
        protected static final String DATA_KEY = "oracle.dmt.dataminer.workflow.ApplyPreferenceSettings";

        public static ApplyPreferenceSettings getInstance() {
            return ApplyPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
        }

        private ApplyPreferenceSettings(HashStructure hashStructure) {
            super(hashStructure);
        }

        public static ApplyPreferenceSettings getInstance(PropertyStorage propertyStorage) {
            return new ApplyPreferenceSettings(ApplyPreferenceSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
        }

        public void setAutomaticSettingModel(boolean bl) {
            this._hash.putBoolean("automatic_setting_model", bl);
        }

        public boolean getAutomaticSettingModel() {
            return this._hash.getBoolean("automatic_setting_model", true);
        }

        public void setAutomaticSettingData(boolean bl) {
            this._hash.putBoolean("automatic_setting_data", bl);
        }

        public boolean getAutomaticSettingData() {
            return this._hash.getBoolean("automatic_setting_data", true);
        }

        public void setDataColumnsFirst(boolean bl) {
            this._hash.putBoolean("data_columns_first", bl);
        }

        public boolean getDataColumnsFirst() {
            return this._hash.getBoolean("data_columns_first", true);
        }

        public boolean getOrderPartitions() {
            return this._hash.getBoolean("order_partitions", true);
        }

        public void setOrderPartitions(boolean bl) {
            this._hash.putBoolean("order_partitions", bl);
        }
    }
}

