/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AddAggregationAttributePanel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AddAggregationExpressionPanel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditMainDialog;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregationWizard;
import oracle.dmt.dataminer.workflow.dialog.aggregate.EditAggregationAttributePanel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.EditAggregationExpressionPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AggregationNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElements;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.util.SwingUtils;

public class AggregationNodeAttributesPanel
extends DialogDisplayer<AggregationNode> {
    private static final Logger theLogger = Logger.getLogger(AggregationNodeAttributesPanel.class.getName());
    private static final String[] COLUMN_NAMES = new String[]{AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_SOURCE_COLUMN"), AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_OUTPUT_COLUMN"), AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_FUNCTION_COLUMN"), AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_SUB_GROUP_BY_COLUMN")};
    private static Icon _editIcon;
    private JButton _wizBtn;
    private JButton _editBtn;
    private JButton _removeBtn;
    private JButton _addElementBtn;
    private JButton _addExpressionBtn;
    private static final int SOURCE = 0;
    private static final int OUTPUT = 1;
    private static final int FUNCTION = 2;
    private static final int SUB_GROUP_BY = 3;
    private AggregationNodeType cachedAggregationNodeType;
    private DataMinerTable _jAttributesTable = new DataMinerTable();
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JButton jBtnGroupBy;
    private JLabel jLabelGroupBy;
    private JTextField jTxtGroupBy;

    public AggregationNodeAttributesPanel(Context context, AggregationNode aggregationNode) {
        super(context, aggregationNode);
        this.cachedAggregationNodeType = new AggregationNodeType();
        this.cachedAggregationNodeType.setAggregationElements(new AggregationElements());
        this.cachedAggregationNodeType.setGroupingElement(new GroupingElementType());
        AggregationNode aggregationNode2 = (AggregationNode)this.getData();
        AggregationNodeType aggregationNodeType = (AggregationNodeType)aggregationNode2.getData();
        if (aggregationNodeType.getAggregationElements() != null && aggregationNodeType.getAggregationElements().getAggregationElement() != null) {
            AttributeTypeHelper.copyAttributes(this.cachedAggregationNodeType.getAggregationElements().getAggregationElement(), aggregationNodeType.getAggregationElements().getAggregationElement(), null);
            this.validateSourceColumn();
        }
        if (aggregationNodeType.getGroupingElement() != null) {
            AttributeTypeHelper.copyGroupingElementType(this.cachedAggregationNodeType.getGroupingElement(), aggregationNodeType.getGroupingElement());
        }
        this.cachedAggregationNodeType.setAutoSpec(aggregationNodeType.getAutoSpec());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLabelGroupBy = new JLabel();
        this.jTxtGroupBy = new JTextField();
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jBtnGroupBy = new JButton();
        this.jLabelGroupBy.setText("Group By:");
        this.jBtnGroupBy.setText("Edit");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelGroupBy, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTxtGroupBy, -1, 329, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jBtnGroupBy).addContainerGap()).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAttributesComponent, -1, 520, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelGroupBy).addComponent(this.jTxtGroupBy, -2, -1, -2).addComponent(this.jBtnGroupBy)).addContainerGap(265, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(44, 44, 44).addComponent((Component)this.jAttributesComponent, -1, 245, Short.MAX_VALUE).addContainerGap())));
    }

    @Override
    public void initRes() {
        if (_editIcon == null) {
            _editIcon = InspectorArb.getIcon((int)24);
        }
        ResourceUtils.resLabel((JLabel)this.jLabelGroupBy, (Component)this.jTxtGroupBy, (String)AggregateDialogsLrb.get("AGGREGATE_EDITOR_GROUP_BY"));
        ResourceUtils.resButton((AbstractButton)this.jBtnGroupBy, (String)AggregateDialogsLrb.get("AGGREGATE_EDITOR_EIT_BUTTON"));
        this.jLabelGroupBy.setHorizontalTextPosition(2);
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._wizBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_VALUE_CLEAR));
        this._wizBtn.setToolTipText(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_CONFIGURE_TOOLTIP"));
        this._wizBtn.getAccessibleContext().setAccessibleName(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_CONFIGURE"));
        this._wizBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregationNode aggregationNode = (AggregationNode)AggregationNodeAttributesPanel.this.getData();
                AbstractNode abstractNode = aggregationNode.findParentNode();
                assert (abstractNode instanceof AbstractDataNode);
                AggregationWizard aggregationWizard = new AggregationWizard();
                Dialog dialog = SwingUtils.getAncestorDialog((Component)AggregationNodeAttributesPanel.this);
                if (aggregationWizard.runWizard(dialog, AggregationNodeAttributesPanel.this._context, aggregationNode, AggregationNodeAttributesPanel.this.cachedAggregationNodeType, (AbstractDataNode)abstractNode, false)) {
                    GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement());
                    AggregationNodeAttributesPanel.this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
                    AggregationNodeAttributesPanel.this._jAttributesTable.setSorted(true);
                }
            }
        });
        controlBar.add((Component)this._wizBtn);
        this._editBtn = new JButton(_editIcon);
        this._editBtn.setToolTipText(InspectorArb.getString((int)25));
        this._editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditAggregationAttributePanel editAggregationAttributePanel;
                int[] nArray = AggregationNodeAttributesPanel.this._jAttributesTable.getSelectedRowsInModel();
                assert (nArray.length == 1);
                GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)AggregationNodeAttributesPanel.this._jAttributesTable.getModel());
                AggregationElementType aggregationElementType = (AggregationElementType)generalAttributesTableModel.getSrcData().get(nArray[0]);
                GroupingElementType groupingElementType = aggregationElementType.getSource();
                AggregationElementType aggregationElementType2 = null;
                AggregationNode aggregationNode = (AggregationNode)AggregationNodeAttributesPanel.this.getData();
                AbstractNode abstractNode = aggregationNode.findParentNode();
                assert (abstractNode instanceof AbstractDataNode);
                if (null != groupingElementType.getExpression()) {
                    EditAggregationExpressionPanel editAggregationExpressionPanel = new EditAggregationExpressionPanel(AggregationNodeAttributesPanel.this._context, (AggregationNode)AggregationNodeAttributesPanel.this.getData(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getGroupingElement(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement(), aggregationElementType);
                    if (editAggregationExpressionPanel.showAsDialog(AggregationNodeAttributesPanel.this)) {
                        aggregationElementType2 = editAggregationExpressionPanel.getNewAggregationElement();
                    }
                } else if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && (editAggregationAttributePanel = new EditAggregationAttributePanel(AggregationNodeAttributesPanel.this._context, (AggregationNode)AggregationNodeAttributesPanel.this.getData(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getGroupingElement(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement(), aggregationElementType)).showAsDialog(AggregationNodeAttributesPanel.this)) {
                    aggregationElementType2 = editAggregationAttributePanel.getNewAggregationElement();
                }
                if (null != aggregationElementType2) {
                    AttributeTypeHelper.copyAggregationElementType(aggregationElementType, aggregationElementType2);
                    generalAttributesTableModel.fireTableDataChanged();
                    AggregationNodeAttributesPanel.this._jAttributesTable.setSelectedRowsInModel(nArray);
                }
            }
        });
        controlBar.add((Component)this._editBtn);
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(AggregateDialogsLrb.get("AGGREGRATION_COLUMNS_DELETE_TOOLTIP"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = AggregationNodeAttributesPanel.this._jAttributesTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)AggregationNodeAttributesPanel.this._jAttributesTable.getModel());
                    HashMap<String, AggregationElementType> hashMap = new HashMap<String, AggregationElementType>();
                    for (AggregationElementType aggregationElementType : AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement()) {
                        hashMap.put(aggregationElementType.getOutput().getName(), aggregationElementType);
                    }
                    ArrayList arrayList = new ArrayList();
                    for (int i = 0; i < nArray.length; ++i) {
                        AggregationElementType aggregationElementType = (AggregationElementType)generalAttributesTableModel.getSrcData().get(nArray[i]);
                        if (null == hashMap.get(aggregationElementType.getOutput().getName())) continue;
                        arrayList.add(aggregationElementType);
                    }
                    if (!arrayList.isEmpty()) {
                        AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement().removeAll(arrayList);
                        generalAttributesTableModel = new GeneralAttributesTableModel(AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement());
                        AggregationNodeAttributesPanel.this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
                        AggregationNodeAttributesPanel.this._jAttributesTable.setSorted(true);
                    }
                }
            }
        });
        controlBar.add((Component)this._removeBtn);
        this._addElementBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addElementBtn.setToolTipText(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_ADD_ELEMENT"));
        this._addElementBtn.getAccessibleContext().setAccessibleName(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_ADD_ELEMENT_TOOLTIP"));
        this._addElementBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddAggregationAttributePanel addAggregationAttributePanel = new AddAggregationAttributePanel(AggregationNodeAttributesPanel.this._context, (AggregationNode)AggregationNodeAttributesPanel.this.getData(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getGroupingElement(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement());
                if (addAggregationAttributePanel.showAsDialog(AggregationNodeAttributesPanel.this)) {
                    AggregationElementType aggregationElementType = addAggregationAttributePanel.getNewAggregationElement();
                    AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement().add(aggregationElementType);
                    GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement());
                    AggregationNodeAttributesPanel.this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
                    AggregationNodeAttributesPanel.this._jAttributesTable.setSorted(true);
                }
            }
        });
        controlBar.add((Component)this._addElementBtn);
        this._addExpressionBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_VALUE_ADD_EXPRESSION));
        this._addExpressionBtn.setToolTipText(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_ADD_EXPRESSION"));
        this._addExpressionBtn.getAccessibleContext().setAccessibleName(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_ADD_EXPRESSION_TOOLTIP"));
        this._addExpressionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddAggregationExpressionPanel addAggregationExpressionPanel = new AddAggregationExpressionPanel(AggregationNodeAttributesPanel.this._context, (AggregationNode)AggregationNodeAttributesPanel.this.getData(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getGroupingElement(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement());
                if (addAggregationExpressionPanel.showAsDialog(AggregationNodeAttributesPanel.this)) {
                    AggregationElementType aggregationElementType = addAggregationExpressionPanel.getNewAggregationElement();
                    AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement().add(aggregationElementType);
                    GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement());
                    AggregationNodeAttributesPanel.this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
                    AggregationNodeAttributesPanel.this._jAttributesTable.setSorted(true);
                }
            }
        });
        controlBar.add((Component)this._addExpressionBtn);
    }

    @Override
    public void initUI() {
        Object object;
        AggregationNode aggregationNode = (AggregationNode)this.getData();
        AggregationNodeType aggregationNodeType = (AggregationNodeType)aggregationNode.getData();
        GroupingElementType groupingElementType = aggregationNodeType.getGroupingElement();
        GroupingElementType groupingElementType2 = aggregationNodeType.getGroupingElement();
        this.jTxtGroupBy.setEditable(false);
        this.setGroupBy(AttributeTypeHelper.convertGroupingElementTypetoString(groupingElementType));
        if (!this.isValidMainGroupBy(groupingElementType2)) {
            this.jLabelGroupBy.setIcon(OracleIcons.getIcon((String)"warning.png"));
            this.jLabelGroupBy.setToolTipText(AggregateDialogsLrb.get("ADD_AGGREGATION_MAIN_GROUP_BY_INVALID"));
        } else {
            this.jLabelGroupBy.setIcon(null);
            this.jLabelGroupBy.setToolTipText(null);
        }
        List list = this.cachedAggregationNodeType.getAggregationElements().getAggregationElement();
        GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(list);
        this.setupItemsTable(generalAttributesTableModel);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jAttributesTable));
        this.jAttributesComponent.setComponent((JComponent)jScrollPane);
        this.jAttributesComponent.setLabel(new JLabel(AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_GRID_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.installItemFilterActions(controlBar);
        this.jAttributesComponent.setControlBar(controlBar);
        this._jAttributesTable.setFillsViewportHeight(true);
        this._jAttributesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ListSelectionModel listSelectionModel;
                if (mouseEvent.getClickCount() == 2 && !(listSelectionModel = AggregationNodeAttributesPanel.this._jAttributesTable.getSelectionModel()).isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
                    EditAggregationAttributePanel editAggregationAttributePanel;
                    int[] nArray = AggregationNodeAttributesPanel.this._jAttributesTable.getSelectedRowsInModel();
                    GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)AggregationNodeAttributesPanel.this._jAttributesTable.getModel());
                    AggregationElementType aggregationElementType = (AggregationElementType)generalAttributesTableModel.getSrcData().get(nArray[0]);
                    GroupingElementType groupingElementType = aggregationElementType.getSource();
                    AggregationElementType aggregationElementType2 = null;
                    if (null != groupingElementType.getExpression()) {
                        EditAggregationExpressionPanel editAggregationExpressionPanel = new EditAggregationExpressionPanel(AggregationNodeAttributesPanel.this._context, (AggregationNode)AggregationNodeAttributesPanel.this.getData(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getGroupingElement(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement(), aggregationElementType);
                        if (editAggregationExpressionPanel.showAsDialog(AggregationNodeAttributesPanel.this)) {
                            aggregationElementType2 = editAggregationExpressionPanel.getNewAggregationElement();
                        }
                    } else if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && (editAggregationAttributePanel = new EditAggregationAttributePanel(AggregationNodeAttributesPanel.this._context, (AggregationNode)AggregationNodeAttributesPanel.this.getData(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getGroupingElement(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement(), aggregationElementType)).showAsDialog(AggregationNodeAttributesPanel.this)) {
                        aggregationElementType2 = editAggregationAttributePanel.getNewAggregationElement();
                    }
                    if (null != aggregationElementType2) {
                        AttributeTypeHelper.copyAggregationElementType(aggregationElementType, aggregationElementType2);
                        generalAttributesTableModel.fireTableDataChanged();
                        AggregationNodeAttributesPanel.this._jAttributesTable.setSelectedRowsInModel(nArray);
                    }
                }
            }
        });
        boolean bl = false;
        AbstractNode abstractNode = aggregationNode.findParentNode();
        if (abstractNode != null && abstractNode instanceof DataProvider && null != (object = (DataProvider)((Object)abstractNode)).getAttributes()) {
            bl = null != object.getAttributes().getAttribute() && !object.getAttributes().getAttribute().isEmpty();
        }
        this._addElementBtn.setEnabled(bl);
        this._addExpressionBtn.setEnabled(bl);
        this._wizBtn.setEnabled(bl);
        object = this._jAttributesTable.getSelectionModel();
        this._removeBtn.setEnabled(!object.isSelectionEmpty());
        this._editBtn.setEnabled(!object.isSelectionEmpty() && object.getMinSelectionIndex() == object.getMaxSelectionIndex());
        object.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                AggregationNodeAttributesPanel.this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
                AggregationNodeAttributesPanel.this._editBtn.setEnabled(!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex());
            }
        });
        AbstractDataNode abstractDataNode = (AbstractDataNode)aggregationNode.findParentNode();
        this.jBtnGroupBy.setEnabled(abstractDataNode != null && null != abstractDataNode.getAttributes() && null != abstractDataNode.getAttributes().getAttribute());
        this.jBtnGroupBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AggregationNode aggregationNode = (AggregationNode)AggregationNodeAttributesPanel.this.getData();
                    AbstractNode abstractNode = aggregationNode.findParentNode();
                    assert (abstractNode instanceof AbstractDataNode);
                    AggregateEditMainDialog aggregateEditMainDialog = new AggregateEditMainDialog(AggregationNodeAttributesPanel.this._context, aggregationNode, (AbstractDataNode)abstractNode, AggregationNodeAttributesPanel.this.cachedAggregationNodeType);
                    DialogHelper dialogHelper = new DialogHelper(aggregateEditMainDialog);
                    if (dialogHelper.showAsDialog(AggregationNodeAttributesPanel.this)) {
                        GroupingElementType groupingElementType = aggregateEditMainDialog.getGroupByElement();
                        AggregationNodeAttributesPanel.this.cachedAggregationNodeType.setGroupingElement(groupingElementType);
                        AggregationNodeAttributesPanel.this.setGroupBy(AttributeTypeHelper.convertGroupingElementTypetoString(groupingElementType));
                        if (!AggregationNodeAttributesPanel.this.isValidMainGroupBy(groupingElementType)) {
                            AggregationNodeAttributesPanel.this.jLabelGroupBy.setIcon(OracleIcons.getIcon((String)"warning.png"));
                            AggregationNodeAttributesPanel.this.jLabelGroupBy.setToolTipText(AggregateDialogsLrb.get("ADD_AGGREGATION_MAIN_GROUP_BY_INVALID"));
                        } else {
                            AggregationNodeAttributesPanel.this.jLabelGroupBy.setIcon(null);
                            AggregationNodeAttributesPanel.this.jLabelGroupBy.setToolTipText(null);
                        }
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doWork() {
        Object object;
        boolean bl = true;
        if (null == this.cachedAggregationNodeType.getAggregationElements() || null == this.cachedAggregationNodeType.getAggregationElements().getAggregationElement()) {
            MessageDialog.error((Component)this, (Object)AggregateDialogsLrb.get("AGGREGATION_COLUMNS_MISSING"), (String)AggregateDialogsLrb.get("ERROR_CREATING_AGGREGATION"), null);
            return false;
        }
        GroupingElementType groupingElementType = this.cachedAggregationNodeType.getGroupingElement();
        if (groupingElementType != null && null != groupingElementType.getAttributes() && !groupingElementType.getAttributes().getAttribute().isEmpty()) {
            object = groupingElementType.getAttributes().getAttribute();
            for (Object object2 : this.cachedAggregationNodeType.getAggregationElements().getAggregationElement()) {
                List list;
                GroupingElementType groupingElementType2 = object2.getSubGroupBy();
                if (null == groupingElementType2.getAttributes() || groupingElementType2.getAttributes().getAttribute().isEmpty() || !AttributeTypeHelper.areEqual((List<AttributeType>)object, list = groupingElementType2.getAttributes().getAttribute())) continue;
                MessageDialog.error((Component)this, (Object)AggregateDialogsLrb.get("AGGREGATION_SUB_GROUP_BY_GROUP_BY_IDENTICAL"), (String)AggregateDialogsLrb.get("ERROR_CREATING_AGGREGATION"), null);
                return false;
            }
        }
        object = (AggregationNode)this.getData();
        CommandProcessor.getInstance().beginTrans(AggregateDialogsLrb.get("AGGREGATE_NODE_PROPERTIES_TRANSACTION_NAME"));
        try {
            Object object2;
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property("allAggregateNodeProperies", null, this.cachedAggregationNodeType, null, null));
            arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
            object2 = (OdmrSDMUndoFilter)((AbstractNode)object).getUndoFilter();
            ((OdmrSDMUndoFilter)((Object)object2)).prepareUndoPropertyList(object, this._context, (List<Property>)arrayList);
            ((AggregationNode)object).validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)AggregateDialogsLrb.get("EDIT_AGGREGATE_ELEMENTS_DIALOG_FAILURE_TITLE"), (String)AggregateDialogsLrb.get("EDIT_AGGREGATE_ELEMENTS_DIALOG_FAILURE_MSG"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
        return bl;
    }

    private void setupItemsTable(GeneralAttributesTableModel generalAttributesTableModel) {
        this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setSortColumn(0, true);
        this._jAttributesTable.setAutoResizeMode(4);
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                AggregationNode aggregationNode;
                AbstractNode abstractNode;
                boolean bl3 = false;
                GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)jTable.getModel());
                int n3 = jTable.convertRowIndexToModel(n);
                AggregationElementType aggregationElementType = (AggregationElementType)generalAttributesTableModel.getSrcData().get(n3);
                Attributes attributes = aggregationElementType.getSource().getAttributes();
                if (null != attributes && null != attributes.getAttribute()) {
                    List list = attributes.getAttribute();
                    if (!list.isEmpty()) {
                        for (AttributeType attributeType : list) {
                            if (!attributeType.getName().equals(object.toString()) || 0 != attributeType.getStatus().compareTo((Enum)AttributeStatus.VALID)) continue;
                            bl3 = true;
                            break;
                        }
                    }
                } else if (null != aggregationElementType.getSource().getExpression() && (abstractNode = (aggregationNode = (AggregationNode)AggregationNodeAttributesPanel.this.getData()).findParentNode()) != null && abstractNode instanceof DataProvider) {
                    DataProvider dataProvider = (DataProvider)((Object)abstractNode);
                    bl3 = null != dataProvider && null != dataProvider.getAttributes() && !dataProvider.getAttributes().getAttribute().isEmpty();
                }
                return bl3 ? OracleIcons.getIcon((String)"attribute.png") : OracleIcons.getIcon((String)"warning.png");
            }
        });
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
    }

    private boolean isValidMainGroupBy(GroupingElementType groupingElementType) {
        AggregationNode aggregationNode = (AggregationNode)this.getData();
        AbstractNode abstractNode = aggregationNode.findParentNode();
        if (abstractNode != null && !(abstractNode instanceof DataProvider)) {
            return false;
        }
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        if (null == dataProvider || null == dataProvider.getAttributes() || dataProvider.getAttributes().getAttribute().isEmpty()) {
            return false;
        }
        boolean bl = true;
        List list = dataProvider.getAttributes().getAttribute();
        Attributes attributes = groupingElementType.getAttributes();
        if (null != attributes) {
            List list2 = attributes.getAttribute();
            for (AttributeType attributeType : list2) {
                boolean bl2 = false;
                for (AttributeType attributeType2 : list) {
                    if (!attributeType.getName().equals(attributeType2.getName())) continue;
                    attributeType.setStatus(attributeType2.getStatus());
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    attributeType.setStatus(AttributeStatus.MISSING);
                }
                if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private void validateSourceColumn() {
        AggregationNode aggregationNode = (AggregationNode)this.getData();
        AbstractNode abstractNode = aggregationNode.findParentNode();
        if (abstractNode != null && !(abstractNode instanceof DataProvider)) {
            this.setStatusAllSourceColumns(this.cachedAggregationNodeType.getAggregationElements().getAggregationElement());
            return;
        }
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        if (null == dataProvider || null == dataProvider.getAttributes() || dataProvider.getAttributes().getAttribute().isEmpty()) {
            this.setStatusAllSourceColumns(this.cachedAggregationNodeType.getAggregationElements().getAggregationElement());
            return;
        }
        List list = dataProvider.getAttributes().getAttribute();
        for (AggregationElementType aggregationElementType : this.cachedAggregationNodeType.getAggregationElements().getAggregationElement()) {
            this.validateSourceElement(list, aggregationElementType);
            this.validateSubGroupingBy(list, aggregationElementType);
        }
    }

    private void validateSourceElement(List<AttributeType> list, AggregationElementType aggregationElementType) {
        GroupingElementType groupingElementType = aggregationElementType.getSource();
        Attributes attributes = groupingElementType.getAttributes();
        if (null != attributes) {
            List list2 = attributes.getAttribute();
            for (AttributeType attributeType : list2) {
                boolean bl = false;
                for (AttributeType attributeType2 : list) {
                    if (!attributeType.getName().equals(attributeType2.getName())) continue;
                    attributeType.setStatus(attributeType2.getStatus());
                    aggregationElementType.getOutput().setStatus(attributeType2.getStatus());
                    bl = true;
                    break;
                }
                if (bl) continue;
                attributeType.setStatus(AttributeStatus.MISSING);
                aggregationElementType.getOutput().setStatus(AttributeStatus.MISSING);
            }
        }
    }

    private void validateSubGroupingBy(List<AttributeType> list, AggregationElementType aggregationElementType) {
        GroupingElementType groupingElementType = aggregationElementType.getSubGroupBy();
        Attributes attributes = groupingElementType.getAttributes();
        if (null != attributes) {
            List list2 = attributes.getAttribute();
            for (AttributeType attributeType : list2) {
                boolean bl = false;
                for (AttributeType attributeType2 : list) {
                    if (!attributeType.getName().equals(attributeType2.getName())) continue;
                    aggregationElementType.getOutput().setStatus(attributeType2.getStatus());
                    bl = true;
                    break;
                }
                if (!bl) {
                    aggregationElementType.getOutput().setStatus(AttributeStatus.MISSING);
                }
                if (!aggregationElementType.getOutput().getStatus().equals((Object)AttributeStatus.MISSING)) continue;
                break;
            }
        }
    }

    private void setStatusAllSourceColumns(List<AggregationElementType> list) {
        AttributeStatus attributeStatus = AttributeStatus.MISSING;
        for (AggregationElementType aggregationElementType : list) {
            Attributes attributes = aggregationElementType.getSource().getAttributes();
            if (null != attributes) {
                List list2 = attributes.getAttribute();
                for (AttributeType attributeType : list2) {
                    attributeType.setStatus(attributeStatus);
                }
            }
            aggregationElementType.getOutput().setStatus(attributeStatus);
        }
    }

    protected void setGroupBy(String string) {
        this.jTxtGroupBy.setText(string);
        this.jTxtGroupBy.setToolTipText(string);
        this.jTxtGroupBy.setCaretPosition(0);
    }

    @Override
    protected String getDialogTitle() {
        return AggregateDialogsLrb.get("EDIT_AGGREGATE_ELEMENTS_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "aggregation_node_edit";
    }

    private static class GeneralAttributesTableModel
    extends ODMrTableModel<AggregationElementType> {
        private GeneralAttributesTableModel(List<AggregationElementType> list) {
            super(COLUMN_NAMES, list);
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            AggregationElementType aggregationElementType = (AggregationElementType)this.srcData.get(n);
            String string = null;
            if (n2 == 0) {
                GroupingElementType groupingElementType = aggregationElementType.getSource();
                if (null == groupingElementType.getExpression()) {
                    List list = groupingElementType.getAttributes().getAttribute();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (AttributeType attributeType : list) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(attributeType.getName());
                    }
                    string = stringBuilder.toString();
                } else {
                    string = groupingElementType.getExpression();
                }
            } else if (n2 == 1) {
                AttributeType attributeType = aggregationElementType.getOutput();
                string = attributeType.getName();
            } else if (n2 == 2) {
                string = aggregationElementType.getAggregationFunction();
            } else if (n2 == 3) {
                GroupingElementType groupingElementType = aggregationElementType.getSubGroupBy();
                if (null == groupingElementType.getExpression()) {
                    if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute()) {
                        List list = groupingElementType.getAttributes().getAttribute();
                        StringBuilder stringBuilder = new StringBuilder();
                        for (AttributeType attributeType : list) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(attributeType.getName());
                        }
                        string = stringBuilder.toString();
                    }
                } else {
                    string = groupingElementType.getExpression();
                }
            } else assert (false) : "Out of bounds column when accessing items";
            return string != null ? string : "";
        }
    }
}

