/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.bali.ewt.validate.ValidationMessageModelEvent;
import oracle.bali.ewt.validate.ValidationMessageModelListener;
import oracle.bali.ewt.validate.ValidationMessagePane;
import oracle.bali.ewt.validate.Validator;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.common.model.AttrTableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.GenericTableValidationComponent;
import oracle.dmt.dataminer.controls.renderers.AttributeNameCellRenderer;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AbstractAggregationWizardPage;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateValidation;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateValidationProgress;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregationWizardModel;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

public class AggregateEditAttributesPanel
extends AbstractAggregationWizardPage
implements DataminerGUIPanel,
DataConsumerPanel,
AggregateValidation {
    protected List<AttributeType> availAttrsTotal;
    protected List<AttributeType> availAttrsCache;
    protected List<AttributeType> selectedAttrsCache = new ArrayList<AttributeType>();
    private Context _context;
    private GroupingElementType _currentGroupByElement;
    private Boolean _wizardMode = Boolean.FALSE;
    private DataProvider _parentNode;
    private JScrollPane _jDescriptionScrollPane;
    private DataMinerTablePanel availableTablePanel;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private DataMinerTablePanel selectedTablePanel;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();
    private ValidationMessagePane _validationPanel;
    private GenericTableValidationComponent _validationComponent;
    private static String warningNum = AggregateDialogsLrb.get("AGGREGATE_WIZ_WARNING_NUMERIC");
    private static String warningChar = AggregateDialogsLrb.get("AGGREGATE_WIZ_WARNING_CHARACTER");

    @Override
    public String getPageDirtyKey() {
        return "columnsDirty";
    }

    @Override
    protected String getValidationMessage() {
        return AggregateDialogsLrb.get("AGGREGATE_WIZ_COLUMNS_PAGE_VALIDATION_MESSAGE");
    }

    @Override
    protected String getValidationTitle() {
        return AggregateDialogsLrb.get("AGGREGATE_WIZ_COLUMNS_PAGE_VALIDATE_TITLE");
    }

    @Override
    protected String getValidationFailedMessage() {
        return AggregateDialogsLrb.get("AGGREGATE_WIZ_COLUMNS_PAGE_VALIDATION_FAILED");
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        boolean bl;
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        boolean bl2 = bl = null != this.selectedAttrsCache && !this.selectedAttrsCache.isEmpty();
        if (!bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)AggregateDialogsLrb.get("AGGREGATE_WIZ_FAILURE_NO_COLUMNS"), (String)AggregateDialogsLrb.get("AGGREGATE_WIZ_FAILURE_TITLE"), null);
        }
        AggregationWizardModel aggregationWizardModel = this.getModel(this.getTraversableContext());
        aggregationWizardModel.setSelectedAttrs(this.selectedAttrsCache);
        return bl;
    }

    public AggregateEditAttributesPanel(Context context, DataProvider dataProvider, List<AttributeType> list, GroupingElementType groupingElementType) {
        this(context, dataProvider, list, groupingElementType, Boolean.FALSE);
    }

    public AggregateEditAttributesPanel(Context context, DataProvider dataProvider, List<AttributeType> list, GroupingElementType groupingElementType, Boolean bl) {
        List<AttributeType> list2;
        this._parentNode = dataProvider;
        this._wizardMode = bl;
        assert (list != null) : "Available attribute collection must not be null";
        Collections.sort(list, AttributeTypeComparator.getComparator());
        this._currentGroupByElement = groupingElementType;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        if (null != this._currentGroupByElement.getAttributes()) {
            list2 = this._currentGroupByElement.getAttributes().getAttribute();
            if (!this._currentGroupByElement.getAttributes().getAttribute().isEmpty()) {
                for (AttributeType attributeType : list2) {
                    hashMap.put(attributeType.getName(), attributeType);
                }
            }
        }
        list2 = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            if (null != hashMap.get(list.get(i).getName())) continue;
            ((ArrayList)list2).add(list.get(i));
        }
        this.availAttrsCache = list2;
        this.availAttrsTotal = new ArrayList<AttributeType>();
        this.availAttrsTotal.addAll(list2);
        this._context = context;
        this.initComponents();
        this.initRes();
        if (bl == null || bl.equals(Boolean.FALSE)) {
            this.initUI();
        } else {
            this.creatValidationMessagePane();
        }
    }

    private void initComponents() {
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this._jDescriptionScrollPane = new JScrollPane();
        this.availableTablePanel = new DataMinerTablePanel();
        this.selectedTablePanel = new DataMinerTablePanel();
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this._jDescriptionScrollPane.setBorder(null);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.availableTablePanel, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -2, 49, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectedTablePanel, -2, 0, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(13, 13, 13).addComponent(this._jDescriptionScrollPane, -1, 510, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jDescriptionScrollPane, -2, 23, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(49, 49, 49).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn)).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectedTablePanel, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.availableTablePanel, -1, 216, Short.MAX_VALUE)))).addGap(6, 6, 6)));
    }

    @Override
    public void initRes() {
        this.initIcons();
        if (this._wizardMode.equals(Boolean.TRUE)) {
            this._jDescription.setText(AggregateDialogsLrb.get("AGGREGATE_WIZ_COLUMNS_PAGE_DESCRIPTION"));
            this._jDescriptionScrollPane.getViewport().add((Component)this._jDescription);
        } else {
            this._jDescriptionScrollPane.setVisible(false);
        }
    }

    private void initIcons() {
        this.jSelectBtn.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
        this.jSelectAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_rightall.png"));
        this.jRemoveBtn.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.jRemoveAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_leftall.png"));
    }

    public List<AttributeType> getSelectedAttributes() {
        return null != this._currentGroupByElement.getAttributes() ? this._currentGroupByElement.getAttributes().getAttribute() : new ArrayList();
    }

    private void initSelectedAttributesCache(List<AttributeType> list) {
        for (AttributeType object : list) {
            AttributeType attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(object);
            this.selectedAttrsCache.add(attributeType);
        }
        HashMap hashMap = new HashMap(this.availAttrsTotal.size());
        for (AttributeType attributeType : this.availAttrsTotal) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        for (AttributeType attributeType : this.selectedAttrsCache) {
            if (null != hashMap.get(attributeType.getName())) continue;
            this.availAttrsTotal.add(attributeType);
            hashMap.put(attributeType.getName(), attributeType);
        }
    }

    @Override
    public void initUI() {
        List<AttributeType> list = this.getSelectedAttributes();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        this.initSelectedAttributesCache(list);
        this.removeSelectedAttrs(this.availAttrsCache, this.selectedAttrsCache);
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        this.availableTablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    AggregateEditAttributesPanel.this.moveItems(AggregateEditAttributesPanel.this.availableTablePanel.getTable(), AggregateEditAttributesPanel.this.selectedTablePanel.getTable(), false);
                }
            }
        });
        this.selectedTablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    AggregateEditAttributesPanel.this.moveItems(AggregateEditAttributesPanel.this.selectedTablePanel.getTable(), AggregateEditAttributesPanel.this.availableTablePanel.getTable(), false);
                }
            }
        });
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregateEditAttributesPanel.this.moveItems(AggregateEditAttributesPanel.this.availableTablePanel.getTable(), AggregateEditAttributesPanel.this.selectedTablePanel.getTable(), false);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregateEditAttributesPanel.this.moveItems(AggregateEditAttributesPanel.this.availableTablePanel.getTable(), AggregateEditAttributesPanel.this.selectedTablePanel.getTable(), true);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregateEditAttributesPanel.this.moveItems(AggregateEditAttributesPanel.this.selectedTablePanel.getTable(), AggregateEditAttributesPanel.this.availableTablePanel.getTable(), false);
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregateEditAttributesPanel.this.moveItems(AggregateEditAttributesPanel.this.selectedTablePanel.getTable(), AggregateEditAttributesPanel.this.availableTablePanel.getTable(), true);
            }
        });
        this.initializeTables();
        this.jSelectBtn.setEnabled(false);
        this.jRemoveBtn.setEnabled(false);
        this.availableTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                AggregateEditAttributesPanel.this.jSelectBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
            }
        });
        this.selectedTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                AggregateEditAttributesPanel.this.jRemoveBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
            }
        });
    }

    private void removeInvalidDataTypes(List<AttributeType> list) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (AttributeType attributeType : list) {
            if (DatabaseMetadataUtils.isDataTypeSupported(attributeType.getDataType())) continue;
            arrayList.add(attributeType);
        }
        list.removeAll(arrayList);
    }

    private void initializeTables() {
        this.removeInvalidDataTypes(this.availAttrsCache);
        AttrTableModel<AttributeType> attrTableModel = new AttrTableModel<AttributeType>(this.availAttrsCache);
        this.setupAvialableTable(attrTableModel);
        AttrTableModel<AttributeType> attrTableModel2 = new AttrTableModel<AttributeType>(this.selectedAttrsCache);
        this.setupSelectedTable(attrTableModel2);
        if (!this._wizardMode.booleanValue()) {
            return;
        }
        if (this._validationComponent != null) {
            this.validateAttributeSelection();
        }
        this.selectedTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                if (AggregateEditAttributesPanel.this._validationComponent != null) {
                    AggregateEditAttributesPanel.this.validateAttributeSelection();
                }
            }
        });
    }

    private void setupSelectedTable(AttrTableModel attrTableModel) {
        this.selectedTablePanel.setup((TableModel)((Object)attrTableModel), DataDialogsLrb.get("SELECTED_LABEL"), 0, true);
        TableColumn tableColumn = this.selectedTablePanel.getTable().getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
    }

    private void setupAvialableTable(AttrTableModel attrTableModel) {
        this.availableTablePanel.setup((TableModel)((Object)attrTableModel), DataDialogsLrb.get("AVAILABLE_LABEL"), 0, true);
        TableColumn tableColumn = this.availableTablePanel.getTable().getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        int n2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List list = ((AttrTableModel)((Object)genericTable.getModel())).getSrcData();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!bl) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                AttributeType object2 = (AttributeType)list.get(nArray[n2]);
                arrayList.add(object2);
            }
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                arrayList.add(list.get(n2));
            }
        }
        for (AttributeType attributeType : arrayList) {
            n = list.indexOf(attributeType);
            if (n == -1) continue;
            list.remove(n);
        }
        List list2 = ((AttrTableModel)((Object)genericTable2.getModel())).getSrcData();
        list2.addAll(arrayList);
        ((AttrTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((AttrTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        int[] nArray2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = list2.indexOf(arrayList.get(n));
            assert (n3 != -1) : "Unexpected state - added item should be present and must have an index";
            nArray2[n] = n3;
        }
        genericTable2.setSelectedRowsInModel(nArray2);
    }

    private void removeSelectedAttrs(List<AttributeType> list, List<AttributeType> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list2) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        Iterator<AttributeType> iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeType attributeType;
            attributeType = iterator.next();
            AttributeType attributeType2 = (AttributeType)hashMap.get(attributeType.getName());
            if (attributeType2 == null || !attributeType2.getName().equals(attributeType.getName()) || !attributeType2.getDataType().equals(attributeType.getDataType())) continue;
            iterator.remove();
        }
    }

    public Context getContext() {
        return this._context;
    }

    @Override
    public boolean doWork() {
        if (this.selectedAttrsCache.isEmpty()) {
            if (this._currentGroupByElement.getAttributes() != null) {
                this._currentGroupByElement.getAttributes().getAttribute().clear();
            } else if (this._currentGroupByElement.getExpression() != null) {
                this._currentGroupByElement.setExpression(null);
            }
            return true;
        }
        Boolean bl = AggregateValidationProgress.startLongRunningOperation(this, false);
        if (bl.equals(Boolean.TRUE)) {
            Attributes attributes = new Attributes();
            List list = attributes.getAttribute();
            list.addAll(this.selectedAttrsCache);
            this._currentGroupByElement.setAttributes(attributes);
            this._currentGroupByElement.setExpression(null);
        }
        return bl;
    }

    @Override
    public boolean isValidExpression(boolean bl) throws Exception {
        if (this.selectedAttrsCache.isEmpty()) {
            return false;
        }
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (AttributeType attributeType : this.selectedAttrsCache) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(" || ");
                stringBuilder.append("'");
                stringBuilder.append(" - ");
                stringBuilder.append("'");
                stringBuilder.append(" || ");
            }
            stringBuilder.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
        }
        StringBuilder stringBuilder2 = new StringBuilder("(select count(*) from (");
        stringBuilder2.append(this._parentNode.getInputSQL());
        stringBuilder2.append(")\n");
        stringBuilder2.append("GROUP BY (");
        stringBuilder2.append((CharSequence)stringBuilder);
        stringBuilder2.append("))");
        if (stringBuilder2 != null) {
            bl2 = AttributeTypeHelper.executeSQLAggregate(this._context, stringBuilder2.toString());
        }
        return bl2;
    }

    @Override
    protected void pageDeselected(TraversableContext traversableContext) throws TraversalException {
        super.pageDeselected(traversableContext);
        AggregationWizardModel aggregationWizardModel = this.getModel(this.getTraversableContext());
        aggregationWizardModel.getWizard().setValidationMessagePane(null);
    }

    private void validateAttributeSelection() {
        AttrTableModel attrTableModel = (AttrTableModel)((Object)this.selectedTablePanel.getTable().getModel());
        List list = attrTableModel.getSrcData();
        AggregationWizardModel aggregationWizardModel = this.getModel(this.getTraversableContext());
        boolean bl = null != aggregationWizardModel.getSelectedNumericFunctions() && !aggregationWizardModel.getSelectedNumericFunctions().isEmpty();
        boolean bl2 = null != aggregationWizardModel.getSelectedCharFunctions() && !aggregationWizardModel.getSelectedCharFunctions().isEmpty();
        Vector<ValidationMessage> vector = new Vector<ValidationMessage>();
        if (list == null || list.isEmpty()) {
            if (bl) {
                vector.add(new ValidationMessage(2, warningNum));
            }
            if (bl2) {
                vector.add(new ValidationMessage(2, warningChar));
            }
        } else {
            boolean bl3 = false;
            boolean bl4 = false;
            for (AttributeType attributeType : list) {
                if (bl3 && bl4) break;
                if (!attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                if (!bl4 && "VARCHAR2".equals(attributeType.getDataType())) {
                    bl4 = true;
                    continue;
                }
                if (bl3 || !"NUMBER".equals(attributeType.getDataType())) continue;
                bl3 = true;
            }
            if (bl && !bl3) {
                vector.add(new ValidationMessage(2, warningNum));
            } else if (bl2 && !bl4) {
                vector.add(new ValidationMessage(2, warningChar));
            }
        }
        this._validationComponent.getValidationMessageModel().clear();
        if (!vector.isEmpty()) {
            this._validationComponent.getValidationMessageModel().addValidationMessages(vector.toArray(new ValidationMessage[vector.size()]));
        }
    }

    @Override
    protected void onEntryAfterInit(TraversableContext traversableContext) {
        if (this.isUiInitialized()) {
            if (this._validationComponent != null) {
                this.validateAttributeSelection();
            }
            this._validationPanel.addValidationComponent((ValidationComponent)this._validationComponent);
        }
    }

    private void hideOrShowMessagePane() {
        AggregationWizardModel aggregationWizardModel = this.getModel(this.getTraversableContext());
        if (this._validationComponent.getValidationMessageModel().getMessageCount() > 0) {
            this._validationPanel.addValidationComponent((ValidationComponent)this._validationComponent);
            aggregationWizardModel.getWizard().setValidationMessagePane(this.getWizardValidationPanel());
        } else {
            aggregationWizardModel.getWizard().setValidationMessagePane(null);
        }
    }

    protected ValidationMessagePane getWizardValidationPanel() {
        if (this._validationPanel == null) {
            this.creatValidationMessagePane();
        }
        return this._validationPanel;
    }

    private void creatValidationMessagePane() {
        MessageListener messageListener = new MessageListener();
        this._validationPanel = new ValidationMessagePane();
        this._validationPanel.addPropertyChangeListener((PropertyChangeListener)messageListener);
        this._validationComponent = new GenericTableValidationComponent(new DataMinerTable());
        AttributeSelectionValidator attributeSelectionValidator = new AttributeSelectionValidator();
        this._validationComponent.addValidator((Object)this.selectedTablePanel.getTable(), attributeSelectionValidator);
        this._validationPanel.addValidationComponent((ValidationComponent)this._validationComponent);
        this._validationComponent.addValidationMessageModelListener(new MessageModelListener());
    }

    private static class AttributeSelectionValidator
    implements Validator {
        private AttributeSelectionValidator() {
        }

        public ValidationMessage[] validate(Component component, Object object) {
            assert (object instanceof AggregationWizardModel) : "Data parameter must be a AggregationWizardModel";
            Vector<ValidationMessage> vector = new Vector<ValidationMessage>();
            AggregationWizardModel aggregationWizardModel = (AggregationWizardModel)object;
            aggregationWizardModel.validateSelectedAttributes(vector);
            ValidationMessage[] validationMessageArray = new ValidationMessage[vector.size()];
            return vector.toArray(validationMessageArray);
        }
    }

    private class MessageModelListener
    implements ValidationMessageModelListener {
        private MessageModelListener() {
        }

        public void messageAdded(ValidationMessageModelEvent validationMessageModelEvent) {
            AggregateEditAttributesPanel.this.hideOrShowMessagePane();
        }

        public void messageRemoved(ValidationMessageModelEvent validationMessageModelEvent) {
            AggregateEditAttributesPanel.this.hideOrShowMessagePane();
        }
    }

    private class MessageListener
    implements PropertyChangeListener {
        private MessageListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof ValidationMessagePane && ValidationMessagePane.PANE_EMPTY.equals(propertyChangeEvent.getPropertyName())) {
                AggregateEditAttributesPanel.this.hideOrShowMessagePane();
            }
        }
    }
}

