/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableAdapter;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.dialog.WorkflowDialogLrb;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageType;

public class ShowMessagesDialog
implements DialogDisplayable {
    private Node selectedNode;

    public ShowMessagesDialog(Node node) {
        this.selectedNode = node;
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableAdapter(){

            @Override
            public int getButtonMask() {
                return 20;
            }

            @Override
            public String getTitle() {
                return WorkflowDialogLrb.get("DIALOG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                return "showValidationErrors";
            }

            @Override
            public JComponent getContent() {
                return new ValidationErrorsPanel(ShowMessagesDialog.this.selectedNode.getData().getMessages().getMessage());
            }
        };
    }

    private static class ValidationsTableModel
    extends ODMrTableModel<MessageType> {
        private static final int MESSAGE = 0;

        private ValidationsTableModel(List<MessageType> list, String[] stringArray) {
            super(stringArray, list);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return MessageType.class;
            }
            return Object.class;
        }

        public Object getValueAt(int n, int n2) {
            MessageType messageType = (MessageType)this.srcData.get(n);
            MessageType messageType2 = null;
            switch (n2) {
                case 0: {
                    messageType2 = messageType;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return messageType2;
        }
    }

    private static class MessageCellRenderer
    extends DefaultTableCellRenderer {
        private MessageCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            MessageType messageType = (MessageType)object;
            String string = this.getLabelText(messageType);
            Icon icon = this.getCellIcon(messageType);
            if (string != null) {
                jLabel.setText(string);
            }
            if (icon != null) {
                jLabel.setIcon(icon);
            }
            return jLabel;
        }

        private Icon getCellIcon(MessageType messageType) {
            ImageIcon imageIcon = null;
            if (messageType.getType().equals((Object)MessageEnumType.INCOMPLETE) || messageType.getType().equals((Object)MessageEnumType.WARNING)) {
                imageIcon = DataMinerIcons.get(Icons.WARNING_STATUS);
            }
            return imageIcon;
        }

        private String getLabelText(MessageType messageType) {
            MessageType.Resource resource = messageType.getResource();
            String string = NodeMessagesLrb.get(resource.getId());
            if (resource.getParameters() != null) {
                List list = resource.getParameters().getValue();
                Object[] objectArray = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    MessageType.Resource.Parameters.Value value = (MessageType.Resource.Parameters.Value)list.get(i);
                    objectArray[i] = value.getValue();
                }
                string = MessageFormat.format(string, objectArray);
            }
            return string;
        }
    }

    class ValidationErrorsPanel
    extends JPanel {
        private final String[] columns = new String[]{WorkflowDialogLrb.get("MESSAGE_COLUMN_TITLE")};
        private transient List<MessageType> messages;
        private DataMinerTable messageTable;
        private JScrollPane scrollPane;

        public ValidationErrorsPanel(List<MessageType> list) {
            this.messages = list;
            this.initComponents();
            this.initRes();
            this.initUI();
        }

        private void initComponents() {
            this.scrollPane = new JScrollPane();
            this.messageTable = new DataMinerTable();
            this.messageTable.setModel(new DefaultTableModel(new Object[][]{{null}, {null}, {null}, {null}}, new String[]{"Validation Error"}){
                boolean[] canEdit;
                {
                    this.canEdit = new boolean[]{false};
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return this.canEdit[n2];
                }
            });
            this.messageTable.getTableHeader().setReorderingAllowed(false);
            this.scrollPane.setViewportView((Component)((Object)this.messageTable));
            GroupLayout groupLayout = new GroupLayout(this);
            this.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 418, Short.MAX_VALUE));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 131, Short.MAX_VALUE));
        }

        public void initRes() {
        }

        public void initUI() {
            ValidationsTableModel validationsTableModel = new ValidationsTableModel(this.messages, this.columns);
            this.messageTable.setModel((TableModel)((Object)validationsTableModel));
            this.messageTable.setSorted(true);
            this.messageTable.setColumnSelectorAvailable(false);
            this.messageTable.setUpdateSelectionOnSort(true);
            this.scrollPane.setColumnHeader(null);
            TableColumn tableColumn = this.messageTable.getColumnModel().getColumn(0);
            MessageCellRenderer messageCellRenderer = new MessageCellRenderer();
            tableColumn.setCellRenderer(messageCellRenderer);
        }
    }
}

