/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils.comparator;

import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.utils.comparator.NullComparator;
import oracle.dmt.dataminer.tviewer.performance.CPerformanceTabState;
import oracle.dmt.dataminer.tviewer.performance.PerformanceMetric;

public class PerformanceMetricComparator
extends NullComparator<PerformanceMetric> {
    private CPerformanceTabState.Measure primaryCompareMesaure;
    private CPerformanceTabState.SortBy sortBy;
    private SortDirection sortDirection;

    public PerformanceMetricComparator(CPerformanceTabState.Measure measure, CPerformanceTabState.SortBy sortBy, SortDirection sortDirection) {
        this.primaryCompareMesaure = measure;
        this.sortBy = sortBy;
        this.sortDirection = sortDirection;
    }

    public int compareImpl(PerformanceMetric performanceMetric, PerformanceMetric performanceMetric2) {
        int n = 0;
        int n2 = SortDirection.ASCENDING == this.sortDirection ? 1 : -1;
        block0 : switch (this.sortBy) {
            case MEASURE: {
                switch (this.primaryCompareMesaure) {
                    case PREDICTIVE_CONFIDENCE: {
                        n = performanceMetric.getPredConfidence().compareTo(performanceMetric2.getPredConfidence());
                        break block0;
                    }
                    case TEST_ROWS: {
                        n = performanceMetric.getTestRows().compareTo(performanceMetric2.getTestRows());
                        break block0;
                    }
                    case AVG_ACCURACY: 
                    case ROOT_MEAN_SQRT_ERR: {
                        n = performanceMetric.getAvgAccuracyOrRoorMeanSqrtErr().compareTo(performanceMetric2.getAvgAccuracyOrRoorMeanSqrtErr());
                        break block0;
                    }
                    case OVERALL_ACCURACY: 
                    case MEAN_ABS_ERR: {
                        n = performanceMetric.getOverallAccuracyOrMeanAbsErr().compareTo(performanceMetric2.getOverallAccuracyOrMeanAbsErr());
                        break block0;
                    }
                    case COST: 
                    case MEAN_PREDICTED_VALUE: {
                        if (performanceMetric.getCostOrMeanPredictValue() == null && performanceMetric2.getCostOrMeanPredictValue() == null) {
                            n = 0;
                            break block0;
                        }
                        if (performanceMetric.getCostOrMeanPredictValue() == null && performanceMetric2.getCostOrMeanPredictValue() != null) {
                            n = -1;
                            break block0;
                        }
                        if (performanceMetric.getCostOrMeanPredictValue() != null && performanceMetric2.getCostOrMeanPredictValue() == null) {
                            n = 1;
                            break block0;
                        }
                        n = performanceMetric.getCostOrMeanPredictValue().compareTo(performanceMetric2.getCostOrMeanPredictValue());
                        break block0;
                    }
                    case MEAN_ACTUAL_VALUE: {
                        if (performanceMetric.getMeanActualValue() == null && performanceMetric2.getMeanActualValue() == null) {
                            n = 0;
                            break block0;
                        }
                        if (performanceMetric.getMeanActualValue() == null && performanceMetric2.getMeanActualValue() != null) {
                            n = -1;
                            break block0;
                        }
                        if (performanceMetric.getMeanActualValue() != null && performanceMetric2.getMeanActualValue() == null) {
                            n = 1;
                            break block0;
                        }
                        n = performanceMetric.getMeanActualValue().compareTo(performanceMetric2.getMeanActualValue());
                        break block0;
                    }
                }
                assert (false) : "Invalid option";
                break;
            }
            case CREATION_TIME: {
                n = performanceMetric.getTestResult().getCreationTime().compareTo(performanceMetric2.getTestResult().getCreationTime());
                break;
            }
            case NAME: {
                n = performanceMetric.getTestResult().toString().compareTo(performanceMetric2.getTestResult().toString());
                break;
            }
            default: {
                assert (false) : "Invalid option";
                break;
            }
        }
        return n * n2;
    }
}

