/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTargetSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleSettings;
import oracle.ide.Context;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;

public class SQLHelper {
    private static final Logger theLogger = Logger.getLogger(SQLHelper.class.getName());
    private static final String INDENTATION = "    ";
    public static final String CREATE_STATEMENT = "CREATE_STATEMENT";
    public static final String CREATE_INDEX = "CREATE_INDEX";
    public static final String INSERT_STATEMENT = "INSERT_STATEMENT";
    public static final String PURGE_TABLE = "PURGE_TABLE";
    public static final String CREATE_SERVER_CALL = "CREATE_SERVER_CALL";
    public static final String CREATE_TEMP_INPUT_VIEW = "CREATE_TEMP_INPUT_VIEW";
    public static final String HISTOGRAM_API = "HISTOGRAM_API";
    public static final String HISTOGRAM_SAMPLE = "HISTOGRAM_SAMPLE";
    public static final String TEMP_INPUT_VIEW_NAME = "TEMP_INPUT_VIEW_NAME";
    public static final String TEMP_SAMPLED_HISTOGRAM_TABLE_NAME = "TEMP_SAMPLED_HISTOGRAM_TABLE_NAME";
    public static final String TEMP_SAMPLED_TABLE_NAME = "TEMP_SAMPLED_TABLE_NAME";
    public static final String DROP_EXPLORE_NODE_TABLE_NAME = "DROP_EXPLORE_NODE_TABLE_NAME";
    public static final String CREATE_SAMPLE_DATA = "CREATE_SAMPLE_DATA";
    public Connection conn;
    public PreparedStatement pstmt;
    public OraclePreparedStatement opstmt;
    public OracleCallableStatement cstmt;
    public Statement stmt;
    public ResultSet rs;
    public OracleResultSet ors;
    public String message;
    public boolean success;
    public static final String COMMA = ",";
    public static final String DOT = ".";
    public String owner;
    public static final StringBuilder _empty = new StringBuilder("");
    private static String _sqlCalcHistograms = "  ODMR_UTIL.CLIENT_CALCULATE_HISTOGRAMS (\n     <p_input_table>,\n      '<stats_table_name>',\n     <p_num_bins>,\n     <p_cat_bins>,\n     <p_date_bins>,\n     <p_grouping_column>,\n     <p_grouping_column_type>,\n     v_attributes,\n     v_attrDataTypes,\n     <p_nulls_label>,\n     <p_other_label>,\n     <p_sampled_mode>,\n     <p_parallel_query_hint>,\n     <p_parallel_insert_hint>,\n     <p_parallel_table_hint>,\n     <p_in_memory_on>,\n     <p_compression>,\n     <p_priority>);\n";
    private static String _sqlNonSampleData = "  v_histogram_sampled_data := v_explore_sampled_data;\n";
    private static String _sqlSampleData = "  v_explore_sampled_data := ODMR_UTIL.CREATE_SAMPLE_DATA (\n     v_data_view_name,\n     <p_useNumberOfRows>,\n     <p_numberOfRows>,\n     <p_usePercentOfTotal>,\n     <p_percentOfTotal>,\n     <p_useRandom>,\n     <p_seed>,\n     <p_useStratified>,\n     <p_useTopN>,\n     <p_parallel_query_hint>,\n     <p_parallel_insert_hint>,\n     <p_parallel_table_hint>,\n     <p_in_memory_on>,\n     <p_compression>,\n     <p_priority>);\n";
    private static String _sqlSampleHistograms = "  v_histogram_sampled_data := ODMR_UTIL.CREATE_HISTOGRAM_SAMPLE_DATA(v_data_view_name);\n";
    private static String _odmrEngineCall_all_data = "\n  ODMR_UTIL.CREATE_EXPLORE_NODE_STATISTICS(\n    p_input_view              => v_data_view_name,\n    p_statistics_table_name   => '<stats_table_name>',\n    p_attributes              => v_attributes,\n    p_attrDataTypes           => v_attrDataTypes,\n    p_calc_percent_distinct   => <PERCENT_DISTINCT>,\n    p_calc_percent_null       => <PERCENT_NULL>,\n    p_calc_max                => <MAX_VALUE>,\n    p_calc_min                => <MIN_VALUE>,\n    p_calc_avg                => <AVG_VALUE>,\n    p_calc_stddev             => <STDDEV_VALUE>,\n    p_calc_variance           => <VAR_VALUE>, \n    p_calc_kurtosis           => <KURT_VALUE>,\n    p_calc_median             => <MEDIAN_VALUE>, \n    p_calc_skewness           => <SKEW_VALUE>,\n    p_calc_mode               => <MODE_VALUE>, \n    p_calc_mode_sampled       => <MODE_SAMPLED>, \n    p_calc_mode_all           => <MODE_ALL>,\n    p_parallel_query_hint     => <p_parallel_query_hint>,\n    p_parallel_insert_hint    => <p_parallel_insert_hint>,\n    p_parallel_table_hint     => <p_parallel_table_hint>,\n    p_in_memory               => <p_in_memory_on>,\n    p_compression             => <p_compression>,\n    p_priority                => <p_priority>);\n";
    private static String _odmrEngineCall_sampled_data = "\n  ODMR_UTIL.CREATE_EXPLORE_NODE_STATISTICS(\n    p_input_view              => v_explore_sampled_data,\n    p_statistics_table_name   => '<stats_table_name>',\n    p_attributes              => v_attributes,\n    p_attrDataTypes           => v_attrDataTypes,\n    p_calc_percent_distinct   => <PERCENT_DISTINCT>,\n    p_calc_percent_null       => <PERCENT_NULL>,\n    p_calc_max                => <MAX_VALUE>,\n    p_calc_min                => <MIN_VALUE>,\n    p_calc_avg                => <AVG_VALUE>,\n    p_calc_stddev             => <STDDEV_VALUE>,\n    p_calc_variance           => <VAR_VALUE>, \n    p_calc_kurtosis           => <KURT_VALUE>,\n    p_calc_median             => <MEDIAN_VALUE>, \n    p_calc_skewness           => <SKEW_VALUE>,\n    p_calc_mode               => <MODE_VALUE>, \n    p_calc_mode_sampled       => <MODE_SAMPLED>, \n    p_calc_mode_all           => <MODE_ALL>,\n    p_parallel_query_hint     => <p_parallel_query_hint>,\n    p_parallel_insert_hint    => <p_parallel_insert_hint>,\n    p_parallel_table_hint     => <p_parallel_table_hint>,\n    p_in_memory               => <p_in_memory_on>,\n    p_compression             => <p_compression>,\n    p_priority                => <p_priority>);\n";
    private static String _columns_LOOP = "  FOR j IN 1..v_columns.COUNT LOOP\n    v_attributes.EXTEND(1);\n    IF ( v_aliases(j) IS NOT NULL ) THEN\n      v_attributes(v_attributes.COUNT) := v_aliases(j);\n    ELSE \n      v_attributes(v_attributes.COUNT) := v_columns(j);\n    END IF;\n  END LOOP;\n\n";
    private static String _dropHistDataViewSQL = "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_data_view_name, 'VIEW', NULL, 'Input Data');";
    private static String _dropHistSampledTableSQL = "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_histogram_sampled_data, 'TABLE', NULL, 'Sampled Histogram Data');";
    private static String _dropSampledTableSQL = "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_explore_sampled_data, 'TABLE', NULL, 'Sampled Data');";
    private static String _dropExploreTableSQL = "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, '<stats_table_name>', 'TABLE', NULL, 'Output Data');";
    public static final String INPUT_SQL = "<INPUT_SQL>";
    private static String _purgeStatsTableSQL = "DROP TABLE <stats_table_name> PURGE";
    public static final String PERCENT_DISTINCT = "<PERCENT_DISTINCT>";
    public static final String PERCENT_NULL = "<PERCENT_NULL>";
    public static final String MAX_VALUE = "<MAX_VALUE>";
    public static final String MIN_VALUE = "<MIN_VALUE>";
    public static final String AVG_VALUE = "<AVG_VALUE>";
    public static final String STDDEV_VALUE = "<STDDEV_VALUE>";
    public static final String VAR_VALUE = "<VAR_VALUE>";
    public static final String KURT_VALUE = "<KURT_VALUE>";
    public static final String MEDIAN_VALUE = "<MEDIAN_VALUE>";
    public static final String SKEW_VALUE = "<SKEW_VALUE>";
    public static final String MODE_VALUE = "<MODE_VALUE>";
    public static final String MODE_ALL = "<MODE_ALL>";
    public static final String MODE_SAMPLED = "<MODE_SAMPLED>";
    public static final String p_parallel_query_hint = "<p_parallel_query_hint>";
    public static final String p_parallel_insert_hint = "<p_parallel_insert_hint>";
    public static final String p_parallel_table_hint = "<p_parallel_table_hint>";
    public static final String p_in_memory_on = "<p_in_memory_on>";
    public static final String p_compression = "<p_compression>";
    public static final String p_priority = "<p_priority>";
    public static final String JOIN_LEFT_OUTER = " LEFT OUTER JOIN ";
    public static final String JOIN_RIGHT_OUTER = " RIGHT OUTER JOIN ";
    public static final String JOIN = " JOIN ";

    public final void close() {
        if (null != this.rs) {
            try {
                this.rs.close();
                this.rs = null;
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.FINEST, sQLException.getMessage(), sQLException);
            }
        }
        if (null != this.ors) {
            try {
                this.ors.close();
                this.ors = null;
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.FINEST, sQLException.getMessage(), sQLException);
            }
        }
        if (null != this.stmt) {
            try {
                this.stmt.close();
                this.stmt = null;
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.FINEST, sQLException.getMessage(), sQLException);
            }
        }
        if (null != this.pstmt) {
            try {
                this.pstmt.close();
                this.pstmt = null;
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.FINEST, sQLException.getMessage(), sQLException);
            }
        }
        if (null != this.opstmt) {
            try {
                this.opstmt.close();
                this.opstmt = null;
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.FINEST, sQLException.getMessage(), sQLException);
            }
        }
        if (null != this.cstmt) {
            try {
                this.cstmt.close();
                this.cstmt = null;
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.FINEST, sQLException.getMessage(), sQLException);
            }
        }
        if (null != this.conn) {
            try {
                this.conn.close();
                this.conn = null;
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.FINEST, sQLException.getMessage(), sQLException);
            }
        }
    }

    public static String buildSimpleQuery(Context context, String[] stringArray, String[] stringArray2, String string) {
        assert (stringArray != null && stringArray.length >= 0) : "Columns array cannot be null";
        assert (stringArray2 != null && stringArray2.length >= 0) : "Tables array cannot be null";
        if (string != null) assert (string.length() > 0) : "Where clause cannot be empty";
        StringBuffer stringBuffer = SQLHelper.formatSelectClause(context, stringArray);
        stringBuffer.append(SQLHelper.formatFromClause(stringArray2));
        if (string != null) {
            stringBuffer.append("\nwhere " + string);
        }
        return stringBuffer.toString();
    }

    public static String buildSimpleAliasQuery(Context context, String[] stringArray, String[] stringArray2, String[] stringArray3, String string) {
        assert (stringArray != null && stringArray.length >= 0) : "Columns array cannot be null";
        assert (stringArray3 != null && stringArray3.length >= 0) : "Tables array cannot be null";
        if (string != null) assert (string.length() > 0) : "Where clause cannot be empty";
        StringBuffer stringBuffer = SQLHelper.formatSelectClauseAlias(context, stringArray, stringArray2);
        stringBuffer.append(SQLHelper.formatFromClause(stringArray3));
        if (string != null) {
            stringBuffer.append("\nwhere " + string);
        }
        return stringBuffer.toString();
    }

    public static Map<String, StringBuilder> buildCreateTableSQL(Context context, List<DatabaseMetadataUtils.ColumnInfo> list, String string, String string2, String string3, String string4) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder("CREATE TABLE " + string + " (\n");
        StringBuilder stringBuilder2 = new StringBuilder();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        try {
            object = null;
            StringBuilder stringBuilder3 = new StringBuilder();
            StringBuilder stringBuilder4 = new StringBuilder();
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DatabaseMetadataUtils.ColumnInfo object2 : list) {
                String string5 = object2.getColumnAlias() != null ? object2.getColumnAlias() : object2.getColumnName();
                String string6 = "\"" + string5 + "\"";
                StringBuilder stringBuilder5 = new StringBuilder();
                for (int i = 0; i < 30 - string5.length(); ++i) {
                    stringBuilder5.append(" ");
                }
                object = object2.getDataType();
                if (n > 0) {
                    stringBuilder.append(",\n");
                }
                stringBuilder.append(INDENTATION + string6 + stringBuilder5.toString() + object2.getDataType());
                if (((String)object).equals("VARCHAR2") || ((String)object).equals("CHAR") || ((String)object).equals("NVARCHAR2") || ((String)object).equals("NCHAR")) {
                    stringBuilder.append("(" + object2.getDataLength() + ")");
                }
                ++n;
                if ("Yes".equals(object2.getPrimaryKey())) {
                    if (stringBuilder3.length() > 0) {
                        stringBuilder3.append(COMMA);
                    }
                    stringBuilder3.append(string6);
                }
                if ("Yes".equals(object2.getIndex()) && "No".equals(object2.getPrimaryKey())) {
                    if (stringBuilder4.length() > 0) {
                        stringBuilder4.append(COMMA);
                    }
                    stringBuilder4.append(string6);
                }
                if (0 == ((String)object).compareToIgnoreCase("CLOB") || 0 == ((String)object).compareToIgnoreCase("NCLOB")) {
                    arrayList.add(String.format("LOB(%s) STORE AS BASICFILE", string6));
                    continue;
                }
                if (0 == ((String)object).compareToIgnoreCase("XMLTYPE")) {
                    arrayList.add(String.format("XMLTYPE COLUMN %s STORE AS BASICFILE CLOB", string6));
                    continue;
                }
                if (object2.getColType() == null || 0 != object2.getColType().compareToIgnoreCase("TABLE")) continue;
                String string7 = DatabaseMetadataUtils.createUniqueTempTableName("ODMR$", connectionFolder);
                arrayList.add(String.format("NESTED TABLE %s STORE AS %s", string6, string7));
            }
            if (stringBuilder3.length() > 0) {
                Iterator iterator = null;
                iterator = DatabaseMetadataUtils.createUniquePKConstraintName("ODMR$", connectionFolder);
                stringBuilder.append(",\n    CONSTRAINT ");
                stringBuilder.append((String)((Object)iterator));
                stringBuilder.append(" PRIMARY KEY (");
                stringBuilder.append((CharSequence)stringBuilder3);
                stringBuilder.append(")");
            }
            stringBuilder.append(")\n");
            n = 0;
            for (String string8 : arrayList) {
                if (n > 0) {
                    stringBuilder.append(",\n");
                }
                stringBuilder.append(INDENTATION + string8);
                ++n;
            }
            int n2 = string2.indexOf("NOLOGGING");
            if (-1 != n2) {
                string2 = string2.substring(0, n2);
            }
            stringBuilder.append(INDENTATION + string2);
            stringBuilder.append(INDENTATION + string4);
            if (!string3.equals("No")) {
                stringBuilder.append(INDENTATION + string3);
            }
            if (stringBuilder4.length() > 0) {
                String string9 = DatabaseMetadataUtils.createUniqueConstraintNameUsinRandom("ODMR$", connectionFolder);
                stringBuilder2.append("v_sql := 'CREATE INDEX ");
                stringBuilder2.append(string9);
                stringBuilder2.append(" ON ");
                stringBuilder2.append(string);
                stringBuilder2.append(" (");
                stringBuilder2.append((CharSequence)stringBuilder4);
                stringBuilder2.append(") " + string2 + " ';");
                stringBuilder2.append("\n");
                stringBuilder2.append("  execSQL(v_sql);");
            }
        }
        catch (Exception exception) {
            stringBuilder = new StringBuilder(String.format(UtilsLrb.get("FAILURE_CREATE_TABLE_SWL"), exception.getMessage()));
        }
        object = new HashMap<String, StringBuilder>();
        object.put(CREATE_STATEMENT, stringBuilder);
        object.put(CREATE_INDEX, stringBuilder2);
        return object;
    }

    public static String alterTableInMemorySQL(Context context, String string, boolean bl, String string2, String string3) {
        if (!SQLHelper.isDBVersion12102andUp(context) || !bl) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("v_sql := 'ALTER TABLE " + string + " " + string2 + " " + string3 + "';");
        stringBuilder.append("\n");
        stringBuilder.append("  execSQL(v_sql);");
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public static String populateCreatedTableSQL(Context context, List<DatabaseMetadataUtils.ColumnInfo> list, String string, String string2, AbstractNode abstractNode, String string3, String string4) {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("INSERT " + string3 + " INTO " + string + "\n");
        boolean bl = SQLHelper.generateSQLInlineHint(context);
        String string5 = bl ? "/*+ inline " + string4 + " */ " : "/*+ " + string4 + " */ ";
        stringBuilder.append("    SELECT " + string5);
        stringBuilder.append("\n");
        for (DatabaseMetadataUtils.ColumnInfo columnInfo : list) {
            String string6 = columnInfo.getColumnName();
            String string7 = "\"" + string6 + "\"";
            if (n > 0) {
                stringBuilder.append(",\n");
            }
            stringBuilder.append(INDENTATION + string7);
            ++n;
        }
        if (abstractNode instanceof DataProfileNode) {
            DatabaseMetadataUtils.ColumnInfo columnInfo;
            DataProfileNode dataProfileNode = (DataProfileNode)abstractNode;
            columnInfo = (DataProfileNodeType)dataProfileNode.getData();
            stringBuilder.append("\n    FROM " + columnInfo.getStatisticTable().getName());
        } else {
            stringBuilder.append("\n    FROM (");
            stringBuilder.append(string2);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public static String buildCreateViewSQL(Context context, List<DatabaseMetadataUtils.ColumnInfo> list, String string, String string2, String string3) {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("CREATE VIEW " + string + " AS \n");
        boolean bl = SQLHelper.generateSQLInlineHint(context);
        String string4 = bl ? "/*+ inline " + string3 + " */ " : "/*+ " + string3 + " */ ";
        stringBuilder.append("    SELECT " + string4);
        stringBuilder.append("\n");
        for (DatabaseMetadataUtils.ColumnInfo columnInfo : list) {
            String string5;
            String string6 = columnInfo.getColumnName();
            String string7 = "\"" + string6 + "\"";
            String string8 = columnInfo.getColumnAlias();
            String string9 = string5 = string8 != null ? "\"" + string8 + "\"" : null;
            if (n > 0) {
                stringBuilder.append(",\n");
            }
            stringBuilder.append(INDENTATION + string7);
            if (string5 != null) {
                stringBuilder.append(" " + string5);
            }
            ++n;
        }
        stringBuilder.append("\n    FROM (");
        stringBuilder.append(string2);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static Map<String, StringBuilder> buildUpdateTableSQL(List<MapTargetSourceType> list, String string, String string2, String string3, String string4, boolean bl, String string5, String string6) {
        CharSequence charSequence;
        String string7;
        Object object2;
        String string8 = string;
        StringBuilder stringBuilder = new StringBuilder("INSERT " + string5 + " INTO " + string8 + " (\n");
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        for (Object object2 : list) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(",\n");
            }
            string7 = object2.getKey().getName();
            stringBuilder2.append("              ");
            stringBuilder2.append(StringUtils.isDoubleQuotedString(string7) ? string7 : StringUtils.addDoubleQuotes(string7));
            if (stringBuilder3.length() > 0) {
                stringBuilder3.append(",\n");
            }
            charSequence = object2.getValue().getName();
            stringBuilder3.append("              ");
            stringBuilder3.append((String)(StringUtils.isDoubleQuotedString((String)charSequence) ? charSequence : StringUtils.addDoubleQuotes((String)charSequence)));
        }
        StringBuilder stringBuilder4 = new StringBuilder("\n              WITH ");
        stringBuilder4.append(string2);
        stringBuilder4.append(",\n");
        object2 = StringUtils.addDoubleQuotes("N$" + string4);
        string7 = StringUtils.addDoubleQuotes("N$" + string3);
        stringBuilder4.append((String)object2);
        stringBuilder4.append(" AS ( SELECT /*+ inline */ ");
        stringBuilder4.append((CharSequence)stringBuilder3);
        stringBuilder4.append(" FROM " + string7);
        stringBuilder4.append(")\n");
        stringBuilder4.append("SELECT * FROM " + (String)object2);
        stringBuilder4.append("\n");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(")\n");
        stringBuilder.append("            SELECT ");
        stringBuilder.append(string6);
        stringBuilder.append("\n");
        stringBuilder.append((CharSequence)stringBuilder3);
        stringBuilder.append("\n            FROM (");
        stringBuilder.append((CharSequence)stringBuilder4);
        stringBuilder.append(")\n");
        charSequence = new StringBuilder();
        if (bl) {
            ((StringBuilder)charSequence).append("v_sql := 'DELETE FROM ");
            ((StringBuilder)charSequence).append(string8);
            ((StringBuilder)charSequence).append("';");
            ((StringBuilder)charSequence).append("\n");
            ((StringBuilder)charSequence).append("  execSQL(v_sql);");
        }
        HashMap<String, StringBuilder> hashMap = new HashMap<String, StringBuilder>();
        hashMap.put(INSERT_STATEMENT, stringBuilder);
        hashMap.put(PURGE_TABLE, (StringBuilder)charSequence);
        return hashMap;
    }

    public static StringBuffer formatSelectClauseAlias(Context context, String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer("select " + (SQLHelper.generateSQLInlineHint(context) ? "/*+ inline */ " : ""));
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (stringArray2[i] != null && stringArray2[i].trim().length() > 0) {
                stringBuffer.append(" AS ");
                stringBuffer.append(stringArray2[i]);
            }
            if (i == stringArray.length - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(", ");
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer formatSelectClause(Context context, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("select " + (SQLHelper.generateSQLInlineHint(context) ? "/*+ inline */ " : ""));
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i == stringArray.length - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(", ");
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer formatFromClause(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("\nfrom ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i == stringArray.length - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(", ");
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer formatJoinFromClause(String string, String string2, String string3, String string4) {
        return new StringBuffer("\n from " + string + string3 + string2).append(" ON " + string4);
    }

    public static String buildSimpleQuery(Context context, String[] stringArray, String[] stringArray2) {
        return SQLHelper.buildSimpleQuery(context, stringArray, stringArray2, null);
    }

    public static String[] delimit(String[] stringArray, String string) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(SQLHelper.delimit(stringArray[i], string));
        }
        String[] stringArray2 = new String[]{};
        return vector.toArray(stringArray2);
    }

    public static String delimit(String string, String string2) {
        return "\"" + string2 + "\"" + DOT + "\"" + string + "\"";
    }

    public static String delimitTable(String string, String string2) {
        return "\"" + string + "\".\"" + string2 + "\"";
    }

    public static String[] combine(String[] stringArray, String[] stringArray2) {
        Vector<String> vector = new Vector<String>();
        for (String string : stringArray) {
            vector.add(string);
        }
        for (String string : stringArray2) {
            vector.add(string);
        }
        String[] stringArray3 = new String[]{};
        return vector.toArray(stringArray3);
    }

    public static void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.FINEST, sQLException.getMessage(), sQLException);
        }
    }

    public static Map<String, StringBuilder> buildStatsTableSQL2(List<AttributeType> list, String string, String string2, String string3, SampleSettings sampleSettings, String string4, String string5, boolean bl, String string6, String string7, String string8, boolean bl2, String string9, String string10) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        CharSequence charSequence;
        boolean bl3;
        HashMap<String, StringBuilder> hashMap = new HashMap<String, StringBuilder>();
        String string11 = StringUtils.getReplacedString(_purgeStatsTableSQL, "<stats_table_name>", string);
        StringBuilder stringBuilder3 = new StringBuilder(string11);
        hashMap.put(PURGE_TABLE, stringBuilder3);
        StringBuilder stringBuilder4 = new StringBuilder(32000);
        StringBuilder stringBuilder5 = new StringBuilder("  v_sql := 'CREATE VIEW ");
        stringBuilder5.append("'||v_data_view_name||'");
        stringBuilder5.append(" AS SELECT ");
        stringBuilder5.append(string7);
        stringBuilder5.append(" * FROM (\n  WITH <INPUT_SQL>\n");
        stringBuilder5.append("SELECT * FROM INPUT_DATA_VIEW)';");
        stringBuilder5.append("\n");
        stringBuilder5.append("  execSQL(v_sql);\n");
        hashMap.put(CREATE_TEMP_INPUT_VIEW, stringBuilder5);
        for (AttributeType attributeType : list) {
            String string12 = attributeType.getName();
            String string13 = attributeType.getAlias();
            String string14 = attributeType.getDataType();
            stringBuilder4.append("  v_columns.EXTEND(1);\n  v_columns(v_columns.COUNT) := '" + string12 + "';\n  v_aliases.EXTEND(1);\n");
            if (string13 != null) {
                stringBuilder4.append("  v_aliases(v_aliases.COUNT) := '" + string13 + "';\n");
            } else {
                stringBuilder4.append("  v_aliases(v_aliases.COUNT) := null;\n");
            }
            stringBuilder4.append("  v_attrDataTypes.EXTEND(1);\n  v_attrDataTypes(v_attrDataTypes.COUNT) := '" + string14 + "';\n\n");
        }
        stringBuilder4.append(_columns_LOOP);
        int n = 0;
        int n2 = 0;
        boolean bl4 = bl3 = null != sampleSettings && !sampleSettings.isUseFullData();
        if (bl3) {
            int n3;
            int n4;
            int n5;
            if (null != sampleSettings.getNumberOfRows()) {
                n = 1;
                n2 = 0;
            } else if (null != sampleSettings.getPercentOfTotal()) {
                n2 = 1;
                n = 0;
            } else {
                n2 = 0;
                n = 0;
            }
            int n6 = 12345;
            if (null != sampleSettings.getMethod() && null != sampleSettings.getMethod().getRandom() && null != sampleSettings.getMethod().getRandom().getSeed()) {
                n5 = 1;
                n4 = 0;
                n3 = 0;
                n6 = sampleSettings.getMethod().getRandom().getSeed().intValue();
            } else {
                n3 = 1;
                n4 = 0;
                n5 = 0;
            }
            charSequence = StringUtils.getReplacedString(_sqlSampleData, "<p_useNumberOfRows>", String.valueOf(n));
            charSequence = StringUtils.getReplacedString(charSequence, "<p_numberOfRows>", String.valueOf(sampleSettings.getNumberOfRows()));
            charSequence = StringUtils.getReplacedString(charSequence, "<p_usePercentOfTotal>", String.valueOf(n2));
            charSequence = StringUtils.getReplacedString(charSequence, "<p_percentOfTotal>", String.valueOf(sampleSettings.getPercentOfTotal()));
            charSequence = StringUtils.getReplacedString(charSequence, "<p_useRandom>", String.valueOf(n5));
            charSequence = StringUtils.getReplacedString(charSequence, "<p_seed>", String.valueOf(n6));
            charSequence = StringUtils.getReplacedString(charSequence, "<p_useStratified>", String.valueOf(n4));
            charSequence = StringUtils.getReplacedString(charSequence, p_parallel_query_hint, StringUtils.addSingleQuotes(String.valueOf(string7)));
            charSequence = StringUtils.getReplacedString(charSequence, p_parallel_insert_hint, StringUtils.addSingleQuotes(String.valueOf(string8)));
            charSequence = StringUtils.getReplacedString(charSequence, p_parallel_table_hint, StringUtils.addSingleQuotes(String.valueOf(string6)));
            charSequence = StringUtils.getReplacedString(charSequence, p_in_memory_on, String.valueOf(bl2));
            charSequence = StringUtils.getReplacedString(charSequence, p_compression, StringUtils.addSingleQuotes(string9));
            charSequence = StringUtils.getReplacedString(charSequence, p_priority, StringUtils.addSingleQuotes(string10));
            charSequence = StringUtils.getReplacedString(charSequence, "<p_useTopN>", String.valueOf(n3));
            stringBuilder2 = new StringBuilder(_dropSampledTableSQL);
            hashMap.put(TEMP_SAMPLED_TABLE_NAME, stringBuilder2);
            stringBuilder = new StringBuilder((String)charSequence);
            hashMap.put(CREATE_SAMPLE_DATA, stringBuilder);
        } else {
            hashMap.put(CREATE_SAMPLE_DATA, _empty);
            hashMap.put(TEMP_SAMPLED_TABLE_NAME, _empty);
        }
        String string15 = StringUtils.getReplacedString(_dropExploreTableSQL, "<stats_table_name>", string);
        StringBuilder stringBuilder6 = new StringBuilder(string15);
        hashMap.put(DROP_EXPLORE_NODE_TABLE_NAME, stringBuilder6);
        StringBuilder stringBuilder7 = new StringBuilder(stringBuilder4);
        String string16 = StringUtils.getReplacedString(bl3 ? _odmrEngineCall_sampled_data : _odmrEngineCall_all_data, "<stats_table_name>", string);
        string16 = StringUtils.getReplacedString(string16, p_in_memory_on, String.valueOf(bl2));
        string16 = StringUtils.getReplacedString(string16, p_compression, StringUtils.addSingleQuotes(string9));
        string16 = StringUtils.getReplacedString(string16, p_priority, StringUtils.addSingleQuotes(string10));
        stringBuilder7.append(string16);
        hashMap.put(CREATE_SERVER_CALL, stringBuilder7);
        if (1 == n && sampleSettings.getNumberOfRows() <= 2000L) {
            charSequence = new StringBuilder(_sqlNonSampleData);
            hashMap.put(HISTOGRAM_SAMPLE, (StringBuilder)charSequence);
            hashMap.put(TEMP_SAMPLED_HISTOGRAM_TABLE_NAME, _empty);
        } else {
            charSequence = new StringBuilder(_sqlSampleHistograms);
            hashMap.put(HISTOGRAM_SAMPLE, (StringBuilder)charSequence);
            stringBuilder2 = new StringBuilder(_dropHistSampledTableSQL);
            hashMap.put(TEMP_SAMPLED_HISTOGRAM_TABLE_NAME, stringBuilder2);
        }
        charSequence = StringUtils.getReplacedString(_sqlCalcHistograms, "<p_input_table>", "v_histogram_sampled_data");
        charSequence = StringUtils.getReplacedString(charSequence, "<stats_table_name>", string);
        charSequence = StringUtils.getReplacedString(charSequence, "<p_nulls_label>", String.valueOf(string4));
        charSequence = StringUtils.getReplacedString(charSequence, "<p_other_label>", String.valueOf(string5));
        charSequence = StringUtils.getReplacedString(charSequence, "<p_sampled_mode>", String.valueOf(bl));
        charSequence = StringUtils.getReplacedString(charSequence, p_in_memory_on, String.valueOf(bl2));
        charSequence = StringUtils.getReplacedString(charSequence, p_compression, StringUtils.addSingleQuotes(string9));
        charSequence = StringUtils.getReplacedString(charSequence, p_priority, StringUtils.addSingleQuotes(string10));
        if (string2 != null) {
            charSequence = StringUtils.getReplacedString(charSequence, "<p_grouping_column>", "'" + string2 + "'");
            charSequence = StringUtils.getReplacedString(charSequence, "<p_grouping_column_type>", "'" + string3 + "'");
        } else {
            charSequence = StringUtils.getReplacedString(charSequence, "<p_grouping_column>", "NULL");
            charSequence = StringUtils.getReplacedString(charSequence, "<p_grouping_column_type>", "NULL");
        }
        stringBuilder2 = new StringBuilder((String)charSequence);
        stringBuilder2.append("\n");
        hashMap.put(HISTOGRAM_API, stringBuilder2);
        stringBuilder = new StringBuilder(_dropHistDataViewSQL);
        hashMap.put(TEMP_INPUT_VIEW_NAME, stringBuilder);
        return hashMap;
    }

    public static boolean isExtendedTypeEnabled(Context context) {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        boolean bl = false;
        try {
            bl = connectionFolder.isExtendedTypeEnabled();
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, exception.getMessage(), exception);
        }
        return bl;
    }

    public static boolean isExpandedObjNameEnabled(Context context) {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        boolean bl = false;
        try {
            bl = connectionFolder.isExpandedObjNameEnabled();
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, exception.getMessage(), exception);
        }
        return bl;
    }

    public static boolean isDBVersion12102andUp(Context context) {
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        if (version == null) {
            version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        }
        boolean bl = DbVersionHelper.isDB12102Up((Version)version);
        return bl;
    }

    public static boolean generateSQLInlineHint(Context context) {
        boolean bl = false;
        if (context != null) {
            Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
            if (version == null) {
                version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
            }
            bl = DbVersionHelper.isDB12102Up((Version)version);
        }
        return !bl;
    }
}

