/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.sql.Connection;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import oracle.aurora.server.tools.loadjava.DatabaseOptions;
import oracle.aurora.server.tools.loadjava.DropJava;
import oracle.aurora.server.tools.loadjava.LoadJava;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.ide.Context;

public class InstallJSONSchemaGen {
    static final Logger log = Logger.getLogger("InstallJSONSchemaGen");
    private Connection _conn;
    private String _contextUser;
    private Context _context;
    private BufferedOutputStream loggingBos;

    public static String[] getJarFiles() {
        String[] stringArray;
        String string = System.getProperty("oracle.home");
        String string2 = string + "/sqldeveloper/extensions/oracle.dmt.dataminer/lib";
        String string3 = string + "/modules";
        String[] stringArray2 = null;
        stringArray2 = stringArray = new String[]{string3 + "/org.glassfish.javax.json.jar", string2 + "/JSONSchemaGenerator.jar"};
        stringArray2 = InstallJSONSchemaGen.replaceSeperator(stringArray2);
        return stringArray2;
    }

    public static String[] getLegacyJarFiles() {
        String[] stringArray;
        String string = System.getProperty("oracle.home") + "/sqldeveloper/extensions/oracle.dmt.dataminer/lib";
        String[] stringArray2 = null;
        stringArray2 = stringArray = new String[]{string + "/javax.json.jar"};
        stringArray2 = InstallJSONSchemaGen.replaceSeperator(stringArray2);
        return stringArray2;
    }

    private static String[] replaceSeperator(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replace("/", File.separator);
            stringArray[i] = stringArray[i].replace("\\", File.separator);
        }
        return stringArray;
    }

    protected String getFileName(String string) {
        int n;
        int n2;
        int n3 = string.lastIndexOf("/");
        int n4 = n2 = n3 > (n = string.lastIndexOf("\\")) ? n3 : n;
        if (n2 > -1) {
            string = string.substring(n2 + 1);
        }
        return string;
    }

    public InstallJSONSchemaGen(Connection connection, Context context, BufferedOutputStream bufferedOutputStream) {
        this._conn = connection;
        this._contextUser = "PUBLIC";
        this._context = context;
        this.loggingBos = bufferedOutputStream;
    }

    public boolean doWork(String string) {
        if ("DeployJSONParser".equals(string)) {
            this.dropJava(this._conn);
            return this.loadJava(this._conn, this._contextUser, true);
        }
        if ("UndeployJSONParser".equals(string)) {
            return this.dropJava(this._conn);
        }
        if ("GrantJSONParser".equals(string)) {
            return this.loadJava(this._conn, this._contextUser, false);
        }
        if ("UpgradeJSONParser".equals(string)) {
            this.dropJava(this._conn);
            return this.loadJava(this._conn, this._contextUser, true);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadJava(Connection connection, String string, boolean bl) {
        try {
            String[] stringArray = this.getLoadJavaArguments(string, bl);
            String[] stringArray2 = InstallJSONSchemaGen.getJarFiles();
            int n = 1;
            for (String string2 : stringArray2) {
                File file = new File(string2);
                stringArray[4] = file.getAbsolutePath();
                ++n;
                LoadJava loadJava = new LoadJava();
                LoadJavaDatabaseOptions loadJavaDatabaseOptions = new LoadJavaDatabaseOptions();
                loadJava.setDatabase((DatabaseOptions)loadJavaDatabaseOptions);
                loadJava.setConnection(connection);
                loadJava.command(stringArray);
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Unexpected Failure: {0}", exception.getLocalizedMessage());
            ConfigUtils.writeToInstallLog(this.loggingBos, exception.getLocalizedMessage());
            boolean bl2 = false;
            return bl2;
        }
        return true;
    }

    protected String[] getLoadJavaArguments(String string, boolean bl) {
        String[] stringArray = null;
        stringArray = bl ? new String[]{"-schema", "ODMRSYS", "-thin", "-verbose", "filename", "-force", "-resolve", "-grant", string} : new String[]{"-schema", "ODMRSYS", "-thin", "-verbose", "filename", "-grant", string};
        return stringArray;
    }

    private boolean dropJava(Connection connection) {
        try {
            String[] stringArray;
            String[] stringArray2 = new String[]{"-schema", "ODMRSYS", "-thin", "filename"};
            String[] stringArray3 = InstallJSONSchemaGen.getJarFiles();
            String[] stringArray4 = InstallJSONSchemaGen.getLegacyJarFiles();
            for (String string : stringArray = (String[])Stream.concat(Arrays.stream(stringArray3), Arrays.stream(stringArray4)).toArray(String[]::new)) {
                File file = new File(string);
                if (!file.exists()) continue;
                stringArray2[3] = file.getAbsolutePath();
                DropJava dropJava = new DropJava();
                LoadJavaDatabaseOptions loadJavaDatabaseOptions = new LoadJavaDatabaseOptions();
                dropJava.setDatabase((DatabaseOptions)loadJavaDatabaseOptions);
                dropJava.setConnection(connection);
                dropJava.command(stringArray2);
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Unexpected Failure: {0}", exception.getLocalizedMessage());
            ConfigUtils.writeToInstallLog(this.loggingBos, exception.getLocalizedMessage());
        }
        return true;
    }

    public final class LoadJavaDatabaseOptions
    extends DatabaseOptions {
        public String getDriver() {
            return "thin";
        }
    }
}

