/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClipboardUtils
implements ClipboardOwner {
    private static final Logger theLogger = Logger.getLogger(ClipboardUtils.class.getName());
    private Object content;

    public ClipboardUtils(Object object) {
        this.content = object;
    }

    public void setContentToClipboard() {
        Transferable transferable = null;
        transferable = this.content instanceof Image ? new TransferableImage((Image)this.content) : new TransferableHTML(this.content.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(transferable, this);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        theLogger.log(Level.FINE, "Lost Clipboard Ownership");
    }

    private static class TransferableHTML
    implements Transferable {
        private String html;

        private TransferableHTML(String string) {
            this.html = string;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[3];
            try {
                dataFlavorArray[0] = new DataFlavor("text/html;class=java.lang.String");
                dataFlavorArray[1] = new DataFlavor("text/html;class=java.io.Reader");
                dataFlavorArray[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                theLogger.log(Level.SEVERE, classNotFoundException.getMessage(), classNotFoundException);
            }
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavor.equals(dataFlavorArray[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.html;
        }
    }

    private static class TransferableImage
    implements Transferable {
        private Image i;

        private TransferableImage(Image image) {
            assert (image != null) : "Image can't be null";
            this.i = image;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(DataFlavor.imageFlavor)) {
                return this.i;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavor.equals(dataFlavorArray[i])) continue;
                return true;
            }
            return false;
        }
    }
}

