/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.profit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataDisplay;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.Reloadable;
import oracle.dmt.dataminer.controls.renderers.ColorCellRenderer;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.TestResultsSelectorPanel;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.TestViewerPartitionToolbar;
import oracle.dmt.dataminer.tviewer.profit.ProfitData;
import oracle.dmt.dataminer.tviewer.profit.ProfitDetailPanel;
import oracle.dmt.dataminer.tviewer.profit.ProfitEditor;
import oracle.dmt.dataminer.tviewer.profit.ProfitInputPanel;
import oracle.dmt.dataminer.tviewer.profit.ProfitTabState;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class ProfitPanel
extends DataMinerViewGUI
implements GraphDataDisplay,
Reloadable {
    private GraphPanel _graphPanel;
    private ProfitTabState _state;
    private boolean _loading;
    private DataMinerTablePanel dataMinerTablePanel;
    private JPanel jGraphControl;
    private JPanel jGraphPanel;
    private JPanel jPanel;
    private JPanel jPanel1;
    private JSlider jQuantileSlider;
    private JButton jSettingsBtn;
    private JSplitPane jSplitPane;
    private JComboBox<String> jTargetComb;
    private JLabel jTargetLbl;
    private TestViewerPartitionToolbar partitionToolbar;
    private JButton jDetailBtn;
    private JButton jAddOrRemoveButton;

    public ProfitPanel(ProfitEditor profitEditor, Context context) {
        super(profitEditor, context);
        this._state = new ProfitTabState(profitEditor.getCachedLegendState());
        this.initComponents();
        this.initGraph();
        this.initRes();
        this.initUI();
    }

    private void initGraph() {
        this._graphPanel = new GraphPanel(this, new DefaultGraphDataModel(null, null, null, null, null));
        this.jGraphPanel.add((Component)new JTextArea(CommonLrb.get("LOADING")), "Center");
        this.jGraphPanel.updateUI();
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLbl, this.jTargetComb, (String)TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("TARGET_VALUE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jSettingsBtn, (String)TestViewerLrb.get("PROFIT_SETTINGS_BTN"));
        this.jSettingsBtn.getAccessibleContext().setAccessibleName(TestViewerLrb.get("PROFIT_SETTINGS_BTN"));
        this.jSettingsBtn.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("PROFIT_SETTINGS_BTN_ADA"));
    }

    private void initUI() {
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        dataMinerTable.addMouseListener(new TableMouseListener());
        this.dataMinerTablePanel.setTitle(CommonLrb.get("MODELS"));
        this.installProfitResultsActions();
        this.initializeControls();
        this.jSplitPane.setDividerLocation(0.75);
        this.jSplitPane.setResizeWeight(0.75);
    }

    private void initializeControls() {
        this.dataMinerTablePanel.getTable().setSelectionMode(0);
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{CommonLrb.get("LOADING")}));
        ListSelectionModel listSelectionModel = this.dataMinerTablePanel.getTable().getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProfitPanel.this.jResultTableValueChanged(listSelectionEvent);
            }
        });
        this.jSettingsBtn.addActionListener(new SettingsButtonActionListener());
        this.jTargetComb.addActionListener(new TargetComboActionListener());
        this.jQuantileSlider.addChangeListener(new QuantileSliderChangeListener());
    }

    @Override
    public void load() {
        LoadWorker loadWorker = new LoadWorker();
        loadWorker.execute();
    }

    @Override
    public void reload() {
        ProfitEditor profitEditor = (ProfitEditor)this.getEditor();
        this._state = new ProfitTabState(profitEditor.getCachedLegendState());
        this.setContext(profitEditor.getContext());
        this.load();
    }

    private void enableControls(boolean bl) {
        this.jTargetComb.setEnabled(bl);
        this.jSettingsBtn.setEnabled(bl);
        this.jDetailBtn.setEnabled(bl && this.dataMinerTablePanel.getTable().getSelectedRowCount() > 0);
    }

    public void jResultTableValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            String string = (String)this._state.getProfitTableModel().getValueAt(nArray[0], this._state.getRESULT_NAME());
            this._state.setSelectedTestResult(string);
            this.enableControls(true);
            this.fireViewPropertySelectionChange(this, string);
        }
    }

    public ProfitData getProfitData() {
        String string = this._state.getSelectedTestResult();
        if (string == null) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            if (nArray.length > 0 && -1 != nArray[0]) {
                string = (String)this._state.getProfitTableModel().getValueAt(nArray[0], this._state.getRESULT_NAME());
                this._state.setSelectedTestResult(string);
            }
            if (string == null) {
                return null;
            }
        }
        int n = this._state.getSelectedQuantileValue();
        ProfitData profitData = new ProfitData(this._state.getProfitData().get(string).get(n));
        profitData.setLabel(string);
        return profitData;
    }

    private void initComponents() {
        this.partitionToolbar = new TestViewerPartitionToolbar();
        this.jPanel1 = new JPanel();
        this.jTargetLbl = new JLabel();
        this.jTargetComb = new JComboBox();
        this.jSettingsBtn = new JButton();
        this.jSplitPane = new JSplitPane();
        this.jPanel = new JPanel();
        this.jGraphPanel = new JPanel();
        this.jGraphControl = new JPanel();
        this.jQuantileSlider = new JSlider();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.jPanel1.setLayout(new FlowLayout(0, 12, 0));
        this.jTargetLbl.setText("Target Value:");
        this.jPanel1.add(this.jTargetLbl);
        this.jTargetComb.setPreferredSize(new Dimension(170, 23));
        this.jPanel1.add(this.jTargetComb);
        this.jSettingsBtn.setText("Settings...");
        this.jPanel1.add(this.jSettingsBtn);
        this.jSplitPane.setDividerLocation(390);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jGraphPanel.setLayout(new BorderLayout());
        this.jGraphControl.setLayout(new GridBagLayout());
        this.jQuantileSlider.setName("jQuantileSlider");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        this.jGraphControl.add((Component)this.jQuantileSlider, gridBagConstraints);
        GroupLayout groupLayout = new GroupLayout(this.jPanel);
        this.jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jGraphControl, -1, 652, Short.MAX_VALUE).addComponent(this.jGraphPanel, -1, 652, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jGraphPanel, -1, 336, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jGraphControl, -2, -1, -2)));
        this.jSplitPane.setTopComponent(this.jPanel);
        this.jSplitPane.setRightComponent(this.dataMinerTablePanel);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane).addComponent(this.partitionToolbar, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.partitionToolbar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane, -1, 460, Short.MAX_VALUE).addContainerGap()));
    }

    private void installProfitResultsActions() {
        this.dataMinerTablePanel.removeSearchField();
        this.jDetailBtn = new JButton(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.setDisabledIcon(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.setToolTipText(TestViewerLrb.get("PROFIT_DETAIL_DIALOG"));
        this.jDetailBtn.addActionListener(new DetailButtonActionListener());
        if (this._state.getParentTestViewerState().getAllTestResults().size() > 1) {
            this.jAddOrRemoveButton = new JButton(OracleIcons.getIcon((String)"compare.png"));
            this.jAddOrRemoveButton.setDisabledIcon(OracleIcons.getIcon((String)"compare.png"));
            this.jAddOrRemoveButton.setToolTipText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE"));
            this.jAddOrRemoveButton.addActionListener(new AddRemoveButtonActionListener());
            this.dataMinerTablePanel.addControlBarComponents(this.jDetailBtn, this.jAddOrRemoveButton);
        } else {
            this.dataMinerTablePanel.addControlBarComponents(this.jDetailBtn);
        }
    }

    public void setSelectedPartition() {
        String string = this.partitionToolbar.getSelectedPartitionID();
        ProfitEditor profitEditor = (ProfitEditor)this.getEditor();
        profitEditor.getCachedLegendState().setSelectedPartition(string);
    }

    private void showDetail() {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        String string = (String)this._state.getProfitTableModel().getValueAt(nArray[0], this._state.getRESULT_NAME());
        ProfitDetailPanel profitDetailPanel = new ProfitDetailPanel(this.getContext(), string, this._state, this._state.getProfitData().get(string));
        profitDetailPanel.showAsDialog(this);
    }

    public Object getCachedPropertyState() {
        return this._state;
    }

    @Override
    public void showData(Object object) {
        this.showDetail();
    }

    private void setupGraphPanel() {
        this.jGraphPanel.removeAll();
        this.jGraphPanel.add((Component)this._graphPanel, "Center");
        this.jGraphPanel.updateUI();
    }

    private void setupTable() {
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        dataMinerTable.setFixedColumns(1, 165);
        dataMinerTable.setModel((TableModel)((Object)this._state.getProfitTableModel()));
        dataMinerTable.setColumnSelectorAvailable(true);
        dataMinerTable.setSorted(true);
        TableColumnModel tableColumnModel = dataMinerTable.getFullColumnModel();
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getModelViewerNumericRenderer();
        TableCellRenderer tableCellRenderer2 = FormatTableCellRenderer.getModelViewerPercentRenderer();
        ColorCellRenderer colorCellRenderer = new ColorCellRenderer(new ColorCellRenderer.ColorChooser(){

            @Override
            public Color getColorFor(Object object) {
                String string = (String)object;
                return ProfitPanel.this._state.getParentTestViewerState().getTestResultGraphColor(string);
            }
        });
        tableColumnModel.getColumn(this._state.getRESULT_NAME()).setCellRenderer(colorCellRenderer);
        tableColumnModel.getColumn(this._state.getPROFIT()).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(this._state.getROI()).setCellRenderer(tableCellRenderer2);
        tableColumnModel.getColumn(this._state.getPERCENTAGE_RECORDS_CUMULATIVE()).setCellRenderer(tableCellRenderer2);
        tableColumnModel.getColumn(this._state.getTARGET_DENSITY_CUMULATIVE()).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(this._state.getMAX_PROFIT()).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(this._state.getMAX_PROFIT_POPULATION()).setCellRenderer(tableCellRenderer2);
        dataMinerTable.autoSizeColumnsToFit();
    }

    private void updateSelectedModel() {
        String string = this._state.getSelectedTestResult();
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        int n = 0;
        if (string == null) {
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < dataMinerTable.getRowCount(); ++i) {
                d = (Double)this._state.getProfitTableModel().getValueAt(i, this._state.getMAX_PROFIT());
                if (!(d2 < d)) continue;
                d2 = d;
                n = i;
            }
        } else {
            for (int i = 0; i < dataMinerTable.getRowCount(); ++i) {
                Object object = this._state.getProfitTableModel().getValueAt(i, this._state.getRESULT_NAME());
                if (!string.equals(object)) continue;
                n = i;
                break;
            }
        }
        dataMinerTable.setRowSelectionInterval(n, n);
    }

    private class UpdateGraphWorker
    extends ODMrSwingWorker<Void, Void> {
        public UpdateGraphWorker() {
            super(ProfitPanel.this, ProfitPanel.this.overLayPanel, ProfitPanel.this.dataMinerTablePanel.getTable());
            ProfitPanel.this._loading = true;
        }

        @Override
        protected void beforeExecute() {
            ProfitPanel.this.enableControls(false);
            ProfitPanel.this.jGraphPanel.removeAll();
            ProfitPanel.this.jGraphPanel.add((Component)new JTextArea(CommonLrb.get("LOADING")), "Center");
        }

        @Override
        protected Void doInBackground() throws Exception {
            ProfitPanel.this._state.refreshProfitData(ProfitPanel.this.partitionToolbar.getCompareMode());
            ProfitPanel.this._graphPanel.initGraph(ProfitPanel.this._state.getProfitGraphModel());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            ProfitPanel.this.setupGraphPanel();
            ProfitPanel.this.setupTable();
            ProfitPanel.this.updateSelectedModel();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(ProfitPanel.this.getEditor().getContext(), throwable, TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            ProfitPanel.this.enableControls(true);
            ProfitPanel.this._loading = false;
        }
    }

    private class UpdateThresholdWorker
    extends ODMrSwingWorker<Void, Void> {
        public UpdateThresholdWorker() {
            super(ProfitPanel.this);
            ProfitPanel.this._loading = true;
        }

        @Override
        protected Void doInBackground() throws Exception {
            ProfitPanel.this._state.refreshCustomThresholdData();
            ProfitPanel.this._graphPanel.refreshGraph();
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            ProfitPanel.this.updateSelectedModel();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(ProfitPanel.this.getEditor().getContext(), throwable, TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            ProfitPanel.this._loading = false;
        }
    }

    private class UpdateModelsWorker
    extends ODMrSwingWorker<Void, Void> {
        private UpdateModelsWorker() {
            super(ProfitPanel.this, null, ProfitPanel.this.dataMinerTablePanel.getTable());
            ProfitPanel.this._loading = true;
        }

        @Override
        protected void beforeExecute() {
            ProfitPanel.this.jGraphPanel.removeAll();
            ProfitPanel.this.jGraphPanel.add((Component)new JTextArea(CommonLrb.get("LOADING")), "Center");
        }

        @Override
        protected Void doInBackground() throws Exception {
            ProfitPanel.this._state.load(ProfitPanel.this.partitionToolbar.getCompareMode());
            ProfitPanel.this._graphPanel.initGraph(ProfitPanel.this._state.getProfitGraphModel());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            ProfitPanel.this.setupGraphPanel();
            ProfitPanel.this.setupTable();
            ProfitPanel.this.updateSelectedModel();
            String[] stringArray = new String[ProfitPanel.this._state.getTargetValues().size()];
            ProfitPanel.this.jTargetComb.setModel(new DefaultComboBoxModel<String>(ProfitPanel.this._state.getTargetValues().toArray(stringArray)));
            ProfitPanel.this.jTargetComb.setSelectedItem(ProfitPanel.this._state.getSelectedTargetValue());
            Integer n = ProfitPanel.this._state.getSelectedQuantileValue();
            Integer n2 = 0;
            Integer n3 = ProfitPanel.this._state.getMaxQuantileCnt() - 1;
            ProfitPanel.this.jQuantileSlider.setMajorTickSpacing(10);
            ProfitPanel.this.jQuantileSlider.setMinorTickSpacing(1);
            ProfitPanel.this.jQuantileSlider.setPaintTicks(true);
            ProfitPanel.this.jQuantileSlider.setPaintLabels(true);
            ProfitPanel.this.jQuantileSlider.setSnapToTicks(true);
            ProfitPanel.this.jQuantileSlider.setModel(new DefaultBoundedRangeModel(n, 0, n2, n3));
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(ProfitPanel.this.getEditor().getContext(), throwable, TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            ProfitPanel.this.enableControls(true);
            ProfitPanel.this.getEditor().updateSelection();
            ProfitPanel.this._loading = false;
        }
    }

    private class LoadWorker
    extends ODMrSwingWorker<Void, Void> {
        private LoadWorker() {
            super(ProfitPanel.this, ProfitPanel.this.overLayPanel, ProfitPanel.this.dataMinerTablePanel.getTable());
            ProfitPanel.this._loading = true;
        }

        @Override
        protected void beforeExecute() {
            ProfitPanel.this.jGraphPanel.removeAll();
            ProfitPanel.this.jGraphPanel.add((Component)new JTextArea(CommonLrb.get("LOADING")), "Center");
        }

        @Override
        protected Void doInBackground() throws Exception {
            ProfitPanel.this.partitionToolbar.load(ProfitPanel.this.getEditor());
            ProfitPanel.this.setSelectedPartition();
            ProfitPanel.this._state.load(ProfitPanel.this.partitionToolbar.getCompareMode());
            ProfitPanel.this._graphPanel.initGraph(ProfitPanel.this._state.getProfitGraphModel());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            ProfitPanel.this.setupGraphPanel();
            ProfitPanel.this.setupTable();
            ProfitPanel.this.updateSelectedModel();
            String[] stringArray = new String[ProfitPanel.this._state.getTargetValues().size()];
            ProfitPanel.this.jTargetComb.setModel(new DefaultComboBoxModel<String>(ProfitPanel.this._state.getTargetValues().toArray(stringArray)));
            ProfitPanel.this.jTargetComb.setSelectedItem(ProfitPanel.this._state.getSelectedTargetValue());
            Integer n = ProfitPanel.this._state.getSelectedQuantileValue();
            Integer n2 = 0;
            Integer n3 = ProfitPanel.this._state.getMaxQuantileCnt() - 1;
            ProfitPanel.this.jQuantileSlider.setMajorTickSpacing(10);
            ProfitPanel.this.jQuantileSlider.setMinorTickSpacing(1);
            ProfitPanel.this.jQuantileSlider.setPaintTicks(true);
            ProfitPanel.this.jQuantileSlider.setPaintLabels(true);
            ProfitPanel.this.jQuantileSlider.setSnapToTicks(true);
            ProfitPanel.this.jQuantileSlider.setModel(new DefaultBoundedRangeModel(n, 0, n2, n3));
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(ProfitPanel.this.getEditor().getContext(), throwable, TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            ProfitPanel.this.enableControls(true);
            ProfitPanel.this.getEditor().updateSelection();
            ProfitPanel.this._loading = false;
        }
    }

    private class QuantileSliderChangeListener
    implements ChangeListener {
        private QuantileSliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (ProfitPanel.this._loading) {
                return;
            }
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (jSlider.getValueIsAdjusting()) {
                return;
            }
            BoundedRangeModel boundedRangeModel = ProfitPanel.this.jQuantileSlider.getModel();
            Integer n = boundedRangeModel.getValue();
            n = Math.max(1, n);
            ProfitPanel.this._state.setSelectedQuantileValue(n);
            UpdateThresholdWorker updateThresholdWorker = new UpdateThresholdWorker();
            updateThresholdWorker.execute();
        }
    }

    private class TargetComboActionListener
    implements ActionListener {
        private TargetComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ProfitPanel.this._loading) {
                return;
            }
            ProfitPanel.this._state.setSelectedTargetValue((String)ProfitPanel.this.jTargetComb.getSelectedItem());
            UpdateGraphWorker updateGraphWorker = new UpdateGraphWorker();
            updateGraphWorker.execute();
        }
    }

    private class SettingsButtonActionListener
    implements ActionListener {
        private SettingsButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProfitInputPanel profitInputPanel = new ProfitInputPanel(ProfitPanel.this.getContext(), ProfitPanel.this._state);
            if (profitInputPanel.showAsDialog(ProfitPanel.this)) {
                UpdateGraphWorker updateGraphWorker = new UpdateGraphWorker();
                updateGraphWorker.execute();
            }
        }
    }

    private class AddRemoveButtonActionListener
    implements ActionListener {
        private AddRemoveButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TestResultsSelectorPanel testResultsSelectorPanel = new TestResultsSelectorPanel(ProfitPanel.this.getEditor().getContext(), ProfitPanel.this._state.getParentTestViewerState());
            if (testResultsSelectorPanel.showAsDialog(ProfitPanel.this)) {
                List<TestResult> list = testResultsSelectorPanel.getSelectedTestResults();
                ProfitPanel.this._state.getParentTestViewerState().setTestResults(list);
                UpdateModelsWorker updateModelsWorker = new UpdateModelsWorker();
                updateModelsWorker.execute();
            }
        }
    }

    private class DetailButtonActionListener
    implements ActionListener {
        private DetailButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProfitPanel.this.showDetail();
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int[] nArray = ProfitPanel.this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
                String string = (String)ProfitPanel.this._state.getProfitTableModel().getValueAt(nArray[0], ProfitPanel.this._state.getRESULT_NAME());
                ProfitDetailPanel profitDetailPanel = new ProfitDetailPanel(ProfitPanel.this.getContext(), string, ProfitPanel.this._state, ProfitPanel.this._state.getProfitData().get(string));
                profitDetailPanel.showAsDialog(ProfitPanel.this);
            }
        }
    }
}

