/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.performance;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.Reloadable;
import oracle.dmt.dataminer.controls.renderers.ColorCellRenderer;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.repository.RegressTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.TestResultsSelectorPanel;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.TestViewerPartitionToolbar;
import oracle.dmt.dataminer.tviewer.performance.CPerformanceTabState;
import oracle.dmt.dataminer.tviewer.performance.MeasureItem;
import oracle.dmt.dataminer.tviewer.performance.PerformanceEditor;
import oracle.dmt.dataminer.tviewer.performance.PerformanceTableModel;
import oracle.dmt.dataminer.tviewer.performance.SortByItem;
import oracle.dmt.dataminer.tviewer.performance.SortOrderItem;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class PerformanceTabPanel
extends DataMinerViewGUI
implements Reloadable {
    private static final Logger theLogger = Logger.getLogger(PerformanceTabPanel.class.getName());
    private CPerformanceTabState _performanceTabState;
    private GraphPanel _graphPanel;
    private MeasureItem _selectedMeasureItem;
    private MeasureItem _predictionConfidenceMeasureItem;
    private MeasureItem _measureItem1;
    private MeasureItem _measureItem2;
    private MeasureItem _measureItem3;
    private MeasureItem _measureItem4;
    private MeasureItem _allMeasureItem;
    private SortByItem _selectedSortByItem;
    private SortOrderItem _selectedSortOrderItem;
    private boolean _showClassResults = true;
    private String[] _columnNames;
    private ColorCellRenderer.ColorChooser colorChooser;
    private JPanel bottomPanel;
    private DataMinerTablePanel dataMinerTablePanel;
    private JComboBox<MeasureItem> jCBMeasure;
    private JComboBox<SortOrderItem> jCBSortOrder;
    private JComboBox<SortByItem> jCB_SortBy;
    private JLabel jLB_Measure;
    private JLabel jLB_SortBy;
    private JPanel jPNL_Graph;
    private JSplitPane jSPLPane;
    private JScrollPane jScrollPane1;
    private TestViewerPartitionToolbar testViewerPartitionToolbar1;
    private JButton _jBT_AddOrRemove;

    public PerformanceTabPanel(PerformanceEditor performanceEditor, Context context) {
        super(performanceEditor, context);
        this._performanceTabState = new CPerformanceTabState(performanceEditor.getCachedLegendState());
        if (this._performanceTabState.getParentTestViewerState().getTestResults().get(0) instanceof RegressTestResult) {
            this._showClassResults = false;
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.testViewerPartitionToolbar1 = new TestViewerPartitionToolbar();
        this.bottomPanel = new JPanel();
        this.jLB_Measure = new JLabel();
        this.jCBMeasure = new JComboBox();
        this.jLB_SortBy = new JLabel();
        this.jCB_SortBy = new JComboBox();
        this.jCBSortOrder = new JComboBox();
        this.jSPLPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jPNL_Graph = new JPanel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.bottomPanel.setLayout(new FlowLayout(0, 12, 0));
        this.jLB_Measure.setLabelFor(this.jCBMeasure);
        this.jLB_Measure.setText("Measure:");
        this.bottomPanel.add(this.jLB_Measure);
        this.jCBMeasure.setPreferredSize(new Dimension(170, 23));
        this.bottomPanel.add(this.jCBMeasure);
        this.jLB_SortBy.setLabelFor(this.jCB_SortBy);
        this.jLB_SortBy.setText("Sort By:");
        this.bottomPanel.add(this.jLB_SortBy);
        this.jCB_SortBy.setMinimumSize(new Dimension(53, 20));
        this.jCB_SortBy.setPreferredSize(new Dimension(170, 23));
        this.bottomPanel.add(this.jCB_SortBy);
        this.jCBSortOrder.setMinimumSize(new Dimension(53, 20));
        this.jCBSortOrder.setPreferredSize(new Dimension(170, 23));
        this.bottomPanel.add(this.jCBSortOrder);
        this.jSPLPane.setDividerLocation(300);
        this.jSPLPane.setOrientation(0);
        this.jSPLPane.setOneTouchExpandable(true);
        this.jSPLPane.setPreferredSize(new Dimension(3, 4));
        this.jPNL_Graph.setMinimumSize(new Dimension(100, 100));
        this.jPNL_Graph.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.jPNL_Graph);
        this.jSPLPane.setTopComponent(this.jScrollPane1);
        this.jSPLPane.setRightComponent(this.dataMinerTablePanel);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bottomPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.testViewerPartitionToolbar1, GroupLayout.Alignment.TRAILING, -1, 703, Short.MAX_VALUE).addComponent(this.jSPLPane, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.testViewerPartitionToolbar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bottomPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSPLPane, -1, 434, Short.MAX_VALUE).addContainerGap()));
    }

    private boolean isEnabledPartitioning() {
        PerformanceEditor performanceEditor = (PerformanceEditor)this.getEditor();
        return performanceEditor.getCachedLegendState().isEnabledPartitioning();
    }

    public void setSelectedPartition() {
        String string = this.testViewerPartitionToolbar1.getSelectedPartitionID();
        PerformanceEditor performanceEditor = (PerformanceEditor)this.getEditor();
        performanceEditor.getCachedLegendState().setSelectedPartition(string);
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLB_Measure, this.jCBMeasure, (String)(CommonLrb.get("MEASURE") + ":"));
        this.jCBMeasure.removeAllItems();
        this._predictionConfidenceMeasureItem = new MeasureItem(CPerformanceTabState.Measure.PREDICTIVE_CONFIDENCE, TestViewerLrb.get("PREDICTIVE_CONFIDENCE"));
        if (this._showClassResults) {
            this._measureItem1 = new MeasureItem(CPerformanceTabState.Measure.AVG_ACCURACY, TestViewerLrb.get("AVG_ACCURACY"));
            this._measureItem2 = new MeasureItem(CPerformanceTabState.Measure.OVERALL_ACCURACY, TestViewerLrb.get("OVERALL_ACCURACY"));
            this._measureItem3 = new MeasureItem(CPerformanceTabState.Measure.COST, TestViewerLrb.get("COST"));
            this._columnNames = this.isEnabledPartitioning() ? new String[]{CommonLrb.get("NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"), TestViewerLrb.get("OVERALL_ACCURACY_COL"), TestViewerLrb.get("AVG_ACCURACY_COL"), TestViewerLrb.get("COST"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("BUILD_ROWS"), TestViewerLrb.get("TEST_ROWS"), TestViewerLrb.get("CREATION_DATE")} : new String[]{CommonLrb.get("NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"), TestViewerLrb.get("OVERALL_ACCURACY_COL"), TestViewerLrb.get("AVG_ACCURACY_COL"), TestViewerLrb.get("COST"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE")};
        } else {
            this._measureItem1 = new MeasureItem(CPerformanceTabState.Measure.MEAN_ABS_ERR, TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"));
            this._measureItem2 = new MeasureItem(CPerformanceTabState.Measure.ROOT_MEAN_SQRT_ERR, TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"));
            this._measureItem3 = new MeasureItem(CPerformanceTabState.Measure.MEAN_PREDICTED_VALUE, TestViewerLrb.get("MEAN_PREDICTED_VALUE"));
            this._measureItem4 = new MeasureItem(CPerformanceTabState.Measure.MEAN_ACTUAL_VALUE, TestViewerLrb.get("MEAN_ACTUAL_VALUE"));
            this._columnNames = this.isEnabledPartitioning() ? new String[]{CommonLrb.get("NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"), TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"), TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"), TestViewerLrb.get("MEAN_PREDICTED_VALUE"), TestViewerLrb.get("MEAN_ACTUAL_VALUE"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("BUILD_ROWS"), TestViewerLrb.get("TEST_ROWS"), TestViewerLrb.get("CREATION_DATE")} : new String[]{CommonLrb.get("NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"), TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"), TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"), TestViewerLrb.get("MEAN_PREDICTED_VALUE"), TestViewerLrb.get("MEAN_ACTUAL_VALUE"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE")};
        }
        this._allMeasureItem = new MeasureItem(CPerformanceTabState.Measure.MULTIPLE_SELECTION, TestViewerLrb.get("MULTIPLE_SELECTION"));
        this.jCBMeasure.addItem(this._predictionConfidenceMeasureItem);
        this.jCBMeasure.addItem(this._measureItem1);
        this.jCBMeasure.addItem(this._measureItem2);
        this.jCBMeasure.addItem(this._measureItem3);
        if (!this._showClassResults) {
            this.jCBMeasure.addItem(this._measureItem4);
        }
        this.jCBMeasure.addItem(this._allMeasureItem);
        this._selectedMeasureItem = this._allMeasureItem;
        ResourceUtils.resLabel((JLabel)this.jLB_SortBy, this.jCB_SortBy, (String)(CommonLrb.get("SORT_BY") + ":"));
        this._selectedSortByItem = new SortByItem(CPerformanceTabState.SortBy.NAME, CommonLrb.get("NAME"));
        this.jCB_SortBy.removeAllItems();
        this.jCB_SortBy.addItem(this._selectedSortByItem);
        this.jCB_SortBy.addItem(new SortByItem(CPerformanceTabState.SortBy.CREATION_TIME, TestViewerLrb.get("CREATION_DATE")));
        this.jCB_SortBy.addItem(new SortByItem(CPerformanceTabState.SortBy.MEASURE, CommonLrb.get("MEASURE")));
        this._selectedSortOrderItem = new SortOrderItem(SortDirection.DESCENDING);
        this.jCBSortOrder.removeAllItems();
        this.jCBSortOrder.addItem(new SortOrderItem(SortDirection.ASCENDING));
        this.jCBSortOrder.addItem(this._selectedSortOrderItem);
    }

    public void initUI() {
        this.setLoading(true);
        this.jCBMeasure.setSelectedItem(this._selectedMeasureItem);
        this.jCB_SortBy.setSelectedItem(this._selectedSortByItem);
        this.jCBSortOrder.setSelectedItem(this._selectedSortOrderItem);
        this.jCBMeasure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PerformanceTabPanel.this._selectedMeasureItem = (MeasureItem)PerformanceTabPanel.this.jCBMeasure.getSelectedItem();
                PerformanceTabPanel.this.reloadGraphPanel();
            }
        });
        this.jCB_SortBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PerformanceTabPanel.this._selectedSortByItem = (SortByItem)PerformanceTabPanel.this.jCB_SortBy.getSelectedItem();
                PerformanceTabPanel.this.reloadGraphPanel();
            }
        });
        this.jCBSortOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PerformanceTabPanel.this._selectedSortOrderItem = (SortOrderItem)PerformanceTabPanel.this.jCBSortOrder.getSelectedItem();
                PerformanceTabPanel.this.reloadGraphPanel();
            }
        });
        this.dataMinerTablePanel.setTitle(CommonLrb.get("MODELS"));
        this.installPerfSummaryActions();
        this.jSPLPane.setDividerLocation(0.85);
        this.jSPLPane.setResizeWeight(0.85);
        this.colorChooser = new ColorCellRenderer.ColorChooser(){

            @Override
            public Color getColorFor(Object object) {
                String string = (String)object;
                return PerformanceTabPanel.this._performanceTabState.getParentTestViewerState().getTestResultGraphColor(string);
            }
        };
        this.jPNL_Graph.add(GraphPanel.LOADING_GRAPH);
    }

    @Override
    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void installPerfSummaryActions() {
        this.dataMinerTablePanel.removeSearchField();
        if (this._performanceTabState.getParentTestViewerState().getAllTestResults().size() > 1) {
            this._jBT_AddOrRemove = new JButton(OracleIcons.getIcon((String)"compare.png"));
            this._jBT_AddOrRemove.setDisabledIcon(OracleIcons.getIcon((String)"compare.png"));
            this._jBT_AddOrRemove.setToolTipText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE"));
            this._jBT_AddOrRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PerformanceTabPanel.this._jBT_Compare_AddOrRemove_actionPerformed(actionEvent);
                }
            });
            this.dataMinerTablePanel.addControlBarComponents(this._jBT_AddOrRemove);
        }
    }

    private void _jBT_Compare_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
        TestResultsSelectorPanel testResultsSelectorPanel = new TestResultsSelectorPanel(this.getContext(), this._performanceTabState.getParentTestViewerState());
        if (testResultsSelectorPanel.showAsDialog(this)) {
            List<TestResult> list = testResultsSelectorPanel.getSelectedTestResults();
            this._performanceTabState.getParentTestViewerState().setTestResults(list);
            this.load();
        }
    }

    @Override
    public void reload() {
        PerformanceEditor performanceEditor = (PerformanceEditor)this.getEditor();
        this._performanceTabState = new CPerformanceTabState(performanceEditor.getCachedLegendState());
        this.setContext(performanceEditor.getContext());
        if (this._performanceTabState != null && this._performanceTabState.getParentTestViewerState().getTestResults().size() > 0 && this._performanceTabState.getParentTestViewerState().getTestResults().get(0) instanceof RegressTestResult) {
            this._showClassResults = false;
        }
        this.load();
    }

    private void reloadGraphPanel() {
        PerformanceTableModel performanceTableModel = new PerformanceTableModel(this._columnNames, this._performanceTabState.getParentTestViewerState().getPerformanceMetrics());
        this.dataMinerTablePanel.getTable().setFixedColumns(1, 165);
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)performanceTableModel));
        this.dataMinerTablePanel.getTable().setSorted(true);
        this.setTableRenderers();
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(145);
        tableColumnModel.getColumn(1).setPreferredWidth(135);
        tableColumnModel.getColumn(2).setPreferredWidth(145);
        tableColumnModel.getColumn(3).setPreferredWidth(135);
        tableColumnModel.getColumn(4).setPreferredWidth(135);
        tableColumnModel.getColumn(5).setPreferredWidth(135);
        if (tableColumnModel.getColumnCount() > 6) {
            tableColumnModel.getColumn(6).setPreferredWidth(135);
        }
        this.dataMinerTablePanel.getTable().setSelectionMode(0);
        this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
        if (!this._performanceTabState.hasCost()) {
            this.jCBMeasure.removeItem(this._measureItem3);
        }
        if (CPerformanceTabState.Measure.MULTIPLE_SELECTION.equals((Object)this._selectedMeasureItem.getMeasure())) {
            if (!this._performanceTabState.hasCost()) {
                this.dataMinerTablePanel.getTable().setHiddenColumns(new int[]{4});
            } else {
                this.dataMinerTablePanel.getTable().setHiddenColumns(new int[0]);
            }
            CPerformanceTabState.Measure[] measureArray = null;
            String[] stringArray = null;
            if (!this._performanceTabState.hasCost()) {
                measureArray = new CPerformanceTabState.Measure[]{this._predictionConfidenceMeasureItem.getMeasure(), this._measureItem1.getMeasure(), this._measureItem2.getMeasure()};
                stringArray = new String[]{this._predictionConfidenceMeasureItem.getDisplayName(), this._measureItem1.getDisplayName(), this._measureItem2.getDisplayName()};
            } else if (!this._showClassResults) {
                measureArray = new CPerformanceTabState.Measure[]{this._predictionConfidenceMeasureItem.getMeasure(), this._measureItem1.getMeasure(), this._measureItem2.getMeasure(), this._measureItem3.getMeasure(), this._measureItem4.getMeasure()};
                stringArray = new String[]{this._predictionConfidenceMeasureItem.getDisplayName(), this._measureItem1.getDisplayName(), this._measureItem2.getDisplayName(), this._measureItem3.getDisplayName(), this._measureItem4.getDisplayName()};
            } else {
                measureArray = new CPerformanceTabState.Measure[]{this._predictionConfidenceMeasureItem.getMeasure(), this._measureItem1.getMeasure(), this._measureItem2.getMeasure(), this._measureItem3.getMeasure()};
                stringArray = new String[]{this._predictionConfidenceMeasureItem.getDisplayName(), this._measureItem1.getDisplayName(), this._measureItem2.getDisplayName(), this._measureItem3.getDisplayName()};
            }
            GraphPanel[] graphPanelArray = new GraphPanel[measureArray.length];
            GraphDataModel[] graphDataModelArray = new GraphDataModel[measureArray.length];
            this.jPNL_Graph.removeAll();
            this.jPNL_Graph.setLayout(new GridLayout(3, 2));
            for (int i = 0; i < measureArray.length; ++i) {
                graphDataModelArray[i] = this._performanceTabState.sortedGraphDataModel(measureArray[i], this._selectedSortByItem.getSortBy(), this._selectedSortOrderItem.getSortOrder(), new Object[]{stringArray[i]});
                graphPanelArray[i] = new GraphPanel(graphDataModelArray[i]);
                graphPanelArray[i].initGraph();
                this.jPNL_Graph.add(graphPanelArray[i]);
            }
            this.jPNL_Graph.updateUI();
        } else {
            GraphDataModel graphDataModel;
            if (!(this.jPNL_Graph.getLayout() instanceof BorderLayout)) {
                this.jPNL_Graph.removeAll();
                this.jPNL_Graph.setLayout(new BorderLayout());
                if (this._graphPanel == null) {
                    graphDataModel = this._performanceTabState.sortedGraphDataModel(this._selectedMeasureItem.getMeasure(), this._selectedSortByItem.getSortBy(), this._selectedSortOrderItem.getSortOrder(), new Object[]{this._selectedMeasureItem.getDisplayName()});
                    this._graphPanel = new GraphPanel(graphDataModel);
                    this._graphPanel.initGraph();
                }
                this.jPNL_Graph.add((Component)this._graphPanel, "Center");
            }
            graphDataModel = this._performanceTabState.sortedGraphDataModel(this._selectedMeasureItem.getMeasure(), this._selectedSortByItem.getSortBy(), this._selectedSortOrderItem.getSortOrder(), new Object[]{this._selectedMeasureItem.getDisplayName()});
            this.columnHiding(this._selectedMeasureItem);
            this._graphPanel.initGraph(graphDataModel);
            this.jPNL_Graph.updateUI();
        }
    }

    private void columnHiding(MeasureItem measureItem) {
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getColumnModel();
        try {
            if (CPerformanceTabState.Measure.PREDICTIVE_CONFIDENCE.equals((Object)measureItem.getMeasure())) {
                int n = tableColumnModel.getColumnIndex(TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"));
                this.hideColumns(n);
            } else if (CPerformanceTabState.Measure.OVERALL_ACCURACY.equals((Object)measureItem.getMeasure())) {
                int n = tableColumnModel.getColumnIndex(TestViewerLrb.get("OVERALL_ACCURACY_COL"));
                this.hideColumns(n);
            } else if (CPerformanceTabState.Measure.MEAN_ABS_ERR.equals((Object)measureItem.getMeasure())) {
                int n = tableColumnModel.getColumnIndex(TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"));
                this.hideColumns(n);
            } else if (CPerformanceTabState.Measure.AVG_ACCURACY.equals((Object)measureItem.getMeasure())) {
                int n = tableColumnModel.getColumnIndex(TestViewerLrb.get("AVG_ACCURACY_COL"));
                this.hideColumns(n);
            } else if (CPerformanceTabState.Measure.ROOT_MEAN_SQRT_ERR.equals((Object)measureItem.getMeasure())) {
                int n = tableColumnModel.getColumnIndex(TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"));
                this.hideColumns(n);
            } else if (CPerformanceTabState.Measure.COST.equals((Object)measureItem.getMeasure())) {
                int n = tableColumnModel.getColumnIndex(TestViewerLrb.get("COST"));
                this.hideColumns(n);
            } else if (CPerformanceTabState.Measure.MEAN_PREDICTED_VALUE.equals((Object)measureItem.getMeasure())) {
                int n = tableColumnModel.getColumnIndex(TestViewerLrb.get("MEAN_PREDICTED_VALUE"));
                this.hideColumns(n);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            theLogger.log(Level.SEVERE, illegalArgumentException.getLocalizedMessage());
        }
    }

    private void hideColumns(int n) {
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        int n2 = ((JTable)((Object)dataMinerTable)).getColumnModel().getColumnIndex(TestViewerLrb.get("ALGORITHM"));
        int n3 = ((JTable)((Object)dataMinerTable)).getColumnModel().getColumnIndex(TestViewerLrb.get("CREATION_DATE"));
        int[] nArray = new int[((JTable)((Object)dataMinerTable)).getColumnCount() - 3];
        int n4 = 0;
        for (int i = 0; i < ((JTable)((Object)dataMinerTable)).getColumnCount(); ++i) {
            if (i == n || i == n2 || i == n3) continue;
            nArray[n4++] = i + 1;
        }
        this.dataMinerTablePanel.getTable().setHiddenColumns(nArray);
    }

    private void setTableRenderers() {
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getFullColumnModel();
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getIntegerRenderer();
        TableCellRenderer tableCellRenderer2 = FormatTableCellRenderer.getModelViewerNumericRenderer();
        TableCellRenderer tableCellRenderer3 = FormatTableCellRenderer.getModelViewerPercentRenderer();
        TableCellRenderer tableCellRenderer4 = FormatTableCellRenderer.getDateRenderer();
        for (String string : this._columnNames) {
            int n = tableColumnModel.getColumnIndex(string);
            if (string.equals(CommonLrb.get("NAME"))) {
                ColorCellRenderer colorCellRenderer = new ColorCellRenderer(this.colorChooser);
                tableColumnModel.getColumn(n).setCellRenderer(colorCellRenderer);
                continue;
            }
            if (string.equals(TestViewerLrb.get("CREATION_DATE"))) {
                tableColumnModel.getColumn(n).setCellRenderer(tableCellRenderer4);
                continue;
            }
            if (string.equals(TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"))) {
                tableColumnModel.getColumn(n).setCellRenderer(tableCellRenderer3);
                continue;
            }
            if (string.equals(TestViewerLrb.get("OVERALL_ACCURACY_COL"))) {
                tableColumnModel.getColumn(n).setCellRenderer(tableCellRenderer3);
                continue;
            }
            if (string.equals(TestViewerLrb.get("AVG_ACCURACY_COL"))) {
                tableColumnModel.getColumn(n).setCellRenderer(tableCellRenderer3);
                continue;
            }
            if (string.equals(TestViewerLrb.get("COST"))) {
                tableColumnModel.getColumn(n).setCellRenderer(tableCellRenderer2);
                continue;
            }
            if (string.equals(TestViewerLrb.get("MEAN_PREDICTED_VALUE"))) {
                tableColumnModel.getColumn(n).setCellRenderer(tableCellRenderer2);
                continue;
            }
            if (string.equals(TestViewerLrb.get("MEAN_ACTUAL_VALUE"))) {
                tableColumnModel.getColumn(n).setCellRenderer(tableCellRenderer2);
                continue;
            }
            if (string.equals(TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"))) {
                tableColumnModel.getColumn(n).setCellRenderer(tableCellRenderer2);
                continue;
            }
            if (string.equals(TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"))) {
                tableColumnModel.getColumn(n).setCellRenderer(tableCellRenderer2);
                continue;
            }
            if (string.equals(TestViewerLrb.get("BUILD_ROWS"))) {
                tableColumnModel.getColumn(n).setCellRenderer(tableCellRenderer);
                continue;
            }
            if (!string.equals(TestViewerLrb.get("TEST_ROWS"))) continue;
            tableColumnModel.getColumn(n).setCellRenderer(tableCellRenderer);
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        public LoadUI() {
            super(PerformanceTabPanel.this, PerformanceTabPanel.this.overLayPanel);
        }

        @Override
        protected Void doInBackground() throws Exception {
            PerformanceTabPanel.this.testViewerPartitionToolbar1.load(PerformanceTabPanel.this.getEditor());
            PerformanceTabPanel.this.setSelectedPartition();
            PerformanceTabPanel.this._performanceTabState.load(PerformanceTabPanel.this._columnNames, PerformanceTabPanel.this.testViewerPartitionToolbar1.getCompareMode());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            PerformanceTabPanel.this.reloadGraphPanel();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(PerformanceTabPanel.this.getEditor().getContext(), throwable, TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            PerformanceTabPanel.this.setLoading(false);
        }
    }
}

