/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.text.MessageFormat;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.teditor.data.DataViewerState;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.GraphPreferences;
import oracle.dmt.dataminer.teditor.graph.GraphQueryBuilder;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphType;
import oracle.ide.Context;

class XYGraphQueryBuilder
extends GraphQueryBuilder {
    public static GraphQueryBuilder getQueryGraphBuilder(Context context, String string, GraphSettingsType graphSettingsType) throws Exception {
        return GraphQueryBuilder.getQueryGraphBuilder(XYGraphQueryBuilder.class, context, string, graphSettingsType, GraphPreferences.getInstance());
    }

    @Override
    public String buildGraphQuery() throws Exception {
        Object object3;
        Object[] objectArray;
        Object object2;
        StringBuilder stringBuilder = null;
        if (this.isGroupByEnabled && !this.isSingleSeries) {
            object2 = GraphUtils.getCategoricalBinValues(this.gbinningSettings);
            if (this.isGroupByEnabled && !object2.isEmpty()) {
                stringBuilder = new StringBuilder(" , case ");
                objectArray = object2.iterator();
                while (objectArray.hasNext()) {
                    object3 = (String)objectArray.next();
                    stringBuilder.append(" when ");
                    stringBuilder.append(this.gAttributeName);
                    stringBuilder.append(" = '");
                    stringBuilder.append((String)object3);
                    stringBuilder.append("' then '");
                    stringBuilder.append((String)object3);
                    stringBuilder.append("'");
                }
                stringBuilder.append(" else 'Other' end as ");
                stringBuilder.append(this.gAttributeName);
            } else {
                stringBuilder = new StringBuilder(" , ");
                stringBuilder.append(this.fqGAttributeName);
            }
        }
        object2 = new StringBuilder();
        for (Object object3 : this.yattributes) {
            String string = StringUtils.createFullyQualifiedName(this.fqCacheTableName, StringUtils.addDoubleQuotes(StringUtils.processQuotedName(object3.getName())));
            ((StringBuilder)object2).append(" , ");
            ((StringBuilder)object2).append(string);
        }
        this.query = "select <parallelHit> <xattr> <yattr> <groupby> from <table> order by <orderby>";
        this.query = StringUtils.getReplacedString(this.query, "<parallelHit>", DataViewerState.getParallelHint());
        this.query = StringUtils.getReplacedString(this.query, "<xattr>", this.fqXAttributeName);
        this.query = StringUtils.getReplacedString(this.query, "<yattr>", ((StringBuilder)object2).toString());
        this.query = StringUtils.getReplacedString(this.query, "<groupby>", this.isGroupByEnabled ? stringBuilder.toString() : "");
        this.query = StringUtils.getReplacedString(this.query, "<table>", this.fqCacheTableName);
        this.query = StringUtils.getReplacedString(this.query, "<orderby>", this.fqXAttributeName);
        this.columnTitles.add(this.xAttributeName);
        if (this.yattributes.size() == 1) {
            if (this.isGroupByEnabled) {
                this.columnTitles.add(this.gAttributeName);
            } else {
                this.columnTitles.add(GraphLrb.get("GRAPH_DATA_SERIES"));
            }
            this.columnTitles.add(((AttributeType)this.yattributes.get(0)).getName());
        } else {
            this.columnTitles.add(GraphLrb.get("GRAPH_DATA_YATR"));
            if (this.graphType == GraphType.SCATTER) {
                objectArray = new Object[]{this.xAttributeName};
                object3 = MessageFormat.format(GraphLrb.get("GRAPH_DATA_SCATTER_VAL"), objectArray);
                this.columnTitles.add(object3);
            } else {
                this.columnTitles.add(GraphLrb.get("GRAPH_DATA_YVAL"));
            }
        }
        return this.query;
    }
}

