/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.teditor.graph.BinClausesInfo;
import oracle.dmt.dataminer.teditor.graph.GraphLoader;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.GraphPreferences;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BinningSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.BinningType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphType;
import oracle.ide.Context;
import oracle.javatools.util.Pair;

abstract class GraphQueryBuilder {
    protected Context context;
    protected String query;
    protected boolean showGroupByNulls;
    protected boolean showXNulls;
    protected boolean isGroupByEnabled;
    protected boolean isMultiSeries;
    protected boolean isSingleSeries;
    protected GraphType graphType;
    protected List<AttributeType> binningAttributes = new ArrayList<AttributeType>();
    protected List<BinningSettingsType> attributeBinningSettings = new ArrayList<BinningSettingsType>();
    protected String allBinsClause = "";
    protected BinningSettingsType xBinningSettings;
    protected List<String> catBinValues;
    protected AttributeType xattribute;
    protected String xAttributeName;
    protected String yAttributeName;
    protected String yAxisLabel;
    protected AttributeType yattribute;
    protected String aggfnc;
    protected List<AttributeType> yattributes;
    protected BinningSettingsType gbinningSettings;
    protected List<String> gcatBinValues;
    protected String gAttributeName;
    protected AttributeType gattribute;
    protected String groupingClause = "";
    protected String emptyGBinClause = "";
    protected String fqCacheTableName;
    protected String fqGAttributeName;
    protected String qGAttributeName;
    protected String fqXAttributeName;
    protected String qXAttributeName;
    protected String qYAttributeName;
    protected List<String> columnTitles = new ArrayList<String>();

    public abstract String buildGraphQuery() throws Exception;

    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public String getYAttributeName() {
        return this.yAttributeName;
    }

    public List<String> getColumnTitles() {
        return this.columnTitles;
    }

    protected static GraphQueryBuilder getQueryGraphBuilder(Class<?> clazz, Context context, String string, GraphSettingsType graphSettingsType, GraphPreferences graphPreferences) throws Exception {
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        if (!(obj instanceof GraphQueryBuilder)) {
            throw new RuntimeException("Unexpected Graph Query Builder type");
        }
        if (graphSettingsType.getXAttribute().getStatus().equals((Object)AttributeStatus.INVALID)) {
            throw new GraphLoader.InvalidAttributeException(GraphLrb.get("INVALID_INPUTS_PRESENT"));
        }
        for (AttributeType attributeType : graphSettingsType.getYAttributes().getYAttribute()) {
            if (!attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
            throw new GraphLoader.InvalidAttributeException(GraphLrb.get("INVALID_INPUTS_PRESENT"));
        }
        if (graphSettingsType.getGroupByOption().isGroupByEnabled() && graphSettingsType.getGroupByOption().getGroupByAttribute().getStatus().equals((Object)AttributeStatus.INVALID)) {
            throw new GraphLoader.InvalidAttributeException(GraphLrb.get("INVALID_INPUTS_PRESENT"));
        }
        GraphQueryBuilder graphQueryBuilder = (GraphQueryBuilder)obj;
        graphQueryBuilder.graphType = graphSettingsType.getType();
        graphQueryBuilder.context = context;
        graphQueryBuilder.showGroupByNulls = graphPreferences.isShowGroupByNullsBin();
        graphQueryBuilder.showXNulls = graphPreferences.isShowGroupByNullsBin();
        graphQueryBuilder.xBinningSettings = graphSettingsType.getXBinningSettings();
        graphQueryBuilder.catBinValues = GraphUtils.getCategoricalBinValues(graphQueryBuilder.xBinningSettings);
        graphQueryBuilder.xattribute = graphSettingsType.getXAttribute();
        graphQueryBuilder.xAttributeName = graphQueryBuilder.xattribute.getName();
        graphQueryBuilder.yattributes = graphSettingsType.getYAttributes().getYAttribute();
        graphQueryBuilder.yattribute = graphQueryBuilder.yattributes.size() == 0 ? null : (AttributeType)graphSettingsType.getYAttributes().getYAttribute().get(0);
        graphQueryBuilder.aggfnc = GraphUtils.getSQLAggregationFunctionClause(graphSettingsType.getYAttributes().getAggregationFunction());
        graphQueryBuilder.isGroupByEnabled = graphSettingsType.getGroupByOption().isGroupByEnabled();
        graphQueryBuilder.gbinningSettings = graphSettingsType.getGroupByOption().getBinningSettings();
        graphQueryBuilder.gcatBinValues = GraphUtils.getCategoricalBinValues(graphQueryBuilder.gbinningSettings);
        graphQueryBuilder.gAttributeName = graphSettingsType.getGroupByOption().isGroupByEnabled() ? graphSettingsType.getGroupByOption().getGroupByAttribute().getName() : "";
        graphQueryBuilder.gattribute = graphSettingsType.getGroupByOption().getGroupByAttribute();
        graphQueryBuilder.isSingleSeries = GraphUtils.isSingleSeriesGraph(graphSettingsType.getType());
        boolean bl = graphQueryBuilder.isMultiSeries = graphSettingsType.getYAttributes().getYAttribute().size() > 1;
        if (!graphQueryBuilder.xBinningSettings.getBinningKind().equals((Object)BinningType.NONE)) {
            graphQueryBuilder.binningAttributes.add(graphQueryBuilder.xattribute);
            graphQueryBuilder.attributeBinningSettings.add(graphQueryBuilder.xBinningSettings);
        }
        if (graphSettingsType.getGroupByOption().isGroupByEnabled() && !graphQueryBuilder.gbinningSettings.getBinningKind().equals((Object)BinningType.NONE)) {
            graphQueryBuilder.binningAttributes.add(graphQueryBuilder.gattribute);
            graphQueryBuilder.attributeBinningSettings.add(graphQueryBuilder.gbinningSettings);
        }
        graphQueryBuilder.fqCacheTableName = "";
        graphQueryBuilder.fqGAttributeName = "";
        graphQueryBuilder.qGAttributeName = "";
        graphQueryBuilder.fqXAttributeName = "";
        graphQueryBuilder.qXAttributeName = "";
        graphQueryBuilder.qYAttributeName = "";
        graphQueryBuilder.fqCacheTableName = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(string));
        if (graphQueryBuilder.isGroupByEnabled) {
            graphQueryBuilder.fqGAttributeName = StringUtils.createFullyQualifiedName(graphQueryBuilder.fqCacheTableName, StringUtils.addDoubleQuotes(StringUtils.processQuotedName(graphQueryBuilder.gAttributeName)));
            graphQueryBuilder.qGAttributeName = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(graphQueryBuilder.gAttributeName));
        }
        graphQueryBuilder.fqXAttributeName = StringUtils.createFullyQualifiedName(graphQueryBuilder.fqCacheTableName, StringUtils.addDoubleQuotes(StringUtils.processQuotedName(graphQueryBuilder.xAttributeName)));
        graphQueryBuilder.qXAttributeName = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(graphQueryBuilder.xAttributeName));
        if (graphQueryBuilder.yattribute != null) {
            graphQueryBuilder.qYAttributeName = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(graphQueryBuilder.yattribute.getName()));
        }
        return graphQueryBuilder;
    }

    protected BinClausesInfo getNumBinClauses(List<NameValuePair> list, String string, AttributeType attributeType, String string2, boolean bl, boolean bl2) {
        String string3 = bl ? " case " : "";
        String string4 = attributeType.getName();
        String string5 = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(string4));
        String string6 = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(string));
        String string7 = " case ";
        String string8 = ", EMPTY_BINS as (";
        String string9 = "  <gcomma>\n<gattr> ";
        int n = 1;
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        } else {
            string2 = "'" + string2 + "'";
            string9 = "<gcomma>\nNVL(BINNED_DATA.<gattr>, EMPTY_BINS.<gattr>) <gattr>";
        }
        boolean bl3 = false;
        boolean bl4 = false;
        NameValuePair nameValuePair = list.get(0);
        String string10 = (String)nameValuePair.getValue();
        if ("eqw".equals(string10)) {
            bl3 = false;
        } else if ("lowcard".equals(string10)) {
            bl3 = true;
        } else if (DatabaseMetadataUtils.isDateType(attributeType.getDataType())) {
            bl4 = true;
        } else {
            throw new RuntimeException("Binning qualifier paramter is missing");
        }
        if (!bl4) {
            list.remove(0);
        }
        for (int i = 0; i < list.size(); ++i) {
            String string11 = (String)list.get(i).getValue();
            String string12 = bl4 ? GraphUtils.getDateConversionClause(attributeType.getDataType(), string11) : string11;
            String string13 = null;
            String string14 = null;
            if (!bl3) {
                if (i == 0) {
                    string13 = " '<uppername>'";
                    string13 = StringUtils.getReplacedString(string13, "<uppername>", "<= <upper>");
                    string13 = StringUtils.getReplacedString(string13, "<upper>", string11);
                    string3 = string3 + " when <attrname> <= <upper> then <binId>\n";
                    string3 = StringUtils.getReplacedString(string3, "<attrname>", string5);
                    string3 = StringUtils.getReplacedString(string3, "<upper>", string12);
                    string3 = StringUtils.getReplacedString(string3, "<binId>", Integer.toString(n));
                    string7 = string7 + " when <attrname> <= <upper> then <binName>\n";
                    string7 = StringUtils.getReplacedString(string7, "<attrname>", string5);
                    string7 = StringUtils.getReplacedString(string7, "<upper>", string12);
                    string7 = StringUtils.getReplacedString(string7, "<binName>", string13);
                } else {
                    String string15 = (String)list.get(i - 1).getValue();
                    String string16 = bl4 ? GraphUtils.getDateConversionClause(attributeType.getDataType(), string15) : string15;
                    string13 = " '<lower>-<upper>'";
                    string13 = StringUtils.getReplacedString(string13, "<upper>", string11);
                    string13 = StringUtils.getReplacedString(string13, "<lower>", string15);
                    string3 = string3 + " when <attrname> <= <upper> and <attrname> > <lower> then <binId>\n";
                    string3 = StringUtils.getReplacedString(string3, "<attrname>", string5);
                    string3 = StringUtils.getReplacedString(string3, "<upper>", string12);
                    string3 = StringUtils.getReplacedString(string3, "<lower>", string16);
                    string3 = StringUtils.getReplacedString(string3, "<binId>", Integer.toString(n));
                    string7 = string7 + " when <attrname> <= <upper> and <attrname> > <lower> then <binName>\n";
                    string7 = StringUtils.getReplacedString(string7, "<attrname>", string5);
                    string7 = StringUtils.getReplacedString(string7, "<upper>", string12);
                    string7 = StringUtils.getReplacedString(string7, "<lower>", string16);
                    string7 = StringUtils.getReplacedString(string7, "<binName>", string13);
                    if (i == list.size() - 1) {
                        string3 = string3 + " when <attrname> > <upper> then <binId> ";
                        string3 = StringUtils.getReplacedString(string3, "<attrname>", string5);
                        string3 = StringUtils.getReplacedString(string3, "<upper>", string12);
                        string3 = StringUtils.getReplacedString(string3, "<binId>", Integer.toString(n + 1));
                        string14 = " '<uppername>'";
                        string14 = StringUtils.getReplacedString(string14, "<uppername>", "> <upper>");
                        string14 = StringUtils.getReplacedString(string14, "<upper>", string11);
                        string7 = string7 + " when <attrname> > <upper> then <binName> ";
                        string7 = StringUtils.getReplacedString(string7, "<attrname>", string5);
                        string7 = StringUtils.getReplacedString(string7, "<upper>", string12);
                        string7 = StringUtils.getReplacedString(string7, "<binName>", string14);
                    }
                }
            } else {
                string12 = (String)list.get(i).getValue();
                string13 = " '<uppername>'";
                string13 = StringUtils.getReplacedString(string13, "<uppername>", "<upper>");
                string13 = StringUtils.getReplacedString(string13, "<upper>", string11);
                string3 = string3 + " when <attrname> = <upper> then <binId>\n";
                string3 = StringUtils.getReplacedString(string3, "<attrname>", string5);
                string3 = StringUtils.getReplacedString(string3, "<upper>", string12);
                string3 = StringUtils.getReplacedString(string3, "<binId>", Integer.toString(n));
                string7 = string7 + " when <attrname> = <upper> then <binName>\n";
                string7 = StringUtils.getReplacedString(string7, "<attrname>", string5);
                string7 = StringUtils.getReplacedString(string7, "<upper>", string12);
                string7 = StringUtils.getReplacedString(string7, "<binName>", string13);
            }
            string8 = string8 + " select 0 as <yattrname>, <binId> as \"BIN_IDS\", <binName> as <attrname> <gcomma> <default_cat> <gattr> from dual \n ";
            string8 = StringUtils.getReplacedString(string8, "<binId>", Integer.toString(n));
            string8 = StringUtils.getReplacedString(string8, "<binName>", string13);
            string8 = string8 + " union all\n ";
            if (i == list.size() - 1) {
                string8 = string8 + " select 0 as <yattrname>, <binId> as \"BIN_IDS\", <binName> as <attrname> <gcomma> <default_cat> <gattr> from dual \n ";
                string8 = StringUtils.getReplacedString(string8, "<binId>", Integer.toString(n + 1));
                string8 = StringUtils.getReplacedString(string8, "<binName>", string14);
            }
            ++n;
        }
        string8 = string8 + ")\n";
        string8 = string8 + ", ALL_BINS as ( select   NVL(BINNED_DATA.<yattrname>, EMPTY_BINS.<yattrname>) <yattrname>,  NVL(BINNED_DATA.BIN_IDS, EMPTY_BINS.BIN_IDS) BIN_IDS,  NVL(BINNED_DATA.<qattrname>, EMPTY_BINS.<qattrname>) <qattrname>   <categorySelectClause> from BINNED_DATA right outer join EMPTY_BINS on BINNED_DATA.BIN_IDS = EMPTY_BINS.BIN_IDS order by bin_ids) ";
        string8 = StringUtils.getReplacedString(string8, "<yattrname>", string6);
        string8 = StringUtils.getReplacedString(string8, "<attrname>", string5);
        string8 = StringUtils.getReplacedString(string8, "<qattrname>", string5);
        string8 = StringUtils.getReplacedString(string8, "<default_cat>", string2);
        string8 = StringUtils.getReplacedString(string8, "<categorySelectClause>", string9);
        if (bl2) {
            string3 = string3 + " when <attrname> is Null Then <binId> ";
            string3 = StringUtils.getReplacedString(string3, "<attrname>", string5);
            string3 = StringUtils.getReplacedString(string3, "<binId>", Integer.toString(n + 1));
            string7 = string7 + " when <attrname> is Null Then 'Nulls' ";
            string7 = StringUtils.getReplacedString(string7, "<attrname>", string5);
        }
        string3 = string3 + (bl ? " end bin_ids " : "");
        string7 = string7 + " end <binning_labels> ";
        string7 = StringUtils.getReplacedString(string7, "<binning_labels>", string5);
        return new BinClausesInfo((Pair<String, String>)new Pair((Object)string3, (Object)string7), string8);
    }

    protected String getCatBinCaseClause(AttributeType attributeType, BinningSettingsType binningSettingsType) {
        if (GraphUtils.getCategoricalBinValues(binningSettingsType).isEmpty()) {
            return "";
        }
        String string = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(attributeType.getName()));
        String string2 = " case when <attr> in (<inclause>) then <attr> else <others> end <attr>";
        String string3 = "'" + GraphLrb.get("BIN_OTHERS") + "'";
        string2 = StringUtils.getReplacedString(string2, "<others>", string3);
        string2 = StringUtils.getReplacedString(string2, "<attr>", string);
        List<String> list = GraphUtils.getCategoricalBinValues(binningSettingsType);
        int n = list.size();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            String string4 = list.get(i);
            stringBuilder.append("'");
            stringBuilder.append(string4);
            stringBuilder.append("'");
            if (i >= n - 1) continue;
            stringBuilder.append(", ");
        }
        string2 = StringUtils.getReplacedString(string2, "<inclause>", stringBuilder.toString());
        return string2;
    }

    public boolean isMultiSeries() {
        return this.isMultiSeries;
    }
}

