/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.utils.Formats;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;
import oracle.sql.BFILE;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.RAW;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.xdb.XMLType;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class ODMrDataTypesUtil {
    private static final Logger LOGGER = Logger.getLogger(ODMrDataTypesUtil.class.getName());
    private static volatile Map<Integer, String> dataTypesMap;
    private static final String SYS_DM_NESTED_NUMERICAL = "SYS.DM_NESTED_NUMERICAL";
    private static final String SYS_DM_NESTED_NUMERICALS = "SYS.DM_NESTED_NUMERICALS";
    private static final String SYS_DM_NESTED_CATEGORICAL = "SYS.DM_NESTED_CATEGORICAL";
    private static final String SYS_DM_NESTED_CATEGORICALS = "SYS.DM_NESTED_CATEGORICALS";
    private static final String SYS_DM_NESTED_BINARY_DOUBLE = "SYS.SYS_DM_NESTED_BINARY_DOUBLE";
    private static final String SYS_DM_NESTED_BINARY_DOUBLES = "SYS.SYS_DM_NESTED_BINARY_DOUBLES";
    private static final String SYS_DM_NESTED_BINARY_FLOAT = "SYS.SYS_DM_NESTED_BINARY_FLOAT";
    private static final String SYS_DM_NESTED_BINARY_FLOATS = "SYS.SYS_DM_NESTED_BINARY_FLOATS";
    private static final String ODMR_PREDICTION_NUM = "ODMRSYS.ODMR_PREDICTION_NUM";
    private static final String ODMR_PREDICTION_SET_NUM = "ODMR_PREDICTION_SET_NUM";
    private static final String ODMR_FEATURE_NUM = "ODMRSYS.ODMR_FEATURE_NUM";
    private static final String ODMR_FEATURE_SET_NUM = "ODMR_FEATURE_SET_NUM";
    private static final String ODMR_CLUSTER_NUM = "ODMRSYS.ODMR_CLUSTER_NUM";
    private static final String ODMR_CLUSTER_SET_NUM = "ODMR_CLUSTER_SET_NUM";
    private static final String ODMR_PREDICTION_NUM_COST = "ODMRSYS.ODMR_PREDICTION_NUM_COST";
    private static final String ODMR_PREDICTION_SET_NUM_COST = "ODMR_PREDICTION_SET_NUM_COST";
    private static final String ODMR_PREDICTION_CAT_COST = "ODMRSYS.ODMR_PREDICTION_CAT_COST";
    private static final String ODMR_PREDICTION_SET_CAT_COST = "ODMR_PREDICTION_SET_CAT_COST";
    private static final String ODMR_PREDICTION_CAT = "ODMRSYS.ODMR_PREDICTION_CAT";
    private static final String ODMR_PREDICTION_SET_CAT = "ODMR_PREDICTION_SET_CAT";
    private static final String ODMR_FEATURE_CAT = "ODMRSYS.ODMR_FEATURE_CAT";
    private static final String ODMR_FEATURE_SET_CAT = "ODMR_FEATURE_SET_CAT";
    private static final String ODMR_CLUSTER_CAT = "ODMRSYS.ODMR_CLUSTER_CAT";
    private static final String ODMR_CLUSTER_SET_CAT = "ODMR_CLUSTER_SET_CAT";
    private static final String ODMR_PREDICTION_NUM_COSTF = "ODMRSYS.ODMR_PREDICTION_NUM_COSTF";
    private static final String ODMR_PREDICTION_NUM_COSTD = "ODMRSYS.ODMR_PREDICTION_NUM_COSTD";
    private static final String ODMR_PREDICTION_NUM_COSTN = "ODMRSYS.ODMR_PREDICTION_NUM_COSTN";
    private static final String ODMR_PREDICTION_SET_NUM_COSTF = "ODMR_PREDICTION_SET_NUM_COSTF";
    private static final String ODMR_PREDICTION_SET_NUM_COSTD = "ODMR_PREDICTION_SET_NUM_COSTD";
    private static final String ODMR_PREDICTION_SET_NUM_COSTN = "ODMR_PREDICTION_SET_NUM_COSTN";
    private static final String ODMR_PREDICTION_NUM_F = "ODMRSYS.ODMR_PREDICTION_NUM_F";
    private static final String ODMR_PREDICTION_NUM_D = "ODMRSYS.ODMR_PREDICTION_NUM_D";
    private static final String ODMR_PREDICTION_NUM_N = "ODMRSYS.ODMR_PREDICTION_NUM_N";
    private static final String ODMR_PREDICTION_SET_NUM_F = "ODMR_PREDICTION_SET_NUM_F";
    private static final String ODMR_PREDICTION_SET_NUM_D = "ODMR_PREDICTION_SET_NUM_D";
    private static final String ODMR_PREDICTION_SET_NUM_N = "ODMR_PREDICTION_SET_NUM_N";
    private static final String ODMR_PREDICTION_CAT_COSTPD = "ODMRSYS.ODMR_PREDICTION_CAT_COSTPD";
    private static final String ODMR_PREDICTION_SET_CAT_COSTPD = "ODMR_PREDICTION_SET_CAT_COSTPD";
    private static final String ODMR_PREDICTION_CATPD = "ODMRSYS.ODMR_PREDICTION_CATPD";
    private static final String ODMR_PREDICTION_SET_CATPD = "ODMR_PREDICTION_SET_CATPD";
    private static final String ODMR_FEATURE_NUMVD = "ODMRSYS.ODMR_FEATURE_NUMVD";
    private static final String ODMR_FEATURE_SET_NUMVD = "ODMR_FEATURE_SET_NUMVD";
    private static final String ODMR_FEATURE_CATVD = "ODMRSYS.ODMR_FEATURE_CATVD";
    private static final String ODMR_FEATURE_SET_CATVD = "ODMR_FEATURE_SET_CATVD";
    private static final String ODMR_CLUSTER_NUMPD = "ODMRSYS.ODMR_CLUSTER_NUMPD";
    private static final String ODMR_CLUSTER_SET_NUMPD = "ODMR_CLUSTER_SET_NUMPD";
    private static final String ODMR_CLUSTER_CATPD = "ODMRSYS.ODMR_CLUSTER_CATPD";
    private static final String ODMR_CLUSTER_SET_CATPD = "ODMR_CLUSTER_SET_CATPD";
    private static final String ODMR_HISTOGRAM_POINT = "ODMRSYS.ODMR_HISTOGRAM_POINT";
    private static final String ODMR_HISTOGRAM_POINT_EX = "ODMRSYS.ODMR_HISTOGRAM_POINT_EX";
    private static final String ODMR_HISTOGRAMS = "ODMR_HISTOGRAMS";
    private static final String ODMR_HISTOGRAMS_EX = "ODMR_HISTOGRAMS_EX";
    private static final String[] ODMR_12_1_APPLY_TYPES_SUPPORTED;
    private static final String[] ODMR_MISC_TYPES_SUPPORTED;

    public static String stringValue(Object object, Connection connection) {
        return ODMrDataTypesUtil.stringValue(object, connection, 4000);
    }

    public static String stringValue(Object object, Connection connection, int n) {
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder = null;
        Object object2 = null;
        if (object instanceof Clob) {
            try {
                object2 = object;
                stringBuilder = new StringBuilder(Translate.translate("(CLOB) "));
                stringBuilder.append(((Clob)object).getSubString(1L, n));
                if ((int)((Clob)object).length() > n) {
                    stringBuilder.append("...");
                }
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
            }
        } else if (object instanceof Blob) {
            object2 = object;
            stringBuilder = new StringBuilder(Translate.translate("(BLOB)"));
        } else if (object instanceof RAW) {
            object2 = object;
            stringBuilder = new StringBuilder((String)NLSUtils.getValue(connection, object));
        } else if (object instanceof BFILE) {
            object2 = object;
            stringBuilder = new StringBuilder(Translate.translate("(BFILE)"));
        } else if (object instanceof TIMESTAMPTZ || object instanceof TIMESTAMPLTZ || object instanceof TIMESTAMP || object instanceof INTERVALYM || object instanceof INTERVALDS) {
            stringBuilder = new StringBuilder((String)oracle.dbtools.raptor.utils.NLSUtils.getValue((Connection)connection, (Object)object));
        } else if (object instanceof Timestamp) {
            stringBuilder = new StringBuilder((String)oracle.dbtools.raptor.utils.NLSUtils.getValue((Connection)connection, (Object)object));
        } else if (object instanceof DATE) {
            try {
                stringBuilder = new StringBuilder((String)oracle.dbtools.raptor.utils.NLSUtils.getValue((Connection)connection, (Object)object));
            }
            catch (NullPointerException nullPointerException) {
                DATE dATE = (DATE)object;
                stringBuilder = new StringBuilder(DATE.toString((byte[])dATE.toBytes()));
            }
        } else if (object instanceof Date) {
            stringBuilder = new StringBuilder(oracle.dbtools.raptor.utils.NLSUtils.format((Connection)connection, (Object)object));
        } else if (object instanceof NUMBER) {
            NUMBER nUMBER = (NUMBER)object;
            try {
                BigDecimal bigDecimal = nUMBER.bigDecimalValue();
                stringBuilder = new StringBuilder(Formats.DataExplore.getNumeric().format(bigDecimal));
            }
            catch (Exception exception) {
                stringBuilder = null;
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            stringBuilder = new StringBuilder(Formats.DataExplore.getNumeric().format(bigDecimal.doubleValue()));
        } else if (object instanceof XMLType) {
            try {
                stringBuilder = new StringBuilder(ODMrDataTypesUtil.convertXMLSpecialsChars(((XMLType)object).getStringVal()));
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        } else if (object instanceof OPAQUE) {
            try {
                stringBuilder = new StringBuilder(((OPAQUE)object).getSQLTypeName().trim());
                if ("SYS.XMLTYPE".equals(stringBuilder.toString())) {
                    stringBuilder = new StringBuilder(XMLType.createXML((OPAQUE)((OPAQUE)object)).getStringVal());
                }
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        } else if (object instanceof STRUCT) {
            try {
                stringBuilder = new StringBuilder(((STRUCT)object).getSQLTypeName().trim());
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        } else if (object instanceof Array) {
            try {
                String string = ((Array)object).getBaseTypeName();
                if (string.equals(SYS_DM_NESTED_NUMERICAL)) {
                    stringBuilder = new StringBuilder(SYS_DM_NESTED_NUMERICALS);
                    stringBuilder.append("(");
                } else if (string.equals(SYS_DM_NESTED_CATEGORICAL)) {
                    stringBuilder = new StringBuilder(SYS_DM_NESTED_CATEGORICALS);
                    stringBuilder.append("(");
                } else if (string.equals(SYS_DM_NESTED_BINARY_DOUBLE)) {
                    stringBuilder = new StringBuilder(SYS_DM_NESTED_BINARY_DOUBLES);
                    stringBuilder.append("(");
                } else if (string.equals(SYS_DM_NESTED_BINARY_FLOAT)) {
                    stringBuilder = new StringBuilder(SYS_DM_NESTED_BINARY_FLOATS);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_PREDICTION_NUM)) {
                    stringBuilder = new StringBuilder(ODMR_PREDICTION_SET_NUM);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_FEATURE_NUM)) {
                    stringBuilder = new StringBuilder(ODMR_FEATURE_SET_NUM);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_CLUSTER_NUM)) {
                    stringBuilder = new StringBuilder(ODMR_CLUSTER_SET_NUM);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_PREDICTION_NUM_COST)) {
                    stringBuilder = new StringBuilder(ODMR_PREDICTION_SET_NUM_COST);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_PREDICTION_CAT_COST)) {
                    stringBuilder = new StringBuilder(ODMR_PREDICTION_SET_CAT_COST);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_PREDICTION_CAT)) {
                    stringBuilder = new StringBuilder(ODMR_PREDICTION_SET_CAT);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_FEATURE_CAT)) {
                    stringBuilder = new StringBuilder(ODMR_FEATURE_SET_CAT);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_CLUSTER_CAT)) {
                    stringBuilder = new StringBuilder(ODMR_CLUSTER_SET_CAT);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_PREDICTION_NUM_COSTF)) {
                    stringBuilder = new StringBuilder(ODMR_PREDICTION_SET_NUM_COSTF);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_PREDICTION_NUM_COSTD)) {
                    stringBuilder = new StringBuilder(ODMR_PREDICTION_SET_NUM_COSTD);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_PREDICTION_NUM_COSTN)) {
                    stringBuilder = new StringBuilder(ODMR_PREDICTION_SET_NUM_COSTN);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_PREDICTION_NUM_F)) {
                    stringBuilder = new StringBuilder(ODMR_PREDICTION_SET_NUM_F);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_PREDICTION_NUM_D)) {
                    stringBuilder = new StringBuilder(ODMR_PREDICTION_SET_NUM_D);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_PREDICTION_NUM_N)) {
                    stringBuilder = new StringBuilder(ODMR_PREDICTION_SET_NUM_N);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_PREDICTION_CAT_COSTPD)) {
                    stringBuilder = new StringBuilder(ODMR_PREDICTION_SET_CAT_COSTPD);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_PREDICTION_CATPD)) {
                    stringBuilder = new StringBuilder(ODMR_PREDICTION_SET_CATPD);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_FEATURE_NUMVD)) {
                    stringBuilder = new StringBuilder(ODMR_FEATURE_SET_NUMVD);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_FEATURE_CATVD)) {
                    stringBuilder = new StringBuilder(ODMR_FEATURE_SET_CATVD);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_CLUSTER_NUMPD)) {
                    stringBuilder = new StringBuilder(ODMR_CLUSTER_SET_NUMPD);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_CLUSTER_CATPD)) {
                    stringBuilder = new StringBuilder(ODMR_CLUSTER_SET_CATPD);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_HISTOGRAM_POINT)) {
                    stringBuilder = new StringBuilder(ODMR_HISTOGRAM_POINT);
                    stringBuilder.append("(");
                } else if (string.equals(ODMR_HISTOGRAM_POINT_EX)) {
                    stringBuilder = new StringBuilder(ODMR_HISTOGRAM_POINT_EX);
                    stringBuilder.append("(");
                } else {
                    if (object == null) {
                        return "";
                    }
                    return DataLrb.get("DATA_VIEWER_COLUMN_NOT_DISPLAYABLE");
                }
                Object[] objectArray = (Object[])((Array)object).getArray();
                if (objectArray.length == 0) {
                    stringBuilder.append(")");
                } else {
                    Array array;
                    Object object3;
                    String string2 = ODMrDataTypesUtil.stringValue(objectArray[0], connection);
                    if ((string2.equals(SYS_DM_NESTED_NUMERICAL) || string2.equals(SYS_DM_NESTED_CATEGORICAL) || string2.equals(SYS_DM_NESTED_BINARY_DOUBLE) || string2.equals(SYS_DM_NESTED_BINARY_FLOAT) || string2.equals(ODMR_PREDICTION_NUM) || string2.equals(ODMR_FEATURE_NUM) || string2.equals(ODMR_PREDICTION_CAT_COST) || string2.equals(ODMR_PREDICTION_CAT) || string2.equals(ODMR_FEATURE_CAT) || string2.equals(ODMR_CLUSTER_CAT) || string2.equals(ODMR_PREDICTION_NUM_COST) || string2.equals(ODMR_CLUSTER_NUM) || string2.equals(ODMR_PREDICTION_NUM_COSTF) || string2.equals(ODMR_PREDICTION_NUM_COSTD) || string2.equals(ODMR_PREDICTION_NUM_COSTN) || string2.equals(ODMR_PREDICTION_NUM_F) || string2.equals(ODMR_PREDICTION_NUM_D) || string2.equals(ODMR_PREDICTION_NUM_N) || string2.equals(ODMR_PREDICTION_CAT_COSTPD) || string2.equals(ODMR_PREDICTION_CATPD) || string2.equals(ODMR_FEATURE_NUMVD) || string2.equals(ODMR_FEATURE_CATVD) || string2.equals(ODMR_CLUSTER_NUMPD) || string2.equals(ODMR_CLUSTER_CATPD) || string2.equals(ODMR_HISTOGRAM_POINT) || string2.equals(ODMR_HISTOGRAM_POINT_EX)) && (object3 = (array = (Array)object).getArray()) instanceof Object[]) {
                        Object[] objectArray2 = (Object[])object3;
                        StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.toString());
                        for (int i = 0; i < objectArray2.length; ++i) {
                            StringBuilder stringBuilder3 = new StringBuilder(string2);
                            STRUCT sTRUCT = (STRUCT)objectArray2[i];
                            Object[] objectArray3 = sTRUCT.getAttributes();
                            stringBuilder3.append("(");
                            for (int j = 0; j < objectArray3.length; ++j) {
                                if (j > 0) {
                                    stringBuilder3.append(",");
                                }
                                stringBuilder3.append(objectArray3[j] != null ? objectArray3[j].toString() : "");
                            }
                            stringBuilder3.append(")");
                            if (i > 0) {
                                stringBuilder2.append(", ");
                            }
                            stringBuilder2.append((CharSequence)stringBuilder3);
                        }
                        stringBuilder2.append(")");
                        stringBuilder = stringBuilder2;
                    }
                }
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        } else if (object instanceof List) {
            stringBuilder = new StringBuilder("{");
            List list = (List)object;
            int n2 = 0;
            List list2 = (List)list.get(0);
            for (Object e : list) {
                if (n2 > 0) {
                    stringBuilder.append("<");
                    int n3 = 0;
                    for (Object e2 : (List)e) {
                        stringBuilder.append(list2.get(n3));
                        stringBuilder.append("=");
                        stringBuilder.append(ODMrDataTypesUtil.stringValue(e2, connection));
                        stringBuilder.append(",");
                        ++n3;
                    }
                    stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
                    stringBuilder.append(">,");
                }
                ++n2;
            }
            stringBuilder.append("}");
        } else if (object instanceof Datum && !(object instanceof INTERVALDS)) {
            try {
                stringBuilder = new StringBuilder(((Datum)object).stringValue());
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        } else {
            stringBuilder = new StringBuilder(object.toString());
        }
        return stringBuilder.toString();
    }

    public static List<List<?>> stringValue(Array array, Connection connection) {
        LinkedList linkedList = new LinkedList();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        try {
            Object object = array.getArray();
            Object[] objectArray = (Object[])object;
            if (objectArray == null || objectArray.length == 0) {
                String string = array.getBaseTypeName();
                linkedList2.add(string);
                linkedList.add(linkedList2);
            } else if (objectArray[0] instanceof STRUCT) {
                Object[] objectArray2;
                int n;
                STRUCT sTRUCT = (STRUCT)objectArray[0];
                ResultSetMetaData resultSetMetaData = sTRUCT.getDescriptor().getMetaData();
                for (n = 0; n < resultSetMetaData.getColumnCount(); ++n) {
                    objectArray2 = resultSetMetaData.getColumnName(n + 1);
                    linkedList2.add(objectArray2);
                }
                linkedList.add(linkedList2);
                for (n = 0; n < objectArray.length; ++n) {
                    sTRUCT = (STRUCT)objectArray[n];
                    objectArray2 = sTRUCT.getAttributes();
                    linkedList2 = new LinkedList();
                    for (int i = 0; i < objectArray2.length; ++i) {
                        linkedList2.add(objectArray2[i]);
                    }
                    linkedList.add(linkedList2);
                }
            } else {
                linkedList2.add("ARRAY");
                linkedList.add(linkedList2);
                for (int i = 0; i < objectArray.length; ++i) {
                    linkedList2 = new LinkedList();
                    linkedList2.add(objectArray[i]);
                    linkedList.add(linkedList2);
                }
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
        }
        return linkedList;
    }

    public static String getEmptyExtendedType(Object object, int n) {
        if (object instanceof Blob || n == 2004) {
            return "empty_blob()";
        }
        if (object instanceof BFILE || n == -13) {
            return "bfilename(' ',' ')";
        }
        return "NULL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getJdbcTypeName(int n) {
        if (dataTypesMap != null) return dataTypesMap.get(n);
        Class<ODMrDataTypesUtil> clazz = ODMrDataTypesUtil.class;
        synchronized (ODMrDataTypesUtil.class) {
            if (dataTypesMap != null) return dataTypesMap.get(n);
            dataTypesMap = new HashMap<Integer, String>();
            Field[] fieldArray = OracleTypes.class.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                try {
                    String string = fieldArray[i].getName();
                    Integer n2 = (Integer)fieldArray[i].get(null);
                    dataTypesMap.put(n2, string);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOGGER.log(Level.SEVERE, illegalAccessException.getLocalizedMessage(), illegalAccessException);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dataTypesMap.get(n);
        }
    }

    public static void main(String[] stringArray) {
    }

    public static boolean canDuplicate(Object object, int n) {
        return !(object instanceof STRUCT) && n != 2002 && !(object instanceof RAW) && n != -4 && n != -2 && n != -3 && !(object instanceof Blob) && n != 2004;
    }

    public static Object getDuplicate(Object object, Connection connection, int n) throws SQLException {
        if (ODMrDataTypesUtil.canDuplicate(object, n)) {
            if (object instanceof Clob || n == 2005) {
                if (object == null || "".equals(object)) {
                    return "";
                }
                return ((Clob)object).getSubString(1L, (int)((Clob)object).length());
            }
            return ODMrDataTypesUtil.stringValue(object, connection);
        }
        return null;
    }

    public static String prettyPrintWithDOM3LS(String string) throws Exception {
        string = string.replaceAll(">\\s+<", "><").trim();
        InputSource inputSource = new InputSource(new StringReader(string));
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource);
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)document.getImplementation().getFeature("LS", "3.0");
        assert (dOMImplementationLS != null) : "No DOM 3 LS supported in " + document.getClass().getName();
        LSOutput lSOutput = dOMImplementationLS.createLSOutput();
        lSOutput.setEncoding("UTF-8");
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        String string2 = "format-pretty-print";
        if (!lSSerializer.getDomConfig().canSetParameter(string2, true)) {
            throw new RuntimeException("DOMConfiguration 'format-pretty-print' parameter isn't settable.");
        }
        lSSerializer.getDomConfig().setParameter(string2, true);
        lSSerializer.getDomConfig().setParameter("xml-declaration", false);
        StringWriter stringWriter = new StringWriter();
        lSOutput.setCharacterStream(stringWriter);
        lSSerializer.write(document, lSOutput);
        return ODMrDataTypesUtil.convertXMLSpecialsChars(stringWriter.toString());
    }

    public static String convertXMLSpecialsChars(String string) {
        String string2 = string;
        string2 = string2.replaceAll("&amp;", "&");
        string2 = string2.replaceAll("&lt;", "<");
        string2 = string2.replaceAll("&gt;", ">");
        string2 = string2.replaceAll("&quot;", "\"");
        string2 = string2.replaceAll("&apos;", "'");
        return string2;
    }

    public static String[] getApply_12_1_Types() {
        return ODMR_12_1_APPLY_TYPES_SUPPORTED;
    }

    public static String[] getODMr_Misc_Types() {
        return ODMR_MISC_TYPES_SUPPORTED;
    }

    static {
        ODMR_12_1_APPLY_TYPES_SUPPORTED = new String[]{ODMR_PREDICTION_SET_NUM_COSTF, ODMR_PREDICTION_SET_NUM_COSTD, ODMR_PREDICTION_SET_NUM_COSTN, ODMR_PREDICTION_SET_NUM_F, ODMR_PREDICTION_SET_NUM_D, ODMR_PREDICTION_SET_NUM_N, ODMR_PREDICTION_SET_CAT_COSTPD, ODMR_PREDICTION_SET_CATPD, ODMR_FEATURE_SET_NUMVD, ODMR_FEATURE_SET_CATVD, ODMR_CLUSTER_SET_NUMPD, ODMR_CLUSTER_SET_CATPD};
        ODMR_MISC_TYPES_SUPPORTED = new String[]{ODMR_HISTOGRAMS, ODMR_HISTOGRAMS_EX};
    }

    private static class Translate {
        private Translate() {
        }

        public static String translate(String string) {
            if (string == null) {
                return null;
            }
            String string2 = string.replace('_', ' ');
            return string2;
        }
    }

    private static class NLSUtils {
        private static final DateFormat SDF = SimpleDateFormat.getDateTimeInstance(3, 3, Locale.getDefault());

        private NLSUtils() {
        }

        public static Object getValue(Connection connection, Object object) {
            if (object == null) {
                return object;
            }
            String string = "";
            try {
                string = object instanceof Clob ? ((Clob)object).getSubString(1L, (int)((Clob)object).length()) : (object instanceof OPAQUE ? ((OPAQUE)object).getSQLTypeName().trim() : (object instanceof TIMESTAMP && connection != null ? NLSUtils.formatTIMESTAMP((TIMESTAMP)object) : (object instanceof TIMESTAMPTZ && connection != null ? NLSUtils.formatTIMESTAMPTZ((TIMESTAMPTZ)object) : (object instanceof TIMESTAMPLTZ && connection != null ? NLSUtils.formatTIMESTAMPLTZ((TIMESTAMPLTZ)object) : (object instanceof DATE && connection != null ? NLSUtils.formatDate((DATE)object) : (object instanceof Date && connection != null ? NLSUtils.formatDate(new DATE((Date)object)) : (object instanceof NUMBER && connection != null ? NLSUtils.formatNUMBER(connection, (NUMBER)object) : (object instanceof BigDecimal && connection != null ? NLSUtils.formatBigDecimal(connection, (BigDecimal)object) : (object instanceof INTERVALDS && connection != null ? object.toString() : (object instanceof Datum ? ((Datum)object).stringValue() : object.toString()))))))))));
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return string;
        }

        public static String formatBigDecimal(Connection connection, BigDecimal bigDecimal) {
            String string = null;
            string = bigDecimal.toPlainString();
            if (string.indexOf(46) != -1 && connection instanceof OracleConnection) {
                char c = '.';
                string = bigDecimal.toPlainString();
                if (c != '.') {
                    string = string.replace('.', c);
                }
            }
            return string;
        }

        public static String formatNUMBER(Connection connection, NUMBER nUMBER) {
            String string = null;
            string = nUMBER.stringValue();
            if (string.indexOf(46) != -1) {
                char c = '.';
                try {
                    BigDecimal bigDecimal = nUMBER.bigDecimalValue();
                    string = bigDecimal.toPlainString();
                    if (c != '.') {
                        string = string.replace('.', c);
                    }
                }
                catch (SQLException sQLException) {
                    LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                }
            }
            return string;
        }

        public static String formatDate(DATE dATE) {
            return SDF.format(dATE.dateValue());
        }

        private static String formatTIMESTAMP(TIMESTAMP tIMESTAMP) {
            String string = "";
            try {
                string = SDF.format(tIMESTAMP.dateValue());
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            return string;
        }

        private static String formatTIMESTAMPTZ(TIMESTAMPTZ tIMESTAMPTZ) {
            String string = "";
            try {
                string = SDF.format(tIMESTAMPTZ.dateValue());
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            return string;
        }

        private static String formatTIMESTAMPLTZ(TIMESTAMPLTZ tIMESTAMPLTZ) {
            String string = "";
            try {
                string = SDF.format(tIMESTAMPLTZ.dateValue());
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            return string;
        }
    }
}

