/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.clas.common.FilterSetting;
import oracle.dmt.dataminer.core.model.common.build.AttributeBiCoefficient;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.SVMBiasRowData;
import oracle.dmt.dataminer.server.model.SVMModelDetails;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OraclePreparedStatement;

public class SVMModelDetailsImpl
implements SVMModelDetails {
    private static final Logger LOGGER = Logger.getLogger(SVMModelDetailsImpl.class.getName());
    private static final String QRY_CLASSIFICATION_COEFFICIENTS = "SELECT * FROM ( \nSELECT * FROM ( \n  SELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"coefficient\" from  \n      (SELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n                       r.attribute_name || '.' ||  r.attribute_subname \n                  ELSE r.attribute_name \n       END \"attribute_name_subname\", \n       r.attribute_name \"attribute_name\", \n       r.attribute_value \"attribute_value\",  \n       r.coefficient \"coefficient\" \n  FROM (SELECT t.class, s.attribute_name, s.attribute_subname, s.attribute_value, <coefficient_value> \n    FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param)) t, \n   TABLE(t.attribute_set) s \n     <internal_where_clause> \n ) r  ) \n  <where_condition> ) <order> \n) <rownum> \n";
    private static final String QRY_CLASSIFICATION_COEFFICIENTS_PARTITION = "SELECT * FROM ( \nSELECT * FROM ( \n  SELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"coefficient\" from  \n      (SELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n                       r.attribute_name || '.' ||  r.attribute_subname \n                  ELSE r.attribute_name \n       END \"attribute_name_subname\", \n       r.attribute_name \"attribute_name\", \n       r.attribute_value \"attribute_value\",  \n       r.coefficient \"coefficient\" \n  FROM (SELECT t.class, s.attribute_name, s.attribute_subname, s.attribute_value, <coefficient_value> \n    FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param, 0, :partitionId)) t, \n   TABLE(t.attribute_set) s \n     <internal_where_clause> \n ) r  ) \n  <where_condition> ) <order> \n) <rownum> \n";
    private static final String QRY_REGRESSION_COEFFICIENTS = "SELECT * FROM ( \nSELECT * FROM ( \n  SELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"coefficient\" from  \n      (SELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n                       r.attribute_name || '.' ||  r.attribute_subname \n                  ELSE r.attribute_name \n       END \"attribute_name_subname\", \n       r.attribute_name \"attribute_name\", \n       r.attribute_value \"attribute_value\",  \n       r.coefficient \"coefficient\" \n  FROM (SELECT t.class, s.attribute_name, s.attribute_subname, s.attribute_value, <coefficient_value> \n    FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param)) t, \n   TABLE(t.attribute_set) s \n  <where_key_word> <and2> <and3> ) r )\n  <where_condition> ) <order> \n) <rownum> \n";
    private static final String QRY_REGRESSION_COEFFICIENTS_PARTITION = "SELECT * FROM ( \nSELECT * FROM ( \n  SELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"coefficient\" from  \n      (SELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n                       r.attribute_name || '.' ||  r.attribute_subname \n                  ELSE r.attribute_name \n       END \"attribute_name_subname\", \n       r.attribute_name \"attribute_name\", \n       r.attribute_value \"attribute_value\",  \n       r.coefficient \"coefficient\" \n  FROM (SELECT t.class, s.attribute_name, s.attribute_subname, s.attribute_value, <coefficient_value> \n    FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param, 0, :partitionId)) t, \n   TABLE(t.attribute_set) s \n  <where_key_word> <and2> <and3> ) r )\n  <where_condition> ) <order> \n) <rownum> \n";
    private static final String _TARGET_CONDITION = "  WHERE t.class = :target_value_param \n";
    private static final String QRY_CLASSIFICATION_COEFFICIENTS_ALL = "SELECT * FROM ( \nSELECT * FROM ( \nSELECT \n<select_stmt>\n\tfrom ( \tSELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n\t      r.attribute_name || '.' ||  r.attribute_subname \n\t     ELSE r.attribute_name \n\t     END \"attribute_name_subname\", \n\t  r.attribute_name \"attribute_name\", \n\t  r.attribute_value \"attribute_value\" \n  FROM (SELECT t.class, s.attribute_name, s.attribute_subname, s.attribute_value \n    FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param)) t, \n   TABLE(t.attribute_set) s \n<target_condition> ) r ) \n<name_filter_condition><group_by>) <order> \n) <rownum> \n";
    private static final String QRY_ALL_PROPENSITIES_BINARY = "SELECT <COUNT_ONLY> FROM (\nSELECT * FROM (\nSELECT * FROM (\n  SELECT \"target\",\n       NVL2( attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n       attribute_name  \"attribute_name\", \n        \"attribute_value\", \n        case when (c1 is not null) AND (c2 is not null) AND (c1 > c2) then c1 \n             when (c2 is null) then c1 \n             else null \n        end \"propensity_target_one\",\n        case when (c2 is not null) AND (c1 is not null) AND (c2 > c1) then c2 \n             when (c1 is null) then c2 \n             else null \n       end \"propensity_target_two\",\n       <ABSOLUTE_VALUE>(  nvl(c1, 0)  +  nvl(c2,0) ) \"propensity_target\"\n  FROM (\n    SELECT t.class \"target_attribute_value\", t.class \"target\", \n           s.attribute_name, s.attribute_subname, s.attribute_value \"attribute_value\", \n           s.coefficient \"coefficient\" \n   FROM \n     TABLE(dbms_data_mining.get_model_details_svm(:model_name_param)) t, \n     TABLE(t.attribute_set) s   \n   <where_clause> \n  )\n  pivot(max(\"coefficient\") FOR \"target_attribute_value\" IN (<target_value_one> c1, <target_value_two> c2 ) )   where c1 is not null or c2 is not null \n) <where_clause_like> \n) <order> \n) <rownum> \n";
    private static final String QRY_ALL_PROPENSITIES_BINARY_PARTITION = "SELECT <COUNT_ONLY> FROM (\nSELECT * FROM (\nSELECT * FROM (\n  SELECT \"target\",\n       NVL2( attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n       attribute_name  \"attribute_name\", \n        \"attribute_value\", \n        case when (c1 is not null) AND (c2 is not null) AND (c1 > c2) then c1 \n             when (c2 is null) then c1 \n             else null \n        end \"propensity_target_one\",\n        case when (c2 is not null) AND (c1 is not null) AND (c2 > c1) then c2 \n             when (c1 is null) then c2 \n             else null \n       end \"propensity_target_two\",\n       <ABSOLUTE_VALUE>(  nvl(c1, 0)  +  nvl(c2,0) ) \"propensity_target\"\n  FROM (\n    SELECT t.class \"target_attribute_value\", t.class \"target\", \n           s.attribute_name, s.attribute_subname, s.attribute_value \"attribute_value\", \n           s.coefficient \"coefficient\" \n   FROM \n     TABLE(dbms_data_mining.get_model_details_svm(:model_name_param,0, :partitionId)) t, \n     TABLE(t.attribute_set) s   \n   <where_clause> \n  )\n  pivot(max(\"coefficient\") FOR \"target_attribute_value\" IN (<target_value_one> c1, <target_value_two> c2 ) )   where c1 is not null or c2 is not null \n) <where_clause_like> \n) <order> \n) <rownum> \n";
    private static final String QRY_ALL_PROPENSITIES_MULTI = "SELECT <COUNT_ONLY> FROM (\nSELECT * FROM (\nSELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"propensity_target_one\", \"propensity_target_two\", \n  ((nvl(<ABSOLUTE_VALUE>(\"propensity_target_one\"), 0.0) + nvl(<ABSOLUTE_VALUE>(\"propensity_target_two\"), 0.0) ) ) \"propensity_target\" \nFROM ( \nSELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\",  \n       case  \n         when c1 > 0 and c2 > 0 and c1 > c2 then (c1-c2)/(c1+c2) \n         when c1 > 0 and c2 < 0 and c1 > c2 then (c1)/(c1+abs(c2)) \n         when c1 < 0 and c2 < 0 and c1 > c2 then -1.0 * (c1-c2)/(abs(c1)+abs(c2)) \n         when (c2 is null) and (c1 is not null) then c1  \n         else null \n       end \"propensity_target_one\", \n       case  \n         when c1 > 0 and c2 > 0 and c2 > c1 then (c2-c1)/(c1+c2)   \n         when c2 > 0 and c1 < 0 and c2 > c1 then (c2)/(abs(c1)+c2) \n         when c1 < 0 and c2 < 0 and c2 > c1 then -1.0 * (c2-c1)/(abs(c1)+abs(c2)) \n         when (c1 is null) and (c2 is not null) then c2 \n         else null \n       end \"propensity_target_two\" \n  FROM ( \n    SELECT t.class \"target_attribute_value\",  \n           NVL2( attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\",  \n           s.attribute_name \"attribute_name\", s.attribute_value \"attribute_value\", s.coefficient \"coefficient\" \n    FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param)) t, TABLE(t.attribute_set) s \n    <where_clause> \n  )\n   pivot(max(\"coefficient\") FOR \"target_attribute_value\" IN (<target_value_one> c1, <target_value_two> c2 ) ) \n  <where_clause_like> \n)\n) <order> \n) <rownum> \n";
    private static final String QRY_ALL_PROPENSITIES_MULTI_PARTITION = "SELECT <COUNT_ONLY> FROM (\nSELECT * FROM (\nSELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"propensity_target_one\", \"propensity_target_two\", \n  ((nvl(<ABSOLUTE_VALUE>(\"propensity_target_one\"), 0.0) + nvl(<ABSOLUTE_VALUE>(\"propensity_target_two\"), 0.0) ) ) \"propensity_target\" \nFROM ( \nSELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\",  \n       case  \n         when c1 > 0 and c2 > 0 and c1 > c2 then (c1-c2)/(c1+c2) \n         when c1 > 0 and c2 < 0 and c1 > c2 then (c1)/(c1+abs(c2)) \n         when c1 < 0 and c2 < 0 and c1 > c2 then -1.0 * (c1-c2)/(abs(c1)+abs(c2)) \n         when (c2 is null) and (c1 is not null) then c1  \n         else null \n       end \"propensity_target_one\", \n       case  \n         when c1 > 0 and c2 > 0 and c2 > c1 then (c2-c1)/(c1+c2)   \n         when c2 > 0 and c1 < 0 and c2 > c1 then (c2)/(abs(c1)+c2) \n         when c1 < 0 and c2 < 0 and c2 > c1 then -1.0 * (c2-c1)/(abs(c1)+abs(c2)) \n         when (c1 is null) and (c2 is not null) then c2 \n         else null \n       end \"propensity_target_two\" \n  FROM ( \n    SELECT t.class \"target_attribute_value\",  \n           NVL2( attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\",  \n           s.attribute_name \"attribute_name\", s.attribute_value \"attribute_value\", s.coefficient \"coefficient\" \n    FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param, 0,:partitionId)) t, TABLE(t.attribute_set) s \n    <where_clause> \n  )\n   pivot(max(\"coefficient\") FOR \"target_attribute_value\" IN (<target_value_one> c1, <target_value_two> c2 ) ) \n  <where_clause_like> \n)\n) <order> \n) <rownum> \n";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param)) t, \n   TABLE(t.attribute_set) s \n   WHERE t.class IN(<target_values>)  ";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION_PARTITION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param,0,:partitionId)) t, \n   TABLE(t.attribute_set) s \n   WHERE t.class IN(<target_values>)  ";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_REGRESSION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param)) t, \n   TABLE(t.attribute_set) s ";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_REGRESSION_PARTITION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param, 0, :partitionId)) t, \n   TABLE(t.attribute_set) s ";
    private ConnectionManager connManager;
    private ModelDescriptor modelDesc;
    static final String QUERY_MIN_MAX = "SELECT  MAX(abs(coefficient)) maximum_value \nFROM TABLE(dbms_data_mining.get_model_details_svm('<model_name>')) t, TABLE(t.attribute_set) s";
    static final String QUERY_MIN_MAX_PARTITION = "SELECT  MAX(abs(coefficient)) maximum_value \nFROM TABLE(dbms_data_mining.get_model_details_svm('<model_name>',0,'<partitionId>')) t, TABLE(t.attribute_set) s";

    private static String createInternalWhereClause(FilterSetting filterSetting, String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = null;
        if (null != filterSetting.getTargetValue()) {
            stringBuilder = new StringBuilder();
            String string5 = null;
            string5 = filterSetting.getTargetValue() instanceof Number ? StringUtils.getReplacedString((String)" t.class = <target_value>", (String)"<target_value>", (String)string) : StringUtils.getReplacedString((String)" t.class = <target_value>", (String)"<target_value>", (String)("'" + string + "'"));
            stringBuilder.append("   WHERE ");
            stringBuilder.append(string5);
        }
        if (string2 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string2);
        }
        if (string2 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string2);
        }
        if (string3 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string3);
        }
        if (string4 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string4);
        }
        return stringBuilder != null ? stringBuilder.toString() : "";
    }

    public SVMModelDetailsImpl(ConnectionManager connectionManager, String string, String string2) {
        this.connManager = connectionManager;
        this.modelDesc = new ModelDescriptor(string, string2);
    }

    public void setPartitionId(String string) {
        this.modelDesc.setPartitionId(string);
    }

    private String getUserName() {
        return this.modelDesc.getSchema();
    }

    private String getModelName() {
        return this.modelDesc.getName();
    }

    private Vector<AttributeBiCoefficient> invokeItemPickerQuery(SQLHelper sQLHelper) throws SQLException {
        Vector<AttributeBiCoefficient> vector = new Vector<AttributeBiCoefficient>();
        try {
            sQLHelper.opstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string;
                String string2 = sQLHelper.rs.getString("attribute_name_subname");
                if (string2 == null) {
                    string2 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
                }
                if ((string = sQLHelper.rs.getString("attribute_value")) == null) {
                    string = "";
                }
                AttributeBiCoefficient attributeBiCoefficient = new AttributeBiCoefficient(string2, string, null, null);
                vector.add(attributeBiCoefficient);
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            vector.clear();
            throw sQLException;
        }
        return vector;
    }

    private Vector<AttributeBiCoefficient> invokeCoefficientQuery(SQLHelper sQLHelper) throws SQLException {
        Vector<AttributeBiCoefficient> vector = new Vector<AttributeBiCoefficient>();
        sQLHelper.opstmt.setFetchSize(1000);
        sQLHelper.rs = sQLHelper.opstmt.executeQuery();
        while (sQLHelper.rs.next()) {
            String string;
            String string2 = sQLHelper.rs.getString("attribute_name_subname");
            if (string2 == null) {
                string2 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
            }
            if ((string = sQLHelper.rs.getString("attribute_value")) == null) {
                string = "";
            }
            Double d = sQLHelper.rs.getDouble("coefficient");
            AttributeBiCoefficient attributeBiCoefficient = new AttributeBiCoefficient(string2, string, d);
            vector.add(attributeBiCoefficient);
        }
        return vector;
    }

    private String prepareCoefficientSQL(SQLHelper sQLHelper, FilterSetting filterSetting, String string, boolean bl) throws SQLException {
        String string2 = QRY_CLASSIFICATION_COEFFICIENTS;
        if (this.modelDesc.isPartitioned()) {
            string2 = QRY_CLASSIFICATION_COEFFICIENTS_PARTITION;
        }
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        StringBuilder stringBuilder = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string7 = "";
        Boolean bl2 = null;
        List list = null;
        if (filterSetting != null) {
            bl2 = filterSetting.getFilterAndSortByAbsolute();
            list = filterSetting.getSortSpecification();
            String string8 = string3 = bl ? "s.coefficient * -1 as coefficient" : "s.coefficient";
            if (filterSetting.getFetchSize() > 0) {
                string7 = " where rownum <= :fetch_size_param ";
            }
            if (list != null && list.size() > 0) {
                stringBuffer.append("order by ");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    SortSpec sortSpec = (SortSpec)iterator.next();
                    if (!sortSpec.isUseIt()) continue;
                    if (sortSpec.getAttributeName().equals("coefficient")) {
                        if (filterSetting.getFilterAndSortByAbsolute()) {
                            stringBuffer.append("ABS(\"" + sortSpec.getAttributeName() + "\") ");
                        } else {
                            stringBuffer.append("\"" + sortSpec.getAttributeName() + "\" ");
                        }
                    } else {
                        stringBuffer.append("\"" + sortSpec.getAttributeName() + "\" ");
                    }
                    if (sortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        string2 = StringUtils.getReplacedString((String)string2, (String)"<coefficient_value>", (String)string3);
        string2 = StringUtils.getReplacedString((String)string2, (String)"<internal_where_clause>", (String)SVMModelDetailsImpl.createInternalWhereClause(filterSetting, StringUtils.escapeSingleQuotesForSQL((String)string), string4, string5, string6));
        string2 = StringUtils.getReplacedString((String)string2, (String)"<order>", (String)stringBuffer.toString());
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder("");
        }
        string2 = StringUtils.getReplacedString((String)string2, (String)"<where_condition>", (String)stringBuilder.toString());
        string2 = StringUtils.getReplacedString((String)string2, (String)"<rownum>", (String)string7);
        sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string2);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), false));
        if (this.modelDesc.isPartitioned()) {
            sQLHelper.opstmt.setStringAtName("partitionId", "\"" + this.modelDesc.getPartitionId() + "\"");
        }
        if (string7.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", filterSetting.getFetchSize());
        }
        return string2;
    }

    private String prepareRegressionCoefficientSQL(SQLHelper sQLHelper, FilterSetting filterSetting, boolean bl) throws SQLException {
        String string = QRY_REGRESSION_COEFFICIENTS;
        if (StringUtils.isNotEmpty((String)this.modelDesc.getPartitionId())) {
            string = QRY_REGRESSION_COEFFICIENTS_PARTITION;
        }
        String string2 = "";
        String string3 = "";
        String string4 = "";
        StringBuilder stringBuilder = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string5 = "";
        Boolean bl2 = null;
        List list = null;
        if (filterSetting != null) {
            bl2 = filterSetting.getFilterAndSortByAbsolute();
            list = filterSetting.getSortSpecification();
            String string6 = string2 = bl ? "s.coefficient * -1 as coefficient" : "s.coefficient";
            if (filterSetting.getFetchSize() > 0) {
                string5 = " where rownum <= :fetch_size_param";
            }
            if (list != null && list.size() > 0) {
                stringBuffer.append("order by ");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    SortSpec sortSpec = (SortSpec)iterator.next();
                    if (!sortSpec.isUseIt()) continue;
                    if (sortSpec.getAttributeName().equals("coefficient")) {
                        if (filterSetting.getFilterAndSortByAbsolute()) {
                            stringBuffer.append("ABS(\"" + sortSpec.getAttributeName() + "\") ");
                        } else {
                            stringBuffer.append("\"" + sortSpec.getAttributeName() + "\" ");
                        }
                    } else {
                        stringBuffer.append("\"" + sortSpec.getAttributeName() + "\" ");
                    }
                    if (sortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        string = StringUtils.getReplacedString((String)string, (String)"<coefficient_value>", (String)string2);
        if (!string3.isEmpty() || !string4.isEmpty()) {
            string = StringUtils.getReplacedString((String)string, (String)"<where_key_word>", (String)"WHERE");
            if (string4.isEmpty()) {
                string = StringUtils.getReplacedString((String)string, (String)"<and2>", (String)string3);
                string = StringUtils.getReplacedString((String)string, (String)"<and3>", (String)string4);
            } else {
                string = StringUtils.getReplacedString((String)string, (String)"<and2>", (String)string3);
                string = StringUtils.getReplacedString((String)string, (String)"<and3>", (String)(" AND " + string4));
            }
        } else {
            string = StringUtils.getReplacedString((String)string, (String)"<where_key_word>", (String)"");
            string = StringUtils.getReplacedString((String)string, (String)"<and2>", (String)"");
            string = StringUtils.getReplacedString((String)string, (String)"<and3>", (String)"");
        }
        string = StringUtils.getReplacedString((String)string, (String)"<order>", (String)stringBuffer.toString());
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder("");
        }
        string = StringUtils.getReplacedString((String)string, (String)"<where_condition>", (String)stringBuilder.toString());
        string = StringUtils.getReplacedString((String)string, (String)"<rownum>", (String)string5);
        sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), false));
        if (this.modelDesc.isPartitioned()) {
            sQLHelper.opstmt.setStringAtName("partitionId", "\"" + this.modelDesc.getPartitionId() + "\"");
        }
        if (string5.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", filterSetting.getFetchSize());
        }
        return string;
    }

    private void prepareCoefficientSQLAll(SQLHelper sQLHelper, FilterSetting filterSetting) throws SQLException {
        String string = QRY_CLASSIFICATION_COEFFICIENTS_ALL;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        String string3 = null;
        String string4 = "";
        StringBuilder stringBuilder = null;
        String string5 = null;
        if (filterSetting != null) {
            List list;
            if (filterSetting.getFetchSize() > 0) {
                string2 = " WHERE rownum <= :fetch_size_param";
            }
            if ((list = filterSetting.getSortSpecification()) != null && list.size() > 0) {
                stringBuffer.append("order by ");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    SortSpec sortSpec = (SortSpec)iterator.next();
                    if (!sortSpec.isUseIt()) continue;
                    String string6 = sortSpec.getAttributeName();
                    if (string6.equals("attribute_name_subname")) {
                        string3 = "\"attribute_name_subname\", max(\"attribute_name\") \"attribute_name\", max(\"attribute_value\") \"attribute_value\"";
                        string4 = "GROUP BY \"attribute_name_subname\"";
                        stringBuffer.append("\"attribute_name_subname\"");
                    } else if (string6.equals("attribute_name")) {
                        string3 = "max(\"attribute_name_subname\") \"attribute_name_subname\", \"attribute_name\", max(\"attribute_value\") \"attribute_value\"";
                        string4 = "GROUP BY \"attribute_name\"";
                        stringBuffer.append("\"attribute_name\"");
                    } else if (string6.equals("attribute_value")) {
                        string3 = "\"attribute_name_subname\", \"attribute_name\", \"attribute_value\"";
                        stringBuffer.append("\"attribute_value\"");
                    }
                    if (sortSpec.isAscending()) {
                        stringBuffer.append(" ASC ");
                    } else {
                        stringBuffer.append(" DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
            string5 = null != filterSetting.getTargetValue() ? _TARGET_CONDITION : "";
        }
        string = StringUtils.getReplacedString((String)string, (String)"<select_stmt>", string3);
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder("");
        }
        string = StringUtils.getReplacedString((String)string, (String)"<name_filter_condition>", (String)stringBuilder.toString());
        string = StringUtils.getReplacedString((String)string, (String)"<target_condition>", (String)string5);
        string = StringUtils.getReplacedString((String)string, (String)"<order>", (String)stringBuffer.toString());
        string = StringUtils.getReplacedString((String)string, (String)"<group_by>", (String)string4);
        string = StringUtils.getReplacedString((String)string, (String)"<rownum>", (String)string2);
        sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), false));
        if (string2.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", filterSetting.getFetchSize());
        }
        if (string5.length() > 0) {
            sQLHelper.opstmt.setStringAtName("target_value_param", filterSetting.getTargetValue().toString());
        }
    }

    @Override
    public List<AttributeBiCoefficient> getAllCoefficients(FilterSetting filterSetting) throws ODMrDAOException {
        ArrayList<AttributeBiCoefficient> arrayList = new ArrayList();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this.connManager.getConnection();
            this.prepareCoefficientSQLAll(sQLHelper, filterSetting);
            arrayList = this.invokeItemPickerQuery(sQLHelper);
        }
        return arrayList;
    }

    public List<AttributeBiCoefficient> getRegressionCoefficients(FilterSetting filterSetting) throws ODMrDAOException {
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this.connManager.getConnection();
            this.prepareRegressionCoefficientSQL(sQLHelper, filterSetting, false);
            Vector<AttributeBiCoefficient> vector = this.invokeCoefficientQuery(sQLHelper);
            return vector;
        }
    }

    public List<AttributeBiCoefficient> getAnomalyCoefficients(FilterSetting filterSetting) throws ODMrDAOException {
        AbstractList abstractList = new ArrayList();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this.connManager.getConnection();
            if (filterSetting.isBinaryClassModel()) {
                this.prepareCoefficientSQL(sQLHelper, filterSetting, filterSetting.getTargetValue() != null ? filterSetting.getTargetValue().toString() : "", false);
                abstractList = this.invokeCoefficientQuery(sQLHelper);
                if (abstractList.size() == 0) {
                    this.prepareCoefficientSQL(sQLHelper, filterSetting, filterSetting.getAnomalyNonSelectedBinaryClassValue().toString(), true);
                    abstractList = this.invokeCoefficientQuery(sQLHelper);
                }
            } else {
                this.prepareCoefficientSQL(sQLHelper, filterSetting, StringUtils.toString((Object)filterSetting.getTargetValue()), false);
                abstractList = this.invokeCoefficientQuery(sQLHelper);
            }
        }
        return abstractList;
    }

    @Override
    public List<AttributeBiCoefficient> getCoefficients(FilterSetting filterSetting) throws ODMrDAOException {
        AbstractList abstractList = new ArrayList();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this.connManager.getConnection();
            if (filterSetting.isBinaryClassModel()) {
                this.prepareCoefficientSQL(sQLHelper, filterSetting, StringUtils.toString((Object)filterSetting.getTargetValue()), false);
                abstractList = this.invokeCoefficientQuery(sQLHelper);
                if (abstractList.size() == 0) {
                    this.prepareCoefficientSQL(sQLHelper, filterSetting, filterSetting.getNonSelectedBinaryClassValue().toString(), true);
                    abstractList = this.invokeCoefficientQuery(sQLHelper);
                }
            } else {
                this.prepareCoefficientSQL(sQLHelper, filterSetting, filterSetting.getTargetValue() != null ? filterSetting.getTargetValue().toString() : "", false);
                abstractList = this.invokeCoefficientQuery(sQLHelper);
            }
        }
        return abstractList;
    }

    public Integer getTotalCountCoefficients() throws ODMrDAOException {
        Integer n = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this.connManager.getConnection();
            this.prepareTotalCountCoefficientsRegressionQuery(sQLHelper);
            n = this.invokeTotalCountCoefficientsQuery(sQLHelper);
        }
        return n;
    }

    public Integer getTotalCountCoefficients(List<Object> list, FilterSetting filterSetting) throws SQLException {
        assert (list != null) : "Must provide a non null collection of target values.";
        assert (list != null && list.size() > 0) : "Must provide at least one target value";
        Integer n = null;
        SQLHelper sQLHelper = new SQLHelper();
        sQLHelper.conn = this.connManager.getConnection();
        if (filterSetting.isBinaryClassModel()) {
            this.prepareTotalCountCoefficientsClassificationQuery(sQLHelper, list);
            n = this.invokeTotalCountCoefficientsQuery(sQLHelper);
            if (n == 0) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(filterSetting.getNonSelectedBinaryClassValue());
                this.prepareTotalCountCoefficientsClassificationQuery(sQLHelper, arrayList);
                n = this.invokeTotalCountCoefficientsQuery(sQLHelper);
            }
        } else {
            this.prepareTotalCountCoefficientsClassificationQuery(sQLHelper, list);
            n = this.invokeTotalCountCoefficientsQuery(sQLHelper);
        }
        return n;
    }

    public Map<String, Object> getCoefficientStatistics(List<Object> list, FilterSetting filterSetting) throws SQLException {
        assert (list != null) : "Must provide a non null collection of target values.";
        assert (list != null && list.size() > 0) : "Must provide at least one target value";
        Map<String, Object> map = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this.connManager.getConnection();
            if (filterSetting.isBinaryClassModel()) {
                this.prepareTotalCountCoefficientsClassificationQuery(sQLHelper, list);
                map = this.invokeCoefficientsStatisticsQuery(sQLHelper);
                Integer n = (Integer)map.get("TOTAL_COEFFICIENTS");
                if (n == 0) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(filterSetting.getNonSelectedBinaryClassValue());
                    this.prepareTotalCountCoefficientsClassificationQuery(sQLHelper, arrayList);
                    map = this.invokeCoefficientsStatisticsQuery(sQLHelper);
                }
            } else {
                this.prepareTotalCountCoefficientsClassificationQuery(sQLHelper, list);
                map = this.invokeCoefficientsStatisticsQuery(sQLHelper);
            }
        }
        return map;
    }

    public Map<String, Object> getCoefficientStatistics() throws ODMrDAOException {
        Map<String, Object> map = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this.connManager.getConnection();
            this.prepareTotalCountCoefficientsRegressionQuery(sQLHelper);
            map = this.invokeCoefficientsStatisticsQuery(sQLHelper);
        }
        return map;
    }

    private void prepareTotalCountCoefficientsClassificationQuery(SQLHelper sQLHelper, List<Object> list) throws SQLException {
        String string = QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION;
        if (this.modelDesc.isPartitioned()) {
            string = QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION_PARTITION;
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        boolean bl = list.get(0) instanceof String;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        int n = 0;
        for (Object object : list) {
            ++n;
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(":target_value_");
            stringBuilder.append(n);
            hashMap.put(object, n);
        }
        string = StringUtils.getReplacedString((String)string, (String)"<target_values>", (String)stringBuilder.toString());
        sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), false));
        if (this.modelDesc.isPartitioned()) {
            sQLHelper.opstmt.setStringAtName("partitionId", "\"" + this.modelDesc.getPartitionId() + "\"");
        }
        if (bl) {
            for (Map.Entry entry : hashMap.entrySet()) {
                String string2 = "target_value_" + ((Integer)entry.getValue()).toString();
                String string3 = entry.getKey().toString();
                sQLHelper.opstmt.setStringAtName(string2, string3);
            }
        } else {
            for (Map.Entry entry : hashMap.entrySet()) {
                Object object;
                String string4 = "target_value_" + ((Integer)entry.getValue()).toString();
                Object k = entry.getKey();
                if (k instanceof BigDecimal) {
                    object = (BigDecimal)k;
                    sQLHelper.opstmt.setBigDecimalAtName(string4, (BigDecimal)object);
                    continue;
                }
                if (k instanceof Float) {
                    object = (Float)k;
                    sQLHelper.opstmt.setFloatAtName(string4, ((Float)object).floatValue());
                    continue;
                }
                if (k instanceof Double) {
                    object = (Double)k;
                    sQLHelper.opstmt.setDoubleAtName(string4, ((Double)object).doubleValue());
                    continue;
                }
                if (k instanceof Integer) {
                    object = (Integer)k;
                    sQLHelper.opstmt.setIntAtName(string4, ((Integer)object).intValue());
                    continue;
                }
                if (k instanceof Short) {
                    object = (Short)k;
                    sQLHelper.opstmt.setShortAtName(string4, ((Short)object).shortValue());
                    continue;
                }
                if (k instanceof Byte) {
                    object = (Byte)k;
                    sQLHelper.opstmt.setByteAtName(string4, ((Byte)object).byteValue());
                    continue;
                }
                object = k.toString();
                sQLHelper.opstmt.setStringAtName(string4, (String)object);
            }
        }
    }

    private void prepareTotalCountCoefficientsRegressionQuery(SQLHelper sQLHelper) throws SQLException {
        String string = QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_REGRESSION;
        if (this.modelDesc.isPartitioned()) {
            string = QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_REGRESSION_PARTITION;
        }
        sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), false));
        if (this.modelDesc.isPartitioned()) {
            sQLHelper.opstmt.setStringAtName("partitionId", "\"" + this.modelDesc.getPartitionId() + "\"");
        }
    }

    private Integer invokeTotalCountCoefficientsQuery(SQLHelper sQLHelper) throws SQLException {
        Integer n = 0;
        sQLHelper.rs = sQLHelper.opstmt.executeQuery();
        if (sQLHelper.rs.next()) {
            n = sQLHelper.rs.getInt("TOTAL_COEFFICIENTS");
        }
        return n;
    }

    private Map<String, Object> invokeCoefficientsStatisticsQuery(SQLHelper sQLHelper) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        sQLHelper.rs = sQLHelper.opstmt.executeQuery();
        if (sQLHelper.rs.next()) {
            Integer n = sQLHelper.rs.getInt("TOTAL_COEFFICIENTS");
            hashMap.put("TOTAL_COEFFICIENTS", n);
            Double d = sQLHelper.rs.getDouble("MAXIMUM_ABS_COEFFICIENT_VALUE");
            hashMap.put("MAXIMUM_ABS_COEFFICIENT_VALUE", d);
        } else {
            hashMap.put("TOTAL_COEFFICIENTS", 0);
            hashMap.put("MAXIMUM_ABS_COEFFICIENT_VALUE", 0.0);
        }
        return hashMap;
    }

    @Override
    public List<SVMBiasRowData> getBiases() throws ODMrDAOException {
        return this.invokeBiasQuery(null);
    }

    @Override
    public SVMBiasRowData getBias(String string) throws ODMrDAOException {
        return this.invokeBiasQuery(string).get(0);
    }

    private List<SVMBiasRowData> invokeBiasQuery(String string) throws ODMrDAOException {
        String string2 = "SELECT t.class,       s.coefficient as bias   FROM TABLE(dbms_data_mining.get_model_details_svm('<model_name>')) t,      TABLE(t.attribute_set) s    WHERE    attribute_name IS NULL <target_value>   ORDER BY \"CLASS\" ASC";
        ArrayList<SVMBiasRowData> arrayList = new ArrayList<SVMBiasRowData>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            string2 = StringUtils.getReplacedString((String)string2, (String)"<model_name>", (String)Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), true));
            string2 = string != null ? (string.trim().length() != 0 ? StringUtils.getReplacedString((String)string2, (String)"<target_value>", (String)(" AND t.class = '" + string + "'")) : StringUtils.getReplacedString((String)string2, (String)"<target_value>", (String)" ")) : StringUtils.getReplacedString((String)string2, (String)"<target_value>", (String)" ");
            sQLHelper.conn = this.connManager.getConnection();
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.stmt.setFetchSize(200);
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string2);
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString("class");
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal("bias");
                SVMBiasRowData sVMBiasRowData = new SVMBiasRowData(string3, bigDecimal);
                arrayList.add(sVMBiasRowData);
            }
        }
        return arrayList;
    }

    @Override
    public boolean isGuasian(List<MiningModelSettings> list) {
        MiningModelSettings miningModelSettings = MiningModelSettings.findSetting((String)"SVMS_KERNEL_FUNCTION", list);
        return miningModelSettings.getSettingValue().equals("SVMS_GAUSSIAN");
    }

    @Override
    public boolean isLinear(List<MiningModelSettings> list) {
        MiningModelSettings miningModelSettings = MiningModelSettings.findSetting((String)"SVMS_KERNEL_FUNCTION", list);
        return miningModelSettings.getSettingValue().equals("SVMS_LINEAR");
    }

    public Integer getTotalCountPropensities(FilterSetting filterSetting) throws SQLException {
        Integer n = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this.connManager.getConnection();
            if (filterSetting.isBinaryClassModel()) {
                this.prepareBinaryPropensitiesSQL(sQLHelper, filterSetting, true);
                n = this.invokeCompareCountQuery(sQLHelper);
            } else {
                this.prepareMultiTargetPropensitiesSQL(sQLHelper, filterSetting, true);
                n = this.invokeCompareCountQuery(sQLHelper);
            }
        }
        return n;
    }

    public List<AttributeBiCoefficient> getPropensities(FilterSetting filterSetting) throws ODMrDAOException {
        ArrayList<AttributeBiCoefficient> arrayList = new ArrayList();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this.connManager.getConnection();
            if (filterSetting.isBinaryClassModel()) {
                this.prepareBinaryPropensitiesSQL(sQLHelper, filterSetting, false);
                arrayList = this.invokeCompareQuery(sQLHelper, true);
            } else {
                this.prepareMultiTargetPropensitiesSQL(sQLHelper, filterSetting, false);
                arrayList = this.invokeCompareQuery(sQLHelper, false);
            }
        }
        return arrayList;
    }

    private String prepareBinaryPropensitiesSQL(SQLHelper sQLHelper, FilterSetting filterSetting, boolean bl) throws SQLException {
        boolean bl2;
        String string = QRY_ALL_PROPENSITIES_BINARY;
        if (this.modelDesc.isPartitioned()) {
            string = QRY_ALL_PROPENSITIES_BINARY_PARTITION;
        }
        StringBuilder stringBuilder = null;
        StringBuilder stringBuilder2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuilder stringBuilder3 = new StringBuilder();
        Boolean bl3 = null;
        List list = null;
        if (filterSetting != null) {
            bl3 = filterSetting.getFilterAndSortByAbsolute();
            list = filterSetting.getSortSpecification();
            if (filterSetting.getFetchSize() > 0) {
                stringBuilder3.append(" WHERE rownum <= :fetch_size_param ");
            }
            if (list != null && list.size() > 0) {
                stringBuffer.append("order by ");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    SortSpec sortSpec = (SortSpec)iterator.next();
                    if (!sortSpec.isUseIt()) continue;
                    if (sortSpec.getAttributeName().equals("coefficient")) {
                        if (filterSetting.getFilterAndSortByAbsolute()) {
                            stringBuffer.append("ABS(\"" + sortSpec.getAttributeName() + "\") ");
                        } else {
                            stringBuffer.append("\"" + sortSpec.getAttributeName() + "\" ");
                        }
                    } else {
                        stringBuffer.append("\"" + sortSpec.getAttributeName() + "\" ");
                    }
                    if (sortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        if (bl2 = filterSetting.getTargetValue() instanceof Number) {
            string = StringUtils.getReplacedString((String)string, (String)"<target_value_one>", (String)filterSetting.getTargetValue().toString());
            string = StringUtils.getReplacedString((String)string, (String)"<target_value_two>", (String)filterSetting.getSecondTargetValue().toString());
        } else {
            string = StringUtils.getReplacedString((String)string, (String)"<target_value_one>", (String)("'" + StringUtils.escapeSingleQuotesForSQL((String)filterSetting.getTargetValue().toString()) + "'"));
            string = StringUtils.getReplacedString((String)string, (String)"<target_value_two>", (String)("'" + StringUtils.escapeSingleQuotesForSQL((String)filterSetting.getSecondTargetValue().toString()) + "'"));
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(" ");
        }
        string = StringUtils.getReplacedString((String)string, (String)"<where_clause>", (String)stringBuilder.toString());
        string = StringUtils.getReplacedString((String)string, (String)"<where_clause_like>", (String)(stringBuilder2 != null ? stringBuilder2.toString() : ""));
        string = StringUtils.getReplacedString((String)string, (String)"<order>", (String)stringBuffer.toString());
        string = filterSetting.getFilterAndSortByAbsolute() ? StringUtils.getReplacedString((String)string, (String)"<ABSOLUTE_VALUE>", (String)"ABS") : StringUtils.getReplacedString((String)string, (String)"<ABSOLUTE_VALUE>", (String)" ");
        if (bl) {
            string = StringUtils.getReplacedString((String)string, (String)"<COUNT_ONLY>", (String)"COUNT(*) TOTAL_PROPENSITIES");
            string = StringUtils.getReplacedString((String)string, (String)"<rownum>", (String)" ");
        } else {
            string = StringUtils.getReplacedString((String)string, (String)"<COUNT_ONLY>", (String)"*");
            string = StringUtils.getReplacedString((String)string, (String)"<rownum>", (String)stringBuilder3.toString());
        }
        sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), false));
        if (this.modelDesc.isPartitioned()) {
            sQLHelper.opstmt.setStringAtName("partitionId", "\"" + this.modelDesc.getPartitionId() + "\"");
        }
        if (!bl && stringBuilder3.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", filterSetting.getFetchSize());
        }
        return string;
    }

    private Vector<AttributeBiCoefficient> invokeCompareQuery(SQLHelper sQLHelper, boolean bl) throws SQLException {
        Vector<AttributeBiCoefficient> vector = new Vector<AttributeBiCoefficient>();
        sQLHelper.opstmt.setFetchSize(1000);
        sQLHelper.rs = sQLHelper.opstmt.executeQuery();
        while (sQLHelper.rs.next()) {
            String string;
            String string2 = sQLHelper.rs.getString("attribute_name_subname");
            if (string2 == null) {
                string2 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
            }
            if ((string = sQLHelper.rs.getString("attribute_value")) == null) {
                string = "";
            }
            BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal("propensity_target_one");
            BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal("propensity_target_two");
            if (bl) {
                if (bigDecimal == null && bigDecimal2 != null) {
                    bigDecimal = new BigDecimal(-1.0 * bigDecimal2.doubleValue());
                } else if (bigDecimal2 == null && bigDecimal != null) {
                    bigDecimal2 = new BigDecimal(-1.0 * bigDecimal.doubleValue());
                }
            }
            AttributeBiCoefficient attributeBiCoefficient = new AttributeBiCoefficient(string2, string, bigDecimal != null ? Double.valueOf(bigDecimal.doubleValue()) : null, bigDecimal2 != null ? Double.valueOf(bigDecimal2.doubleValue()) : null);
            vector.add(attributeBiCoefficient);
        }
        return vector;
    }

    private Integer invokeCompareCountQuery(SQLHelper sQLHelper) throws SQLException {
        Integer n = null;
        sQLHelper.rs = sQLHelper.opstmt.executeQuery();
        sQLHelper.rs.next();
        n = sQLHelper.rs.getInt("TOTAL_PROPENSITIES");
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double getAbsMaxValue() {
        String string;
        SQLHelper sQLHelper = new SQLHelper();
        Double d = null;
        if (this.modelDesc.isPartitioned()) {
            string = StringUtils.getReplacedString((String)QUERY_MIN_MAX_PARTITION, (String)"<model_name>", (String)Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), true));
            string = StringUtils.getReplacedString((String)string, (String)"<partitionId>", (String)("\"" + this.modelDesc.getPartitionId() + "\""));
        } else {
            string = StringUtils.getReplacedString((String)QUERY_MIN_MAX, (String)"<model_name>", (String)Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), true));
        }
        try {
            sQLHelper.conn = this.connManager.getConnection();
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string);
            if (sQLHelper.rs.next()) {
                d = sQLHelper.rs.getDouble(1);
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            d = 0.0;
        }
        finally {
            sQLHelper.close();
        }
        return d;
    }

    private void prepareMultiTargetPropensitiesSQL(SQLHelper sQLHelper, FilterSetting filterSetting, boolean bl) throws SQLException {
        boolean bl2;
        String string = QRY_ALL_PROPENSITIES_MULTI;
        if (this.modelDesc.isPartitioned()) {
            string = QRY_ALL_PROPENSITIES_MULTI_PARTITION;
        }
        StringBuilder stringBuilder = null;
        StringBuilder stringBuilder2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuilder stringBuilder3 = new StringBuilder();
        Boolean bl3 = null;
        List list = null;
        if (filterSetting != null) {
            bl3 = filterSetting.getFilterAndSortByAbsolute();
            list = filterSetting.getSortSpecification();
            if (filterSetting.getFetchSize() > 0) {
                stringBuilder3.append(" WHERE rownum <= :fetch_size_param ");
            }
            if (list != null && list.size() > 0) {
                stringBuffer.append("order by ");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    SortSpec sortSpec = (SortSpec)iterator.next();
                    if (!sortSpec.isUseIt()) continue;
                    if (sortSpec.getAttributeName().equals("coefficient")) {
                        if (filterSetting.getFilterAndSortByAbsolute()) {
                            stringBuffer.append("ABS(\"" + sortSpec.getAttributeName() + "\") ");
                        } else {
                            stringBuffer.append("\"" + sortSpec.getAttributeName() + "\" ");
                        }
                    } else {
                        stringBuffer.append("\"" + sortSpec.getAttributeName() + "\" ");
                    }
                    if (sortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        if (bl2 = filterSetting.getTargetValue() instanceof Number) {
            string = StringUtils.getReplacedString((String)string, (String)"<target_value_one>", (String)filterSetting.getTargetValue().toString());
            string = StringUtils.getReplacedString((String)string, (String)"<target_value_two>", (String)filterSetting.getSecondTargetValue().toString());
        } else {
            string = StringUtils.getReplacedString((String)string, (String)"<target_value_one>", (String)("'" + StringUtils.escapeSingleQuotesForSQL((String)filterSetting.getTargetValue().toString()) + "'"));
            string = StringUtils.getReplacedString((String)string, (String)"<target_value_two>", (String)("'" + StringUtils.escapeSingleQuotesForSQL((String)filterSetting.getSecondTargetValue().toString()) + "'"));
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(" ");
        }
        if (stringBuilder2 != null) {
            stringBuilder2.append(" AND (c1 is not null or c2 is not null) ");
        } else {
            stringBuilder2 = new StringBuilder(" where c1 is not null or c2 is not null ");
        }
        string = StringUtils.getReplacedString((String)string, (String)"<where_clause>", (String)stringBuilder.toString());
        string = StringUtils.getReplacedString((String)string, (String)"<where_clause_like>", (String)stringBuilder2.toString());
        string = StringUtils.getReplacedString((String)string, (String)"<order>", (String)stringBuffer.toString());
        string = filterSetting.getFilterAndSortByAbsolute() ? StringUtils.getReplacedString((String)string, (String)"<ABSOLUTE_VALUE>", (String)"ABS") : StringUtils.getReplacedString((String)string, (String)"<ABSOLUTE_VALUE>", (String)" ");
        if (bl) {
            string = StringUtils.getReplacedString((String)string, (String)"<COUNT_ONLY>", (String)"COUNT(*) TOTAL_PROPENSITIES");
            string = StringUtils.getReplacedString((String)string, (String)"<rownum>", (String)" ");
        } else {
            string = StringUtils.getReplacedString((String)string, (String)"<COUNT_ONLY>", (String)"*");
            string = StringUtils.getReplacedString((String)string, (String)"<rownum>", (String)stringBuilder3.toString());
        }
        sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), false));
        if (this.modelDesc.isPartitioned()) {
            sQLHelper.opstmt.setStringAtName("partitionId", "\"" + this.modelDesc.getPartitionId() + "\"");
        }
        if (!bl && stringBuilder3.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", filterSetting.getFetchSize());
        }
    }
}

