/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.model.CoreServerConstantsLrb;
import oracle.dmt.dataminer.core.utils.comparator.ToStringComparator;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.javatools.util.Version;

public final class MiningAlgorithmOptions
extends Enum<MiningAlgorithmOptions> {
    public static final /* enum */ MiningAlgorithmOptions ALL = new MiningAlgorithmOptions(CoreServerConstantsLrb.get((String)"ALGO_ALL_ALGORITHMS"));
    public static final /* enum */ MiningAlgorithmOptions APRIORI = new MiningAlgorithmOptions(CoreServerConstantsLrb.get((String)"ALGO_APRIORI_ASSOCIATION_RULES"));
    public static final /* enum */ MiningAlgorithmOptions DECISION_TREE = new MiningAlgorithmOptions(CoreServerConstantsLrb.get((String)"ALGO_DECISION_TREE"));
    public static final /* enum */ MiningAlgorithmOptions GENERALIZED_LINEAR_MODEL = new MiningAlgorithmOptions(CoreServerConstantsLrb.get((String)"ALGO_GENERALIZED_LINEAR_MODEL"));
    public static final /* enum */ MiningAlgorithmOptions KMEANS = new MiningAlgorithmOptions(CoreServerConstantsLrb.get((String)"ALGO_KMEANS"));
    public static final /* enum */ MiningAlgorithmOptions NAIVE_BAYES = new MiningAlgorithmOptions(CoreServerConstantsLrb.get((String)"ALGO_NAIVE_BAYES"));
    public static final /* enum */ MiningAlgorithmOptions NON_NEGATIVE_MATRIX_FACTORIZATION = new MiningAlgorithmOptions(CoreServerConstantsLrb.get((String)"ALGO_NONNEGATIVE_MATRIX_FACTOR"));
    public static final /* enum */ MiningAlgorithmOptions SINGULAR_VALUE_DECOMP = new MiningAlgorithmOptions(CoreServerConstantsLrb.get((String)"ALGO_SINGULAR_VALUE_DECOMP"));
    public static final /* enum */ MiningAlgorithmOptions PRINCIPAL_COMPONENT_ANALYSIS = new MiningAlgorithmOptions(CoreServerConstantsLrb.get((String)"ALGO_PRINCIPAL_COMPONENT_ANALYSIS"));
    public static final /* enum */ MiningAlgorithmOptions OCLUSTER = new MiningAlgorithmOptions(CoreServerConstantsLrb.get((String)"ALGO_O_CLUSTER"));
    public static final /* enum */ MiningAlgorithmOptions EXPECTATION_MAXIMIZATION = new MiningAlgorithmOptions(CoreServerConstantsLrb.get((String)"ALGO_EXPECTATION_MAXIMIZATION"));
    public static final /* enum */ MiningAlgorithmOptions SUPPORT_VECTOR_MACHINE = new MiningAlgorithmOptions(CoreServerConstantsLrb.get((String)"ALGO_SUPPORT_VECTOR_MACHINE"));
    public static final /* enum */ MiningAlgorithmOptions EXPLICIT_SEMANTIC_ANALYSIS = new MiningAlgorithmOptions(CoreServerConstantsLrb.get((String)"ALGO_EXPLICIT_SEMANTIC_ANALYS"));
    public static final /* enum */ MiningAlgorithmOptions R_EXTENSIBLE = new MiningAlgorithmOptions(CoreServerConstantsLrb.get((String)"ALGO_R_USER_DEFINED"));
    private final String translation;
    private static final Map<String, MiningAlgorithmOptions> stringToEnum;
    private static final /* synthetic */ MiningAlgorithmOptions[] $VALUES;

    public static MiningAlgorithmOptions[] values() {
        return (MiningAlgorithmOptions[])$VALUES.clone();
    }

    public static MiningAlgorithmOptions valueOf(String string) {
        return Enum.valueOf(MiningAlgorithmOptions.class, string);
    }

    private MiningAlgorithmOptions(String string2) {
        this.translation = string2;
    }

    public static MiningAlgorithmOptions fromString(String string) {
        return stringToEnum.get(string);
    }

    public String toString() {
        return this.translation;
    }

    public static List<MiningAlgorithmOptions> getMiningAlgorithmOptions(Version version, MiningFunctions miningFunctions) {
        assert (version != null) : "Version cannot be null";
        ArrayList<MiningAlgorithmOptions> arrayList = new ArrayList<MiningAlgorithmOptions>();
        if (miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION)) {
            arrayList.add(SUPPORT_VECTOR_MACHINE);
        } else if (miningFunctions.equals((Object)MiningFunctions.ASSOCIATION_RULES)) {
            arrayList.add(APRIORI);
        } else if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
            arrayList.add(ALL);
            arrayList.add(NAIVE_BAYES);
            arrayList.add(DECISION_TREE);
            arrayList.add(SUPPORT_VECTOR_MACHINE);
            arrayList.add(GENERALIZED_LINEAR_MODEL);
            if (DbVersionHelper.isDB122Up((Version)version)) {
                arrayList.add(R_EXTENSIBLE);
            }
        } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
            arrayList.add(ALL);
            arrayList.add(SUPPORT_VECTOR_MACHINE);
            arrayList.add(GENERALIZED_LINEAR_MODEL);
            if (DbVersionHelper.isDB122Up((Version)version)) {
                arrayList.add(R_EXTENSIBLE);
            }
        } else if (miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            arrayList.add(ALL);
            arrayList.add(KMEANS);
            arrayList.add(OCLUSTER);
            if (DbVersionHelper.isDB121Up((Version)version)) {
                arrayList.add(EXPECTATION_MAXIMIZATION);
                if (DbVersionHelper.isDB122Up((Version)version)) {
                    arrayList.add(R_EXTENSIBLE);
                }
            }
        } else if (miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION)) {
            arrayList.add(ALL);
            arrayList.add(NON_NEGATIVE_MATRIX_FACTORIZATION);
            if (DbVersionHelper.isDB121Up((Version)version)) {
                arrayList.add(SINGULAR_VALUE_DECOMP);
                arrayList.add(PRINCIPAL_COMPONENT_ANALYSIS);
                if (DbVersionHelper.isDB122Up((Version)version)) {
                    arrayList.add(EXPLICIT_SEMANTIC_ANALYSIS);
                    arrayList.add(R_EXTENSIBLE);
                }
            }
        }
        Collections.sort(arrayList, ToStringComparator.getComparator());
        return arrayList;
    }

    public static MiningAlgorithmOptions getPreferredAlgorithmOptionForModelDetailsNode(AbstractNode abstractNode, MiningFunctions miningFunctions) {
        MiningAlgorithmOptions miningAlgorithmOptions = null;
        if (miningFunctions == null) {
            return miningAlgorithmOptions;
        }
        if (MetaDataHelper.isExtensibleBuildNode(abstractNode)) {
            miningAlgorithmOptions = R_EXTENSIBLE;
        } else if (miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION)) {
            miningAlgorithmOptions = SUPPORT_VECTOR_MACHINE;
        } else if (miningFunctions.equals((Object)MiningFunctions.ASSOCIATION_RULES)) {
            miningAlgorithmOptions = APRIORI;
        } else if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
            miningAlgorithmOptions = ALL;
        } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
            miningAlgorithmOptions = ALL;
        } else if (miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            miningAlgorithmOptions = ALL;
        } else if (miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION)) {
            miningAlgorithmOptions = NON_NEGATIVE_MATRIX_FACTORIZATION;
        }
        return miningAlgorithmOptions;
    }

    public static MiningAlgorithmType getMiningAlgorithmType(MiningAlgorithmOptions miningAlgorithmOptions) {
        assert (miningAlgorithmOptions != null) : "Algorithm Type cannot be null";
        switch (miningAlgorithmOptions) {
            case ALL: {
                return MiningAlgorithmType.ALL;
            }
            case APRIORI: {
                return MiningAlgorithmType.APRIORI_ASSOCIATION_RULES;
            }
            case DECISION_TREE: {
                return MiningAlgorithmType.DECISION_TREE;
            }
            case EXPECTATION_MAXIMIZATION: {
                return MiningAlgorithmType.EXPECTATION_MAXIMIZATION;
            }
            case GENERALIZED_LINEAR_MODEL: {
                return MiningAlgorithmType.GENERALIZED_LINEAR_MODEL;
            }
            case KMEANS: {
                return MiningAlgorithmType.KMEANS;
            }
            case NAIVE_BAYES: {
                return MiningAlgorithmType.NAIVE_BAYES;
            }
            case NON_NEGATIVE_MATRIX_FACTORIZATION: {
                return MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR;
            }
            case OCLUSTER: {
                return MiningAlgorithmType.O_CLUSTER;
            }
            case SUPPORT_VECTOR_MACHINE: {
                return MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
            }
            case SINGULAR_VALUE_DECOMP: {
                return MiningAlgorithmType.SINGULAR_VALUE_DECOMP;
            }
            case PRINCIPAL_COMPONENT_ANALYSIS: {
                return MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS;
            }
            case EXPLICIT_SEMANTIC_ANALYSIS: {
                return MiningAlgorithmType.EXPLICIT_SEMANTIC_ANALYSIS;
            }
            case R_EXTENSIBLE: {
                return MiningAlgorithmType.R_EXTENSIBLE;
            }
        }
        assert (false);
        return null;
    }

    public static MiningAlgorithmOptions getMiningAlgorithmOption(MiningAlgorithmType miningAlgorithmType) {
        MiningAlgorithmOptions miningAlgorithmOptions = null;
        if (miningAlgorithmType == null) {
            return miningAlgorithmOptions;
        }
        if (miningAlgorithmType.equals((Object)MiningAlgorithmType.ALL)) {
            miningAlgorithmOptions = ALL;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.APRIORI_ASSOCIATION_RULES)) {
            miningAlgorithmOptions = APRIORI;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.DECISION_TREE)) {
            miningAlgorithmOptions = DECISION_TREE;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.EXPECTATION_MAXIMIZATION)) {
            miningAlgorithmOptions = EXPECTATION_MAXIMIZATION;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.GENERALIZED_LINEAR_MODEL)) {
            miningAlgorithmOptions = GENERALIZED_LINEAR_MODEL;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.KMEANS)) {
            miningAlgorithmOptions = KMEANS;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.NAIVE_BAYES)) {
            miningAlgorithmOptions = NAIVE_BAYES;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR)) {
            miningAlgorithmOptions = NON_NEGATIVE_MATRIX_FACTORIZATION;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.O_CLUSTER)) {
            miningAlgorithmOptions = OCLUSTER;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.SUPPORT_VECTOR_MACHINES)) {
            miningAlgorithmOptions = SUPPORT_VECTOR_MACHINE;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.SINGULAR_VALUE_DECOMP)) {
            miningAlgorithmOptions = SINGULAR_VALUE_DECOMP;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS)) {
            miningAlgorithmOptions = PRINCIPAL_COMPONENT_ANALYSIS;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.EXPLICIT_SEMANTIC_ANALYSIS)) {
            miningAlgorithmOptions = EXPLICIT_SEMANTIC_ANALYSIS;
        } else if (miningAlgorithmType.equals((Object)MiningAlgorithmType.R_EXTENSIBLE)) {
            miningAlgorithmOptions = R_EXTENSIBLE;
        }
        return miningAlgorithmOptions;
    }

    static {
        $VALUES = new MiningAlgorithmOptions[]{ALL, APRIORI, DECISION_TREE, GENERALIZED_LINEAR_MODEL, KMEANS, NAIVE_BAYES, NON_NEGATIVE_MATRIX_FACTORIZATION, SINGULAR_VALUE_DECOMP, PRINCIPAL_COMPONENT_ANALYSIS, OCLUSTER, EXPECTATION_MAXIMIZATION, SUPPORT_VECTOR_MACHINE, EXPLICIT_SEMANTIC_ANALYSIS, R_EXTENSIBLE};
        stringToEnum = new HashMap<String, MiningAlgorithmOptions>();
        for (MiningAlgorithmOptions miningAlgorithmOptions : MiningAlgorithmOptions.values()) {
            stringToEnum.put(miningAlgorithmOptions.toString(), miningAlgorithmOptions);
        }
    }
}

