/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.clus.common.GetClusterModelDetailsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clus.common.GetDivergenceHistogramCentroidQuery;
import oracle.dmt.dataminer.core.model.clus.ClusteringAlgorithm;
import oracle.dmt.dataminer.core.model.clus.ClusteringDetailRow;
import oracle.dmt.dataminer.core.model.clus.compare.CompareClustersModelRow;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.model.generated.server.DmHistograms;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModelRow;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentData;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentModelRow;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentProjectionItem;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.ClusteringDetailRowShort;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.dmt.dataminer.server.model.GlobalDetails;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;

public class ClusteringDetailsImpl {
    private static final Logger theLogger = Logger.getLogger(ClusteringDetailsImpl.class.getName());
    private ConnectionManager connManager;
    private ModelDescriptor modelDesc;
    private SqlDataAccessObject dao;
    private ClusteringAlgorithm algorithmType;
    private static String CLUSTER_DETAILS_QUERY_NEW = "WITH dup_attributes AS\n  (SELECT a.id            ,\n    a.cluster_id          ,\n    a.rule.rule_id        ,\n    r.attribute_name      ,\n    r.attribute_subname   ,\n    r.attribute_support   ,\n    r.attribute_confidence,\n    NVL2(r.attribute_subname, r.attribute_name\n    || '.'\n    || r.attribute_subname, r.attribute_name) attribute_name_subname\n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS1>)a,\n    TABLE(a.rule.antecedent) r\n  ),\n  rule_attributes AS\n  ( SELECT DISTINCT * FROM dup_attributes d\n  ),\n  all_attributes AS\n  (SELECT b.attribute_name,\n    b.attribute_Subname   ,\n    NVL2(b.attribute_subname, b.attribute_name\n    || '.'\n    || b.attribute_subname, b.attribute_name) attribute_name_subname\n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS2>)a,\n     TABLE(a.centroid) b),\n  join_attributes AS\n    (SELECT a.attribute_name,\n      a.attribute_subname   ,\n      a.attribute_name_subname ,\n      b.attribute_support   ,\n      b.attribute_confidence\n       FROM all_attributes a,\n      rule_attributes b\n      WHERE a.attribute_name_subname = b.attribute_name_subname(+)\n      <ORDER_BY1>\n    ),\n    filtered_attributes AS\n    (SELECT * FROM join_attributes <FETCH_CONDITION>\n      <WHERE_CONFIDENCE> \n    ),\n    centroids AS\n    (SELECT b.attribute_name,\n      b.attribute_subname   ,\n      NVL2(b.attribute_subname, b.attribute_name\n        || '.'\n        || b.attribute_subname, b.attribute_name) attribute_name_subname,  \n      b.mean                ,\n      b.mode_value          ,\n      b.variance            ,\n      CAST(MULTISET\n      (SELECT e.*\n         FROM TABLE(a.histogram)e\n        WHERE NVL2(e.attribute_subname, e.attribute_name\n        || '.'\n        || e.attribute_subname, e.attribute_name) = NVL2(b.attribute_subname, b.attribute_name\n        || '.'\n        || b.attribute_subname, b.attribute_name)\n      ) AS DM_HISTOGRAMS) AS histogram\n       FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS3>)a,\n      TABLE(a.centroid) b\n    )\n   SELECT a.attribute_name                 ,\n    a.attribute_subname                    ,\n    a.attribute_name_subname AS attribute_name_subname, \n    nvl(a.attribute_support,0) attribute_support, \n    nvl(a.attribute_confidence,0)  attribute_confidence, \n    b.attribute_name    AS centroid_name   ,\n    b.attribute_subname AS centroid_subname, \n    b.attribute_name_subname AS centroid_name_subname, \n    b.mean                                 ,\n    b.mode_value                           ,\n    b.variance                             ,\n    b.histogram\n     FROM filtered_attributes a,\n    centroids b\n    WHERE a.attribute_name_subname = b.attribute_name_subname \n    <ORDER_BY2>\n";
    private static String KM_DBMS_API_1_12_1 = "GET_MODEL_DETAILS_KM(?,?,NULL,0,0,2,NULL, ?)";
    private static String KM_DBMS_API_1_12_1_PARTITIONED = "GET_MODEL_DETAILS_KM(?,?,NULL,0,0,2,NULL, ?, ?)";
    private static String OC_DBMS_API_1 = "GET_MODEL_DETAILS_OC(?,?,NULL,0,0,2)";
    private static String OC_DBMS_API_1_PARTITIONED = "GET_MODEL_DETAILS_OC(?,?,NULL,0,0,2,NULL,?)";
    private static String EM_DBMS_API_1 = "GET_MODEL_DETAILS_EM(?,?,NULL,0,0,2,NULL, ?)";
    private static String EM_DBMS_API_1_PARTITIONED = "GET_MODEL_DETAILS_EM(?,?,NULL,0,0,2,NULL, ?, ? )";
    private static String KM_DBMS_API_2_12_1 = "GET_MODEL_DETAILS_KM(?,?,NULL,1,0,0,NULL, ?)";
    private static String KM_DBMS_API_2_12_1_PARTITIONED = "GET_MODEL_DETAILS_KM(?,?,NULL,1,0,0,NULL, ?, ? )";
    private static String OC_DBMS_API_2 = "GET_MODEL_DETAILS_OC(?,?,NULL,1,0,0)";
    private static String OC_DBMS_API_2_PARTITIONED = "GET_MODEL_DETAILS_OC(?,?,NULL,1,0,0,NULL,?)";
    private static String EM_DBMS_API_2 = "GET_MODEL_DETAILS_EM(?,?,NULL,1,0,0,NULL, ?)";
    private static String EM_DBMS_API_2_PARTITIONED = "GET_MODEL_DETAILS_EM(?,?,NULL,1,0,0,NULL, ?, ? )";
    private static String KM_DBMS_API_3_12_1 = "GET_MODEL_DETAILS_KM(?,?,NULL,1,1,0,NULL, ?)";
    private static String KM_DBMS_API_3_12_1_PARTITIONED = "GET_MODEL_DETAILS_KM(?,?,NULL,1,1,0,NULL, ?, ?)";
    private static String OC_DBMS_API_3 = "GET_MODEL_DETAILS_OC(?,?,NULL,1,1,0)";
    private static String OC_DBMS_API_3_PARTITIONED = "GET_MODEL_DETAILS_OC(?,?,NULL,1,1,0,NULL,?)";
    private static String EM_DBMS_API_3 = "GET_MODEL_DETAILS_EM(?,?,NULL,1,1,0,NULL, ?)";
    private static String EM_DBMS_API_3_PARTITIONED = "GET_MODEL_DETAILS_EM(?,?,NULL,1,1,0,NULL, ?,?)";
    private static String CONFIDENCE_DBMS_API_RANGE_OC = "AND attribute_confidence >= ?  AND attribute_confidence <= ?";
    private static String CONFIDENCE_DBMS_API_RANGE_KM_EM = " attribute_confidence >= ?  AND attribute_confidence <= ?";
    private static String FETCH_SIZE_OC = "rownum <= <FETCH_SIZE>";
    private static String CLUSTER_DETAILS_QUERY = "WITH dup_attributes AS\n  (SELECT a.id            ,\n    a.cluster_id          ,\n    a.rule.rule_id        ,\n    r.attribute_name      ,\n    r.attribute_subname   ,\n    r.attribute_support   ,\n    r.attribute_confidence,\n    NVL2(r.attribute_subname, r.attribute_name\n    || '.'\n    || r.attribute_subname, r.attribute_name) attribute_name_subname\n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS1>)a,\n    TABLE(a.rule.antecedent) r\n  ),\n  rule_attributes AS\n  ( SELECT DISTINCT * FROM dup_attributes d\n  ),\n  all_attributes AS\n  (SELECT b.attribute_name,\n    b.attribute_Subname   ,\n    NVL2(b.attribute_subname, b.attribute_name\n    || '.'\n    || b.attribute_subname, b.attribute_name) attribute_name_subname\n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS2>)a,\n     TABLE(a.centroid) b),\n  join_attributes AS\n    (SELECT a.attribute_name,\n      a.attribute_subname   ,\n      a.attribute_name_subname ,\n      b.attribute_support   ,\n      b.attribute_confidence\n       FROM all_attributes a,\n      rule_attributes b\n      WHERE a.attribute_name_subname = b.attribute_name_subname(+)\n      <ORDER_BY1>\n    ),\n    filtered_attributes AS\n    (SELECT * FROM join_attributes WHERE rownum <= <FETCH_SIZE>\n      <WHERE_CONFIDENCE> \n    ),\n    centroids AS\n    (SELECT b.attribute_name,\n      b.attribute_subname   ,\n      NVL2(b.attribute_subname, b.attribute_name\n        || '.'\n        || b.attribute_subname, b.attribute_name) attribute_name_subname,  \n      b.mean                ,\n      b.mode_value          ,\n      b.variance            ,\n      CAST(MULTISET\n      (SELECT e.*\n         FROM TABLE(a.histogram)e\n        WHERE NVL2(e.attribute_subname, e.attribute_name\n        || '.'\n        || e.attribute_subname, e.attribute_name) = NVL2(b.attribute_subname, b.attribute_name\n        || '.'\n        || b.attribute_subname, b.attribute_name)\n      ) AS DM_HISTOGRAMS) AS histogram\n       FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS3>)a,\n      TABLE(a.centroid) b\n    )\n   SELECT a.attribute_name                 ,\n    a.attribute_subname                    ,\n    a.attribute_name_subname AS attribute_name_subname, \n    nvl(a.attribute_support,0) attribute_support, \n    nvl(a.attribute_confidence,0)  attribute_confidence, \n    b.attribute_name    AS centroid_name   ,\n    b.attribute_subname AS centroid_subname, \n    b.attribute_name_subname AS centroid_name_subname, \n    b.mean                                 ,\n    b.mode_value                           ,\n    b.variance                             ,\n    b.histogram\n     FROM filtered_attributes a,\n    centroids b\n    WHERE a.attribute_name_subname = b.attribute_name_subname \n    <ORDER_BY2>\n";
    private static String KM_DBMS_API_1 = "GET_MODEL_DETAILS_KM(?,?,NULL,0,0,2,NULL)";
    private static String KM_DBMS_API_2 = "GET_MODEL_DETAILS_KM(?,?,NULL,1,0,0,NULL)";
    private static String KM_DBMS_API_3 = "GET_MODEL_DETAILS_KM(?,?,NULL,1,1,0,NULL)";
    private static String CONFIDENCE_DBMS_API_RANGE = "AND attribute_confidence >= ?  AND attribute_confidence <= ?";
    private static String _compare_sql = "select aname, subname, \n  CASE WHEN mean_val1 IS NULL THEN mode_val1 ELSE TO_CHAR(mean_val1) END centroid1,\n  CASE WHEN mean_val2 IS NULL THEN mode_val2 ELSE TO_CHAR(mean_val2) END centroid2,\n  rnk,\n  sym_kld\nFROM (WITH\nnode1 AS (\n  SELECT t.record_count rec_cnt, histogram, centroid\n  FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>(?,?,NULL,1,1)) t),\nnode2 AS (\n  SELECT t. record_count rec_cnt, histogram, centroid\n  FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>(?,?,NULL,1,1)) t),\ncent1 AS (\n  SELECT c.attribute_name aname, \n         c.attribute_subname subname,\n         c.mean mean_val,\n         c.mode_value mode_val\n  FROM node1 t, TABLE(centroid) c),\ncent2 AS (\n  SELECT c.attribute_name aname, \n         c.attribute_subname subname,\n         c.mean mean_val,\n         c.mode_value mode_val\n  FROM node2 t, TABLE(centroid) c), \ncent AS (\n  SELECT nvl(c1.aname, c2.aname) aname,\n         nvl(c1.subname, c2.subname) subname,\n         nvl(c1.mean_val, 0)  mean_val1, \n         c1.mode_val mode_val1,\n         nvl(c2.mean_val, 0) mean_val2, \n         c2.mode_val mode_val2\n  FROM cent1 c1 full outer join cent2 c2\n    ON c1.aname = c2.aname AND \n       nvl(c1.subname, c1.aname) = nvl(c2.subname, c2.aname)),\nhist1 AS (\n  SELECT h.attribute_name aname,\n         h.attribute_subname subname,\n         h.bin_id bin_id,\n         h.count/t.rec_cnt prob\n  FROM node1 t, TABLE(t.histogram) h),\nhist2 AS (\n  SELECT h.attribute_name aname,\n       h.attribute_subname subname,\n       h.bin_id bin_id,\n       h.count/rec_cnt prob\n  FROM node2 t, TABLE(t.histogram) h),\nhist_av AS(\n  SELECT nvl(h1.aname, h2.aname) aname,\n          nvl(h1.subname, h2.subname) subname, \n          nvl(h1.bin_id, h2.bin_id) bin_id,\n          (nvl(h1.prob,0) + nvl(h2.prob,0))/2 prob \n  FROM hist1 h1 full outer join hist2 h2 \n      ON h1.aname = h2.aname AND\n         nvl(h1.subname,h1.aname)=nvl(h2.subname, h2.aname) AND \n         h1.bin_id = h2.bin_id),\nkld AS (\n  SELECT aname, subname, sum(kld)/2 sym_kld FROM \n  (SELECT h2.aname aname, h2.subname subname, \n         sum(h1.prob*ln(h1.prob/h2.prob)) kld\n  FROM hist1 h1, hist_av h2\n  WHERE h1.prob > 0 \n  AND h1.aname = h2.aname \n  AND nvl(h1.subname, h1.aname)=nvl(h2.subname, h2.aname) \n  AND h1.bin_id=h2.bin_id \n  GROUP BY h2.aname, h2.subname\n  UNION all\n  SELECT h2.aname aname, h2.subname subname, \n         sum(h1.prob*ln(h1.prob/h2.prob)) kld\n  FROM hist2 h1, hist_av h2\n  WHERE h1.prob > 0 \n  AND h1.aname = h2.aname \n  AND nvl(h1.subname, h1.aname)=nvl(h2.subname, h2.aname) \n  AND h1.bin_id=h2.bin_id \n  GROUP BY h2.aname, h2.subname)\n  GROUP BY aname, subname)\nSELECT k.aname, k.subname, \n  CASE WHEN c.mode_val1 IS NULL THEN c.mean_val1 ELSE NULL END mean_val1,\n  c.mode_val1, \n  CASE WHEN c.mode_val2 IS NULL THEN c.mean_val2 ELSE NULL END mean_val2,    \n  c.mode_val2, \n  rank() over (order by sym_kld desc) rnk, sym_kld \nFROM kld k, cent c\nWHERE k.aname=c.aname \n    AND nvl(k.subname, k.aname)=nvl(c.subname, c.aname) \n ORDER BY rnk)";
    static String ALL_CLUSTERS_ATTRIBUTE_COUNT_QUERY_2 = " with all_attributes AS\n  (SELECT a.id ID, a.cluster_id CLUSTER_ID, a.parent CLUSTER_PARENT, ch.id CHILD_ID \n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>)a,\n     TABLE(a.centroid) b, TABLE(A.CHILD) ch)\n select id, cluster_id, cluster_parent, child_id, count(*) TOTAL_ATTRIBUTE_COUNT from all_attributes\n group by id, cluster_id, cluster_parent, child_id\n order by id";
    private static String _get_model_details_comp_no_condition = "SELECT * FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_COMP(:model_name)) WHERE ROWNUM < :fetch_size <component_condition>";
    private static String _get_model_details_comp_no_condition_partition = "SELECT * FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_COMP(:model_name, :partitionId)) WHERE ROWNUM < :fetch_size <component_condition>";
    private static String _get_model_details_comp_condition = "SELECT * FROM (\nSELECT INFO_TYPE, COMPONENT_ID, CLUSTER_ID, ATTRIBUTE_NAME, COVARIATE_NAME, ATTRIBUTE_VALUE, VALUE\nFROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_COMP(:model_name)) \nWHERE <where_conditon_name>UNION ALL\nSELECT INFO_TYPE, COMPONENT_ID, CLUSTER_ID, NULL, NULL, NULL, VALUE FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_COMP(:model_name)) \nWHERE INFO_TYPE IN ( 'Prior', 'Cluster') \nORDER BY INFO_TYPE, COMPONENT_ID\n) where ROWNUM < :fetch_size <component_condition>";
    private static String _get_model_details_comp_condition_partition = "SELECT * FROM (\nSELECT INFO_TYPE, COMPONENT_ID, CLUSTER_ID, ATTRIBUTE_NAME, COVARIATE_NAME, ATTRIBUTE_VALUE, VALUE\nFROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_COMP(:model_name, :partitionId)) \nWHERE <where_conditon_name>UNION ALL\nSELECT INFO_TYPE, COMPONENT_ID, CLUSTER_ID, NULL, NULL, NULL, VALUE FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_COMP(:model_name, :partitionId)) \nWHERE INFO_TYPE IN ( 'Prior', 'Cluster') \nORDER BY INFO_TYPE, COMPONENT_ID\n) where ROWNUM < :fetch_size <component_condition>";
    private static String _where_conditon_name = "ATTRIBUTE_NAME LIKE '%<pattern>%' ";
    private static String _component_condition = "AND COMPONENT_ID = :component";
    private static String _cluster = "Cluster";
    private static String _prior = "Prior";
    private static String _mean = "Mean";
    private static String _covariance = "Covariance";
    private static String _frequency = "Frequency";
    private static String _get_model_details_proj_details = "SELECT * FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_PROJ(:model_name)) WHERE FEATURE_NAME = :feature_name AND ATTRIBUTE_NAME = :attribute_name";
    private static String _get_model_details_proj_details_partition = "SELECT * FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_PROJ(:model_name, :partitionId)) WHERE FEATURE_NAME = :feature_name AND ATTRIBUTE_NAME = :attribute_name";
    private static String _get_model_details_proj_names_counts = "SELECT FEATURE_NAME, ATTRIBUTE_NAME FROM (  SELECT FEATURE_NAME, ATTRIBUTE_NAME, count(ATTRIBUTE_NAME) NUM FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_PROJ(:model_name) )    WHERE FEATURE_NAME IN (     SELECT ATTRIBUTE_NAME FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_COMP(:model_name)) WHERE ROWNUM < :fetch_size   ) GROUP BY FEATURE_NAME, ATTRIBUTE_NAME ) WHERE NUM > 0";
    private static String _get_model_details_proj_names_counts_partition = "SELECT FEATURE_NAME, ATTRIBUTE_NAME FROM (  SELECT FEATURE_NAME, ATTRIBUTE_NAME, count(ATTRIBUTE_NAME) NUM FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_PROJ(:model_name, :partitionId) )    WHERE FEATURE_NAME IN (     SELECT ATTRIBUTE_NAME FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_COMP(:model_name, :partitionId)) WHERE ROWNUM < :fetch_size   ) GROUP BY FEATURE_NAME, ATTRIBUTE_NAME ) WHERE NUM > 0";

    public ClusteringDetailsImpl(ConnectionManager connectionManager, String string, String string2, ClusteringAlgorithm clusteringAlgorithm) {
        this.connManager = connectionManager;
        this.modelDesc = new ModelDescriptor(string, string2);
        this.algorithmType = clusteringAlgorithm;
        this.dao = new SqlDataAccessObject(connectionManager);
    }

    public void setPartitionId(String string) {
        this.modelDesc.setPartitionId(string);
    }

    public List<ClusteringDetailRow> getClusterModelDetails(int n, boolean bl) throws ODMrDAOException {
        List list = null;
        GetClusterModelDetailsQuery getClusterModelDetailsQuery = new GetClusterModelDetailsQuery(this.connManager.getDbVersion(), this.modelDesc, n, this.algorithmType, bl);
        list = this.dao.readItems((Query)getClusterModelDetailsQuery);
        return list;
    }

    public List<CompareClustersModelRow> getDivergenceHistogramCentroid(Integer n, String string, Integer n2, String string2, int n3) throws ODMrDAOException {
        List list = null;
        GetDivergenceHistogramCentroidQuery getDivergenceHistogramCentroidQuery = new GetDivergenceHistogramCentroidQuery(this.connManager.getDbVersion(), this.modelDesc, n, string, n2, string2, n3, this.algorithmType);
        list = this.dao.readItems((Query)getDivergenceHistogramCentroidQuery);
        return list;
    }

    public List<ClusterDetailsModelRow> getModelAttributeDetailsKM(ClusteringFilterSetting clusteringFilterSetting) throws Exception {
        Version version = this.connManager.getDbVersion();
        if (version.toCanonicalString().startsWith("11.")) {
            return this.getModelAttributeDetails(clusteringFilterSetting, ClusteringAlgorithm.KMEANS);
        }
        return this.getModelAttributeDetails12_1(clusteringFilterSetting, ClusteringAlgorithm.KMEANS);
    }

    public List<ClusterDetailsModelRow> getModelAttributeDetailsEM(ClusteringFilterSetting clusteringFilterSetting) throws Exception {
        return this.getModelAttributeDetails12_1(clusteringFilterSetting, ClusteringAlgorithm.EMCLUSTER);
    }

    public List<ClusterDetailsModelRow> getModelAttributeDetailsOC(ClusteringFilterSetting clusteringFilterSetting) throws Exception {
        Version version = this.connManager.getDbVersion();
        if (version.toCanonicalString().startsWith("11.")) {
            return this.getModelAttributeDetails(clusteringFilterSetting, ClusteringAlgorithm.OCLUSTER);
        }
        return this.getModelAttributeDetails12_1(clusteringFilterSetting, ClusteringAlgorithm.OCLUSTER);
    }

    public List<ClusterDetailsModelRow> getModelAttributeDetails12_1(ClusteringFilterSetting clusteringFilterSetting, ClusteringAlgorithm clusteringAlgorithm) throws SQLException {
        ArrayList<ClusterDetailsModelRow> arrayList = new ArrayList<ClusterDetailsModelRow>();
        if (clusteringFilterSetting == null || clusteringFilterSetting.getClusterId() == null) {
            return arrayList;
        }
        Version version = this.connManager.getDbVersion();
        boolean bl = DbVersionHelper.isDB122Up((Version)version);
        String string = CLUSTER_DETAILS_QUERY_NEW;
        SQLHelper sQLHelper = new SQLHelper();
        StringBuffer stringBuffer = new StringBuffer();
        List<SortSpec> list = null;
        Double d = clusteringFilterSetting.getMinConfidence() / 100.0;
        Double d2 = clusteringFilterSetting.getMaxConfidence() / 100.0;
        String string2 = "";
        try {
            Object object;
            if (clusteringAlgorithm == ClusteringAlgorithm.KMEANS) {
                if (bl && this.modelDesc.isPartitioned()) {
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS1>", KM_DBMS_API_1_12_1_PARTITIONED);
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS2>", KM_DBMS_API_2_12_1_PARTITIONED);
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS3>", KM_DBMS_API_3_12_1_PARTITIONED);
                } else {
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS1>", KM_DBMS_API_1_12_1);
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS2>", KM_DBMS_API_2_12_1);
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS3>", KM_DBMS_API_3_12_1);
                }
            } else if (clusteringAlgorithm == ClusteringAlgorithm.OCLUSTER) {
                if (bl && this.modelDesc.isPartitioned()) {
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS1>", OC_DBMS_API_1_PARTITIONED);
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS2>", OC_DBMS_API_2_PARTITIONED);
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS3>", OC_DBMS_API_3_PARTITIONED);
                } else {
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS1>", OC_DBMS_API_1);
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS2>", OC_DBMS_API_2);
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS3>", OC_DBMS_API_3);
                }
                string2 = StringUtils.getReplacedString(FETCH_SIZE_OC, "<FETCH_SIZE>", clusteringFilterSetting.getFetchSize() + "");
            } else if (clusteringAlgorithm == ClusteringAlgorithm.EMCLUSTER) {
                if (bl && this.modelDesc.isPartitioned()) {
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS1>", EM_DBMS_API_1_PARTITIONED);
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS2>", EM_DBMS_API_2_PARTITIONED);
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS3>", EM_DBMS_API_3_PARTITIONED);
                } else {
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS1>", EM_DBMS_API_1);
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS2>", EM_DBMS_API_2);
                    string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS3>", EM_DBMS_API_3);
                }
            }
            if (!string2.isEmpty()) {
                string2 = " WHERE " + string2;
            }
            string = StringUtils.getReplacedString(string, "<FETCH_CONDITION>", string2);
            list = clusteringFilterSetting.getSortSpecification();
            if (list != null && list.size() > 0) {
                stringBuffer.append("order by ");
                object = list.iterator();
                while (object.hasNext()) {
                    SortSpec sortSpec = object.next();
                    if (!sortSpec.isUseIt()) continue;
                    stringBuffer.append(sortSpec.getAttributeName() + " ");
                    if (sortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!object.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
            string = StringUtils.getReplacedString(string, "<ORDER_BY1>", stringBuffer.toString());
            string = StringUtils.getReplacedString(string, "<ORDER_BY2>", stringBuffer.toString());
            object = "";
            if (clusteringFilterSetting.isUseFilterSpecification()) {
                object = clusteringAlgorithm == ClusteringAlgorithm.OCLUSTER ? CONFIDENCE_DBMS_API_RANGE_OC : CONFIDENCE_DBMS_API_RANGE_KM_EM;
            }
            if (string2.isEmpty()) {
                if (((String)object).isEmpty()) {
                    string = StringUtils.getReplacedString(string, "<WHERE_CONFIDENCE>", "");
                } else {
                    object = " WHERE " + (String)object;
                    string = StringUtils.getReplacedString(string, "<WHERE_CONFIDENCE>", (String)object);
                }
            } else {
                string = ((String)object).isEmpty() ? StringUtils.getReplacedString(string, "<WHERE_CONFIDENCE>", "") : StringUtils.getReplacedString(string, "<WHERE_CONFIDENCE>", (String)object);
            }
            sQLHelper.conn = this.connManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            int n = 1;
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(this.modelDesc.getSchema(), this.modelDesc.getName(), false));
            sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getClusterId());
            if (clusteringAlgorithm != ClusteringAlgorithm.OCLUSTER) {
                sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getFetchSize());
            }
            if (bl && this.modelDesc.isPartitioned()) {
                sQLHelper.pstmt.setString(n++, "\"" + this.modelDesc.getPartitionId() + "\"");
            }
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(this.modelDesc.getSchema(), this.modelDesc.getName(), false));
            sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getClusterId());
            if (clusteringAlgorithm != ClusteringAlgorithm.OCLUSTER) {
                sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getFetchSize());
            }
            if (bl && this.modelDesc.isPartitioned()) {
                sQLHelper.pstmt.setString(n++, "\"" + this.modelDesc.getPartitionId() + "\"");
            }
            if (clusteringFilterSetting.isUseFilterSpecification()) {
                sQLHelper.pstmt.setDouble(n++, d);
                sQLHelper.pstmt.setDouble(n++, d2);
            }
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(this.modelDesc.getSchema(), this.modelDesc.getName(), false));
            sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getClusterId());
            if (clusteringAlgorithm != ClusteringAlgorithm.OCLUSTER) {
                sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getFetchSize());
            }
            if (bl && this.modelDesc.isPartitioned()) {
                sQLHelper.pstmt.setString(n++, "\"" + this.modelDesc.getPartitionId() + "\"");
            }
            sQLHelper.pstmt.execute();
            ClusterDetailsModelRow clusterDetailsModelRow = null;
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                String string4 = sQLHelper.rs.getString("ATTRIBUTE_SUBNAME");
                Double d3 = sQLHelper.rs.getDouble("ATTRIBUTE_SUPPORT");
                Double d4 = sQLHelper.rs.getDouble("ATTRIBUTE_CONFIDENCE");
                Double d5 = sQLHelper.rs.getDouble("MEAN");
                Double d6 = sQLHelper.rs.getDouble("VARIANCE");
                String string5 = sQLHelper.rs.getString("MODE_VALUE");
                DmHistograms dmHistograms = (DmHistograms)((OracleResultSet)sQLHelper.rs).getORAData("HISTOGRAM", DmHistograms.getORADataFactory());
                clusterDetailsModelRow = new ClusterDetailsModelRow(string3, string4, dmHistograms, d4, d3, d5, string5, d6);
                arrayList.add(clusterDetailsModelRow);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            throw exception;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            theLogger.log(Level.SEVERE, outOfMemoryError.getMessage(), outOfMemoryError);
            throw outOfMemoryError;
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    public List<ClusterDetailsModelRow> getModelAttributeDetails(ClusteringFilterSetting clusteringFilterSetting, ClusteringAlgorithm clusteringAlgorithm) throws Exception {
        assert (clusteringFilterSetting != null) : "Condition can not be null.";
        assert (clusteringFilterSetting.getClusterId() != null) : "Cluster id can not be null. Will cause join problems.";
        assert (clusteringFilterSetting.getClusterId() >= 1) : "Cluster id can not be zero or less than one. Will cause join problems.";
        String string = CLUSTER_DETAILS_QUERY;
        SQLHelper sQLHelper = new SQLHelper();
        ArrayList<ClusterDetailsModelRow> arrayList = new ArrayList<ClusterDetailsModelRow>();
        StringBuffer stringBuffer = new StringBuffer();
        List<SortSpec> list = null;
        Double d = clusteringFilterSetting.getMinConfidence() / 100.0;
        Double d2 = clusteringFilterSetting.getMaxConfidence() / 100.0;
        try {
            Object object;
            if (clusteringAlgorithm == ClusteringAlgorithm.KMEANS) {
                string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS1>", KM_DBMS_API_1);
                string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS2>", KM_DBMS_API_2);
                string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS3>", KM_DBMS_API_3);
            } else if (clusteringAlgorithm == ClusteringAlgorithm.OCLUSTER) {
                string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS1>", OC_DBMS_API_1);
                string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS2>", OC_DBMS_API_2);
                string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS3>", OC_DBMS_API_3);
            } else if (clusteringAlgorithm == ClusteringAlgorithm.EMCLUSTER) {
                string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS1>", EM_DBMS_API_1);
                string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS2>", EM_DBMS_API_2);
                string = StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS3>", EM_DBMS_API_3);
            }
            string = StringUtils.getReplacedString(string, "<FETCH_SIZE>", clusteringFilterSetting.getFetchSize() + "");
            list = clusteringFilterSetting.getSortSpecification();
            if (list != null && list.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<SortSpec> iterator = list.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (!object.isUseIt()) continue;
                    stringBuffer.append(object.getAttributeName() + " ");
                    if (object.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
            string = StringUtils.getReplacedString(string, "<ORDER_BY1>", stringBuffer.toString());
            string = StringUtils.getReplacedString(string, "<ORDER_BY2>", stringBuffer.toString());
            string = clusteringFilterSetting.isUseFilterSpecification() ? StringUtils.getReplacedString(string, "<WHERE_CONFIDENCE>", CONFIDENCE_DBMS_API_RANGE) : StringUtils.getReplacedString(string, "<WHERE_CONFIDENCE>", "");
            sQLHelper.conn = this.connManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            int n = 1;
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(this.modelDesc.getSchema(), this.modelDesc.getName(), false));
            sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getClusterId());
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(this.modelDesc.getSchema(), this.modelDesc.getName(), false));
            sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getClusterId());
            if (clusteringFilterSetting.isUseFilterSpecification()) {
                sQLHelper.pstmt.setDouble(n++, d);
                sQLHelper.pstmt.setDouble(n++, d2);
            }
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(this.modelDesc.getSchema(), this.modelDesc.getName(), false));
            sQLHelper.pstmt.setInt(n, clusteringFilterSetting.getClusterId());
            sQLHelper.pstmt.execute();
            object = null;
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string2 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                String string3 = sQLHelper.rs.getString("ATTRIBUTE_SUBNAME");
                Double d3 = sQLHelper.rs.getDouble("ATTRIBUTE_SUPPORT");
                Double d4 = sQLHelper.rs.getDouble("ATTRIBUTE_CONFIDENCE");
                Double d5 = sQLHelper.rs.getDouble("MEAN");
                Double d6 = sQLHelper.rs.getDouble("VARIANCE");
                String string4 = sQLHelper.rs.getString("MODE_VALUE");
                DmHistograms dmHistograms = (DmHistograms)((OracleResultSet)sQLHelper.rs).getORAData("HISTOGRAM", DmHistograms.getORADataFactory());
                object = new ClusterDetailsModelRow(string2, string3, dmHistograms, d4, d3, d5, string4, d6);
                arrayList.add((ClusterDetailsModelRow)object);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            throw exception;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            theLogger.log(Level.SEVERE, outOfMemoryError.getMessage(), outOfMemoryError);
            throw outOfMemoryError;
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    public Integer getTotalNumberOfModelAttributesKM(Integer n) throws SQLException {
        return this.getTotalNumberOfModelAttributes(n, ClusteringAlgorithm.KMEANS);
    }

    public Integer getTotalNumberOfModelAttributesOC(Integer n) throws SQLException {
        return this.getTotalNumberOfModelAttributes(n, ClusteringAlgorithm.OCLUSTER);
    }

    private Integer getTotalNumberOfModelAttributes(int n, ClusteringAlgorithm clusteringAlgorithm) throws SQLException {
        assert (n >= 1) : "Cluster id can not be zero or less than one. Will cause join problems.";
        String string = "with all_attributes AS\n  (SELECT b.attribute_name,\n    b.attribute_Subname   ,\n    NVL2(b.attribute_subname, b.attribute_name\n    || '.'\n    || b.attribute_subname, b.attribute_name) attribute_name_subname\n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>)a,\n     TABLE(a.centroid) b)\n select count(*)TOTAL_ATTRIBUTE_COUNT  from all_attributes\n";
        Integer n2 = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            string = clusteringAlgorithm == ClusteringAlgorithm.KMEANS ? StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM(?,?,NULL,1,0,0,NULL)") : StringUtils.getReplacedString(string, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC(?,?,NULL,1,0,0)");
            sQLHelper.conn = this.connManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            int n3 = 1;
            sQLHelper.pstmt.setString(n3++, Model.getCombinedUserNameModelName(this.modelDesc.getSchema(), this.modelDesc.getName(), false));
            sQLHelper.pstmt.setInt(n3++, n);
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            boolean bl = sQLHelper.rs.next();
            if (bl) {
                n2 = sQLHelper.rs.getInt("TOTAL_ATTRIBUTE_COUNT");
            }
        }
        return n2;
    }

    public Map<String, ClusteringDetailRowShort> getTotalNumberOfModelAttributesPerClusterKM2() {
        return this.getTotalNumberOfModelAttributesPerCluster2(ClusteringAlgorithm.KMEANS);
    }

    public Map<String, ClusteringDetailRowShort> getTotalNumberOfModelAttributesPerClusterEM() {
        return this.getTotalNumberOfModelAttributesPerCluster2(ClusteringAlgorithm.EMCLUSTER);
    }

    public Map<String, ClusteringDetailRowShort> getTotalNumberOfModelAttributesPerClusterOC2() {
        return this.getTotalNumberOfModelAttributesPerCluster2(ClusteringAlgorithm.OCLUSTER);
    }

    public void getCompareClusterDetailsKM(int n, int n2, List<CompareClustersModelRow> list) throws SQLException {
        this.getCompareClusterDetails(n, n2, list, ClusteringAlgorithm.KMEANS);
    }

    public void getCompareClusterDetailsOC(int n, int n2, List<CompareClustersModelRow> list) throws SQLException {
        this.getCompareClusterDetails(n, n2, list, ClusteringAlgorithm.OCLUSTER);
    }

    private void getCompareClusterDetails(int n, int n2, List<CompareClustersModelRow> list, ClusteringAlgorithm clusteringAlgorithm) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        String string = clusteringAlgorithm == ClusteringAlgorithm.KMEANS ? StringUtils.getReplacedString(_compare_sql, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM") : StringUtils.getReplacedString(_compare_sql, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC");
        HashMap<String, CompareClustersModelRow> hashMap = new HashMap<String, CompareClustersModelRow>();
        for (Object object : list) {
            hashMap.put(object.getFullAttributeName(), (CompareClustersModelRow)object);
        }
        String string2 = Model.getCombinedUserNameModelName(this.modelDesc.getSchema(), this.modelDesc.getName(), false);
        try {
            sQLHelper.conn = this.connManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.pstmt.setString(1, string2);
            sQLHelper.pstmt.setInt(2, n);
            sQLHelper.pstmt.setString(3, string2);
            sQLHelper.pstmt.setInt(4, n2);
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                Object object;
                object = sQLHelper.rs.getString("aname");
                String string3 = sQLHelper.rs.getString("subname");
                String string4 = sQLHelper.rs.getString("centroid1");
                String string5 = sQLHelper.rs.getString("centroid2");
                int n3 = sQLHelper.rs.getInt("rnk");
                double d = sQLHelper.rs.getDouble("sym_kld");
                String string6 = this.getFullAttributeName((String)object, string3);
                CompareClustersModelRow compareClustersModelRow = (CompareClustersModelRow)hashMap.get(string6);
                if (null == compareClustersModelRow) continue;
                compareClustersModelRow.setCentroid1(string4);
                compareClustersModelRow.setCentroid2(string5);
                compareClustersModelRow.setDivergence(d);
                compareClustersModelRow.setRank(Integer.valueOf(n3));
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
    }

    private String getFullAttributeName(String string, String string2) {
        String string3 = string2 != null ? string + "." + string2 : string;
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ClusteringDetailRowShort> getTotalNumberOfModelAttributesPerCluster2(ClusteringAlgorithm clusteringAlgorithm) {
        String string = "GET_MODEL_DETAILS_KM(?,NULL,NULL,1,0,0,NULL)";
        String string2 = "GET_MODEL_DETAILS_OC(?,NULL,NULL,1,0,0)";
        String string3 = "GET_MODEL_DETAILS_EM(?,NULL,NULL,1,0,0,NULL)";
        if (this.modelDesc.isPartitioned()) {
            string = "GET_MODEL_DETAILS_KM(?,NULL,NULL,1,0,0,NULL,NULL,?)";
            string2 = "GET_MODEL_DETAILS_OC(?,NULL,NULL,1,0,0,NULL,?)";
            string3 = "GET_MODEL_DETAILS_EM(?,NULL,NULL,1,0,0,NULL,NULL,?)";
        }
        String string4 = ALL_CLUSTERS_ATTRIBUTE_COUNT_QUERY_2;
        HashMap<String, ClusteringDetailRowShort> hashMap = new HashMap<String, ClusteringDetailRowShort>();
        SQLHelper sQLHelper = new SQLHelper();
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        try {
            if (clusteringAlgorithm == ClusteringAlgorithm.KMEANS) {
                string4 = StringUtils.getReplacedString(string4, "<GET_MODEL_DETAILS>", string);
            } else if (clusteringAlgorithm == ClusteringAlgorithm.OCLUSTER) {
                string4 = StringUtils.getReplacedString(string4, "<GET_MODEL_DETAILS>", string2);
            } else if (clusteringAlgorithm == ClusteringAlgorithm.EMCLUSTER) {
                string4 = StringUtils.getReplacedString(string4, "<GET_MODEL_DETAILS>", string3);
            }
            sQLHelper.conn = this.connManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string4);
            String string5 = Model.getCombinedUserNameModelName(this.modelDesc.getSchema(), this.modelDesc.getName(), false);
            sQLHelper.pstmt.setString(1, string5);
            if (this.modelDesc.isPartitioned()) {
                sQLHelper.pstmt.setString(2, "\"" + this.modelDesc.getPartitionId() + "\"");
            }
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                n2 = sQLHelper.rs.getInt("ID");
                int n5 = sQLHelper.rs.getInt("CLUSTER_PARENT");
                n3 = sQLHelper.rs.wasNull() ? null : Integer.valueOf(n5);
                n5 = sQLHelper.rs.getInt("CHILD_ID");
                n4 = sQLHelper.rs.wasNull() ? null : Integer.valueOf(n5);
                String string6 = sQLHelper.rs.getString("CLUSTER_ID");
                n = sQLHelper.rs.getInt("TOTAL_ATTRIBUTE_COUNT");
                ClusteringDetailRowShort clusteringDetailRowShort = (ClusteringDetailRowShort)hashMap.get(string6);
                ArrayList<Integer> arrayList = null;
                if (clusteringDetailRowShort == null) {
                    if (n4 != null) {
                        arrayList = new ArrayList<Integer>();
                        arrayList.add(n4);
                    }
                    clusteringDetailRowShort = new ClusteringDetailRowShort(n2, string6, n, n3, arrayList);
                    hashMap.put(string6, clusteringDetailRowShort);
                    continue;
                }
                if (n4 == null) continue;
                clusteringDetailRowShort.getChildren().add(n4);
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    public void getModelDetailsComp(int n, String string, Map<Integer, List<ClusterComponentModelRow>> map, List<Integer> list, Integer n2) throws ODMrDAOException {
        NameValuePair nameValuePair;
        ArrayList<NameValuePair> arrayList;
        Map<String, Object> map2;
        Map<String, Double> map3;
        Object object;
        Object object2;
        SQLHelper sQLHelper = new SQLHelper();
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        String string2 = null;
        if (string != null && string.length() > 0) {
            string2 = this.modelDesc.isPartitioned() ? _get_model_details_comp_condition_partition : _get_model_details_comp_condition;
            object2 = StringUtils.isDoubleQuotedString(string) ? string : string.toUpperCase();
            string2 = StringUtils.getReplacedString(string2, "<where_conditon_name>", _where_conditon_name);
            string2 = StringUtils.getReplacedString(string2, "<pattern>", (String)object2);
        } else {
            string2 = this.modelDesc.isPartitioned() ? _get_model_details_comp_no_condition_partition : _get_model_details_comp_no_condition;
            string2 = StringUtils.getReplacedString(string2, "<where_conditon_name>", "");
        }
        string2 = n2 != null ? StringUtils.getReplacedString(string2, "<component_condition>", _component_condition) : StringUtils.getReplacedString(string2, "<component_condition>", "");
        try {
            sQLHelper.conn = this.connManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string2);
            sQLHelper.opstmt.setStringAtName("model_name", this.modelDesc.getQualifiedName());
            sQLHelper.opstmt.setIntAtName("fetch_size", n);
            if (this.modelDesc.isPartitioned()) {
                sQLHelper.opstmt.setStringAtName("partitionId", "\"" + this.modelDesc.getPartitionId() + "\"");
            }
            if (n2 != null) {
                sQLHelper.opstmt.setIntAtName("component", n2.intValue());
            }
            sQLHelper.opstmt.execute();
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            object2 = null;
            while (sQLHelper.rs.next()) {
                String object3 = sQLHelper.rs.getString("INFO_TYPE");
                int n3 = sQLHelper.rs.getInt("COMPONENT_ID");
                object2 = (ClusterComponentData)hashMap.get(n3);
                if (object2 == null) {
                    object2 = new ClusterComponentData(n3);
                    hashMap.put(n3, object2);
                    list.add(n3);
                }
                if (object3.equals(_cluster)) {
                    int d = sQLHelper.rs.getInt("CLUSTER_ID");
                    ((ClusterComponentData)object2).setClusterId(d);
                    continue;
                }
                if (object3.equals(_prior)) {
                    Double d = sQLHelper.rs.getDouble("VALUE");
                    ((ClusterComponentData)object2).setPriorValue(d);
                    continue;
                }
                if (object3.equals(_mean)) {
                    Double string3 = sQLHelper.rs.getDouble("VALUE");
                    object = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                    map3 = ((ClusterComponentData)object2).getMeanValues();
                    if (map3 == null) {
                        map3 = new HashMap<String, Double>();
                        ((ClusterComponentData)object2).setMeanValues(map3);
                    }
                    map3.put((String)object, string3);
                    continue;
                }
                if (object3.equals(_covariance)) {
                    Double n5 = sQLHelper.rs.getDouble("VALUE");
                    object = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                    map3 = ((ClusterComponentData)object2).getCovarianceValues();
                    if (map3 == null) {
                        map3 = new HashMap<String, Double>();
                        ((ClusterComponentData)object2).setCovarianceValues(map3);
                    }
                    map3.put((String)object, n5);
                    continue;
                }
                if (object3.equals(_frequency)) {
                    String string3 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                    object = sQLHelper.rs.getString("ATTRIBUTE_VALUE");
                    map3 = sQLHelper.rs.getDouble("VALUE");
                    map2 = ((ClusterComponentData)object2).getFrequencyValues();
                    if (map2 == null) {
                        map2 = new HashMap();
                        ((ClusterComponentData)object2).setFrequencyValues(map2);
                    }
                    if ((arrayList = (List)map2.get(string3)) == null) {
                        arrayList = new ArrayList<NameValuePair>();
                        map2.put(string3, arrayList);
                    }
                    nameValuePair = new NameValuePair((String)object, (Object)map3);
                    arrayList.add(nameValuePair);
                    continue;
                }
                assert (false) : "this should never happen";
            }
        }
        catch (SQLException sQLException) {
            throw new ODMrDAOException((Throwable)sQLException);
        }
        finally {
            sQLHelper.close();
        }
        for (Integer n4 : list) {
            Object object3;
            List<NameValuePair> list2;
            String string4;
            ClusterComponentData clusterComponentData = (ClusterComponentData)hashMap.get(n4);
            Integer n5 = clusterComponentData.getClusterId();
            object = clusterComponentData.getPriorValue();
            map3 = clusterComponentData.getMeanValues();
            map2 = clusterComponentData.getCovarianceValues();
            arrayList = clusterComponentData.getFrequencyValues();
            nameValuePair = new ArrayList();
            if (!arrayList.isEmpty()) {
                for (Map.Entry<String, List<NameValuePair>> entry : arrayList.entrySet()) {
                    string4 = entry.getKey();
                    list2 = entry.getValue();
                    if (list2 == null || list2.isEmpty()) continue;
                    object3 = new ClusterComponentModelRow(n4, n5, string4, (Double)object);
                    ((ClusterComponentModelRow)object3).setFrequencyValues(list2);
                    nameValuePair.add(object3);
                }
            }
            if (!map3.isEmpty() && !map2.isEmpty()) {
                for (Map.Entry<String, Object> entry : map3.entrySet()) {
                    string4 = entry.getKey();
                    list2 = (Double)entry.getValue();
                    object3 = (Double)map2.get(string4);
                    if (list2 == null || object3 == null) continue;
                    ClusterComponentModelRow clusterComponentModelRow = new ClusterComponentModelRow(n4, n5, string4, (Double)object);
                    clusterComponentModelRow.setMeanValue((Double)((Object)list2));
                    clusterComponentModelRow.setCovarianceValue((Double)object3);
                    nameValuePair.add(clusterComponentModelRow);
                }
            }
            map.put(n4, (List<ClusterComponentModelRow>)nameValuePair);
        }
    }

    public List<ClusterComponentProjectionItem> getModelDetailsProjDetails(String string, String string2) throws ODMrDAOException {
        SQLHelper sQLHelper = new SQLHelper();
        ArrayList<ClusterComponentProjectionItem> arrayList = new ArrayList<ClusterComponentProjectionItem>();
        String string3 = this.modelDesc.isPartitioned() ? _get_model_details_proj_details_partition : _get_model_details_proj_details;
        try {
            sQLHelper.conn = this.connManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("model_name", this.modelDesc.getQualifiedName());
            if (this.modelDesc.isPartitioned()) {
                sQLHelper.opstmt.setStringAtName("partitionId", "\"" + this.modelDesc.getPartitionId() + "\"");
            }
            sQLHelper.opstmt.setStringAtName("feature_name", string2);
            sQLHelper.opstmt.setStringAtName("attribute_name", string);
            sQLHelper.opstmt.execute();
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string4 = sQLHelper.rs.getString("ATTRIBUTE_SUBNAME");
                String string5 = sQLHelper.rs.getString("ATTRIBUTE_VALUE");
                Double d = sQLHelper.rs.getDouble("COEFFICIENT");
                ClusterComponentProjectionItem clusterComponentProjectionItem = new ClusterComponentProjectionItem();
                clusterComponentProjectionItem.setFeatureName(string2);
                clusterComponentProjectionItem.setAttributName(string);
                clusterComponentProjectionItem.setAttributeSubname(string4);
                if (string5 != null) {
                    clusterComponentProjectionItem.setAttributeValue(string5);
                }
                clusterComponentProjectionItem.setCoefficient(d);
                arrayList.add(clusterComponentProjectionItem);
            }
        }
        catch (SQLException sQLException) {
            throw new ODMrDAOException((Throwable)sQLException);
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    public boolean isModelEmpty() throws ODMrDAOException {
        List<NameValuePair> list = GlobalDetails.getModelDetailsGlobal(this.connManager, this.modelDesc);
        Collections.sort(list);
        int n = Collections.binarySearch(list, new NameValuePair("NUM_COMPONENTS", null));
        if (n >= 0) {
            Object object = list.get(n).getValue();
            if (object == null) {
                return true;
            }
            return ((Double)object).intValue() == 1;
        }
        return true;
    }

    public Map<String, String> getEMModelProjectionFeatureNameMap(int n) throws ODMrDAOException {
        SQLHelper sQLHelper = new SQLHelper();
        String string = null;
        String string2 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = this.modelDesc.isPartitioned() ? _get_model_details_proj_names_counts_partition : _get_model_details_proj_names_counts;
        try {
            sQLHelper.conn = this.connManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("model_name", this.modelDesc.getQualifiedName());
            if (this.modelDesc.isPartitioned()) {
                sQLHelper.opstmt.setStringAtName("partitionId", "\"" + this.modelDesc.getPartitionId() + "\"");
            }
            sQLHelper.opstmt.setIntAtName("fetch_size", n);
            sQLHelper.opstmt.execute();
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                string = sQLHelper.rs.getString("FEATURE_NAME");
                string2 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                hashMap.put(string, string2);
            }
        }
        catch (SQLException sQLException) {
            throw new ODMrDAOException((Throwable)sQLException);
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    public static class ODM_DM_CLUSTER_COMPARE {
        public static final String ATTRIBUTE_NAME = "aname";
        public static final String ATTRIBUTE_SUBNAME = "subname";
        public static final String CENTROID1 = "centroid1";
        public static final String CENTROID2 = "centroid2";
        public static final String RANK = "rnk";
        public static final String DIVERGENCE = "sym_kld";
    }

    public static class ODM_DM_CLUSTER_ATTRIBUTES {
        public static final String ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
        public static final String ATTRIBUTE_SUBNAME = "ATTRIBUTE_SUBNAME";
        public static final String ATTRIBUTE_SUPPORT = "ATTRIBUTE_SUPPORT";
        public static final String ATTRIBUTE_CONFIDENCE = "ATTRIBUTE_CONFIDENCE";
        public static final String MEAN = "MEAN";
        public static final String MODE_VALUE = "MODE_VALUE";
        public static final String VARIANCE = "VARIANCE";
        public static final String HISTOGRAM = "HISTOGRAM";
    }
}

