/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDoubleMapper;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlStringMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetTargetValuesQuery;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionColumn;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.TargetPriorsPredictionSet;
import oracle.dmt.dataminer.utils.SQLHelper;

public class Classification
extends Model {
    private static final Logger theLogger = Logger.getLogger(Classification.class.getName());
    private final String PRED_SET_PREDICTION = "PREDICTION";
    private final String PRED_SET_PROBABILITY = "PROBABILITY";
    private static final String ALL_TARGET_VALUES = "ALL_TARGET_VALUES";
    private static final String MODEL_PREDICTION_SELECT = "select prediction from table(prediction_set(<MODEL_NAME>  using))  ";
    private static final String SELECT_MINUS_TARGETS = "(select prediction from ALL_TARGET_VALUES MINUS\nselect prediction from table(prediction_set(<MODEL_NAME>  using)))";
    private static final String TARGET_VALUE_COMPARE_QUERY = "WITH ALL_TARGET_VALUES AS ( <SELECT_FOR_ALL_TARGET_VALUES> ) <SELECT_FOR_COMPARE>";

    public Classification(ConnectionManager connectionManager, String string, String string2) {
        super(connectionManager, string, string2);
    }

    @Override
    public void setPartitionId(String string) {
        this.modelDescriptor.setPartitionId(string);
    }

    public static List<String> getTargetValueStrings(ConnectionManager connectionManager, ModelDescriptor modelDescriptor) throws ODMrDAOException {
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject(connectionManager);
        GetTargetValuesQuery getTargetValuesQuery = new GetTargetValuesQuery(connectionManager.getDbVersion(), (SqlMapper)new SqlStringMapper(), modelDescriptor);
        List list = sqlDataAccessObject.readItems((Query)getTargetValuesQuery);
        return list;
    }

    public static List<Double> getTargetValueNumbers(ConnectionManager connectionManager, ModelDescriptor modelDescriptor) throws ODMrDAOException {
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject(connectionManager);
        GetTargetValuesQuery getTargetValuesQuery = new GetTargetValuesQuery(connectionManager.getDbVersion(), (SqlMapper)new SqlDoubleMapper(), modelDescriptor);
        List list = sqlDataAccessObject.readItems((Query)getTargetValuesQuery);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TargetPriorsPredictionSet> getTargetValuePredictionSet(PartitionVO partitionVO) throws ODMrDAOException {
        Object object;
        Object object2;
        SQLHelper sQLHelper = new SQLHelper();
        ArrayList<TargetPriorsPredictionSet> arrayList = new ArrayList<TargetPriorsPredictionSet>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select prediction, probability from table(prediction_set( ");
        stringBuilder.append(Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), false));
        if (StringUtils.isNotEmpty(partitionVO.getPartitionID())) {
            stringBuilder.append(" using ");
            object2 = partitionVO.getColumns();
            for (int i = 0; i < object2.size(); ++i) {
                object = (PartitionColumn)object2.get(i);
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("'");
                stringBuilder.append(object.getValue());
                stringBuilder.append("' as ");
                stringBuilder.append(object.getColumnName());
            }
            stringBuilder.append("))");
        } else {
            stringBuilder.append(" using <bfile_workaround>))");
        }
        object2 = this.getBFILEColumns();
        String string = StringUtils.getReplacedString(stringBuilder.toString(), "<bfile_workaround>", (String)object2);
        try {
            sQLHelper.conn = this.connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            object = sQLHelper.rs.getMetaData();
            int n = object.getColumnType(1);
            while (sQLHelper.rs.next()) {
                TargetPriorsPredictionSet targetPriorsPredictionSet = null;
                Object object3 = null;
                if (DatabaseMetadataUtils.isSQLDataTypeNumeric(n)) {
                    object3 = sQLHelper.rs.getBigDecimal("PREDICTION");
                } else if (DatabaseMetadataUtils.isSQLDataTypeString(n)) {
                    object3 = sQLHelper.rs.getString("PREDICTION");
                } else if (DatabaseMetadataUtils.isSQLDataTypeString(n)) {
                    object3 = sQLHelper.rs.getDate("PREDICTION");
                } else {
                    throw new Exception("Unexpected target data type. Expected either a number, string or date.");
                }
                targetPriorsPredictionSet = new TargetPriorsPredictionSet(object3, n, sQLHelper.rs.getDouble("PROBABILITY"));
                arrayList.add(targetPriorsPredictionSet);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    public TargetPriorsPredictionSet findMostCommonTargetValue(List<TargetPriorsPredictionSet> list) {
        Double d = 0.0;
        Object object = null;
        TargetPriorsPredictionSet targetPriorsPredictionSet = null;
        for (TargetPriorsPredictionSet targetPriorsPredictionSet2 : list) {
            if (!(d <= targetPriorsPredictionSet2.getProbability())) continue;
            d = targetPriorsPredictionSet2.getProbability();
            object = targetPriorsPredictionSet2.getPrediction();
            targetPriorsPredictionSet = targetPriorsPredictionSet2;
        }
        assert (object != null) : "Unable to find a target value with a prob value >= 0";
        return targetPriorsPredictionSet;
    }

    public TargetPriorsPredictionSet findSecondMostCommonTargetValue(List<TargetPriorsPredictionSet> list, TargetPriorsPredictionSet targetPriorsPredictionSet) {
        Double d = 0.0;
        Object object = null;
        TargetPriorsPredictionSet targetPriorsPredictionSet2 = null;
        for (TargetPriorsPredictionSet targetPriorsPredictionSet3 : list) {
            if (targetPriorsPredictionSet3.getPrediction().equals(targetPriorsPredictionSet.getPrediction()) || !(d <= targetPriorsPredictionSet3.getProbability())) continue;
            d = targetPriorsPredictionSet3.getProbability();
            object = targetPriorsPredictionSet3.getPrediction();
            targetPriorsPredictionSet2 = targetPriorsPredictionSet3;
        }
        assert (object != null) : "Unable to find a target value with a prob value >= 0";
        return targetPriorsPredictionSet2;
    }

    public static boolean areTargetValuesTheSame(ConnectionManager connectionManager, List<String> list) throws SQLException {
        return Classification.areTargetValuesTheSame(connectionManager, list, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean areTargetValuesTheSame(ConnectionManager connectionManager, List<String> list, String string) throws SQLException {
        String string2;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator<String> iterator = list.iterator();
        boolean bl2 = true;
        if (string != null && string.length() != 0) {
            stringBuffer.append(StringUtils.getReplacedString(MODEL_PREDICTION_SELECT, "<MODEL_NAME>", string + ""));
            bl2 = false;
        }
        while (iterator.hasNext()) {
            string2 = iterator.next();
            if (bl2) {
                stringBuffer.append(StringUtils.getReplacedString(MODEL_PREDICTION_SELECT, "<MODEL_NAME>", string2 + ""));
            }
            stringBuffer2.append(StringUtils.getReplacedString(SELECT_MINUS_TARGETS, "<MODEL_NAME>", string2 + ""));
            if (!iterator.hasNext()) continue;
            if (bl2) {
                stringBuffer.append(" UNION \n");
            }
            stringBuffer2.append(" UNION \n");
        }
        string2 = StringUtils.getReplacedString(TARGET_VALUE_COMPARE_QUERY, "<SELECT_FOR_ALL_TARGET_VALUES>", stringBuffer.toString() + "");
        string2 = StringUtils.getReplacedString(string2, "<SELECT_FOR_COMPARE>", stringBuffer2.toString() + "");
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string2);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                bl = false;
            }
        }
        return bl;
    }
}

