/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.wflownodes;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ARModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.EMClusterModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ESAModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.KMModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NMFModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.OCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.PCAModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.RModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVDModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMRModelNode;
import oracle.dmt.dataminer.navigator.net.DMURLFileSystemHelper;
import oracle.dmt.dataminer.navigator.wflownodes.BuildNavNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionModelType;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriModelType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ExpectationMaximizationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisModelType;
import oracle.dmt.dataminer.workflow.xmlschema.KMeansModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;

public class BuildNavNodeFilter
extends BaseDeferredFilter {
    @Override
    protected List<Element> loadChildrenImpl(TNode tNode) throws Exception {
        BuildNavNode buildNavNode = (BuildNavNode)tNode.getData();
        ConnectionFolder connectionFolder = buildNavNode.getConnectionFolder();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        buildNavNode.open();
        NodeType nodeType = (NodeType)buildNavNode.getRepositoryData();
        if (nodeType instanceof BuildNodeType) {
            List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)nodeType);
            for (ModelType modelType : list) {
                String string = connectionFolder.getUserAccountName();
                string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string;
                BaseTreeNode baseTreeNode = BuildNavNodeFilter.getChildNode(buildNavNode.getURL().getPath() + "/" + modelType.getName(), modelType, string);
                baseTreeNode.setParent(this.getOwner());
                baseTreeNode.setConnectionFolder(connectionFolder);
                arrayList.add((Element)baseTreeNode);
            }
        }
        return arrayList;
    }

    public static BaseTreeNode getChildNode(String string, Object object, String string2) throws Exception {
        BaseTreeNode baseTreeNode = null;
        if (object instanceof ModelType) {
            ModelType modelType = (ModelType)object;
            Class clazz = null;
            if (modelType instanceof NaiveBayesModelType) {
                clazz = NBModelNode.class;
            } else if (modelType instanceof DecisionTreeModelType) {
                clazz = DTModelNode.class;
            } else if (modelType instanceof CGeneralizedLinearModelType) {
                clazz = GLMCModelNode.class;
            } else if (modelType instanceof CSupportVectorMachineModelType) {
                clazz = SVMCModelNode.class;
            } else if (modelType instanceof AnomalyDetectionModelType) {
                clazz = ANModelNode.class;
            } else if (modelType instanceof RGeneralizedLinearModelType) {
                clazz = GLMRModelNode.class;
            } else if (modelType instanceof RSupportVectorMachineModelType) {
                clazz = SVMRModelNode.class;
            } else if (modelType instanceof KMeansModelType) {
                clazz = KMModelNode.class;
            } else if (modelType instanceof OClusterModelType) {
                clazz = OCModelNode.class;
            } else if (modelType instanceof ExpectationMaximizationModelType) {
                clazz = EMClusterModelNode.class;
            } else if (modelType instanceof AprioriModelType) {
                clazz = ARModelNode.class;
            } else if (modelType instanceof NonNegativeMatrixFactorModelType) {
                clazz = NMFModelNode.class;
            } else if (modelType instanceof SVDModelType) {
                clazz = SVDModelNode.class;
            } else if (modelType instanceof PCAModelType) {
                clazz = PCAModelNode.class;
            } else if (modelType instanceof ExplicitSemanticAnalysisModelType) {
                clazz = ESAModelNode.class;
            } else if (modelType instanceof RModelType) {
                clazz = RModelNode.class;
            }
            String string3 = modelType.getName();
            if (string3 != null) {
                URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)string);
                ModelNode modelNode = (ModelNode)NodeFactory.findOrCreate(clazz, (URL)uRL);
                modelNode.setURL(uRL);
                modelNode.setSchema(string2);
                modelNode.setRepositoryData(modelType);
                baseTreeNode = (BaseTreeNode)((Object)modelNode);
            }
        }
        return baseTreeNode;
    }
}

