/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.svd;

import java.util.Comparator;
import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.fe.svd.SVDCoefficient;
import oracle.dmt.dataminer.core.utils.comparator.AbsoluteNumberComparator;
import oracle.dmt.dataminer.core.utils.comparator.LetterNumberComparator;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.mviewer.svd.SVDLrb;

public class SingularValuesTableModel
extends ODMrTableModel<SVDCoefficient> {
    static final int FEATURE_ID_COLUMN = 0;
    static final int SINGULAR_VALUE_COLUMN = 1;
    private static final String[] COLUMN_NAMES = new String[]{SVDLrb.get("FEATURE_ID_COLUMN"), SVDLrb.get("SINGULAR_VALUE_COLUMN")};
    private boolean _absoluteSort;

    public SingularValuesTableModel() {
        super(COLUMN_NAMES);
    }

    public SingularValuesTableModel(List<SVDCoefficient> list) {
        super(COLUMN_NAMES, list);
    }

    public void updateFeatureID(String string, String string2) {
        for (SVDCoefficient sVDCoefficient : this.srcData) {
            if (!sVDCoefficient.getAttributeName().equals(string2)) continue;
            sVDCoefficient.setAttributeName(string);
            break;
        }
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 1: {
                return this._absoluteSort ? AbsoluteNumberComparator.getComparator() : NumberComparator.getComparator();
            }
            case 0: {
                return LetterNumberComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        SVDCoefficient sVDCoefficient = (SVDCoefficient)this.srcData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = sVDCoefficient.getAttributeName();
                break;
            }
            case 1: {
                object = sVDCoefficient.getSingularValue();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        return object == null ? "NULL" : object;
    }

    public void setAbsoluteValueSort(boolean bl) {
        this._absoluteSort = bl;
    }

    public int getColumnAlignment(int n) {
        return 4;
    }
}

