/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.model.common.build.MiningAttributeInfo;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;

class SettingsViewerTextAttrsTableModel
extends ODMrTableModel<MiningAttributeInfo> {
    static final int ATTRIBUTE_NAME = 0;
    static final int DATA_TYPE = 1;
    static final int MINING_TYPE = 2;
    private static final String[] COLUMNS = new String[]{CoreCommonLrb.get((String)"NAME"), CoreCommonLrb.get((String)"DATA_TYPE"), CoreCommonLrb.get((String)"MINING_TYPE")};

    SettingsViewerTextAttrsTableModel() {
        super(COLUMNS);
    }

    SettingsViewerTextAttrsTableModel(List<MiningAttributeInfo> list) {
        super(COLUMNS, list);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        MiningAttributeInfo miningAttributeInfo = (MiningAttributeInfo)this.srcData.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = miningAttributeInfo.getAttributeName();
                break;
            }
            case 1: {
                string = miningAttributeInfo.getDataType();
                break;
            }
            case 2: {
                string = ServerConstants.MiningType.toHuman((String)miningAttributeInfo.getAttributeType());
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing model attributes";
                break;
            }
        }
        if (string == null) {
            return "NULL";
        }
        return string;
    }
}

