/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.math.BigDecimal;
import java.sql.Date;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dmt.dataminer.controls.BaseTreeTableNode;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetComputedSettingsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetModelDetailsGlobalQuery;
import oracle.dmt.dataminer.core.model.common.NameValue;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.common.build.ModelGeneralDescription;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.Formats;
import oracle.javatools.ui.treetable.AbstractTreeTableModel;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.javatools.util.Version;

class SettingsViewerGeneralTreeTableModel
extends AbstractTreeTableModel {
    private int _maxStrLength;
    private SqlDataAccessObject dao;
    private ModelSettingsNode _root = new ModelSettingsNode();
    private static final int COLUMN_COUNT = 2;
    static final int SETTING_NAME = 0;
    static final int SETTING_VALUE = 1;
    private static final String[] COLUMNS = new String[]{CoreCommonLrb.get((String)"NAME"), CoreCommonLrb.get((String)"VALUE")};
    private int nodeCount = 1;
    private static String _NOT_BUILT = SettingsLrb.get("BUILD_MODEL_NOT_BUILT");

    public int getNodeCount() {
        return this.nodeCount;
    }

    public Object getRoot() {
        return this._root;
    }

    public SettingsViewerGeneralTreeTableModel() {
        super((Object)new DefaultMutableTreeNode("-"));
    }

    public int getMaxStringLength() {
        return this._maxStrLength;
    }

    public int getChildCount(Object object) {
        return ((DefaultMutableTreeNode)object).getChildCount();
    }

    public Object getChild(Object object, int n) {
        return ((DefaultMutableTreeNode)object).getChildAt(n);
    }

    public Class getColumnClass(int n) {
        return n == 0 ? TreeTableModel.class : String.class;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        return COLUMNS[n];
    }

    public Object getValueAt(Object object, int n) {
        return object instanceof ModelSettingsNode ? ((ModelSettingsNode)object).getValue(n) : "";
    }

    void loadTempStatusNode(String string) {
        if (this._root.getChildCount() > 0) {
            this._root.removeAllChildren();
        }
        ModelSettingsNode modelSettingsNode = new ModelSettingsNode(string);
        this._root.add(modelSettingsNode);
        this.fireTreeStructureChanged((Object)this, new TreeNode[]{this._root}, null, null);
    }

    public void loadTree(Model model, ConnectionManager connectionManager, String string) throws ODMrDAOException {
        this.loadGeneralSettings(model.getModelGeneralDescription());
        this.loadMiningModelSettings(model, connectionManager, string);
        if (DbVersionHelper.isDB122Up((Version)connectionManager.getDbVersion())) {
            this.loadBuildDetailsSettings(model, connectionManager, string);
        }
        this.fireTreeStructureChanged((Object)this, new TreeNode[]{this._root}, null, null);
    }

    public boolean isCellEditable(Object object, int n) {
        if (n == 0) {
            return true;
        }
        return super.isCellEditable(object, n);
    }

    private void loadGeneralSettings(ModelGeneralDescription modelGeneralDescription) {
        BigDecimal bigDecimal;
        String string;
        BigDecimal bigDecimal2;
        if (this._root.getChildCount() > 0) {
            this._root.removeAllChildren();
        }
        this.nodeCount = 1;
        ModelSettingsNode modelSettingsNode = new ModelSettingsNode(CoreCommonLrb.get((String)"GENERAL"));
        this._root.add(modelSettingsNode);
        ++this.nodeCount;
        String string2 = ServerConstants.MiningFunction.getUIFunctionName((String)modelGeneralDescription.getMiningFunction());
        ModelSettingsNode modelSettingsNode2 = new ModelSettingsNode(CoreCommonLrb.get((String)"TYPE"), string2);
        modelSettingsNode.add(modelSettingsNode2);
        ++this.nodeCount;
        this._maxStrLength = string2.length();
        modelSettingsNode2 = new ModelSettingsNode(CoreCommonLrb.get((String)"OWNER"), modelGeneralDescription.getOwner());
        modelSettingsNode.add(modelSettingsNode2);
        ++this.nodeCount;
        if (null != modelGeneralDescription.getOwner()) {
            this._maxStrLength = Math.max(this._maxStrLength, modelGeneralDescription.getOwner().length());
        }
        modelSettingsNode2 = new ModelSettingsNode(CoreCommonLrb.get((String)"MODEL_NAME"), modelGeneralDescription.getModelName());
        modelSettingsNode.add(modelSettingsNode2);
        ++this.nodeCount;
        if (null != modelGeneralDescription.getModelName()) {
            this._maxStrLength = Math.max(this._maxStrLength, modelGeneralDescription.getModelName().length());
        }
        if (modelGeneralDescription.getTargetAttributeName() != null) {
            modelSettingsNode2 = new ModelSettingsNode(SettingsLrb.get("TARGET_NAME"), modelGeneralDescription.getTargetAttributeName());
            modelSettingsNode.add(modelSettingsNode2);
            ++this.nodeCount;
            if (null != modelGeneralDescription.getTargetAttributeName()) {
                this._maxStrLength = Math.max(this._maxStrLength, modelGeneralDescription.getTargetAttributeName().length());
            }
        }
        Date date = modelGeneralDescription.getCreationDate();
        DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());
        String string3 = date != null ? dateFormat.format(new java.util.Date(date.getTime())) : _NOT_BUILT;
        modelSettingsNode2 = new ModelSettingsNode(SettingsLrb.get("CREATION_DATE"), string3);
        modelSettingsNode.add(modelSettingsNode2);
        ++this.nodeCount;
        if (null != string3) {
            this._maxStrLength = Math.max(this._maxStrLength, string3.length());
        }
        if ((bigDecimal2 = modelGeneralDescription.getBuildDuration()) != null) {
            double d = bigDecimal2.doubleValue() / 60.0;
            string = NumericFormat.format((double)d, (boolean)true, (int)4);
        } else {
            string = "";
        }
        modelSettingsNode2 = new ModelSettingsNode(SettingsLrb.get("DURATION"), string);
        modelSettingsNode.add(modelSettingsNode2);
        ++this.nodeCount;
        if (null != string) {
            this._maxStrLength = Math.max(this._maxStrLength, string.length());
        }
        String string4 = (bigDecimal = modelGeneralDescription.getModelSize()) != null ? NumericFormat.format((double)bigDecimal.doubleValue(), (boolean)true, (int)4) : "";
        modelSettingsNode2 = new ModelSettingsNode(SettingsLrb.get("SIZE"), string4);
        modelSettingsNode.add(modelSettingsNode2);
        ++this.nodeCount;
        if (null != string4) {
            this._maxStrLength = Math.max(this._maxStrLength, string4.length());
        }
        modelSettingsNode2 = new ModelSettingsNode(CoreCommonLrb.get((String)"COMMENT"), modelGeneralDescription.getComments());
        modelSettingsNode.add(modelSettingsNode2);
        ++this.nodeCount;
        if (null != modelGeneralDescription.getComments()) {
            this._maxStrLength = Math.max(this._maxStrLength, modelGeneralDescription.getComments().length());
        }
    }

    private void loadMiningModelSettings(Model model, ConnectionManager connectionManager, String string) throws ODMrDAOException {
        String string2;
        String string3;
        Object object;
        List<MiningModelSettings> list = model.getModelSettings();
        ModelSettingsNode modelSettingsNode = new ModelSettingsNode(CoreCommonLrb.get((String)"ALGORITHM"));
        this._root.add(modelSettingsNode);
        ++this.nodeCount;
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        for (int i = 0; i < list.size(); ++i) {
            MiningModelSettings miningModelSettings2 = list.get(i);
            if (MiningModelSettings.filterOutSettings((String)miningModelSettings2.getSettingName())) continue;
            object = MiningModelSettings.translateModelSettingsName((String)miningModelSettings2.getSettingName());
            String string4 = object != null ? object : miningModelSettings2.getSettingName();
            string3 = MiningModelSettings.translateModelSettingsValue((String)miningModelSettings2.getSettingValue());
            string2 = string3 != null ? string3 : miningModelSettings2.getSettingValue();
            arrayList.add(new NameValue(string4, string2));
        }
        if (StringUtils.isNotEmpty(string)) {
            this.dao = new SqlDataAccessObject(connectionManager);
            ModelDescriptor modelDescriptor = new ModelDescriptor(model.getUserName(), model.getModelName(), string);
            GetComputedSettingsQuery getComputedSettingsQuery = new GetComputedSettingsQuery(connectionManager.getDbVersion(), modelDescriptor);
            object = this.dao.readItems((Query)getComputedSettingsQuery);
            for (int i = 0; i < object.size(); ++i) {
                String string5;
                string3 = (NameValue)object.get(i);
                string2 = MiningModelSettings.translateModelSettingsName((String)string3.getName());
                if (string2 != null) {
                    string3.setName(string2);
                }
                if ((string5 = MiningModelSettings.translateModelSettingsValue((String)string3.getStringValue())) == null) continue;
                string3.setStringValue(string5);
            }
            arrayList.addAll((Collection<NameValue>)object);
        }
        Collections.sort(arrayList);
        for (NameValue nameValue : arrayList) {
            object = new ModelSettingsNode(nameValue.getName(), nameValue.getStringValue());
            modelSettingsNode.add((MutableTreeNode)object);
            ++this.nodeCount;
        }
    }

    private void loadBuildDetailsSettings(Model model, ConnectionManager connectionManager, String string) throws ODMrDAOException {
        Object object;
        NumberFormat numberFormat = Formats.ModelViewer.getNumeric();
        NumberFormat numberFormat2 = Formats.ModelViewer.getPercentage();
        ModelSettingsNode modelSettingsNode = new ModelSettingsNode(SettingsLrb.get("BUILD_DETAILS"));
        this._root.add(modelSettingsNode);
        ++this.nodeCount;
        ArrayList arrayList = new ArrayList();
        this.dao = new SqlDataAccessObject(connectionManager);
        ModelDescriptor modelDescriptor = new ModelDescriptor(model.getUserName(), model.getModelName(), string);
        GetModelDetailsGlobalQuery getModelDetailsGlobalQuery = new GetModelDetailsGlobalQuery(connectionManager.getDbVersion(), modelDescriptor);
        List list = this.dao.readItems((Query)getModelDetailsGlobalQuery);
        block5: for (int i = 0; i < list.size(); ++i) {
            NameValuePair nameValuePair = (NameValuePair)list.get(i);
            object = nameValuePair.getValue();
            String string2 = nameValuePair.getName();
            String string3 = MiningModelSettings.translateModelSettingsName((String)nameValuePair.getName());
            if (string3 != null) {
                nameValuePair.setName(string3);
            }
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (bl) {
                    nameValuePair.setValue((Object)MiningModelSettings.translateModelSettingsValue((String)"YES"));
                    continue;
                }
                nameValuePair.setValue((Object)MiningModelSettings.translateModelSettingsValue((String)"NO"));
                continue;
            }
            if (string2.equals("TERMINATION")) {
                if (!(object instanceof Double)) continue;
                int n = ((Double)object).intValue();
                switch (n) {
                    case 0: {
                        nameValuePair.setValue((Object)MiningModelSettings.translateModelSettingsValue((String)"TERMINATION_NORMAL"));
                        break;
                    }
                    case 1: {
                        nameValuePair.setValue((Object)MiningModelSettings.translateModelSettingsValue((String)"TERMINATION_EARY"));
                        break;
                    }
                    case 2: {
                        nameValuePair.setValue((Object)MiningModelSettings.translateModelSettingsValue((String)"TERMINATION_SKIP_CATEGORICALS"));
                        break;
                    }
                    default: {
                        assert (false) : "The setting value of GLM_GLOBAL_TERMINATION should be a valid value(0,1,2).";
                        continue block5;
                    }
                }
                continue;
            }
            if (object instanceof Double) {
                if (string2.equals("PCT_CORRECT") || string2.equals("PCT_INCORRECT") || string2.equals("PCT_TIED") || string2.equals("EMCS_LOGLIKE_IMPROVEMENT")) {
                    nameValuePair.setValue((Object)(numberFormat2.format(100.0 * (Double)object) + "%"));
                    continue;
                }
                if (string2.equals("LOGLIKELIHOOD")) {
                    nameValuePair.setValue((Object)(numberFormat.format((Double)object) + "%"));
                    continue;
                }
                nameValuePair.setValue((Object)numberFormat.format((Double)object));
                continue;
            }
            String string4 = MiningModelSettings.translateModelSettingsValue((String)object.toString());
            if (string4 == null) continue;
            nameValuePair.setValue((Object)string4);
        }
        arrayList.addAll(list);
        Collections.sort(arrayList);
        for (NameValuePair nameValuePair : arrayList) {
            object = new ModelSettingsNode(nameValuePair.getName(), nameValuePair.getValue().toString());
            modelSettingsNode.add((MutableTreeNode)object);
            ++this.nodeCount;
        }
    }

    public static class ModelSettingsNode
    extends BaseTreeTableNode {
        protected int _type;
        protected int _ROOT = 0;
        protected int _FOLDER = 1;
        protected int _LEAF = 2;
        protected HashMap<String, Object> _values = new HashMap();

        public int getColumnCount() {
            return COLUMNS.length;
        }

        public String getColumnName(int n) {
            return COLUMNS[n];
        }

        public ModelSettingsNode() {
            this._type = this._ROOT;
            this._values.put(COLUMNS[0], "-");
            this._values.put(COLUMNS[1], "");
        }

        public ModelSettingsNode(String string) {
            this._type = this._FOLDER;
            this._values.put(COLUMNS[0], string);
            this._values.put(COLUMNS[1], "");
        }

        public ModelSettingsNode(String string, String string2) {
            this._type = this._LEAF;
            this._values.put(COLUMNS[0], string);
            this._values.put(COLUMNS[1], string2);
        }

        public Object getValue(int n) {
            Object object = this._values.get(COLUMNS[n]);
            return object != null ? object : "";
        }

        public void setValue(Object object, int n) {
            this._values.put(COLUMNS[n], object);
        }

        public boolean isFolderNode() {
            return this._type == this._FOLDER;
        }

        public boolean isLeafNode() {
            return this._type == this._LEAF;
        }

        public boolean isRootNode() {
            return this._type == this._ROOT;
        }

        @Override
        public String toString() {
            return this._values.get(COLUMNS[0]).toString();
        }

        public String getLabel() {
            return this.toString();
        }
    }
}

