/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.model.common.build.TextFeature;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;

class SettingsViewerFeaturesTableModel
extends ODMrTableModel<TextFeature> {
    static final int FEATURE_NAME = 0;
    static final int FEATURE_TYPE = 1;
    static final int FEATURE_FREQUENCY = 2;
    private static final String[] COLUMN_NAMES = new String[]{SettingsLrb.get("FEATURE_NAME"), CoreCommonLrb.get((String)"TYPE"), SettingsLrb.get("FEATURE_FREQUENCY")};

    SettingsViewerFeaturesTableModel() {
        super(COLUMN_NAMES);
    }

    SettingsViewerFeaturesTableModel(List<TextFeature> list) {
        super(COLUMN_NAMES, list);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 2) {
            return Integer.class;
        }
        return String.class;
    }

    public Object getValueAt(int n, int n2) {
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
        if (this.srcData == null || this.srcData.size() == 0) {
            return null;
        }
        TextFeature textFeature = (TextFeature)this.srcData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = textFeature.getName();
                break;
            }
            case 1: {
                object = ServerConstants.StopTokenType.toHuman((String)textFeature.getType());
                break;
            }
            case 2: {
                object = textFeature.getFrequency();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing model attributes";
                break;
            }
        }
        return object;
    }
}

