/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.mviewer.partition.SettingsPartitionModelTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.server.model.PartitionModelAttributeInfo;

public class PartitionKeysPanel
extends JPanel {
    private SettingsPartitionModelTableModel tableModel;
    private JLabel jExpressionLabel;
    private JPanel jExpressionPanel;
    private JScrollPane jScrollPane1;
    private JCheckBox jShowExpChk;
    private JSplitPane jSplitPane2;
    private JTextArea jTextArea2;
    private DataMinerTablePanel partitionsTablePanel;

    public PartitionKeysPanel() {
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jSplitPane2 = new JSplitPane();
        this.jExpressionPanel = new JPanel();
        this.jExpressionLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jShowExpChk = new JCheckBox();
        this.partitionsTablePanel = new DataMinerTablePanel();
        this.jSplitPane2.setDividerLocation(200);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(0.5);
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jExpressionPanel.setName("");
        this.jExpressionLabel.setText("Expression Details");
        this.jExpressionLabel.setVerticalAlignment(3);
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setRows(5);
        this.jTextArea2.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.jTextArea2);
        this.jShowExpChk.setLabel("Show Reverse Expression");
        GroupLayout groupLayout = new GroupLayout(this.jExpressionPanel);
        this.jExpressionPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 520, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jExpressionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jShowExpChk).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jExpressionLabel).addComponent(this.jShowExpChk)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 140, Short.MAX_VALUE)));
        this.jSplitPane2.setRightComponent(this.jExpressionPanel);
        this.jSplitPane2.setLeftComponent(this.partitionsTablePanel);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane2).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane2, -1, 454, Short.MAX_VALUE).addContainerGap()));
    }

    private void initUI() {
        this.jShowExpChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionKeysPanel.this.displayExpression();
            }
        });
        this.tableModel = new SettingsPartitionModelTableModel();
        this.partitionsTablePanel.setup((TableModel)((Object)this.tableModel), "", 0);
        this.partitionsTablePanel.getTable().setSelectionMode(0);
        this.partitionsTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PartitionKeysPanel.this.displayExpression();
            }
        });
        if (this.tableModel.getRowCount() > 0) {
            this.partitionsTablePanel.getTable().setSelectedRowInModel(0);
        }
    }

    private void displayExpression() {
        int[] nArray = this.partitionsTablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length > 0) {
            int n = nArray[0];
            PartitionModelAttributeInfo partitionModelAttributeInfo = (PartitionModelAttributeInfo)this.tableModel.getSrcData().get(n);
            this.jExpressionLabel.setText(SettingsLrb.get("PARTITION_EXPRESSION_DETAILS"));
            StringBuilder stringBuilder = new StringBuilder();
            if (StringUtils.isNotEmpty((String)partitionModelAttributeInfo.getExpression().toString())) {
                stringBuilder.append(SettingsLrb.get("MODEL_XFORM_TITLE"));
                stringBuilder.append("\n\t");
                stringBuilder.append(partitionModelAttributeInfo.getExpression().toString());
            }
            String string = StringUtils.toString((Object)partitionModelAttributeInfo.getRevExpression());
            if (this.jShowExpChk.isSelected() && StringUtils.isNotEmpty((String)string)) {
                stringBuilder.append("\n");
                stringBuilder.append(SettingsLrb.get("MODEL_REV_XFORM_TITLE"));
                stringBuilder.append("\n\t");
                stringBuilder.append(partitionModelAttributeInfo.getRevExpression());
            }
            this.jTextArea2.setText(stringBuilder.toString());
        }
    }

    public void setData(List<PartitionModelAttributeInfo> list) {
        this.tableModel.setSrcData(list);
    }
}

