/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.partition;

import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.server.model.PartitionModelAttributeInfo;

public class SettingsPartitionModelTableModel
extends ODMrTableModel<PartitionModelAttributeInfo> {
    public static final int PARTITION_KEY_NAME = 0;
    public static final int DATA_TYPE = 1;
    public static final int PARTITION_KEY_SOURCE = 2;
    public static final int PARTITION_KEY_VALUE = 3;
    public static final String[] COLUMNS = new String[]{CoreCommonLrb.get((String)"NAME"), CoreCommonLrb.get((String)"DATA_TYPE"), CoreCommonLrb.get((String)"SOURCE"), CoreCommonLrb.get((String)"VALUE")};

    public SettingsPartitionModelTableModel() {
        super(COLUMNS);
    }

    public SettingsPartitionModelTableModel(List<PartitionModelAttributeInfo> list) {
        super(COLUMNS, list);
    }

    public StringBuilder getExpression(int n) {
        return ((PartitionModelAttributeInfo)this.srcData.get(n)).getExpression();
    }

    public String getRevExpression(int n) {
        return ((PartitionModelAttributeInfo)this.srcData.get(n)).getRevExpression();
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        PartitionModelAttributeInfo partitionModelAttributeInfo = (PartitionModelAttributeInfo)this.srcData.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = partitionModelAttributeInfo.getPartitionKeyName();
                break;
            }
            case 1: {
                string = partitionModelAttributeInfo.getDataType();
                break;
            }
            case 2: {
                if ("".equals(partitionModelAttributeInfo.getExpression().toString().trim())) {
                    string = CoreCommonLrb.get((String)"COLUMN");
                    break;
                }
                string = SettingsLrb.get("PARTITION_EXPRESSION");
                break;
            }
            case 3: {
                string = partitionModelAttributeInfo.getPartitionKeyValue();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing model attributes";
                break;
            }
        }
        if (string == null) {
            return "NULL";
        }
        return string;
    }
}

