/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.glmdetails;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.common.build.GLMModelDetail;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.dmt.dataminer.utils.Formats;

public class GLMDetailsTableModel
extends ODMrTableModel<GLMModelDetail> {
    public static final int NAME = 0;
    public static final int VALUE = 1;
    private static final String[] COLUMNS = new String[]{CommonLrb.get("NAME"), CommonLrb.get("VALUE")};
    private NumberFormat numericFormat;
    private NumberFormat percentageFormat = Formats.ModelViewer.getPercentage();

    public GLMDetailsTableModel() {
        super(COLUMNS, new ArrayList());
        this.numericFormat = Formats.ModelViewer.getNumeric(EnumSet.of(Formats.Options.MAX), 1);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        GLMModelDetail gLMModelDetail = (GLMModelDetail)this.srcData.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = this.getSettingName(gLMModelDetail.getName());
                break;
            }
            case 1: {
                string = this.getRowValue(gLMModelDetail);
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing global details";
                break;
            }
        }
        if (string == null) {
            return "NULL";
        }
        return string;
    }

    private String getRowValue(GLMModelDetail gLMModelDetail) {
        Object object = gLMModelDetail.getValue();
        String string = object instanceof Boolean ? this.getBooleanTranslation(object) : ("TERMINATION".equals(gLMModelDetail.getName()) ? this.getGlobalTerminationDescription(object) : (object instanceof Double ? this.getFormattedDouble(gLMModelDetail.getName(), object) : this.getSettingValue(object)));
        return string;
    }

    private String getSettingName(Object object) {
        return MiningModelSettings.translateModelSettingsName((String)object.toString());
    }

    private String getBooleanTranslation(Object object) {
        boolean bl = (Boolean)object;
        String string = bl ? MiningModelSettings.translateModelSettingsValue((String)"YES") : MiningModelSettings.translateModelSettingsValue((String)"NO");
        return string;
    }

    private String getGlobalTerminationDescription(Object object) {
        String string = null;
        if (object instanceof Double) {
            int n = ((Double)object).intValue();
            switch (n) {
                case 0: {
                    string = MiningModelSettings.translateModelSettingsValue((String)"TERMINATION_NORMAL");
                    break;
                }
                case 1: {
                    string = MiningModelSettings.translateModelSettingsValue((String)"TERMINATION_EARY");
                    break;
                }
                case 2: {
                    string = MiningModelSettings.translateModelSettingsValue((String)"TERMINATION_SKIP_CATEGORICALS");
                    break;
                }
                default: {
                    assert (false) : "The setting value of GLM_GLOBAL_TERMINATION should be a valid value(0,1,2).";
                    break;
                }
            }
        }
        return string;
    }

    private String getFormattedDouble(String string, Object object) {
        double d = (Double)object;
        String string2 = "PCT_CORRECT".equals(string) || "PCT_INCORRECT".equals(string) || "PCT_TIED".equals(string) ? this.getPercentageFormattedValue(d) : this.getNumericFormattedValue(d);
        return string2;
    }

    private String getPercentageFormattedValue(double d) {
        return this.percentageFormat.format(100.0 * d) + "%";
    }

    private String getNumericFormattedValue(double d) {
        return this.numericFormat.format(d);
    }

    private String getSettingValue(Object object) {
        return MiningModelSettings.translateModelSettingsValue((String)object.toString());
    }
}

