/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.SortOrder;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.common.build.ColumnFilter;
import oracle.dmt.dataminer.core.model.fe.common.FeatureCoefficient;
import oracle.dmt.dataminer.core.model.fe.common.FeatureItemSet;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.model.filter.SortType;
import oracle.dmt.dataminer.core.utils.comparator.TagComparator;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.ESACoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.features.ESAFeatureFilterTableModel;
import oracle.dmt.dataminer.mviewer.features.ESAFeatureItemsTableModel;
import oracle.dmt.dataminer.mviewer.features.ESAFeatureViewerSettings;
import oracle.dmt.dataminer.mviewer.features.FeatureLrb;
import oracle.dmt.dataminer.server.model.FeatureExtraction;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.Context;
import oracle.javatools.util.Version;

public class FeatureViewerState
extends BaseViewerState {
    private static final String COEFFICIENT = "COEFFICIENT";
    private static final Predicate<SortSpec> IS_NOT_COEFFICIENT_SPEC = sortSpec -> !COEFFICIENT.equals(sortSpec.getAttributeName());
    private static final Predicate<SortSpec> IS_COEFFICIENT_SPEC = sortSpec -> COEFFICIENT.equals(sortSpec.getAttributeName());
    private static final int DEFAULT_ITEM_FETCH_SIZE = 20;
    private static final int DEFAULT_COEFFICIENT_FETCH_SIZE = 100;
    private static final int DEFAULT_FEATURE_FETCH_SIZE = 2000;
    private static final ESAFeatureViewerSettings FEATURE_SETTINGS = ESAFeatureViewerSettings.getInstance();
    private int itemsFetchSize;
    private int featuresFetchSize;
    private int coefficientsFetchSize;
    private ColumnFilter.Match matchType;
    private List<String> availableAttributes;
    private List<SortSpec> sortingSpecs;
    private FeatureItemSet selectedFeatureItemSet;
    private FeatureExtraction featureExtractionModel;
    private List<MiningAttributeType> inputAttributes;
    private ESACoefViewerTableModel coefficientTableModel;
    private ESAFeatureItemsTableModel featureItemsTableModel;
    private ESAFeatureFilterTableModel featureFilterTableModel;

    public FeatureViewerState(Context context) {
        super(context);
        this.objectsInitialization();
        if (this.isESA()) {
            this.addESASortingSpecifications();
        }
        this.featureExtractionModel = this.getFeatureExtraction();
    }

    private void objectsInitialization() {
        this.matchType = ColumnFilter.Match.ALL;
        this.itemsFetchSize = 20;
        this.featuresFetchSize = 2000;
        this.coefficientsFetchSize = 100;
        this.inputAttributes = new ArrayList<MiningAttributeType>();
        this.availableAttributes = new ArrayList<String>();
        this.sortingSpecs = new ArrayList<SortSpec>();
        this.coefficientTableModel = new ESACoefViewerTableModel();
        this.featureItemsTableModel = new ESAFeatureItemsTableModel();
        this.featureFilterTableModel = new ESAFeatureFilterTableModel();
    }

    private void addESASortingSpecifications() {
        this.sortingSpecs.add(new SortSpec("coefficient".toUpperCase(), SortDirection.DESCENDING, true));
        this.sortingSpecs.add(new SortSpec("attribute_name".toUpperCase(), SortDirection.ASCENDING, true));
        this.sortingSpecs.add(new SortSpec("attribute_subname".toUpperCase(), SortDirection.ASCENDING, true));
        this.sortingSpecs.add(new SortSpec("attribute_value".toUpperCase(), SortDirection.ASCENDING, true));
    }

    public List<MiningAttributeType> getInputAttributesFromDB() throws ODMrDAOException {
        return this.featureExtractionModel.getMiningAttributeTypes();
    }

    public void loadPartitionData(String string) throws ODMrDAOException {
        this.setPartitionId(string);
        this.loadPartitionFeatureItemSets();
        this.loadAvailableAttributes();
    }

    public void loadPartitionFeatureItemSets() throws ODMrDAOException {
        List<FeatureItemSet> list = this.queryFeatureItemSets();
        this.featureItemsTableModel.addRows(list);
    }

    public void loadAvailableAttributes() throws ODMrDAOException {
        this.availableAttributes = this.queryAvailableAttributes();
    }

    private List<FeatureItemSet> queryFeatureItemSets() throws ODMrDAOException {
        Class<? extends ModelType> clazz = this.getModelTypeClass();
        List<FeatureItemSet> list = this.featureExtractionModel.getFeatureItemSets(clazz, this.featureFilterTableModel.getSrcData(), this.matchType, this.getFeatureSortDirection(), this.featuresFetchSize, FEATURE_SETTINGS.getItemAggregationFetchSize());
        return list;
    }

    private List<String> queryAvailableAttributes() throws ODMrDAOException {
        Class<? extends ModelType> clazz = this.getModelTypeClass();
        List<String> list = this.featureExtractionModel.getAvailableAttributes(clazz);
        return list;
    }

    public void loadSelectedFeatureCoefficients() throws ODMrDAOException {
        List<FeatureCoefficient> list;
        if (this.selectedFeatureItemSet == null) {
            return;
        }
        this.prepareSortPolicy();
        List<ColumnFilter> list2 = this.getAttributeFiltersOnly();
        String string = this.selectedFeatureItemSet.getFeatureId();
        if (this.retrieveFilteredCoefficientsOnly() && !list2.isEmpty()) {
            list = this.getPrefilteredFeatureCoefficients(string, list2);
            this.setCoefficientsFiltered(list);
        } else {
            list = this.getFeatureCoefficients(string);
            this.highlightMatchingCoefficients(list, list2);
        }
        Collections.sort(list, new TagComparator(this.getCoefficientSortType(), this.getCoefficientSortDirection()));
        this.coefficientTableModel.clear();
        this.coefficientTableModel.addRows(list);
    }

    private void prepareSortPolicy() {
        this.enableAllSortingSpecifications();
        SortType sortType = this.getCoefficientSortType();
        SortDirection sortDirection = this.getCoefficientSortDirection();
        switch (sortType) {
            case NUMERICAL: {
                this.prepareNumericalSorting(sortDirection);
                break;
            }
            default: {
                this.prepareAlphabeticalSorting(sortDirection);
            }
        }
    }

    private void enableAllSortingSpecifications() {
        this.sortingSpecs.forEach(sortSpec -> sortSpec.setUseIt(true));
    }

    private void prepareNumericalSorting(SortDirection sortDirection) {
        this.setDirectionToFilteredSpecs(IS_COEFFICIENT_SPEC, sortDirection);
        this.setDirectionToFilteredSpecs(IS_NOT_COEFFICIENT_SPEC, SortDirection.ASCENDING);
    }

    private void setDirectionToFilteredSpecs(Predicate<SortSpec> predicate, SortDirection sortDirection) {
        this.sortingSpecs.stream().filter(predicate).forEach(sortSpec -> sortSpec.setSortDirection(sortDirection));
    }

    private void prepareAlphabeticalSorting(SortDirection sortDirection) {
        this.setDirectionToFilteredSpecs(IS_NOT_COEFFICIENT_SPEC, sortDirection);
        this.disableFilteredSpecifications(IS_COEFFICIENT_SPEC);
    }

    private void disableFilteredSpecifications(Predicate<SortSpec> predicate) {
        this.sortingSpecs.stream().filter(predicate).forEach(sortSpec -> sortSpec.setUseIt(false));
    }

    private List<ColumnFilter> getAttributeFiltersOnly() {
        List<ColumnFilter> list = this.featureFilterTableModel.getSrcData();
        List<ColumnFilter> list2 = this.removeFeatureIdFilters(list);
        return list2;
    }

    private List<ColumnFilter> removeFeatureIdFilters(List<ColumnFilter> list) {
        List<ColumnFilter> list2 = list.stream().filter(columnFilter -> !FeatureLrb.get("FEATURE_ID_TAG").equals(columnFilter.getTargetColumn().getColumnName())).collect(Collectors.toList());
        return list2;
    }

    public boolean retrieveFilteredCoefficientsOnly() {
        return FEATURE_SETTINGS.areCoefficientsFiltered();
    }

    private List<FeatureCoefficient> getPrefilteredFeatureCoefficients(String string, List<ColumnFilter> list) throws ODMrDAOException {
        List<FeatureCoefficient> list2 = this.featureExtractionModel.getFeatureCoefficients(this.getModelTypeClass(), list, this.sortingSpecs, this.matchType, this.coefficientsFetchSize, string);
        return list2;
    }

    private void setCoefficientsFiltered(List<FeatureCoefficient> list) {
        list.forEach(featureCoefficient -> featureCoefficient.setFiltered(true));
    }

    private List<FeatureCoefficient> getFeatureCoefficients(String string) throws ODMrDAOException {
        List<FeatureCoefficient> list = this.featureExtractionModel.getFeatureCoefficients(this.getModelTypeClass(), this.sortingSpecs, this.coefficientsFetchSize, string);
        return list;
    }

    private void highlightMatchingCoefficients(List<FeatureCoefficient> list, List<ColumnFilter> list2) {
        if (!list2.isEmpty()) {
            List<FeatureCoefficient> list3 = this.getCoefficientsToHighlight(list, list2);
            this.setCoefficientsFiltered(list3);
        }
    }

    private List<FeatureCoefficient> getCoefficientsToHighlight(List<FeatureCoefficient> list, List<ColumnFilter> list2) {
        Map<String, List<ColumnFilter>> map = this.groupFiltersByName(list2);
        List<Object> list3 = map.size() == 1 ? list.stream().filter(featureCoefficient -> this.coefficientMatchesFilters((FeatureCoefficient)featureCoefficient, list2)).collect(Collectors.toList()) : list.stream().filter(featureCoefficient -> {
            if (!map.containsKey(featureCoefficient.getAttributeName())) {
                return false;
            }
            List list = (List)map.get(featureCoefficient.getAttributeName());
            return this.coefficientMatchesFilters((FeatureCoefficient)featureCoefficient, list);
        }).collect(Collectors.toList());
        return list3;
    }

    private Map<String, List<ColumnFilter>> groupFiltersByName(List<ColumnFilter> list) {
        Map<String, List<ColumnFilter>> map = list.stream().collect(Collectors.groupingBy(columnFilter -> columnFilter.getTargetColumn().getColumnName()));
        return map;
    }

    private boolean coefficientMatchesFilters(FeatureCoefficient featureCoefficient, List<ColumnFilter> list) {
        Version version = this.connectionManager.getDbVersion();
        Class<? extends ModelType> clazz = this.getModelTypeClass();
        switch (this.matchType) {
            case ALL: {
                return list.stream().allMatch(featureCoefficient.getColumnFilterPredicate(version, clazz));
            }
            case ANY: {
                return list.stream().anyMatch(featureCoefficient.getColumnFilterPredicate(version, clazz));
            }
            case NONE: {
                return list.stream().noneMatch(featureCoefficient.getColumnFilterPredicate(version, clazz));
            }
        }
        return true;
    }

    public void setInputAttributes(List<MiningAttributeType> list) {
        if (list != null) {
            this.inputAttributes = list;
        }
    }

    public List<MiningAttributeType> getInputAttributes() {
        return this.inputAttributes;
    }

    public ESACoefViewerTableModel getCoefficientTableModel() {
        return this.coefficientTableModel;
    }

    public ESAFeatureItemsTableModel getFeatureItemsTableModel() {
        return this.featureItemsTableModel;
    }

    public ESAFeatureFilterTableModel getFeatureFilterTableModel() {
        return this.featureFilterTableModel;
    }

    public void setSelectedFeature(FeatureItemSet featureItemSet) {
        this.selectedFeatureItemSet = featureItemSet;
    }

    public FeatureItemSet getSelectedFeature() {
        return this.selectedFeatureItemSet;
    }

    public Version getDbVersion() {
        return this.connectionManager.getDbVersion();
    }

    public void setCoefficientsFiltered(boolean bl) {
        FEATURE_SETTINGS.setCoefficientsFiltered(bl);
    }

    public int getItemFetchSize() {
        return FEATURE_SETTINGS.getItemAggregationFetchSize();
    }

    public void setItemFetchSize(int n) {
        FEATURE_SETTINGS.setItemAggregationFetchSize(n);
    }

    public void setFeatureFetchSize(int n) {
        this.featuresFetchSize = n;
    }

    public void setCoefficientFetchSize(int n) {
        this.coefficientsFetchSize = n;
    }

    public void setCoefficientSortDirection(SortDirection sortDirection) {
        switch (sortDirection) {
            case ASCENDING: {
                FEATURE_SETTINGS.setCoefficientSortDirection(0);
                break;
            }
            default: {
                FEATURE_SETTINGS.setCoefficientSortDirection(1);
            }
        }
    }

    public SortDirection getCoefficientSortDirection() {
        SortDirection sortDirection;
        switch (FEATURE_SETTINGS.getCoefficientSortDirection()) {
            case 0: {
                sortDirection = SortDirection.ASCENDING;
                break;
            }
            default: {
                sortDirection = SortDirection.DESCENDING;
            }
        }
        return sortDirection;
    }

    public void setCoefficientSortType(SortType sortType) {
        switch (sortType) {
            case ALPHABETICAL: {
                FEATURE_SETTINGS.setCoefficientSortType(0);
                break;
            }
            default: {
                FEATURE_SETTINGS.setCoefficientSortType(1);
            }
        }
    }

    public SortType getCoefficientSortType() {
        switch (FEATURE_SETTINGS.getCoefficientSortType()) {
            case 0: {
                return SortType.ALPHABETICAL;
            }
        }
        return SortType.NUMERICAL;
    }

    public void setFeatureSortDirection(SortOrder sortOrder) {
        switch (sortOrder) {
            case DESCENDING: {
                FEATURE_SETTINGS.setFeatureSortDirection(1);
                break;
            }
            default: {
                FEATURE_SETTINGS.setFeatureSortDirection(0);
            }
        }
    }

    public SortOrder getFeatureSortDirection() {
        switch (FEATURE_SETTINGS.getFeatureSortDirection()) {
            case 0: {
                return SortOrder.ASCENDING;
            }
        }
        return SortOrder.DESCENDING;
    }

    public void setFilterMatchType(ColumnFilter.Match match) {
        if (match != null) {
            this.matchType = match;
        }
    }

    public List<String> getAvailableAttributeNames() {
        return this.availableAttributes;
    }
}

