/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.features;

import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.mviewer.features.FeatureLrb;
import oracle.dmt.dataminer.mviewer.features.FeatureViewerState;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.infotip.InfoTip;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BalloonTemplate;
import oracle.javatools.ui.infotip.templates.Template;

public class FeatureItemSettingPanel
extends JPanel {
    private InfoTip infoTip;
    private FeatureViewerState state;
    private BalloonTemplate balloonTemplate;
    private JLabel itemLabel;
    private JSpinner itemSpinner;

    public FeatureItemSettingPanel(FeatureViewerState featureViewerState) {
        assert (featureViewerState != null) : "State cannot be null";
        this.state = featureViewerState;
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.itemSpinner = new JSpinner();
        this.itemLabel = new JLabel();
        this.itemSpinner.setValue(50);
        this.itemLabel.setText("Retrieved Items");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.itemLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.itemSpinner, -2, 60, -2).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.itemLabel).addComponent(this.itemSpinner, -2, -1, -2)).addContainerGap()));
    }

    private void initUI() {
        this.balloonTemplate = new BalloonTemplate();
        this.balloonTemplate.setTitle(OracleIcons.getIcon((String)"find.png"), ControlsLrb.get("FIND_VALUES_CONTROL_TITLE"));
        this.balloonTemplate.setContent((JComponent)this);
        this.infoTip = new InfoTip((Template)this.balloonTemplate, InfoTipStyles.DEFAULT);
        ResourceUtils.resSpinner((JLabel)this.itemLabel, (JSpinner)this.itemSpinner, (String)FeatureLrb.get("ITEM_SET_SIZE"));
        this.itemSpinner.setModel(new SpinnerNumberModel(50, 1, Integer.MAX_VALUE, 5));
        this.itemSpinner.setValue(this.state.getItemFetchSize());
        this.itemSpinner.addChangeListener(changeEvent -> this.state.setItemFetchSize((Integer)this.itemSpinner.getValue()));
    }

    public void show(JComponent jComponent) {
        if (this.infoTip.isShowing()) {
            return;
        }
        this.infoTip.show(jComponent);
    }
}

