/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.util.Comparator;
import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.common.build.AttributeBiCoefficient;
import oracle.dmt.dataminer.core.utils.comparator.AbsoluteNumberComparator;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;

public class NBProbabilitiesTableModel
extends ODMrTableModel<AttributeBiCoefficient> {
    public static final int ATTRIBUTE = 0;
    public static final int VALUE = 1;
    public static final int PROBABILITY = 2;
    private static final String[] COLUMN_NAMES = new String[]{CoefficientsLrb.get("PRIORS_ATTRIBUTE_NAME"), CoefficientsLrb.get("PRIORS_ATTRIBUTE_VALUE"), CoefficientsLrb.get("PRIORS_ATTRIBUTE_PROBABILITY")};
    private boolean _absoluteSort;

    public NBProbabilitiesTableModel() {
        super(COLUMN_NAMES);
    }

    public NBProbabilitiesTableModel(List<AttributeBiCoefficient> list) {
        super(COLUMN_NAMES, list);
    }

    public void updateColumnIdentifiers(String string) {
        Object[] objectArray = new String[COLUMN_NAMES.length];
        System.arraycopy(COLUMN_NAMES, 0, objectArray, 0, COLUMN_NAMES.length);
        objectArray[2] = objectArray[2] + string;
        this.setColumnIdentifiers(objectArray);
    }

    public Comparator getColumnSortComparator(int n) {
        Comparator comparator = null;
        comparator = n == 2 ? (this._absoluteSort ? AbsoluteNumberComparator.getComparator() : NumberComparator.getComparator()) : super.getColumnSortComparator(n);
        return comparator;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        AttributeBiCoefficient attributeBiCoefficient = (AttributeBiCoefficient)this.srcData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = attributeBiCoefficient.getAttributeFullName();
                break;
            }
            case 1: {
                object = attributeBiCoefficient.getAttributeValue();
                break;
            }
            case 2: {
                if (attributeBiCoefficient.getCoefficient1() != null) {
                    object = attributeBiCoefficient.getCoefficient1() * 100.0;
                    break;
                }
                object = attributeBiCoefficient.getCoefficient1();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        return object == null ? " " : object;
    }

    public void setAbsoluteValueSort(boolean bl) {
        this._absoluteSort = bl;
    }

    public boolean getAbsoluteValueSort() {
        return this._absoluteSort;
    }
}

