/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.controls.renderers.MiniHistogramCellRenderer;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentDataTableModel;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentDetailPane;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentModelRow;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentProjectionItem;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentTableModel;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentViewerState;
import oracle.dmt.dataminer.mviewer.clustering.component.ComponentLrb;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;

public class ClusterComponentViewerMainPanel
extends DataMinerViewGUI {
    private static final Logger theLogger = Logger.getLogger(ClusterComponentViewerMainPanel.class.getName());
    private static final String _noSelectedAttributes = ComponentLrb.get("CLUSTER_COMPONENT_SELECTED_ATTRIBUTES_NONE");
    public static final int FILTER_DETAIL_ATTRIBUTE = 0;
    private ClusterComponentViewerState state;
    private ClusterComponentDetailPane jTabPane;
    private GraphPanel[] graphPanel;
    private Dimension _histogramRowDimension;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance();
    private JButton _jApplyFilterButton;
    private JComboBox _jComponentCombo;
    private JLabel _jComponentComboLabel;
    private JPanel _jDetailPanel;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private DataMinerTablePanel dataMinerTablePanel;
    private JLabel jFilterLabel;
    private JLabel jPriorLabel;
    private JLabel jPriorValue;
    private JSplitPane jSplitPane1;
    private JTextField jTextField1;
    private ModelViewerPartitionToolbar modelViewerPartitionToolbar1;

    public ClusterComponentViewerMainPanel(Editor editor, Context context) {
        super(editor, context);
        this._histogramRowDimension = new Dimension(120, 25);
        this.state = new ClusterComponentViewerState(context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)ComponentLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(ComponentLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(ComponentLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        this._jApplyFilterButton.setToolTipText(ComponentLrb.get("QUERY_ADA"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)ComponentLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(ComponentLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(ComponentLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(ComponentLrb.get("FETCH_SIZE_ADA") + "\n" + ComponentLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(this.state.getInitialFetchSize(), 1, Integer.MAX_VALUE, 100));
        ResourceUtils.resLabel((JLabel)this._jComponentComboLabel, (Component)this._jComponentCombo, (String)ComponentLrb.get("COMPONENT_LABEL"));
        this._jComponentComboLabel.getAccessibleContext().setAccessibleName(ComponentLrb.get("COMPONENT_LABEL"));
        this._jComponentComboLabel.getAccessibleContext().setAccessibleDescription(ComponentLrb.get("COMPONENT_LABEL_ADA"));
        ResourceUtils.resLabel((JLabel)this.jPriorLabel, (Component)this.jPriorValue, (String)ComponentLrb.get("PRIOR_LABEL"));
        this.jPriorLabel.getAccessibleContext().setAccessibleName(ComponentLrb.get("PRIOR_LABEL"));
        this.jPriorLabel.getAccessibleContext().setAccessibleDescription(ComponentLrb.get("PRIOR_LABEL_ADA"));
        ResourceUtils.resLabel((JLabel)this.jFilterLabel, (Component)this.jTextField1, (String)ComponentLrb.get("FILTER_LABEL"));
        this.jFilterLabel.getAccessibleContext().setAccessibleName(ComponentLrb.get("FILTER_LABEL"));
        this.jFilterLabel.getAccessibleContext().setAccessibleDescription(ComponentLrb.get("FILTER_LABEL_ADA"));
        this.setTotalNumberComponents();
    }

    @Override
    public HelpInfo getHelpInfo() {
        return this.state.getHelpInfo();
    }

    @Override
    public void setLoading(boolean bl) {
        super.setLoading(bl);
        this.enableControls(!bl);
    }

    private void enableControls(boolean bl) {
        this._jApplyFilterButton.setEnabled(bl);
        this._jFetchSize.setEnabled(bl);
        this._jFetchSizeLabel.setEnabled(bl);
        this._jComponentCombo.setEnabled(bl);
        this.jPriorValue.setEnabled(bl);
        this.jTextField1.setEnabled(bl);
    }

    public void initUI() {
        this.setLoading(true);
        this.initializeControls();
        this.modelViewerPartitionToolbar1.setVisible(false);
        this._jFetchSize.setLocale(Locale.getDefault());
        this.jTabPane = new ClusterComponentDetailPane();
        this.jTabPane.initialize(this.state, this.getContext());
        this.jSplitPane1.setResizeWeight(0.8);
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setRightComponent(this.jTabPane);
        this.dataMinerTablePanel.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel.getTable().setShowGrid(true);
        this.dataMinerTablePanel.getTable().setSelectionMode(0);
        this.dataMinerTablePanel.getTable().getTableHeader().setReorderingAllowed(false);
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new MasterTableListener());
        this.jSplitPane1.updateUI();
    }

    @Override
    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    @Override
    public void reload() {
        super.reload();
        if (this._jComponentCombo.getItemCount() > 0) {
            this._jComponentCombo.setSelectedIndex(0);
            this.state.setSelectedComponent((Integer)this._jComponentCombo.getSelectedItem());
            this._jApplyFilterButton_actionPerformed(null);
        }
    }

    private void initializeControls() {
        this.setupTable();
        this.enableControls(false);
    }

    private void setupTable() {
        this.dataMinerTablePanel.setup((TableModel)((Object)new ClusterComponentTableModel((List<ClusterComponentModelRow>)new ArrayList<ClusterComponentModelRow>())), null, 0);
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getColumnModel();
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getModelViewerNumericRenderer();
        tableColumnModel.getColumn(1).setCellRenderer(new MiniHistogramCellRenderer(this.state, this._histogramRowDimension, 20));
        tableColumnModel.getColumn(2).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(3).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(250);
        tableColumnModel.getColumn(2).setPreferredWidth(125);
        tableColumnModel.getColumn(3).setPreferredWidth(125);
    }

    private void setTotalNumberComponents() {
        String string = ComponentLrb.get("TOTAL_COMPONENTS");
        String string2 = NumericFormat.format((int)this.state.getTotalComponents());
        String string3 = MessageFormat.format(string, string2);
        this.dataMinerTablePanel.setTitle(string3);
    }

    private String getSelectedAttributeName() {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        if (null == nArray || nArray.length == 0) {
            return null;
        }
        ClusterComponentTableModel clusterComponentTableModel = (ClusterComponentTableModel)((Object)this.dataMinerTablePanel.getTable().getModel());
        List list = clusterComponentTableModel.getSrcData();
        ClusterComponentModelRow clusterComponentModelRow = (ClusterComponentModelRow)list.get(nArray[0]);
        return clusterComponentModelRow.getAttributeName();
    }

    private boolean isChartVisible() {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        if (null == nArray || nArray.length == 0) {
            return false;
        }
        ClusterComponentTableModel clusterComponentTableModel = (ClusterComponentTableModel)((Object)this.dataMinerTablePanel.getTable().getModel());
        List list = clusterComponentTableModel.getSrcData();
        ClusterComponentModelRow clusterComponentModelRow = (ClusterComponentModelRow)list.get(nArray[0]);
        return clusterComponentModelRow.isFrequencyAvailable();
    }

    public void createMessagePanel(String string) {
        this.jTabPane.createMessagePanel(string);
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this._jApplyFilterButton.setEnabled(false);
            if (this.validateSettings()) {
                this.setLoading(true);
                ((ClusterComponentTableModel)((Object)this.dataMinerTablePanel.getTable().getModel())).setSrcData(((ClusterComponentTableModel)this.state.getComponentTableModel()).getSrcData());
                this.load();
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
        }
    }

    private boolean validateSettings() throws Exception {
        boolean bl = false;
        bl = true;
        Number number = this.getNumber(this._jFetchSize);
        this.state.getFilterSetting().setFetchSize(number.intValue());
        this.state.getFilterSetting().setUseFilterSpecification(false);
        String string = this.jTextField1.getText();
        this.state.setAttributeNameFilter(string);
        return bl;
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    private String getFormatedDoubleValue(Double d) {
        String string = null;
        try {
            NumberFormat numberFormat = Formats.ModelViewer.getNumeric();
            string = numberFormat.format(d);
        }
        catch (Exception exception) {
            string = d.toString();
        }
        return string;
    }

    private String getEMModelNestedAttributeName() {
        String string = null;
        try {
            String string2 = this.getSelectedAttributeName();
            string = this.state.getEMModelNestedAttributeName(string2);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return string;
    }

    private void initComponents() {
        this._jComponentComboLabel = new JLabel();
        this._jComponentCombo = new JComboBox();
        this.jPriorLabel = new JLabel();
        this.jPriorValue = new JLabel();
        this._jFetchSizeLabel = new JLabel();
        this._jApplyFilterButton = new JButton();
        this._jFetchSize = new JSpinner();
        this.jFilterLabel = new JLabel();
        this.jTextField1 = new JTextField();
        this.jSplitPane1 = new JSplitPane();
        this._jDetailPanel = new JPanel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.modelViewerPartitionToolbar1 = new ModelViewerPartitionToolbar();
        this.setPreferredSize(new Dimension(760, 463));
        this._jComponentComboLabel.setText("Component:");
        this._jComponentCombo.setMaximumSize(new Dimension(150, 20));
        this._jComponentCombo.setMinimumSize(new Dimension(150, 20));
        this._jComponentCombo.setPreferredSize(new Dimension(150, 20));
        this._jComponentCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusterComponentViewerMainPanel.this._jComponentComboActionPerformed(actionEvent);
            }
        });
        this.jPriorLabel.setHorizontalAlignment(11);
        this.jPriorLabel.setText("Prior:");
        this.jPriorValue.setText("0.5");
        this._jFetchSizeLabel.setHorizontalAlignment(4);
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jFetchSizeLabel.setPreferredSize(new Dimension(60, 14));
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusterComponentViewerMainPanel.this._jApplyFilterButtonActionPerformed(actionEvent);
            }
        });
        this._jFetchSize.setMaximumSize(new Dimension(87, 20));
        this._jFetchSize.setMinimumSize(new Dimension(87, 20));
        this._jFetchSize.setPreferredSize(new Dimension(87, 20));
        this.jFilterLabel.setText("Filter by Attribute Name:");
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    ClusterComponentViewerMainPanel.this._jApplyFilterButton_actionPerformed(null);
                }
            }
        });
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.8);
        this._jDetailPanel.setPreferredSize(new Dimension(245, 235));
        GroupLayout groupLayout = new GroupLayout(this._jDetailPanel);
        this._jDetailPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 834, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 78, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this._jDetailPanel);
        this.jSplitPane1.setLeftComponent(this.dataMinerTablePanel);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 836, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.modelViewerPartitionToolbar1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFilterLabel).addComponent(this._jComponentComboLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField1).addComponent(this._jComponentCombo, 0, 157, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.jPriorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPriorValue, -2, 118, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this._jFetchSizeLabel, -2, 129, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFetchSize, -2, 106, -2).addGap(5, 5, 5).addComponent(this._jApplyFilterButton, -2, 106, -2))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jComponentComboLabel, -2, 20, -2).addComponent(this._jComponentCombo, -2, -1, -2).addComponent(this.jPriorLabel).addComponent(this.jPriorValue, -2, 20, -2).addComponent(this._jApplyFilterButton, -2, -1, -2).addComponent(this._jFetchSize, -2, -1, -2).addComponent(this._jFetchSizeLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFilterLabel).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modelViewerPartitionToolbar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 342, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.linkSize(1, this.jPriorLabel, this.jPriorValue);
    }

    private void _jComponentComboActionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this.state.setSelectedComponent((Integer)this._jComponentCombo.getSelectedItem());
    }

    private void _jApplyFilterButtonActionPerformed(ActionEvent actionEvent) {
        this._jApplyFilterButton_actionPerformed(actionEvent);
    }

    static /* synthetic */ GraphPanel[] access$902(ClusterComponentViewerMainPanel clusterComponentViewerMainPanel, GraphPanel[] graphPanelArray) {
        clusterComponentViewerMainPanel.graphPanel = graphPanelArray;
        return graphPanelArray;
    }

    private class LoadUI
    extends ODMrSwingWorker {
        public LoadUI() {
            super(ClusterComponentViewerMainPanel.this, ClusterComponentViewerMainPanel.this.overLayPanel, ClusterComponentViewerMainPanel.this.dataMinerTablePanel.getTable());
        }

        protected void onSuccess(Object object) throws Exception {
            int[] nArray;
            List<Integer> list = ClusterComponentViewerMainPanel.this.state.getComponentList();
            ClusterComponentViewerMainPanel.this._jComponentCombo.setModel(new DefaultComboBoxModel<Integer>(list.toArray(new Integer[list.size()])));
            ClusterComponentViewerMainPanel.this._jComponentCombo.setSelectedItem(ClusterComponentViewerMainPanel.this.state.getSelectedComponent());
            ClusterComponentViewerMainPanel.this.state.loadTableModel();
            ((ClusterComponentTableModel)((Object)ClusterComponentViewerMainPanel.this.dataMinerTablePanel.getTable().getModel())).setSrcData(((ClusterComponentTableModel)ClusterComponentViewerMainPanel.this.state.getComponentTableModel()).getSrcData());
            ClusterComponentViewerMainPanel.this.dataMinerTablePanel.trySearch();
            ClusterComponentViewerMainPanel.this.dataMinerTablePanel.getTable().setSortColumn(0, true);
            Double d = ClusterComponentViewerMainPanel.this.state.getSelectedPrior();
            if (null != d) {
                ClusterComponentViewerMainPanel.this.jPriorValue.setText(ClusterComponentViewerMainPanel.this.getFormatedDoubleValue(d));
            } else {
                ClusterComponentViewerMainPanel.this.jPriorValue.setText("");
            }
            ClusterComponentViewerMainPanel.this.setTotalNumberComponents();
            ClusterComponentViewerMainPanel.this.enableControls(true);
            ClusterComponentViewerMainPanel.this.setLoaded(true);
            ClusterComponentViewerMainPanel.this.setLoading(false);
            if (ClusterComponentViewerMainPanel.this.dataMinerTablePanel.getTable().getRowCount() > 0) {
                int n = ClusterComponentViewerMainPanel.this.dataMinerTablePanel.getTable().convertRowIndexToModel(0);
                ClusterComponentViewerMainPanel.this.dataMinerTablePanel.getTable().setSelectedRowsInModel(new int[]{n});
            }
            if (null == (nArray = ClusterComponentViewerMainPanel.this.dataMinerTablePanel.getTable().getSelectedRowsInModel()) || nArray.length == 0) {
                ClusterComponentDataTableModel clusterComponentDataTableModel = new ClusterComponentDataTableModel((List<NameValuePair>)new ArrayList<NameValuePair>());
                ClusterComponentViewerMainPanel.this.state.setClusterComponentDataTableModel(clusterComponentDataTableModel);
                ClusterComponentViewerMainPanel.this.jTabPane.reset();
            } else {
                ClusterComponentViewerMainPanel.this.jTabPane.showFrequency();
            }
        }

        @Override
        protected Object doInBackground() throws Exception {
            ClusterComponentViewerMainPanel.this.modelViewerPartitionToolbar1.load(ClusterComponentViewerMainPanel.this.getEditor());
            ClusterComponentViewerMainPanel.this.state.load(ClusterComponentViewerMainPanel.this.modelViewerPartitionToolbar1.getSelectedPartitionID());
            return ClusterComponentViewerMainPanel.this.state.isLoaded();
        }
    }

    private class LoadGraphPanel
    extends ODMrSwingWorker {
        GraphDataModel[] localGraphModel;
        int[] _selectedRowsInModel;

        public LoadGraphPanel(int[] nArray) {
            super(ClusterComponentViewerMainPanel.this);
            this._selectedRowsInModel = nArray;
            this.localGraphModel = new GraphDataModel[nArray.length];
        }

        @Override
        protected Object doInBackground() throws Exception {
            List list = ((ClusterComponentTableModel)((Object)ClusterComponentViewerMainPanel.this.dataMinerTablePanel.getTable().getModel())).getSrcData();
            if (!list.isEmpty()) {
                for (int i = 0; i < this._selectedRowsInModel.length; ++i) {
                    ClusterComponentModelRow clusterComponentModelRow = (ClusterComponentModelRow)list.get(this._selectedRowsInModel[i]);
                    this.localGraphModel[i] = ClusterComponentViewerMainPanel.this.state.createGraphDataModelForAttribute(clusterComponentModelRow);
                }
            }
            return ClusterComponentViewerMainPanel.this.state.isLoaded();
        }

        protected void onSuccess(Object object) throws Exception {
            List list = ((ClusterComponentTableModel)((Object)ClusterComponentViewerMainPanel.this.dataMinerTablePanel.getTable().getModel())).getSrcData();
            if (!list.isEmpty()) {
                int n = this._selectedRowsInModel.length;
                ClusterComponentViewerMainPanel.access$902(ClusterComponentViewerMainPanel.this, new GraphPanel[n]);
                for (int i = 0; i < n; ++i) {
                    ((ClusterComponentViewerMainPanel)ClusterComponentViewerMainPanel.this).graphPanel[i] = new GraphPanel(this.localGraphModel[i]);
                    this.localGraphModel[i].setDepthRadius(Integer.valueOf(ClusterComponentViewerMainPanel.this.state.getDepthRadius()));
                    boolean bl = false;
                    if (n == 1) {
                        bl = true;
                        this.localGraphModel[i].setLegendSeriesCount(Integer.valueOf(2));
                    }
                    this.localGraphModel[i].setLegendVisible(bl);
                    ClusterComponentViewerMainPanel.this.graphPanel[i].initGraph();
                    this.localGraphModel[i].setStyleSelection(ClusterComponentViewerMainPanel.this.state.getStyleSelection());
                    ClusterComponentViewerMainPanel.this.graphPanel[i].updateGraphStyle();
                }
                ClusterComponentViewerMainPanel.this.jTabPane.layoutCharts(n, ClusterComponentViewerMainPanel.this.graphPanel);
            }
        }
    }

    private class LoadProjectionPanel
    extends ODMrSwingWorker {
        String attributeName;
        List<ClusterComponentProjectionItem> projectionData;

        public LoadProjectionPanel(String string) {
            super(ClusterComponentViewerMainPanel.this);
            this.attributeName = string;
            this.projectionData = new ArrayList<ClusterComponentProjectionItem>();
        }

        @Override
        protected Object doInBackground() throws Exception {
            String string = ClusterComponentViewerMainPanel.this.getSelectedAttributeName();
            String string2 = ClusterComponentViewerMainPanel.this.state.getEMModelNestedAttributeName(string);
            if (string2 != null) {
                ClusterComponentViewerMainPanel.this.modelViewerPartitionToolbar1.load(ClusterComponentViewerMainPanel.this.getEditor());
            }
            this.projectionData = ClusterComponentViewerMainPanel.this.state.getModelDetailsProjDetails(string2, string, ClusterComponentViewerMainPanel.this.modelViewerPartitionToolbar1.getSelectedPartitionID());
            return ClusterComponentViewerMainPanel.this.state.isLoaded();
        }

        protected void onSuccess(Object object) throws Exception {
            ClusterComponentViewerMainPanel.this.state.loadProjectionData(this.projectionData);
            ClusterComponentViewerMainPanel.this.jTabPane.updateProjections();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            ClusterComponentViewerMainPanel.this.state.loadProjectionErrorStatus();
            ClusterComponentViewerMainPanel.this.jTabPane.updateProjections();
        }
    }

    private class MasterTableListener
    implements ListSelectionListener {
        private MasterTableListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ODMrSwingWorker oDMrSwingWorker;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            boolean bl = true;
            int[] nArray = ClusterComponentViewerMainPanel.this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            String string = null;
            if (null == nArray || nArray.length == 0) {
                bl = false;
                string = _noSelectedAttributes;
            }
            if (!bl) {
                ClusterComponentViewerMainPanel.this.createMessagePanel(string);
                return;
            }
            if (!ClusterComponentViewerMainPanel.this.state.isLoaded()) {
                return;
            }
            int n = ClusterComponentViewerMainPanel.this.jTabPane.getSelectedIndex();
            ClusterComponentViewerMainPanel.this.jTabPane.showDataTab(ClusterComponentViewerMainPanel.this.isChartVisible());
            String string2 = ClusterComponentViewerMainPanel.this.getEMModelNestedAttributeName();
            boolean bl2 = null != string2;
            ClusterComponentViewerMainPanel.this.jTabPane.showProjectionsTab(bl2);
            if (bl2) {
                ClusterComponentViewerMainPanel.this.state.loadProjectionStatus();
                ClusterComponentViewerMainPanel.this.jTabPane.updateProjections();
                oDMrSwingWorker = new LoadProjectionPanel(string2);
                oDMrSwingWorker.execute();
            }
            ClusterComponentViewerMainPanel.this.state.loadFrequencyTable(ClusterComponentViewerMainPanel.this.getSelectedAttributeName());
            ClusterComponentViewerMainPanel.this.jTabPane.showFrequency();
            if (n > 0 && n < ClusterComponentViewerMainPanel.this.jTabPane.getTabCount()) {
                ClusterComponentViewerMainPanel.this.jTabPane.setSelectedIndex(n);
            }
            oDMrSwingWorker = new LoadGraphPanel(nArray);
            oDMrSwingWorker.execute();
        }
    }
}

