/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.component;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentProjectionItem;
import oracle.dmt.dataminer.mviewer.clustering.component.ComponentLrb;
import oracle.javatools.ui.search.SearchMatcher;

public class ClusterComponentProjectionsTableModel
extends SimpleBaseTableModel {
    static Vector<String> _colNames = new Vector();
    public static final int _COLUMN_SUBNAME = 0;
    public static final int _COLUMN_VALUE = 1;
    public static final int _COLUMN_COEFFICIENT = 2;
    private Vector<ClusterComponentProjectionItem> _data;

    public ClusterComponentProjectionsTableModel() {
        ClusterComponentProjectionItem clusterComponentProjectionItem = new ClusterComponentProjectionItem("");
        Vector<ClusterComponentProjectionItem> vector = new Vector<ClusterComponentProjectionItem>();
        vector.add(clusterComponentProjectionItem);
        this.setDataVector(vector);
        this.setColumnIdentifiers(_colNames);
    }

    private ClusterComponentProjectionsTableModel(Vector<ClusterComponentProjectionItem> vector) {
        Object[] objectArray = _colNames.toArray(new String[_colNames.size()]);
        this.setDataVector(vector);
        this.setColumnIdentifiers(objectArray);
    }

    public void loadData(List<ClusterComponentProjectionItem> list) {
        assert (list != null) : "Input data is missing.";
        this.clear();
        this.setDataList(list);
        this.fireTableDataChanged();
    }

    public void loadErrorStatus() {
        String string = ComponentLrb.get("CLUSTER_COMPONENT_PROJECTIONS_ERROR");
        this.loadTableStatus(string);
    }

    public void loadStatus() {
        String string = ComponentLrb.get("CLUSTER_COMPONENT_EDITOR_LOADING");
        this.loadTableStatus(string);
    }

    private void loadTableStatus(String string) {
        this.clear();
        ClusterComponentProjectionItem clusterComponentProjectionItem = new ClusterComponentProjectionItem(string);
        Vector<ClusterComponentProjectionItem> vector = new Vector<ClusterComponentProjectionItem>();
        vector.add(clusterComponentProjectionItem);
        this.setDataVector(vector);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public void clear() {
        this._data.clear();
    }

    public void setDataVector(Vector<ClusterComponentProjectionItem> vector) {
        this._data = vector;
        this.setRowCount(this._data.size());
    }

    public void setDataList(List<ClusterComponentProjectionItem> list) {
        this._data.addAll(list);
        this.setRowCount(this._data.size());
    }

    private String createName(ClusterComponentProjectionItem clusterComponentProjectionItem) {
        return clusterComponentProjectionItem.getAttributeSubname();
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        ClusterComponentProjectionItem clusterComponentProjectionItem = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = this.createName(clusterComponentProjectionItem);
                break;
            }
            case 1: {
                object = clusterComponentProjectionItem.getAttributeValue();
                break;
            }
            case 2: {
                object = clusterComponentProjectionItem.getCoefficient();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing cluster details";
                break;
            }
        }
        return object != null ? object : "";
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return NumberComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }

    public ClusterComponentProjectionsTableModel getFilteredStatistics(String string, int n) throws Exception {
        Vector<ClusterComponentProjectionItem> vector = null;
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Vector<ClusterComponentProjectionItem> vector2 = this.getDataVector();
        vector = new Vector<ClusterComponentProjectionItem>();
        Iterator<ClusterComponentProjectionItem> iterator = vector2.iterator();
        ClusterComponentProjectionItem clusterComponentProjectionItem = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            clusterComponentProjectionItem = iterator.next();
            if (bl) {
                bl2 = true;
            } else {
                String string2 = null;
                switch (n) {
                    case 0: {
                        string2 = this.createName(clusterComponentProjectionItem);
                        break;
                    }
                    default: {
                        assert (false) : "Invalid table filter category.";
                        string2 = this.createName(clusterComponentProjectionItem);
                    }
                }
                if (string2 == null) {
                    string2 = "";
                }
                bl2 = searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector.add(clusterComponentProjectionItem);
        }
        return new ClusterComponentProjectionsTableModel(vector);
    }

    public Vector<ClusterComponentProjectionItem> getDataVector() {
        return this._data;
    }

    public static Vector<String> getColNames() {
        return _colNames;
    }

    public static String getColName(int n) {
        return _colNames.get(n);
    }

    static {
        _colNames.add(ComponentLrb.get("CLUSTER_COMPONENT_PROJECTIONS_TABLE_COLUMN_SUBNAME"));
        _colNames.add(ComponentLrb.get("CLUSTER_COMPONENT_PROJECTIONS_TABLE_COLUMN_VALUE"));
        _colNames.add(ComponentLrb.get("CLUSTER_COMPONENT_PROJECTIONS_TABLE_COLUMN_COEFF"));
    }
}

