/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.formatters;

import java.util.HashMap;
import oracle.dmt.dataminer.core.model.ar.Rule;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.formatters.ARObjectAbstractFormatter;
import oracle.dmt.dataminer.utils.FileHelper;

public abstract class ARRuleAbstractFormatter
extends ARObjectAbstractFormatter<Rule> {
    private static final String RULE_ID_LABEL = "RULE_ID_LABEL";
    private static final String RULE_ID_VALUE = "RULE_ID_VALUE";
    private static final String IF_LABEL = "IF_LABEL";
    private static final String IF_DETAIL = "IF_DETAIL";
    private static final String THEN_LABEL = "THEN_LABEL";
    private static final String THEN_DETAIL = "THEN_DETAIL";
    protected String headerHtml = FileHelper.loadFile("/oracle/dmt/dataminer/mviewer/res/ARRuleHeader.html");

    @Override
    protected String getNoItemSelectedMessage() {
        return ARRulesLrb.get("NO_RULE_TO_DISPLAY");
    }

    @Override
    protected String getSingleSelectionMessage() {
        return ARRulesLrb.get("SELECT_SINGLE_RULE");
    }

    @Override
    protected String formatHeader(Rule rule) {
        assert (rule != null) : "Rule can not be null";
        String string = "<span style=\"font-weight: bold;\">" + CoreCommonLrb.get((String)"ID") + ":</span>";
        String string2 = "<span style=\"font-weight: bold;\">" + CoreCommonLrb.get((String)"IF") + "</span>";
        String string3 = rule.getFullAntecedent();
        String string4 = "<span style=\"font-weight: bold;\">" + CoreCommonLrb.get((String)"THEN") + "</span>";
        String string5 = rule.getFullConsequent();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(RULE_ID_LABEL, string);
        hashMap.put(RULE_ID_VALUE, rule.getId() + "");
        hashMap.put(IF_LABEL, string2);
        hashMap.put(IF_DETAIL, string3);
        hashMap.put(THEN_LABEL, string4);
        hashMap.put(THEN_DETAIL, string5);
        String string6 = StringUtils.getReplacedString((String)this.headerHtml, hashMap);
        return string6;
    }
}

