/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.awt.Container;
import java.awt.Font;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.mviewer.arrules.ARPreferences;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;

public class ARPreferencesPanel
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    private JCheckBox jCheckBoxAntecedent;
    private JCheckBox jCheckBoxAverage;
    private JCheckBox jCheckBoxConsequent;
    private JCheckBox jCheckBoxItemsetAntecedent;
    private JCheckBox jCheckBoxItemsetConsequent;
    private JCheckBox jCheckBoxMetricDetails;
    private JCheckBox jCheckBoxRule;
    private JLabel jLabelColumns;
    private JLabel jLabelEditor;
    private JSeparator jSeparator;

    public ARPreferencesPanel() {
        this.initComponents();
        this.initRes();
    }

    private void initComponents() {
        this.jLabelEditor = new JLabel();
        this.jLabelColumns = new JLabel();
        this.jCheckBoxRule = new JCheckBox();
        this.jCheckBoxAntecedent = new JCheckBox();
        this.jCheckBoxConsequent = new JCheckBox();
        this.jCheckBoxItemsetAntecedent = new JCheckBox();
        this.jCheckBoxItemsetConsequent = new JCheckBox();
        this.jSeparator = new JSeparator();
        this.jCheckBoxAverage = new JCheckBox();
        this.jCheckBoxMetricDetails = new JCheckBox();
        this.jLabelEditor.setFont(new Font("Tahoma", 1, 11));
        this.jLabelEditor.setText("Rules Editor");
        this.jLabelColumns.setText("Columns to be displayed by default");
        this.jCheckBoxRule.setText("Aggregate for Rule");
        this.jCheckBoxAntecedent.setText("Aggregate for Antecedent");
        this.jCheckBoxConsequent.setText("Aggregate for Consequent");
        this.jCheckBoxItemsetAntecedent.setText("Aggregate for Itemset Antecedent");
        this.jCheckBoxItemsetConsequent.setText("Aggregate for Itemset Consequent");
        this.jCheckBoxAverage.setText("Show Average (This will double the columns selected)");
        this.jCheckBoxMetricDetails.setText("Show Average on Metric Details");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCheckBoxMetricDetails).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jCheckBoxAverage).addContainerGap(99, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelEditor).addComponent(this.jLabelColumns).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxAntecedent).addComponent(this.jCheckBoxRule).addComponent(this.jCheckBoxConsequent).addComponent(this.jCheckBoxItemsetAntecedent).addComponent(this.jCheckBoxItemsetConsequent)))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelEditor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelColumns).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxRule).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxAntecedent).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxConsequent).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxItemsetAntecedent).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxItemsetConsequent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxAverage).addGap(18, 18, 18).addComponent(this.jCheckBoxMetricDetails).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelEditor, null, (String)ARRulesLrb.get("AR_PREFERENCES_TITLE"));
        ResourceUtils.resLabel((JLabel)this.jLabelColumns, null, (String)ARRulesLrb.get("AR_PREFERENCES_DISPLAYED_DEFAULT"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxRule, (String)ARRulesLrb.get("AR_PREFERENCES_SHOW_AGGREGATE_RULE"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxAntecedent, (String)ARRulesLrb.get("AR_PREFERENCES_SHOW_AGGREGATE_ANTECEDENT"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxConsequent, (String)ARRulesLrb.get("AR_PREFERENCES_SHOW_AGGREGATE_CONSEQUENT"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxItemsetAntecedent, (String)ARRulesLrb.get("AR_PREFERENCES_SHOW_AGGREGATE_ITEMSET_ANTECEDENT"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxItemsetConsequent, (String)ARRulesLrb.get("AR_PREFERENCES_SHOW_AGGREGATE_ITEMSET_CONSEQUENT"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxAverage, (String)ARRulesLrb.get("AR_PREFERENCES_SHOW_AVERAGE"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxMetricDetails, (String)ARRulesLrb.get("AR_PREFERENCES_SHOW_AVERAGE_METRIC_DETAILS"));
        this.setHelpID("preferences_ar_model_viewer");
    }

    public void onEntry(TraversableContext traversableContext) {
        ARPreferences aRPreferences = ARPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this.jCheckBoxRule.setSelected(aRPreferences.getShowRuleColumn());
        this.jCheckBoxAntecedent.setSelected(aRPreferences.getShowAntecedentColumn());
        this.jCheckBoxConsequent.setSelected(aRPreferences.getShowConsequentColumn());
        this.jCheckBoxItemsetAntecedent.setSelected(aRPreferences.getShowItemsetAntecedentColumn());
        this.jCheckBoxItemsetConsequent.setSelected(aRPreferences.getShowItemsetConsequentColumn());
        this.jCheckBoxAverage.setSelected(aRPreferences.getShowAverageColumn());
        this.jCheckBoxMetricDetails.setSelected(aRPreferences.getShowAverageMetricDetailsColumn());
    }

    public void onExit(TraversableContext traversableContext) {
        ARPreferences aRPreferences = ARPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        aRPreferences.setShowRuleColumn(this.jCheckBoxRule.isSelected());
        aRPreferences.setShowAntecedentColumn(this.jCheckBoxAntecedent.isSelected());
        aRPreferences.setShowConsequentColumn(this.jCheckBoxConsequent.isSelected());
        aRPreferences.setShowItemsetAntecedentColumn(this.jCheckBoxItemsetAntecedent.isSelected());
        aRPreferences.setShowItemsetConsequentColumn(this.jCheckBoxItemsetConsequent.isSelected());
        aRPreferences.setShowAverageColumn(this.jCheckBoxAverage.isSelected());
        aRPreferences.setShowAverageMetricDetailsColumn(this.jCheckBoxMetricDetails.isSelected());
    }

    private static ARPreferences getCoolFeaturePrefs(TraversableContext traversableContext) {
        return ARPreferences.getInstance();
    }

    @Override
    public void initUI() {
    }
}

