/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import oracle.dmt.dataminer.DataMinerPreferenceSettings;
import oracle.dmt.dataminer.core.model.ar.RulesFilterSetting;
import oracle.dmt.dataminer.core.model.ar.filter.FilterOn;
import oracle.dmt.dataminer.core.model.ar.filter.FilterRule;
import oracle.dmt.dataminer.core.model.common.Range;
import oracle.dmt.dataminer.mviewer.arrules.ARMetricDetailsType;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public class ARPreferences
extends DataMinerPreferenceSettings {
    private static final String DATA_KEY = ARPreferences.class.getName();
    private static final String SHOW_RULE_COLUMN = "show_aggregate_column";
    private static final String SHOW_ANTECEDENT_COLUMN = "show_antecedent_column";
    private static final String SHOW_CONSEQUENT_COLUMN = "show_consequent_column";
    private static final String SHOW_ITEMSET_ANTECEDENT_COLUMN = "show_itemset_antecedent_column";
    private static final String SHOW_ITEMSET_CONSEQUENT_COLUMN = "show_itemset_consequent_column";
    private static final String SHOW_AVERAGE_COLUMN = "show_average_column";
    private static final String SHOW_AVERAGE_METRIC_DETAILS_COLUMN = "show_average_metric_details_column";
    private static final String SAVE_RULES_SELECTED_METRIC_DETAIL = "save_r_selected_metric_details";
    private static final String SAVE_RULES_SELECTED_ALL_RULES = "save_r_selected_all_rules";
    private static final String MAX_CONFIDENCE = "confidence_max";
    private static final String MIN_CONFIDENCE = "confidence_min";
    private static final String MAX_ITEMS_IN_RULE = "items_max";
    private static final String MIN_ITEMS_IN_RULE = "items_min";
    private static final String MAX_LIFT = "lift_max";
    private static final String MIN_LIFT = "lift_min";
    private static final String MAX_SUPPORT = "support_max";
    private static final String MIN_SUPPORT = "support_min";
    private static final String NULL = "NULL";
    private static final String DEFAULT_LIFT_MIN = "2.0";
    private static final String DEFAULT_SUPPORT_MIN = "0.01";
    private static final String DEFAULT_CONFIDENCE_MIN = "0.1";
    private static final String DEFAULT_ITEMS_IN_RULE_MIN = "1";
    private static final String DEFAULT_ITEMS_IN_RULE_MAX = "10";
    private static final String ITEMSET_MAX_ITEMS = "itemset_max_items";
    private static final String ITEMSET_MIN_SUPPORT = "itemset_min_support";
    private static final int DEFAULT_ITEMSET_MAX_ITEMS = 10;
    private static final double DEFAULT_ITEMSET_MIN_SUPPORT = 1.0;
    private static final String FIND_ITEMS_FETCH_SIZE = "find_items_fetch_size";
    private static final Integer DEFAULT_FIND_ITEMS_FETCH_SIZE = 100;

    private ARPreferences(HashStructure hashStructure) {
        super(hashStructure);
    }

    public void setShowRuleColumn(boolean bl) {
        this._hash.putBoolean(SHOW_RULE_COLUMN, bl);
    }

    public boolean getShowRuleColumn() {
        return this._hash.getBoolean(SHOW_RULE_COLUMN, false);
    }

    public void setShowAntecedentColumn(boolean bl) {
        this._hash.putBoolean(SHOW_ANTECEDENT_COLUMN, bl);
    }

    public boolean getShowAntecedentColumn() {
        return this._hash.getBoolean(SHOW_ANTECEDENT_COLUMN, false);
    }

    public void setShowConsequentColumn(boolean bl) {
        this._hash.putBoolean(SHOW_CONSEQUENT_COLUMN, bl);
    }

    public boolean getShowConsequentColumn() {
        return this._hash.getBoolean(SHOW_CONSEQUENT_COLUMN, true);
    }

    public void setShowItemsetAntecedentColumn(boolean bl) {
        this._hash.putBoolean(SHOW_ITEMSET_ANTECEDENT_COLUMN, bl);
    }

    public boolean getShowItemsetAntecedentColumn() {
        return this._hash.getBoolean(SHOW_ITEMSET_ANTECEDENT_COLUMN, false);
    }

    public void setShowItemsetConsequentColumn(boolean bl) {
        this._hash.putBoolean(SHOW_ITEMSET_CONSEQUENT_COLUMN, bl);
    }

    public boolean getShowItemsetConsequentColumn() {
        return this._hash.getBoolean(SHOW_ITEMSET_CONSEQUENT_COLUMN, false);
    }

    public void setShowAverageColumn(boolean bl) {
        this._hash.putBoolean(SHOW_AVERAGE_COLUMN, bl);
    }

    public boolean getShowAverageColumn() {
        return this._hash.getBoolean(SHOW_AVERAGE_COLUMN, false);
    }

    public void setShowAverageMetricDetailsColumn(boolean bl) {
        this._hash.putBoolean(SHOW_AVERAGE_METRIC_DETAILS_COLUMN, bl);
    }

    public boolean getShowAverageMetricDetailsColumn() {
        return this._hash.getBoolean(SHOW_AVERAGE_METRIC_DETAILS_COLUMN, false);
    }

    public void setSaveRulesSelectedMetricDetails(ARMetricDetailsType aRMetricDetailsType) {
        this._hash.putString(SAVE_RULES_SELECTED_METRIC_DETAIL, aRMetricDetailsType.name());
    }

    public ARMetricDetailsType getSaveRulesSelectedMetricDetails() {
        String string = this._hash.getString(SAVE_RULES_SELECTED_METRIC_DETAIL, ARMetricDetailsType.STANDARD.name());
        return ARMetricDetailsType.valueOf(string);
    }

    public void setSaveRulesSelectedAllRules(boolean bl) {
        this._hash.putBoolean(SAVE_RULES_SELECTED_ALL_RULES, bl);
    }

    public boolean getSaveRulesSelectedAllRules() {
        return this._hash.getBoolean(SAVE_RULES_SELECTED_ALL_RULES, true);
    }

    public void setMinLift(Number number) {
        this.setStringValue(MIN_LIFT, number);
    }

    public Double getMinLift() {
        return this.getDoubleValue(MIN_LIFT, DEFAULT_LIFT_MIN);
    }

    public void setMaxLift(Number number) {
        this.setStringValue(MAX_LIFT, number);
    }

    public Double getMaxLift() {
        return this.getDoubleValue(MAX_LIFT, NULL);
    }

    public void setMaxItems(Number number) {
        this.setStringValue(MAX_ITEMS_IN_RULE, number);
    }

    public Integer getMaxItems() {
        return this.getIntegerValue(MAX_ITEMS_IN_RULE, DEFAULT_ITEMS_IN_RULE_MAX);
    }

    public void setMinItems(Number number) {
        this.setStringValue(MIN_ITEMS_IN_RULE, number);
    }

    public Integer getMinItems() {
        return this.getIntegerValue(MIN_ITEMS_IN_RULE, DEFAULT_ITEMS_IN_RULE_MIN);
    }

    public void setMinSupport(Number number) {
        this.setStringValue(MIN_SUPPORT, number);
    }

    public Double getMinSupport() {
        return this.getDoubleValue(MIN_SUPPORT, DEFAULT_SUPPORT_MIN);
    }

    public void setMaxSupport(Number number) {
        this.setStringValue(MAX_SUPPORT, number);
    }

    public Double getMaxSupport() {
        return this.getDoubleValue(MAX_SUPPORT, NULL);
    }

    public void setMinConfidence(Number number) {
        this.setStringValue(MIN_CONFIDENCE, number);
    }

    public Double getMinConfidence() {
        return this.getDoubleValue(MIN_CONFIDENCE, DEFAULT_CONFIDENCE_MIN);
    }

    public void setMaxConfidence(Number number) {
        this.setStringValue(MAX_CONFIDENCE, number);
    }

    public Double getMaxConfidence() {
        return this.getDoubleValue(MAX_CONFIDENCE, NULL);
    }

    private void setStringValue(String string, Number number) {
        String string2 = NULL;
        if (number != null) {
            string2 = number.toString();
        }
        this._hash.putString(string, string2);
    }

    private Double getDoubleValue(String string, String string2) {
        String string3 = this._hash.getString(string, string2);
        Double d = null;
        if (NULL.equals(string3)) {
            return null;
        }
        d = Double.parseDouble(string3);
        return d;
    }

    private Integer getIntegerValue(String string, String string2) {
        String string3 = this._hash.getString(string, string2);
        Integer n = null;
        if (NULL.equals(string3)) {
            return null;
        }
        n = Integer.parseInt(string3);
        return n;
    }

    public void updateRulesFilterValuesFromSettings(RulesFilterSetting rulesFilterSetting) {
        if (rulesFilterSetting.isFilterEnabled()) {
            for (FilterRule filterRule : rulesFilterSetting.getFilters()) {
                Range range;
                FilterOn filterOn = filterRule.getFilterOn();
                if (!filterRule.isStickyFilter()) continue;
                if (FilterOn.LIFT.equals((Object)filterOn)) {
                    range = filterRule.getRange();
                    this.setMinLift(range.getMin());
                    if (range.isOnlyMin()) continue;
                    this.setMaxLift(range.getMax());
                    continue;
                }
                if (FilterOn.SUPPORT.equals((Object)filterOn)) {
                    range = filterRule.getRange();
                    this.setMinSupport(range.getMin());
                    if (range.isOnlyMin()) continue;
                    this.setMaxSupport(range.getMax());
                    continue;
                }
                if (FilterOn.CONFIDENCE.equals((Object)filterOn)) {
                    range = filterRule.getRange();
                    this.setMinConfidence(range.getMin());
                    if (range.isOnlyMin()) continue;
                    this.setMaxConfidence(range.getMax());
                    continue;
                }
                if (!FilterOn.ITEMS_IN_RULE.equals((Object)filterOn)) continue;
                range = filterRule.getRange();
                this.setMinItems(range.getMin());
                this.setMaxItems(range.getMax());
            }
        }
    }

    public void setItemSetMaxItems(int n) {
        this._hash.putInt(ITEMSET_MAX_ITEMS, n);
    }

    public int getItemSetMaxItems() {
        return this._hash.getInt(ITEMSET_MAX_ITEMS, 10);
    }

    public void setItemSetMinSupport(double d) {
        this._hash.putDouble(ITEMSET_MIN_SUPPORT, d);
    }

    public double getItemSetMinSupport() {
        return this._hash.getDouble(ITEMSET_MIN_SUPPORT, 1.0);
    }

    public void setFindItemsFetchSize(Integer n) {
        this._hash.putInt(FIND_ITEMS_FETCH_SIZE, n.intValue());
    }

    public Integer getFindItemsFetchSize() {
        return this._hash.getInt(FIND_ITEMS_FETCH_SIZE, DEFAULT_FIND_ITEMS_FETCH_SIZE.intValue());
    }

    public static ARPreferences getInstance() {
        return new ARPreferences(ARPreferences.findOrCreate((PropertyStorage)Preferences.getPreferences(), (String)DATA_KEY));
    }
}

