/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer;

import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.TreeRulesSettings;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusTreeRule;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeLink;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeNode;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusterTreeSDMModel;
import oracle.dmt.dataminer.mviewer.dtree.DTTreeRule;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeLink;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeNode;
import oracle.dmt.dataminer.mviewer.dtree.model.DecisionTreeSDMModel;
import oracle.dmt.dataminer.navigator.modelnodes.ClusteringModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.utils.ClipboardUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.model.Node;
import oracle.javatools.data.PropertyStorage;

public class TreeRulesPanel
extends DialogDisplayer {
    private static final Logger LOGGER = Logger.getLogger(TreeRulesPanel.class.getName());
    private TreeRulesSettings treeRulesSettings = TreeRulesSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private Node node;
    private ButtonGroup OptionButtonGroup;
    private JSeparator jSeparator1;
    private JCheckBox leavesOnlyCheck;
    private JRadioButton saveToClipboarOption;
    private JRadioButton saveToFileOption;

    public TreeRulesPanel(Context context, Node node) {
        super(context, null);
        this.node = node;
        this.initComponents();
        this.initRes();
    }

    private void initComponents() {
        this.OptionButtonGroup = new ButtonGroup();
        this.leavesOnlyCheck = new JCheckBox();
        this.saveToClipboarOption = new JRadioButton();
        this.saveToFileOption = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.leavesOnlyCheck.setSelected(true);
        this.leavesOnlyCheck.setText("Leaves Only");
        this.OptionButtonGroup.add(this.saveToClipboarOption);
        this.saveToClipboarOption.setSelected(true);
        this.saveToClipboarOption.setText("Save to Clipboard");
        this.OptionButtonGroup.add(this.saveToFileOption);
        this.saveToFileOption.setText("Save to File");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1)).addGroup(groupLayout.createSequentialGroup().addGap(19, 19, 19).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.saveToClipboarOption).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.saveToFileOption)).addGap(25, 25, 25).addComponent(this.leavesOnlyCheck).addGap(9, 9, 9))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.saveToClipboarOption).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveToFileOption, -2, 23, -2).addComponent(this.leavesOnlyCheck)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2)));
    }

    @Override
    public void initRes() {
        this.leavesOnlyCheck.setText(ModelViewerLrb.get("TREE_RULES_LEAVES_CHK"));
        this.saveToClipboarOption.setText(ModelViewerLrb.get("TREE_RULES_SAVE_CLIPBOARD"));
        this.saveToFileOption.setText(ModelViewerLrb.get("TREE_RULES_SAVE_FILE"));
    }

    @Override
    public void initUI() {
    }

    @Override
    public boolean doWork() {
        try {
            if (this.saveToClipboarOption.isSelected()) {
                if (this.node instanceof ClusteringModelNode) {
                    this.copyClusterRules(this.node, this.leavesOnlyCheck.isSelected());
                } else if (this.node instanceof DTModelNode) {
                    this.copyDTRules(this.node, this.leavesOnlyCheck.isSelected());
                }
            } else if (this.saveToFileOption.isSelected()) {
                if (this.node instanceof ClusteringModelNode) {
                    String string = this.getHTMLClusterRules(this.node, this.leavesOnlyCheck.isSelected());
                    String string2 = ((ClusteringModelNode)this.node).getOdmModel().getModelName() + "_Rules";
                    this.saveRuleFiles(string2, string);
                } else if (this.node instanceof DTModelNode) {
                    String string = this.getHTMLDTRues(this.node, this.leavesOnlyCheck.isSelected());
                    String string3 = ((DTModelNode)this.node).getOdmModel().getModelName() + "_Rules";
                    this.saveRuleFiles(string3, string);
                }
            }
            return true;
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
    }

    public boolean isLeaf(IlvSDMNode ilvSDMNode) {
        if (ilvSDMNode instanceof ClusTreeNode) {
            return ((ClusTreeNode)ilvSDMNode).getData().getChild().size() == 0;
        }
        return false;
    }

    public void copyDTRules(Node node, boolean bl) {
        String string = this.getHTMLDTRues(node, bl);
        new ClipboardUtils(string).setContentToClipboard();
    }

    public String getHTMLDTRues(Node node, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        if (node instanceof DTModelNode) {
            String string = ((DTModelNode)node).getOdmModel().getModelName();
            stringBuilder.append("<p><strong>" + ModelViewerLrb.get("TREE_RULES_MODEL_NAME") + ": " + string + "</strong></p>");
            DecisionTreeSDMModel decisionTreeSDMModel = (DecisionTreeSDMModel)((DTModelNode)node).getSDMModel();
            Map<String, IlvSDMNode> map = decisionTreeSDMModel.getNodeStore();
            for (Map.Entry<String, IlvSDMNode> entry : map.entrySet()) {
                List<DTTreeLink> list;
                IlvSDMNode ilvSDMNode = entry.getValue();
                if (ilvSDMNode instanceof DTTreeLink || !(ilvSDMNode instanceof DTTreeNode)) continue;
                DTTreeNode dTTreeNode = (DTTreeNode)ilvSDMNode;
                if (bl) {
                    list = decisionTreeSDMModel.findLinksFromNode(ilvSDMNode);
                    if (list.size() != 0) continue;
                    String string2 = String.valueOf(dTTreeNode.getData().getId());
                    stringBuilder.append("<br><p><strong> " + ModelViewerLrb.get("TREE_RULES_NODE") + ": " + string2 + "</strong></p><br>");
                    stringBuilder.append(DTTreeRule.getRulesHtml(dTTreeNode, true));
                    continue;
                }
                list = String.valueOf(dTTreeNode.getData().getId());
                stringBuilder.append("<br><p><strong>" + ModelViewerLrb.get("TREE_RULES_NODE") + ": " + (String)((Object)list) + "</strong></p><br>");
                stringBuilder.append(DTTreeRule.getRulesHtml(dTTreeNode, true));
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public String getHTMLClusterRules(Node node, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        if (node instanceof ClusteringModelNode) {
            String string = ((ClusteringModelNode)node).getOdmModel().getModelName();
            stringBuilder.append("<p><strong>" + ModelViewerLrb.get("TREE_RULES_MODEL_NAME") + ": " + string + "</strong></p>");
            ClusterTreeSDMModel clusterTreeSDMModel = (ClusterTreeSDMModel)((ClusteringModelNode)node).getSDMModel();
            Map<String, IlvSDMNode> map = clusterTreeSDMModel.getNodeStore();
            for (Map.Entry<String, IlvSDMNode> entry : map.entrySet()) {
                String string2;
                String string3;
                IlvSDMNode ilvSDMNode = entry.getValue();
                if (ilvSDMNode instanceof ClusTreeLink || !(ilvSDMNode instanceof ClusTreeNode)) continue;
                ClusTreeNode clusTreeNode = (ClusTreeNode)ilvSDMNode;
                if (bl) {
                    if (!this.isLeaf(ilvSDMNode)) continue;
                    string3 = clusTreeNode.getData().getClusterId();
                    if (string3.equals(string2 = String.valueOf(clusTreeNode.getData().getId()))) {
                        stringBuilder.append("<br><p><strong> " + ModelViewerLrb.get("TREE_RULES_CLUSTER") + ": " + string3 + "</strong></p><br>");
                    } else {
                        stringBuilder.append("<br><p><strong>" + ModelViewerLrb.get("TREE_RULES_CLUSTER") + ": " + string3 + " (" + string2 + ")</strong></p><br>");
                    }
                    stringBuilder.append(ClusTreeRule.getRulesHtml(clusTreeNode, true, 10, true));
                    continue;
                }
                string3 = clusTreeNode.getData().getClusterId();
                if (string3.equals(string2 = String.valueOf(clusTreeNode.getData().getId()))) {
                    stringBuilder.append("<br><p><strong> " + ModelViewerLrb.get("TREE_RULES_CLUSTER") + ": " + string3 + "</strong></p><br>");
                } else {
                    stringBuilder.append("<br><p><strong>" + ModelViewerLrb.get("TREE_RULES_CLUSTER") + ": " + string3 + " (" + string2 + ")</strong></p><br>");
                }
                stringBuilder.append(ClusTreeRule.getRulesHtml(clusTreeNode, true, 10, true));
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public void copyClusterRules(Node node, boolean bl) {
        String string = this.getHTMLClusterRules(node, bl);
        new ClipboardUtils(string).setContentToClipboard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRuleFiles(String string, String string2) {
        FileOutputStream fileOutputStream = null;
        Writer writer = null;
        try {
            File file;
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Html/Text files", "html", "txt", ".doc", "docx");
            URLFileChooser uRLFileChooser = new URLFileChooser();
            String string3 = this.getLastPath();
            if (string3 != null && !"".equals(string3)) {
                file = new File(string3);
                if (file.isFile()) {
                    file = file.getParentFile();
                }
                if (file.exists()) {
                    uRLFileChooser.setCurrentDirectory(file);
                    string3 = file.getAbsolutePath();
                } else {
                    string3 = uRLFileChooser.getCurrentDirectory().getAbsolutePath();
                }
            }
            file = new File(string3 + File.separator + string + ".html");
            int n = 1;
            while (file.exists()) {
                String string4 = string + n;
                file = new File(string3 + File.separator + string4 + ".html");
                ++n;
            }
            uRLFileChooser.setSelectedFile(file);
            uRLFileChooser.setFileFilter((FileFilter)fileNameExtensionFilter);
            int n2 = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow());
            if (n2 == 0) {
                String string5 = uRLFileChooser.getSelectedFile().getAbsolutePath();
                this.treeRulesSettings.setLastPathUsedValue(uRLFileChooser.getSelectedFile().getParent());
                File file2 = new File(string5);
                fileOutputStream = new FileOutputStream(file2);
                writer = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                writer.write(string2);
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
                }
            }
        }
    }

    public String getLastPath() {
        return this.treeRulesSettings.getLastPathUsedValue();
    }

    @Override
    protected String getDialogTitle() {
        return ModelViewerLrb.get("TREE_RULES_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return null;
    }

    @Override
    protected int getDialogButtonMask() {
        return 3;
    }
}

