/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer;

import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetModelViewerAlertsQuery;
import oracle.dmt.dataminer.core.model.common.build.AlertEntry;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.comparator.StringEndingWithNumberComparator;
import oracle.dmt.dataminer.mviewer.ModelMessagePanel;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.utils.HTMLStringUtils;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.javatools.icons.OracleIcons;

public class AlertViewerPanel
extends DataMinerViewGUI {
    private AlertTableModel tableModel;
    private DataMinerTablePanel _alertTable;
    private JEditorPane _messagePane;
    private JEditorPane jEditorPane1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public AlertViewerPanel(Editor editor, Context context) {
        super(editor, context);
        ModelNode modelNode = (ModelNode)context.getNode();
        assert (modelNode != null) : "Null node";
        if (!modelNode.exists()) {
            this.add((Component)new ModelMessagePanel(ModelViewerLrb.get("MODEL_DOES_NOT_EXIST")), "Center");
            return;
        }
        this.tableModel = new AlertTableModel((List<AlertEntry>)new ArrayList<AlertEntry>());
        this.initComponents();
        this.initUI();
    }

    private void initUI() {
        this._alertTable.setup((TableModel)((Object)this.tableModel), null, 0, true);
        this._alertTable.getTable().getColumnModel().getColumn(2).setCellRenderer(new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return OracleIcons.getIcon((String)"warning.png");
            }
        }));
        this._alertTable.getTable().getSelectionModel().setSelectionMode(2);
        this._alertTable.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AlertViewerPanel.this.loadDetail();
            }
        });
        this._messagePane.setEditable(false);
        this._messagePane.setContentType("text/html");
        this._messagePane.setDragEnabled(true);
        this._messagePane.setText(RunManagerLrb.get("VIEW_NO_SELECTION"));
        this._messagePane.setTransferHandler(new TransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent jComponent) {
                JEditorPane jEditorPane = (JEditorPane)jComponent;
                return new StringSelection(jEditorPane.getSelectedText());
            }

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 3;
            }
        });
    }

    private void loadDetail() {
        AlertTableModel alertTableModel = (AlertTableModel)((Object)this._alertTable.getTable().getModel());
        int n = this._alertTable.getTable().getSelectedRowCount();
        String string = "";
        if (n > 1) {
            string = RunManagerLrb.get("VIEW_TOO_MANY_SELECTED");
            this._messagePane.setText(string);
            return;
        }
        int n2 = this._alertTable.getTable().getSelectedRowInModel();
        if (n2 == -1) {
            string = RunManagerLrb.get("VIEW_NO_SELECTION");
            this._messagePane.setText(string);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("<html><table>\n<tr>\n");
        stringBuilder.append("<td align=\"left\" valign=\"center\" style=\" margin-top:3px;\"><img src={2}");
        stringBuilder.append(" height=\"12\" width=\"12\"></td>\n");
        stringBuilder.append("<td align=\"left\" valign=\"top\"><p><b>{1}</b></p></td>\n");
        stringBuilder.append("<td align=\"left\" valign=\"top\">{0}</td>\n");
        stringBuilder.append("</tr>\n</table></html>");
        string = alertTableModel.getStringValueAt(n2, 2);
        string = string != null ? HTMLStringUtils.forHTML(string) : RunManagerLrb.get("VIEW_NO_INFO");
        RunManagerLrb.get("EVENT_VIEWER_MESSAGE_HEADER");
        Object[] objectArray = new Object[]{string, "", this.getImageName()};
        String string2 = MessageFormat.format(stringBuilder.toString(), objectArray);
        this._messagePane.setText(string2);
        this._messagePane.setCaretPosition(this._messagePane.getDocument().getLength());
        this._messagePane.moveCaretPosition(0);
    }

    private String getImageName() {
        URL uRL = this.getClass().getClassLoader().getResource(Icons.WARNING_STATUS.getFilePath());
        return uRL.toString();
    }

    @Override
    public HelpInfo getHelpInfo() {
        return new HelpInfo("dataminer_model_build_alert_viewer");
    }

    @Override
    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this._alertTable = new DataMinerTablePanel();
        this.jScrollPane2 = new JScrollPane();
        this._messagePane = new JEditorPane();
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        this.jScrollPane2.setViewportView(this._messagePane);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._alertTable, -1, 380, Short.MAX_VALUE).addComponent(this.jScrollPane2)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._alertTable, -1, 205, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 67, -2).addContainerGap()));
    }

    public static class AlertTableModel
    extends ODMrTableModel<AlertEntry> {
        private static final int PARTITION_ID = 0;
        private static final int PARTITION_NAME = 1;
        private static final int MESSAGE = 2;
        private static final String[] columns = new String[]{CommonLrb.get("PARTITION_ID"), CommonLrb.get("PARTITION_NAME"), CommonLrb.get("MESSAGE")};

        public AlertTableModel(List<AlertEntry> list) {
            super(columns, list);
        }

        public Comparator getColumnSortComparator(int n) {
            switch (n) {
                case 0: {
                    return StringEndingWithNumberComparator.getComparator();
                }
            }
            return super.getColumnSortComparator(n);
        }

        public String getValueAt(int n, int n2) {
            String string = "";
            AlertEntry alertEntry = (AlertEntry)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    string = alertEntry.getPartitionId();
                    break;
                }
                case 1: {
                    string = alertEntry.getPartitionName();
                    break;
                }
                case 2: {
                    string = alertEntry.getMessage();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<List<AlertEntry>, Void> {
        public LoadUI() {
            super(AlertViewerPanel.this, null, AlertViewerPanel.this._alertTable.getTable());
        }

        @Override
        protected List<AlertEntry> doInBackground() throws ODMrDAOException {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(AlertViewerPanel.this.getContext());
            SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject((ConnectionManager)connectionFolder);
            ModelDescriptor modelDescriptor = new ModelDescriptor(((ModelNode)AlertViewerPanel.this.getContext().getNode()).getSchema(), AlertViewerPanel.this.getContext().getNode().toString());
            GetModelViewerAlertsQuery getModelViewerAlertsQuery = new GetModelViewerAlertsQuery(connectionFolder.getDbVersion(), modelDescriptor);
            try {
                return sqlDataAccessObject.readItems((Query)getModelViewerAlertsQuery);
            }
            catch (ODMrDAOException oDMrDAOException) {
                return new ArrayList<AlertEntry>();
            }
        }

        @Override
        protected void onSuccess(List<AlertEntry> list) throws Exception {
            AlertViewerPanel.this.tableModel.setSrcData(list);
            AlertViewerPanel.this._alertTable.setTitle(MessageFormat.format(ModelViewerLrb.get("MODEL_VIEWER_ALERT_COUNT"), list.size()));
        }
    }
}

