/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.filter;

import java.util.ArrayList;
import javax.swing.JPanel;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.DataMinerViewListener;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.filter.FilterEvent;
import oracle.dmt.dataminer.filter.FilterImplementer;
import oracle.dmt.dataminer.filter.FilterListener;

public abstract class FilterWindowGUI
extends JPanel
implements FilterImplementer,
DataminerGUIPanel,
DataMinerViewListener {
    private Object _filterListenerLock = new Object();
    protected ArrayList<FilterListener> _filterListeners = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterListener(FilterListener filterListener) {
        Object object = this._filterListenerLock;
        synchronized (object) {
            if (this._filterListeners == null) {
                this._filterListeners = new ArrayList();
            }
            this._filterListeners.add(filterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterListener(FilterListener filterListener) {
        Object object = this._filterListenerLock;
        synchronized (object) {
            this._filterListeners.remove(filterListener);
        }
    }

    private void fireEvent(FilterListenerHandler filterListenerHandler, FilterEvent filterEvent) {
        ArrayList<FilterListener> arrayList = this.cloneToAvoidConcurrentModificationException(this._filterListeners);
        for (FilterListener filterListener : arrayList) {
            filterListenerHandler.handle(filterListener, filterEvent);
        }
    }

    private ArrayList<FilterListener> cloneToAvoidConcurrentModificationException(ArrayList<FilterListener> arrayList) {
        return (ArrayList)arrayList.clone();
    }

    protected void fireFilterEvent(FilterEvent filterEvent) {
        try {
            this.fireEvent(new FilterListenerHandler(){

                @Override
                public void handle(FilterListener filterListener, FilterEvent filterEvent) {
                    filterListener.applyEvent(filterEvent);
                }
            }, filterEvent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void viewPropertySelectionChange(DataMinerViewEvent dataMinerViewEvent) {
    }

    private static interface FilterListenerHandler {
        public void handle(FilterListener var1, FilterEvent var2);
    }
}

