/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.filter;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dmt.dataminer.filter.Filter;
import oracle.dmt.dataminer.filter.FilterConsumer;
import oracle.dmt.dataminer.filter.FilterEvent;
import oracle.dmt.dataminer.filter.FilterImplementer;
import oracle.dmt.dataminer.filter.FilterListener;
import oracle.dmt.dataminer.filter.FilterLrb;
import oracle.dmt.dataminer.filter.FilterManager;
import oracle.dmt.dataminer.filter.FilterPageProvider;
import oracle.dmt.dataminer.filter.FilterWindowGUI;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableListener;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.dialogs.MessageDialog;

public class FilterWindow
extends DockableWindow
implements EditorListener,
ViewListener,
DockableListener,
ActiveViewListener {
    private static final Logger theLogger = Logger.getLogger(FilterWindow.class.getName());
    private static Icon _icon;
    public static final String VIEW_TYPE = "DATAMININGFILTERFACTORY";
    public static final String VIEW_NAME = "FILTER";
    protected HashMap<View, ArrayList<FilterListener>> _filterListenersByType;
    private Object _filterListenerLock = new Object();
    protected ArrayList<Component> _filterWindows;
    FilterGUIEventHandler _guiEventHandler;
    private static final FilterWindow _singleton;
    private JScrollPane _rootContainer;
    private JPanel _emptyPanel;
    private final FilterManager _filterManager = FilterManager.getFilterManager();
    private final Filter _filter = Filter.getInstance();
    private View _currentEditor = null;
    private View _currentView = null;
    private Component _currentGUI = null;
    private static boolean _isView;
    private static boolean _dockableHidden;
    private static boolean editorListenerAdded;
    private Collection<FilterConsumer> _consumers = null;
    public static final String LAYOUT_SHOW_FILTER = "Layout.ShowFilter";
    public static final String LAYOUT_RAISE_FILTER = "Layout.RaiseFilter";

    public static String viewId() {
        return "DATAMININGFILTERFACTORY.FILTER";
    }

    public FilterWindow() {
        super(FilterWindow.viewId());
        DockStation.getDockStation().addDockableListener((DockableListener)this, (Dockable)this);
        this._filterListenersByType = new HashMap();
        this._guiEventHandler = new FilterGUIEventHandler();
    }

    private void initRootContainer() {
        this._rootContainer = new JScrollPane();
        this._emptyPanel = new JPanel();
        JLabel jLabel = new JLabel();
        jLabel.setText("No Associated Editor");
        this._emptyPanel.add(jLabel);
        this.loadRootContainer(this._emptyPanel);
    }

    private void consumerListeners() {
        this._consumers = this._filterManager.getFilterConsumers();
        if (this._consumers == null) {
            return;
        }
        for (FilterConsumer filterConsumer : this._consumers) {
            filterConsumer.getConsumerView().addViewListener((ViewListener)this);
        }
    }

    public Component getGUI() {
        View view;
        if (this._rootContainer == null) {
            this.initRootContainer();
        }
        if ((view = this.getEditor()) == null) {
            this.loadRootContainer(this._emptyPanel);
            this._currentGUI = null;
            return this.loadRootContainer(this._currentGUI);
        }
        this._currentView = view;
        _isView = true;
        if (this._consumers == null) {
            this.consumerListeners();
        }
        if (this._synchronizeFilter(this.getEditor(), false)) {
            return this._rootContainer;
        }
        this._currentGUI = null;
        return this.loadRootContainer(this._emptyPanel);
    }

    private Component loadRootContainer(Component component) {
        if (component != null) {
            this._rootContainer.setViewportView(component);
        } else {
            this._rootContainer.getViewport().removeAll();
        }
        return this._rootContainer;
    }

    private Component getInternalGUI() {
        Component component = null;
        FilterConsumer filterConsumer = null;
        if (this._currentEditor instanceof FilterConsumer) {
            filterConsumer = (FilterConsumer)this._currentEditor;
        }
        FilterPageProvider filterPageProvider = null;
        if (filterConsumer != null) {
            filterPageProvider = this.findFilterPageProvider(filterConsumer);
            assert (filterPageProvider != null) : "Filter dockable received a request from a consumer, but there is no matching filter provider.";
            component = filterPageProvider.getFilterPage().getGUI();
            if (component instanceof FilterWindowGUI) {
                this.addInternalGUIToListener(component);
                this.loadRootContainer(component);
            } else assert (false) : "GUI provided by FilterPageProvider is not an instance of FilterWindowGUI";
        }
        return component;
    }

    private void addInternalGUIToListener(Component component) {
        if (this._filterWindows == null) {
            this._filterWindows = new ArrayList();
        }
        if (!this._filterWindows.contains(component)) {
            ((FilterWindowGUI)component).addFilterListener(this._guiEventHandler);
            this._filterWindows.add(component);
        }
    }

    private FilterPageProvider findFilterPageProvider(FilterConsumer filterConsumer) {
        FilterPageProvider filterPageProvider = null;
        for (FilterPageProvider filterPageProvider2 : this._filter.getFilterPageProviders()) {
            if (!filterPageProvider2.getFilterType().equals(filterConsumer.getFilterType())) continue;
            filterPageProvider = filterPageProvider2;
            break;
        }
        return filterPageProvider;
    }

    public static FilterWindow getInstance() {
        return _singleton;
    }

    public void dockableShown(DockableEvent dockableEvent) {
        _dockableHidden = false;
        super.dockableShown(dockableEvent);
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
        this._synchronizeFilter(this.getEditor(), true);
    }

    public void dockableHidden(DockableEvent dockableEvent) {
        this.unloadUI();
        _dockableHidden = true;
        this._currentEditor = null;
        super.dockableHidden(dockableEvent);
        Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
    }

    public void stateChange(int n) {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        super.stateChange(n);
    }

    public View getEditor() {
        if (_isView) {
            return this._currentView;
        }
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor == null || editor.getContext() == null || editor.getContext().getNode() == null) {
            editor = null;
        }
        return editor;
    }

    private boolean _synchronizeFilter(View view, boolean bl) {
        if (!editorListenerAdded) {
            EditorManager.getEditorManager().addEditorListener((EditorListener)this);
            editorListenerAdded = true;
        }
        if (view == null) {
            this.loadRootContainer(this._emptyPanel);
            return false;
        }
        if (this._currentEditor == null || view != this._currentEditor) {
            Component component;
            if (!(view instanceof FilterConsumer)) {
                this._currentEditor = view;
                this._currentGUI = null;
                this.loadRootContainer(this._emptyPanel);
                return true;
            }
            if (this._currentGUI != null) {
                this.unloadUI();
            }
            this._currentEditor = view;
            this._currentGUI = component = this.getInternalGUI();
            if (this._currentGUI != null) {
                this.loadRootContainer(this._currentGUI);
                if (bl) {
                    this.initializeUI();
                }
                return true;
            }
            this.loadRootContainer(this._emptyPanel);
            return false;
        }
        this.initializeUI();
        return true;
    }

    private void initializeUI() {
        if (this._currentGUI instanceof FilterImplementer) {
            try {
                FilterImplementer filterImplementer = (FilterImplementer)((Object)this._currentGUI);
                if (!filterImplementer.isLoaded()) {
                    filterImplementer.setupUI(this._currentEditor);
                }
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)FilterLrb.get("FILTER_PROCESSING_MESG"), (String)FilterLrb.get("FILTER_PROCESSING_TITLE"), null);
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    private void unloadUI() {
        if (this._currentGUI instanceof FilterImplementer) {
            try {
                FilterImplementer filterImplementer = (FilterImplementer)((Object)this._currentGUI);
                if (filterImplementer.isLoaded()) {
                    filterImplementer.unloadUI();
                }
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)FilterLrb.get("FILTER_PROCESSING_MESG"), (String)FilterLrb.get("FILTER_PROCESSING_TITLE"), null);
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    public void addFilterListener(FilterListener filterListener) {
        this.addFilterListener(filterListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterListener(FilterListener filterListener, View view) {
        Object object = this._filterListenerLock;
        synchronized (object) {
            ArrayList<FilterListener> arrayList = null;
            if (this._filterListenersByType == null) {
                this._filterListenersByType = new HashMap();
            }
            if (!this._filterListenersByType.containsKey(view)) {
                this._filterListenersByType.put(view, new ArrayList());
            }
            arrayList = this._filterListenersByType.get(view);
            arrayList.add(filterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterListener(FilterListener filterListener) {
        Object object = this._filterListenerLock;
        synchronized (object) {
            if (this._filterListenersByType == null) {
                return;
            }
            for (ArrayList<FilterListener> arrayList : this._filterListenersByType.values()) {
                arrayList.remove(filterListener);
            }
        }
    }

    private void fireFilterEvent(FilterEvent filterEvent) {
        try {
            this.fireEvent(new FilterListenerHandler(){

                @Override
                public void handle(FilterListener filterListener, FilterEvent filterEvent) {
                    filterListener.applyEvent(filterEvent);
                }
            }, filterEvent);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void fireEvent(FilterListenerHandler filterListenerHandler, FilterEvent filterEvent) {
        HashMap<View, ArrayList<FilterListener>> hashMap = this.cloneToAvoidConcurrentModificationException(this._filterListenersByType);
        ArrayList<FilterListener> arrayList = hashMap.get(filterEvent.getTarget());
        if (arrayList != null) {
            for (FilterListener filterListener : arrayList) {
                filterListenerHandler.handle(filterListener, filterEvent);
            }
        }
        if (filterEvent.getTarget() != null && (arrayList = hashMap.get(null)) != null) {
            for (FilterListener filterListener : arrayList) {
                filterListenerHandler.handle(filterListener, filterEvent);
            }
        }
    }

    private HashMap<View, ArrayList<FilterListener>> cloneToAvoidConcurrentModificationException(HashMap<View, ArrayList<FilterListener>> hashMap) {
        return (HashMap)hashMap.clone();
    }

    public void editorOpened(Editor editor) {
    }

    public void editorActivated(Editor editor) {
        _isView = false;
        if (!_dockableHidden) {
            this._synchronizeFilter((View)editor, true);
        }
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        if (editor != null && editor == this._currentEditor) {
            this._currentEditor = null;
            this._currentView = null;
            this.unloadUI();
            this._currentGUI = null;
            this.loadRootContainer(this._emptyPanel);
            _isView = false;
        }
    }

    public void viewActivated(ViewEvent viewEvent) {
        _isView = true;
        View view = viewEvent.getView();
        if (!_dockableHidden) {
            this._currentView = view;
            this._synchronizeFilter(view, true);
        }
    }

    public void viewDeactivated(ViewEvent viewEvent) {
    }

    public void viewClosed(ViewEvent viewEvent) {
        View view = viewEvent.getView();
        if (view != null && view == this._currentView) {
            this._currentView = null;
            this._currentEditor = null;
            this.unloadUI();
            this._currentGUI = null;
            this.loadRootContainer(this._emptyPanel);
            _isView = false;
        }
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        if (activeViewEvent.getNewView() == null) {
            this.loadRootContainer(this._emptyPanel);
            return;
        }
        View view = this.getEditor();
        if (view == null) {
            this.loadRootContainer(this._emptyPanel);
            return;
        }
        if (!_dockableHidden) {
            this._synchronizeFilter(view, true);
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_dataminer_filter_html");
    }

    public int getDefaultVisibility(Layout layout) {
        String string = layout.getProperty(LAYOUT_SHOW_FILTER, null);
        boolean bl = Boolean.valueOf(string);
        String string2 = layout.getProperty(LAYOUT_RAISE_FILTER, bl ? "true" : "false");
        boolean bl2 = Boolean.valueOf(string2);
        return (bl ? 1 : 0) | (bl2 ? 4 : 0);
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public String getTitleName() {
        return FilterLrb.get("FILTER_TAB_NAME");
    }

    public String getUniqueName() {
        return "DATAMININGFILTERFACTORY.FILTER";
    }

    static {
        _singleton = new FilterWindow();
        _isView = false;
        _dockableHidden = false;
        editorListenerAdded = false;
    }

    class FilterGUIEventHandler
    implements FilterListener {
        FilterGUIEventHandler() {
        }

        @Override
        public void applyEvent(FilterEvent filterEvent) {
            FilterWindow.this.fireFilterEvent(filterEvent);
        }
    }

    private static interface FilterListenerHandler {
        public void handle(FilterListener var1, FilterEvent var2);
    }
}

