/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.expressionbuilder2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.DataAccessObject;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.extensible.r.GetRConfigurationQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.extensible.r.GetRFunctionOwnersQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.extensible.r.GetRFunctionsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.extensible.r.GetRScriptsQuery;
import oracle.dmt.dataminer.core.model.extensible.r.RFunction;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.expressionbuilder2.DialogsLrb;
import oracle.dmt.dataminer.expressionbuilder2.RScriptViewerPanel;
import oracle.dmt.dataminer.expressionbuilder2.RScriptsTableModel;
import oracle.dmt.dataminer.expressionbuilder2.SQLContext;
import oracle.dmt.dataminer.expressionbuilder2.SQLExpressionBuilderPanel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.preferences.RInterfaceFunctionSettings;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.Version;

public class RScriptsPanel
extends AbstractPanel<AbstractNode>
implements SearchListener {
    private static final String RQEVAL = "rqEval";
    private static final String RQEVAL_PROTOCOL = "rqEval(\n  cursor(select * from <table-1>), -- Param Cursor \n  'select <column list> from <table-2>', -- Output Definition \n  '<RScript>' -- R Script \n) \n";
    private static final String RQTABLEEVAL = "rqTableEval";
    private static final String RQTABLEEVAL_PROTOCOL = "rqTableEval(\n  cursor(select * from <table-1>), -- Input Cursor \n  cursor(select * from <table-2>), -- Param Cursor \n  'select <column list> from <table-3>', -- Output Definition \n  '<RScript>' -- R Script \n) \n";
    private static final String RQROWEVAL = "rqRowEval";
    private static final String RQROWEVAL_PROTOCOL = "rqRowEval(\n  cursor(select * from <table-1>), -- Input Cursor \n  cursor(select * from <table-2>), -- Param Cursor \n  'select <column list> from <table-3>', -- Output Definition \n  '<num rows>', -- Number of rows \n  '<RScript>' -- R Script \n) \n";
    private static final String RQGROUPEVAL = "rqGroupEval";
    private static final String RQGROUPEVAL_PROTOCOL = "rqGroupEval(\n  cursor(select * from <table-1>), -- Input Cursor \n  cursor(select * from <table-2>), -- Param Cursor \n  'select <column list> from <table-3>', -- Output Definition \n  '<grouping column name>', -- Group name \n  '<RScript>' -- R Script \n) \n";
    private static final String NO_FUNCTION = DialogsLrb.get("SQLQUERY_RSCRIPT_NO_FUNCTION");
    private static final String RQSYS = "RQSYS";
    private static final double ORE_1_5 = 1.5;
    private String currentUser;
    private JLabel usersLabel;
    private JComboBox<String> usersComboBox;
    private DefaultComboBoxModel<String> userComboBoxModel;
    private JButton viewButton;
    private JButton refreshButton;
    private String searchText;
    private SearchField searchField;
    private SearchCategory searchCategory;
    private DataMinerTable scriptsTable;
    private RScriptsTableModel rScriptsTableModel;
    private SQLContext sqlContext;
    private Map<String, Object> oreConfiguration;
    private SQLExpressionBuilderPanel parentPanel;
    private RInterfaceFunctionSettings rInterfacePreferences;
    private RowFilter<RScriptsTableModel, Integer> rScriptFilter;
    private Version dbVersion;
    private DataAccessObject dao;
    private Query<String> functionOwnersQuery;
    private Query<RFunction> query;
    private Query<Map<String, Object>> oreConfigurationQuery;
    private JLabel jRFunctionLabel;
    private JCheckBox jRInterfaceFuncCheckBox;
    private JPanel jRQPanel;
    private JPanel jRScriptPanel;
    private JComboBox<RFunction> rScriptComboBox;
    private JToolBar toolbar;

    public RScriptsPanel(SQLExpressionBuilderPanel sQLExpressionBuilderPanel, SQLContext sQLContext) {
        super(sQLContext.getContext(), sQLContext.getNode());
        this.parentPanel = sQLExpressionBuilderPanel;
        this.sqlContext = sQLContext;
        this.currentUser = "";
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.sqlContext.getContext());
        this.dbVersion = connectionFolder.getDbVersion();
        this.dao = new SqlDataAccessObject((ConnectionManager)connectionFolder);
        this.functionOwnersQuery = new GetRFunctionOwnersQuery(this.dbVersion);
        this.oreConfigurationQuery = new GetRConfigurationQuery(this.dbVersion);
        Preferences preferences = Preferences.getPreferences();
        this.rInterfacePreferences = RInterfaceFunctionSettings.getInstance((PropertyStorage)preferences);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jRScriptPanel = new JPanel();
        this.toolbar = new JToolBar();
        this.jRQPanel = new JPanel();
        this.jRInterfaceFuncCheckBox = new JCheckBox();
        this.jRFunctionLabel = new JLabel();
        this.rScriptComboBox = new JComboBox();
        this.jRScriptPanel.setLayout(new BorderLayout());
        this.toolbar.setRollover(true);
        this.jRScriptPanel.add((Component)this.toolbar, "North");
        this.jRFunctionLabel.setLabelFor(this.rScriptComboBox);
        this.jRFunctionLabel.setText("Function:");
        GroupLayout groupLayout = new GroupLayout(this.jRQPanel);
        this.jRQPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jRInterfaceFuncCheckBox, -2, 170, -2)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jRFunctionLabel, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rScriptComboBox, -2, -1, -2))).addContainerGap(146, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jRInterfaceFuncCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRFunctionLabel).addComponent(this.rScriptComboBox, -2, -1, -2)).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRScriptPanel, -1, 322, Short.MAX_VALUE).addComponent(this.jRQPanel, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jRScriptPanel, -1, 387, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRQPanel, -2, -1, -2)));
    }

    @Override
    public void initRes() {
        this.usersComboBox = new JComboBox();
        this.usersLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.usersLabel, this.usersComboBox, (String)DialogsLrb.get("SQLQUERY_PLSQL_USER"));
        ResourceUtils.resLabel((JLabel)this.jRFunctionLabel, this.rScriptComboBox, (String)DialogsLrb.get("SQLQUERY_RSCRIPT_R_INTERFACE_FUNC"));
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("SQLQUERY_RSCRIPT_WARP_R_INTERFACE"), this.jRInterfaceFuncCheckBox);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        SearchCategory searchCategory2;
        SearchCategory[] searchCategoryArray;
        this.refreshButton = new JButton();
        this.refreshButton.setIcon(OracleIcons.getIcon((String)"refresh.png"));
        this.refreshButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SQLQUERY_RSCRIPT_REFRESH_ADA"));
        this.refreshButton.setToolTipText(DialogsLrb.get("SQLQUERY_RSCRIPT_REFRESH_ADA"));
        this.refreshButton.addActionListener(new LoadActionListener());
        this.viewButton = new JButton();
        this.viewButton.setIcon(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_ENA));
        this.viewButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SQLQUERY_RSCRIPT_VIEW_ADA"));
        this.viewButton.setToolTipText(DialogsLrb.get("SQLQUERY_RSCRIPT_VIEW_ADA"));
        this.viewButton.addActionListener(new ViewScriptActionListener());
        this.searchField = new SearchField(SearchField.Style.FILTER);
        this.searchField.setPreferredSize(new Dimension(100, 10));
        for (SearchCategory searchCategory2 : searchCategoryArray = new SearchCategory[]{new SearchCategory(DialogsLrb.get("SQLQUERY_RSCRIPT_TABLE_NAME"))}) {
            this.searchField.addCategory(searchCategory2);
        }
        this.scriptsTable = new DataMinerTable(){

            public boolean getScrollableTracksViewportHeight() {
                Container container = this.getParent();
                if (container instanceof JViewport) {
                    return container.getHeight() > this.getPreferredSize().height;
                }
                return false;
            }
        };
        this.rScriptsTableModel = new RScriptsTableModel();
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.scriptsTable));
        this.jRScriptPanel.add((Component)jScrollPane, "Center");
        this.scriptsTable.setModel((TableModel)((Object)this.rScriptsTableModel));
        this.scriptsTable.setAutoResizeMode(4);
        this.scriptsTable.setSelectionMode(0);
        this.scriptsTable.setShowGrid(false);
        this.scriptsTable.setUpdateSelectionOnSort(true);
        this.scriptsTable.setRowSelectionAllowed(true);
        this.scriptsTable.setTransferHandler(new FromTransferHandler());
        this.scriptsTable.setDragEnabled(true);
        this.rScriptFilter = new RowFilter<RScriptsTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends RScriptsTableModel, ? extends Integer> entry) {
                String string;
                boolean bl = true;
                boolean bl2 = RScriptsPanel.this.searchText != null && RScriptsPanel.this.searchCategory != null;
                Integer n = entry.getIdentifier();
                RScriptsTableModel rScriptsTableModel = entry.getModel();
                String string2 = string = RScriptsPanel.this.searchText != null ? RScriptsPanel.this.searchText.toLowerCase() : null;
                if (bl2 && RScriptsPanel.this.searchCategory.getLabel().equals(DialogsLrb.get("SQLQUERY_RSCRIPT_TABLE_NAME"))) {
                    String string3 = (String)rScriptsTableModel.getValueAt(n, 0);
                    bl = string3.toLowerCase().contains(string);
                }
                return bl;
            }
        };
        this.configureSorting();
        this.scriptsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                RScriptsPanel.this.enableControls();
            }
        });
        this.scriptsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JTable jTable = (JTable)mouseEvent.getSource();
                    int n = jTable.getSelectedRow();
                    n = jTable.convertRowIndexToModel(n);
                    String string = ((RFunction)RScriptsPanel.this.rScriptsTableModel.getSrcData().get(n)).toSQLString();
                    if (RScriptsPanel.this.jRInterfaceFuncCheckBox.isSelected()) {
                        RFunction rFunction = (RFunction)RScriptsPanel.this.rScriptComboBox.getSelectedItem();
                        string = rFunction.getScript().replace("<RScript>", string);
                    }
                    RScriptsPanel.this.parentPanel.insertSQLExpression(string);
                }
            }
        });
        this.userComboBoxModel = new DefaultComboBoxModel();
        this.usersComboBox.setModel(this.userComboBoxModel);
        this.jRInterfaceFuncCheckBox.addActionListener(actionEvent -> this.rInterfacePreferences.setRInterfaceEnable(this.jRInterfaceFuncCheckBox.isSelected()));
        this.jRInterfaceFuncCheckBox.setSelected(this.rInterfacePreferences.isRInterfaceEnable());
        RFunction rFunction = new RFunction(RQEVAL, RQEVAL_PROTOCOL);
        RFunction rFunction2 = new RFunction(RQTABLEEVAL, RQTABLEEVAL_PROTOCOL);
        searchCategory2 = new RFunction(RQGROUPEVAL, RQGROUPEVAL_PROTOCOL);
        RFunction rFunction3 = new RFunction(RQROWEVAL, RQROWEVAL_PROTOCOL);
        RFunction[] rFunctionArray = new RFunction[]{rFunction, rFunction2, searchCategory2, rFunction3};
        this.rScriptComboBox.setModel(new DefaultComboBoxModel<RFunction>(rFunctionArray));
        for (RFunction rFunction4 : rFunctionArray) {
            if (!this.rInterfacePreferences.getRInterface().equals(rFunction4.getName())) continue;
            this.rScriptComboBox.setSelectedItem(rFunction4);
            break;
        }
        this.rScriptComboBox.addActionListener(actionEvent -> {
            RFunction rFunction = (RFunction)this.rScriptComboBox.getSelectedItem();
            this.rInterfacePreferences.setRInterface(rFunction.getName());
        });
    }

    public void load() {
        LoadWorker loadWorker = new LoadWorker();
        loadWorker.execute();
    }

    private void query() {
        QueryWorker queryWorker = new QueryWorker();
        queryWorker.execute();
    }

    public String[] getRQFunctions() {
        return new String[]{RQEVAL, RQTABLEEVAL, RQGROUPEVAL, RQROWEVAL};
    }

    private void addToolbarControls(List<String> list) {
        this.toolbar.removeAll();
        this.toolbar.add(this.refreshButton);
        this.toolbar.add(this.viewButton);
        this.toolbar.addSeparator();
        if (!list.isEmpty()) {
            this.addUserComboBoxToToolbar(list);
        }
        this.toolbar.addSeparator();
        this.toolbar.add((Component)this.searchField);
        this.searchField.addSearchListener((SearchListener)this);
    }

    private void addUserComboBoxToToolbar(List<String> list) {
        this.userComboBoxModel.removeAllElements();
        list.forEach(string -> this.userComboBoxModel.addElement((String)string));
        this.usersComboBox.addActionListener(new LoadOwnerFunctionsListener());
        this.toolbar.add(this.usersLabel);
        this.toolbar.add(this.usersComboBox);
    }

    private void enableControls() {
        this.viewButton.setEnabled(this.scriptsTable.getSelectedRowCount() > 0);
    }

    public void configureSorting() {
        TableRowSorter<RScriptsTableModel> tableRowSorter = (TableRowSorter<RScriptsTableModel>)this.scriptsTable.getRowSorter();
        if (tableRowSorter == null) {
            tableRowSorter = new TableRowSorter<RScriptsTableModel>(this.rScriptsTableModel);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            tableRowSorter.setSortKeys(arrayList);
            tableRowSorter.setSortsOnUpdates(true);
        }
        tableRowSorter.setRowFilter(this.rScriptFilter);
        this.scriptsTable.setRowSorter(tableRowSorter);
    }

    public void searchPerformed(SearchEvent searchEvent) {
        this.searchCategory = searchEvent.getSearchCategory();
        this.searchText = searchEvent.getSearchText();
        this.configureSorting();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
        this.searchCategory = searchEvent.getSearchCategory();
        this.searchText = searchEvent.getSearchText();
        this.configureSorting();
    }

    private void reloadFunctionTable(List<RFunction> list) {
        if (list != null) {
            if (list.isEmpty()) {
                this.scriptsTable.setNoEntryInstructionText(NO_FUNCTION);
            }
            this.rScriptsTableModel.clear();
            this.rScriptsTableModel.addRows(list);
            this.scriptsTable.clearSelection();
            this.scriptsTable.updateUI();
            this.configureSorting();
        }
    }

    private class LoadOwnerFunctionsListener
    implements ActionListener {
        private LoadOwnerFunctionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RScriptsPanel.this.currentUser = (String)RScriptsPanel.this.usersComboBox.getSelectedItem();
            RScriptsPanel.this.query();
        }
    }

    private class ViewScriptActionListener
    implements ActionListener {
        private ViewScriptActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = RScriptsPanel.this.scriptsTable.getSelectedRow();
            n = RScriptsPanel.this.scriptsTable.convertRowIndexToModel(n);
            if (n >= 0) {
                String string = ((RFunction)RScriptsPanel.this.rScriptsTableModel.getSrcData().get(n)).getScript();
                RScriptViewerPanel rScriptViewerPanel = new RScriptViewerPanel(RScriptsPanel.this.getContext(), string);
                rScriptViewerPanel.showAsDialog(RScriptsPanel.this);
            }
        }
    }

    private class LoadActionListener
    implements ActionListener {
        private LoadActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RScriptsPanel.this.load();
        }
    }

    private class FromTransferHandler
    extends TransferHandler {
        private FromTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        @Override
        public Transferable createTransferable(JComponent jComponent) {
            int n = RScriptsPanel.this.scriptsTable.getSelectedRow();
            n = RScriptsPanel.this.scriptsTable.convertRowIndexToModel(n);
            if (n >= 0) {
                String string = ((RFunction)RScriptsPanel.this.rScriptsTableModel.getSrcData().get(n)).toSQLString();
                if (RScriptsPanel.this.jRInterfaceFuncCheckBox.isSelected()) {
                    RFunction rFunction = (RFunction)RScriptsPanel.this.rScriptComboBox.getSelectedItem();
                    string = rFunction.getScript().replace("<RScript>", string);
                }
                return new StringSelection(string);
            }
            return null;
        }
    }

    private class QueryWorker
    extends ODMrSwingWorker<List<RFunction>, Void> {
        private QueryWorker() {
            super(RScriptsPanel.this, null, RScriptsPanel.this.scriptsTable);
        }

        @Override
        protected List<RFunction> doInBackground() throws Exception {
            if (RScriptsPanel.this.query instanceof GetRFunctionsQuery) {
                ((GetRFunctionsQuery)RScriptsPanel.this.query).setSchema(RScriptsPanel.this.currentUser);
            }
            List list = RScriptsPanel.this.dao.readItems(RScriptsPanel.this.query);
            return list;
        }

        @Override
        protected void onSuccess(List<RFunction> list) throws Exception {
            RScriptsPanel.this.reloadFunctionTable(list);
        }

        @Override
        protected void onFailure(Throwable throwable) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNEXPECTED_ERROR_MSG"), null);
        }

        @Override
        protected void onFinally() {
            RScriptsPanel.this.enableControls();
        }
    }

    private class LoadWorker
    extends ODMrSwingWorker<List<RFunction>, Void> {
        private LoadWorker() {
            super(RScriptsPanel.this, null, RScriptsPanel.this.scriptsTable);
            for (ActionListener actionListener : RScriptsPanel.this.usersComboBox.getActionListeners()) {
                RScriptsPanel.this.usersComboBox.removeActionListener(actionListener);
            }
            RScriptsPanel.this.userComboBoxModel.removeAllElements();
            RScriptsPanel.this.userComboBoxModel.addElement(CommonLrb.get("LOADING"));
        }

        @Override
        protected List<RFunction> doInBackground() throws Exception {
            this.initializeOREConfiguration();
            this.initializeFunctionsQuery();
            List<String> list = this.getDistinctRFunctionOwners();
            RScriptsPanel.this.addToolbarControls(list);
            if (RScriptsPanel.this.query instanceof GetRFunctionsQuery && !list.isEmpty()) {
                RScriptsPanel.this.currentUser = list.get(0);
                ((GetRFunctionsQuery)RScriptsPanel.this.query).setSchema(RScriptsPanel.this.currentUser);
            }
            List list2 = RScriptsPanel.this.dao.readItems(RScriptsPanel.this.query);
            return list2;
        }

        private void initializeFunctionsQuery() {
            RScriptsPanel.this.query = (Query)(this.is122CompatibleOREVersion() ? new GetRFunctionsQuery(RScriptsPanel.this.dbVersion) : new GetRScriptsQuery(RScriptsPanel.this.dbVersion));
        }

        private boolean is122CompatibleOREVersion() {
            String string;
            Optional optional;
            if (RScriptsPanel.this.oreConfiguration.containsKey("VERSION") && (optional = StringUtils.parseNumber((String)(string = (String)RScriptsPanel.this.oreConfiguration.get("VERSION")))).isPresent()) {
                Number number = (Number)optional.get();
                return number.doubleValue() >= 1.5;
            }
            return false;
        }

        private void initializeOREConfiguration() {
            try {
                RScriptsPanel.this.oreConfiguration = RScriptsPanel.this.dao.readItem(RScriptsPanel.this.oreConfigurationQuery).orElse(Collections.emptyMap());
            }
            catch (ODMrDAOException oDMrDAOException) {
                RScriptsPanel.this.oreConfiguration = Collections.emptyMap();
            }
        }

        private List<String> getDistinctRFunctionOwners() {
            List list;
            if (this.is122CompatibleOREVersion()) {
                try {
                    list = RScriptsPanel.this.dao.readItems(RScriptsPanel.this.functionOwnersQuery);
                    if (!list.contains(RScriptsPanel.RQSYS)) {
                        list.add(RScriptsPanel.RQSYS);
                    }
                    Collections.sort(list);
                }
                catch (ODMrDAOException oDMrDAOException) {
                    list = Collections.emptyList();
                }
            } else {
                list = Collections.emptyList();
            }
            return list;
        }

        @Override
        protected void onSuccess(List<RFunction> list) throws Exception {
            RScriptsPanel.this.reloadFunctionTable(list);
        }

        @Override
        protected void onFailure(Throwable throwable) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNEXPECTED_ERROR_MSG"), null);
        }

        @Override
        protected void onFinally() {
            RScriptsPanel.this.enableControls();
        }
    }
}

