/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.dprofiler;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.dprofiler.DataProfilePanelSettings;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;

public class DataProfilePreferencesPanel
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    private JSpinner jNumericalPrecisionValueSpinner;
    private JLabel jNumericalValuesPrecisionLabel;
    private JSpinner jPercentagePrecisionValueSpinner;
    private JLabel jPercentageValuesPrecisionLabel;
    private JLabel jPrecisionGroupDescription;
    private Integer _percentagePrecisionLevel = 4;
    private Integer _numericalPrecisionLevel = 4;

    public DataProfilePreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jPercentageValuesPrecisionLabel = new JLabel();
        this.jPercentagePrecisionValueSpinner = new JSpinner();
        this.jNumericalValuesPrecisionLabel = new JLabel();
        this.jPrecisionGroupDescription = new JLabel();
        this.jNumericalPrecisionValueSpinner = new JSpinner();
        this.jPercentageValuesPrecisionLabel.setText("Percentage Based Values:");
        this.jNumericalValuesPrecisionLabel.setText("Numerical Values:");
        this.jPrecisionGroupDescription.setText("Precision Settings:");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addGap(11, 11, 11).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jNumericalValuesPrecisionLabel, -1, 191, Short.MAX_VALUE).addComponent(this.jPercentageValuesPrecisionLabel, -1, 191, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPercentagePrecisionValueSpinner, -2, 47, -2).addComponent(this.jNumericalPrecisionValueSpinner, GroupLayout.Alignment.TRAILING, -2, 47, -2)).addGap(80, 80, 80)).addComponent(this.jPrecisionGroupDescription, -1, 334, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jPrecisionGroupDescription).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jPercentageValuesPrecisionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNumericalValuesPrecisionLabel)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jPercentagePrecisionValueSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNumericalPrecisionValueSpinner, -2, -1, -2))).addContainerGap(219, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jNumericalPrecisionValueSpinner, this.jNumericalValuesPrecisionLabel, this.jPercentagePrecisionValueSpinner, this.jPercentageValuesPrecisionLabel);
    }

    @Override
    public void initRes() {
        this.jPercentagePrecisionValueSpinner.setModel(new SpinnerNumberModel(this._percentagePrecisionLevel, 0, 12, 1));
        this.jNumericalPrecisionValueSpinner.setModel(new SpinnerNumberModel(this._numericalPrecisionLevel, 0, 12, 1));
        this.setHelpID("preferences_explore_data_viewer");
        ResourceUtils.resLabel((JLabel)this.jPrecisionGroupDescription, null, (String)DataProfileStatisticsLrb.get("PREFERENCES_PRECISION_SETTINGS"));
        ResourceUtils.resLabel((JLabel)this.jNumericalValuesPrecisionLabel, (Component)this.jNumericalPrecisionValueSpinner, (String)DataProfileStatisticsLrb.get("PREFERENCES_NUMERICAL"));
        ResourceUtils.resLabel((JLabel)this.jPercentageValuesPrecisionLabel, (Component)this.jPercentagePrecisionValueSpinner, (String)DataProfileStatisticsLrb.get("PREFERENCES_PERCENTAGE"));
    }

    @Override
    public void initUI() {
    }

    public void onEntry(TraversableContext traversableContext) {
        DataProfilePanelSettings dataProfilePanelSettings = DataProfilePreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this._percentagePrecisionLevel = dataProfilePanelSettings.getPercentagePrecisionLevel();
        this.jPercentagePrecisionValueSpinner.setValue(this._percentagePrecisionLevel);
        this._numericalPrecisionLevel = dataProfilePanelSettings.getNumericalPrecisionLevel();
        this.jNumericalPrecisionValueSpinner.setValue(this._numericalPrecisionLevel);
    }

    public void onExit(TraversableContext traversableContext) {
        Number number;
        DataProfilePanelSettings dataProfilePanelSettings = DataProfilePreferencesPanel.getCoolFeaturePrefs(traversableContext);
        Number number2 = this.getNumber(this.jPercentagePrecisionValueSpinner);
        if (number2 != null) {
            dataProfilePanelSettings.setPercentagePrecisionLevel(number2.intValue());
        }
        if ((number = this.getNumber(this.jNumericalPrecisionValueSpinner)) != null) {
            dataProfilePanelSettings.setNumericalPrecisionLevel(number.intValue());
        }
    }

    private static DataProfilePanelSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return DataProfilePanelSettings.getInstance(traversableContext.getPropertyStorage());
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }
}

