/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls.renderers;

import java.awt.Component;
import java.text.DateFormat;
import java.text.Format;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import oracle.dmt.dataminer.utils.Formats;

public class FormatTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Border PADDING = BorderFactory.createEmptyBorder(0, 0, 0, 8);
    private Format format;

    private FormatTableCellRenderer(Format format) {
        this(format, 2);
    }

    private FormatTableCellRenderer(Format format, int n) {
        this.format = format;
        this.setHorizontalAlignment(n);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.setText(this.formatValue(object));
        if (this.getHorizontalAlignment() == 4) {
            this.setBorder(BorderFactory.createCompoundBorder(this.getBorder(), PADDING));
        }
        return component;
    }

    private String formatValue(Object object) {
        String string = "";
        if (object instanceof String) {
            string = object.toString();
        } else if (object != null) {
            string = this.format.format(object);
        }
        return string;
    }

    public static final TableCellRenderer getDateRenderer() {
        return new FormatTableCellRenderer(DateFormat.getDateTimeInstance(3, 3, Locale.getDefault()));
    }

    public static final TableCellRenderer getDateRenderer(DateFormat dateFormat) {
        return new FormatTableCellRenderer(dateFormat);
    }

    public static TableCellRenderer getIntegerRenderer() {
        return new FormatTableCellRenderer(Formats.getInteger(), 4);
    }

    public static TableCellRenderer getScientificRenderer() {
        return new FormatTableCellRenderer(Formats.getScientific(), 4);
    }

    public static TableCellRenderer getModelViewerNumericRenderer() {
        return new FormatTableCellRenderer(Formats.ModelViewer.getNumeric(), 4);
    }

    public static TableCellRenderer getModelViewerPercentRenderer() {
        return new FormatTableCellRenderer(Formats.ModelViewer.getPercentage(), 4);
    }

    public static TableCellRenderer getDataExploreNumericRenderer() {
        return new FormatTableCellRenderer(Formats.DataExplore.getNumeric(), 4);
    }

    public static TableCellRenderer getDataExplorePercentRenderer() {
        return new FormatTableCellRenderer(Formats.DataExplore.getPercentage(), 4);
    }
}

